close all;
clear all;

LoadData     = 1;
LoadGridData = 0;
DumpData     = 0;
SavePlots    = 1;
GraphixDebug = 1;
outputdir = '';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                               Experiments                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Experiment names.
fizexp = 'FizhiClimate';
conexp = 'Observations';

% Fihzi data and grid directories.
fizD  = ['/Users/enderton/Data/GraphixTest/Fizhi/Data'];
fizG  = ['/Users/enderton/Data/GraphixTest/Fizhi/Grid'];

% Time step and iteration information.
fizdt = 120;
fizit = [31896];

fizG1 = ['/DATA/d06/molod/fizhi-cs-32x32x40-nas24/data'];

verroot = '/Users/enderton/Data/Verification/';
erbeD = [verroot,'Clouds_radiation/erbe/'];

condt = 1;
conit = [1];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                      Initialize field cell arrays                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

FizBasics = {...
    {{'U','uVeltave',fizD,fizG,fizexp,'Tav',fizit,fizdt,'A','MDS','MDS',...
      'Avg','Zon','Con','GridSuffix','_FizhiZ10','Vector',1,'Mate','vVeltave'},...
     {'V','vVeltave',fizD,fizG,fizexp,'Tav',fizit,fizdt,'A','MDS','MDS',...
      'Avg','Zon','Con','GridSuffix','_FizhiZ10','Vector',2,'Mate','uVeltave'},...
     'Sbs'},...
    {{'T','Ttave',fizD,fizG,fizexp,'Tav',fizit,fizdt,'A','MDS','MDS',...
      'Avg','Zon','Con','GridSuffix','_FizhiZ10'},...
     {'ActT','Ttave',fizD,fizG,fizexp,'Tav',fizit,fizdt,'A','MDS','MDS',...
      'Avg','Zon','Con','GridSuffix','_FizhiZ10','ThetaToActT',1},...
     'Sbs'},...
    {{'Psi','',fizD,fizG,fizexp,'Tav',fizit,fizdt,'A','MDS','MDS','Avg',...
      'Zon','Con','GridSuffix','_FizhiZ10','uFld','uVeltave','vFld','vVeltave'}},...
};

OLR = {...
    {{'OLR','surface',fizD,fizG,fizexp,'Non',fizit,fizdt,'A','MDS','MDS',...
      'Avg','Sur','Cnf','GridSuffix','_FizhiZ10','Index',{'+',2},...
     'Coast','1','XL',[-180:2.5:177.5],'YL',[-90:2:90]}},...
    {{'OLR','erbe2x25.tabl',erbeD,erbeD,conexp,'Gra',conit,condt,...
      'A','MDS','MDS','Avg','Sur','Cnf','Coast','1'}},...
    {{'OLR','surface',fizD,fizG,[fizexp,'-',conexp],'Non',fizit,fizdt,...
      'A','MDS','MDS','Avg','Sur','Cnf','GridSuffix','_FizhiZ10',...
      'Index',{'+',2},'Coast','1','XL',[-180:2.5:177.5],'YL',[-90:2:90]},...
     {'OLR','erbe2x25.tabl',erbeD,erbeD,[fizexp,'-',conexp],'Gra',...
      conit,condt,'A','MDS','MDS','Avg','Sur','Cnf','Coast','1'},...
     'Dif'},...
};

GraphixRun(FizBasics,'FizBasics','LoadData',LoadData,'LoadGridData',LoadGridData,'GraphixDebug',GraphixDebug,'SavePlots',SavePlots);
GraphixRun(OLR      ,'OLR'      ,'LoadData',LoadData,'LoadGridData',LoadGridData,'GraphixDebug',GraphixDebug,'SavePlots',SavePlots);

% Notes:
% You can pass in the grid to interpolate to (XL,YL), otherwise the default
% is in GraphixRunDefaults.  The colorbar default is in
% GraphixPlotDefaults, with an override being passed in as
% ...,'UseColorBar',1.