#include "ECCO_OPTIONS.h"
#ifdef ALLOW_CTRL
# include "CTRL_OPTIONS.h"
#endif

C--  File ecco_check.F:
C--   Contents
C--   o ECCO_CHECK
C--   o ECCO_CHECK_FILES

C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|

      SUBROUTINE ECCO_CHECK( myThid )
C     *==========================================================*
C     | SUBROUTINE ECCO_CHECK                                    |
C     | o Check runtime activated packages have been built in.   |
C     *==========================================================*
C     | All packages can be selected/deselected at build time    |
C     | ( when code is compiled ) and activated/deactivated at   |
C     | runtime. This routine does a quick check to trap packages|
C     | that were activated at runtime but that were not compiled|
C     | in at build time.                                        |
C     *==========================================================*
      IMPLICIT NONE

C     === Global variables ===
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "DYNVARS.h"
#include "GRID.h"
#ifdef ALLOW_CAL
# include "cal.h"
#endif
#ifdef ALLOW_ECCO
# include "ecco_cost.h"
#endif

C     === Routine arguments ===
C     myThid -  Number of this instances
      INTEGER myThid

c     == external functions ==
      INTEGER  ILNBLNK
      EXTERNAL ILNBLNK

C     === Local variables ===
C     msgBuf      - Informational/error message buffer
      CHARACTER*(MAX_LEN_MBUF) msgBuf
#ifdef ALLOW_GENCOST_CONTRIBUTION
      INTEGER igen_etagcm, il
      INTEGER igen_tp, igen_ers, igen_gfo, use_mon_int, use_day_int
      LOGICAL exst
      CHARACTER*(128) tempfile
      INTEGER icount_transp
      INTEGER k
#endif
      INTEGER nRetired

      _BEGIN_MASTER(myThid)

      WRITE(msgBuf,'(2A)') 'ECCO_CHECK: ',
     &                     ' --> Starts to check ECCO set-up'
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT, myThid )

c ============ retired compile option checks
      nRetired = 0

#ifdef ALLOW_MEAN_HFLUX_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_MEAN_HFLUX_COST_CONTRIBUTION has no',
     &      'effect since cost_mean_heatflux has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_MEAN_SFLUX_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_MEAN_SFLUX_COST_CONTRIBUTION has no',
     &      'effect since cost_mean_saltflux has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_SSH_GLOBMEAN_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_SSH_GLOBMEAN_COST_CONTRIBUTION has no',
     &      'effect since cost_ssh_globmean has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_NEW_SSH_COST
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_NEW_SSH_COST has no',
     &      'effect since cost_ssh_new has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_CURMTR_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_CURMTR_COST_CONTRIBUTION has no',
     &      'effect since cost_curmtr has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_DRIFTER_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_DRIFTER_COST_CONTRIBUTION has no',
     &      'effect since cost_drifter has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_BP_COST_CONTRIBUTION
        WRITE(msgBuf,'(3A)') 'ECCO_CHECK:',
     &      ' "ALLOW_BP_COST_CONTRIBUTION" has been removed',
     &      ' since cost_bp has been retired'
        CALL PRINT_ERROR( msgBuf, myThid )
        nRetired = nRetired + 1
#endif
#ifdef ALLOW_SCAT_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_SCAT_COST_CONTRIBUTION has no',
     &      'effect since cost_scat etc has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_DAILYSCAT_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_DAILYSCAT_COST_CONTRIBUTION has no',
     &      'effect since cost_scat etc has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_DRIFT_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_DRIFT_COST_CONTRIBUTION has no',
     &      'effect since cost_drift has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_DRIFTW_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_DRIFTW_COST_CONTRIBUTION has no',
     &      'effect since cost_driftw has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_COST_INI_FIN
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_COST_INI_FIN has no',
     &      'effect since cost_theta_ini_fin etc has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_COST_TRANSPORT
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_COST_TRANSPORT has no',
     &      'effect since cost_trans_merid etc has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_COST_ATLANTIC
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_COST_ATLANTIC has no',
     &      'effect since cost_atlantic has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_TRANSPORT_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_TRANSPORT_COST_CONTRIBUTION has no',
     &      'effect since cost_gen_transport has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_EGM96_ERROR_COV
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_EGM96_ERROR_COV has no',
     &      'effect since cost_geoid etc has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_IESTAU_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_IESTAU_COST_CONTRIBUTION has no',
     &      'effect since cost_ies etc has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_SIGMAR_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_SIGMAR_COST_CONTRIBUTION has no',
     &      'effect since cost_sigmar has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif
#ifdef ALLOW_EDDYPSI_COST_CONTRIBUTION
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'ALLOW_EDDYPSI_COST_CONTRIBUTION has no',
     &      'effect since cost_tau_eddy has been retired'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
       nRetired = nRetired + 1
#endif

      IF ( nRetired .GT. 0 ) THEN
       WRITE(msgBuf,'(2A)') 'S/R ECCO_CHECK: ',
     &  '  retired compile-time options need to be removed'
       CALL PRINT_ERROR( msgBuf, myThid )
       CALL ALL_PROC_DIE( 0 )
       STOP 'ABNORMAL END: S/R ECCO_CHECK'
      ENDIF

c ============ retired run-time parameter checks
      nRetired = 0

#ifdef ALLOW_GENCOST_CONTRIBUTION
      DO k=1,NGENCOST
       IF (gencost_scalefile(k).NE.' ') THEN
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'gencost_scalefile has been retired; ',
     &      'gencost_posproc_c should now be used instead'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           nRetired = nRetired + 1
       ENDIF
       IF (gencost_smooth2Ddiffnbt(k).NE.0) THEN
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'gencost_smooth2Ddiffnbt has been retired; ',
     &      'gencost_posproc_i should now be used instead'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           nRetired = nRetired + 1
       ENDIF
       IF (gencost_timevaryweight(k)) THEN
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'gencost_timevaryweight has been retired; ',
     &      'gencost_posproc should now be used instead'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           nRetired = nRetired + 1
       ENDIF
       IF (gencost_nrecperiod(k).NE.0) THEN
           WRITE(msgBuf,'(3A)') '** WARNING ** ECCO_CHECK:',
     &      'gencost_nrecperiod has been retired; ',
     &      'gencost_posproc clim should now be used instead'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           nRetired = nRetired + 1
       ENDIF

      ENDDO
#endif

      IF ( nRetired .GT. 0 ) THEN
       WRITE(msgBuf,'(2A)') 'S/R ECCO_CHECK: ',
     &  '  retired run-time options were found in data.ecco'
       CALL PRINT_ERROR( msgBuf, myThid )
       CALL ALL_PROC_DIE( 0 )
       STOP 'ABNORMAL END: S/R ECCO_CHECK'
      ENDIF

c ============ backward compatibility checks
      IF ( (using_topex).AND.(.NOT.using_tpj) ) using_tpj=.TRUE.

      _END_MASTER(myThid)

c ============ generic cost function related checks

#ifdef ALLOW_GENCOST_CONTRIBUTION
      icount_transp=0
      igen_tp = 0
      igen_ers = 0
      igen_gfo = 0
      DO k=1,NGENCOST

         IF (gencost_pointer3d(k).GT.NGENCOST3D) THEN
           WRITE(msgBuf,'(2A)')
     &      'ECCO_CHECK: too many 3D cost terms; please',
     &      'increase NGENCOST3D and recompile.'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           CALL PRINT_ERROR( msgBuf , myThid )
           STOP 'ABNORMAL END: S/R ECCO_CHECK'
         ENDIF

         IF (gencost_msk_pointer3d(k).GT.NGENCOST3D) THEN
           WRITE(msgBuf,'(2A)')
     &      'ECCO_CHECK: too many 3D msk terms; please',
     &      'increase NGENCOST3D and recompile.'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           CALL PRINT_ERROR( msgBuf , myThid )
           STOP 'ABNORMAL END: S/R ECCO_CHECK'
         ENDIF

         IF ( gencost_datafile(k) .NE. ' ' ) THEN

           CALL ECCO_CHECK_FILES( using_gencost(k), 'gencost',
     &       gencost_datafile(k), gencost_startdate1(k), myThid )

c--
           IF ( (gencost_preproc(1,k).EQ.'variaweight').AND.
     &          ( gencost_errfile(k) .NE. ' ' ) ) THEN
             CALL ECCO_CHECK_FILES( using_gencost(k), 'gencost',
     &         gencost_errfile(k), gencost_startdate1(k), myThid )
           ELSEIF ( gencost_errfile(k) .NE. ' ' ) THEN
             il = ILNBLNK(gencost_errfile(k))
             inquire( file=gencost_errfile(k)(1:il), exist=exst )
             IF (.NOT.exst) THEN
               using_gencost(k)=.FALSE.
               il = ILNBLNK(gencost_name(k))
               WRITE(msgBuf,'(4A)')
     &           '** WARNING ** ECCO_CHECK_FILES: missing error file',
     &           ' so ',gencost_name(k)(1:il),' gets switched off'
               CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                    SQUEEZE_RIGHT , myThid)
             ENDIF
           ENDIF

c altimetry related checks

         IF (gencost_name(k).EQ.'sshv4-tp') THEN
           igen_tp = k
           using_tpj = using_gencost(k)
         ENDIF
         IF (gencost_name(k).EQ.'sshv4-ers') THEN
           igen_ers = k
           using_ers = using_gencost(k)
         ENDIF
         IF (gencost_name(k).EQ.'sshv4-gfo') THEN
           igen_gfo = k
           using_gfo = using_gencost(k)
         ENDIF
         IF (gencost_name(k).EQ.'sshv4-mdt') using_mdt=using_gencost(k)

c seaice related checks
         IF (gencost_name(k).EQ.'siv4-conc')
     &       using_cost_seaice=using_gencost(k)
         IF (gencost_name(k).EQ.'siv4-deconc')
     &       using_cost_seaice=using_gencost(k)
         IF (gencost_name(k).EQ.'siv4-exconc')
     &       using_cost_seaice=using_gencost(k)
catn-- put STOP statement if use old siv4 names:
         IF (gencost_name(k).EQ.'siv4-sst') THEN
           WRITE(msgBuf,'(2A)')
     &      'ECCO_CHECK: OLD seaice gencost_name siv4-sst is retired,',
     &      ' NEW name is siv4-deconc'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           CALL PRINT_ERROR( msgBuf , myThid )
           STOP 'ABNORMAL END: S/R ECCO_CHECK'
         ENDIF
         IF (gencost_name(k).EQ.'siv4-vol') THEN
           WRITE(msgBuf,'(2A)')
     &      'ECCO_CHECK: OLD seaice gencost_name siv4-vol is retired,',
     &      ' NEW name is siv4-exconc'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                     SQUEEZE_RIGHT , myThid )
           CALL PRINT_ERROR( msgBuf , myThid )
           STOP 'ABNORMAL END: S/R ECCO_CHECK'
         ENDIF

c-atn add another block for cost that do not need datafile but
c should have checks for other things:
c here, separate into different gencost_flag block
         ELSE  !if ( gencost_datafile(k) .NE. ' ' ) THEN
c---------------- block -1 ----------------------------
c block -1: cost ssh-[mdt,lsc,amsre-lsc] do not need datafile
c but need errfile. at the moment do not accomodate variaweight.
          IF (gencost_flag(k).EQ. -1) THEN
            IF (gencost_errfile(k) .NE. ' ') THEN
             il = ILNBLNK(gencost_errfile(k))
             inquire( file=gencost_errfile(k)(1:il), exist=exst )
             IF (.NOT.exst) THEN
              using_gencost(k)=.FALSE.
              il = ILNBLNK(gencost_name(k))
              WRITE(msgBuf,'(4A)')
     &          '** WARNING ** ECCO_CHECK_FILES: missing error file',
     &          ' so ',gencost_name(k)(1:il),' gets switched off'
              CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                   SQUEEZE_RIGHT , myThid)
             ENDIF
            ELSEIF(.NOT.(gencost_name(k).EQ.'sshv4-gmsl')) THEN
             using_gencost(k)=.FALSE.
             il = ILNBLNK(gencost_name(k))
             WRITE(msgBuf,'(4A)')
     &        '** WARNING ** ECCO_CHECK_FILES: error file not defined',
     &        ' so ',gencost_name(k)(1:il),' gets switched off'
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                  SQUEEZE_RIGHT , myThid)
            ENDIF

c---------------- block -3 ----------------------------
c-- boxmean: require [err,bar]file, can have datafile, not checked here
c-- also not checked for variwei at the moment
          ELSEIF(gencost_flag(k) .EQ. -3 ) THEN
           WRITE(msgBuf,'(A,i3,L5)')
     &     'entering boxmean/horflux check,k,using_gencost(k): ,',
     &     k,using_gencost(k)
           CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                        SQUEEZE_RIGHT , myThid)

            IF (gencost_errfile(k) .NE. ' ') THEN
              WRITE(msgBuf,'(3A)') 'S/R ECCO_CHECK: boxmean now ',
     &          ' uses gencost_mask instead of gencost_errfile --',
     &          ' please update data.ecco accordingly'
              CALL PRINT_ERROR( msgBuf, myThid )
              STOP 'ABNORMAL END: S/R ECCO_CHECK'
            ENDIF

            IF (gencost_mask(k) .EQ. ' ') THEN
              using_gencost(k)=.FALSE.
              il = ILNBLNK(gencost_name(k))
              WRITE(msgBuf,'(4A)')
     &          '** WARNING ** ECCO_CHECK_FILES: gencost_mask is',
     &          ' undefined so ',gencost_name(k)(1:il),
     &          ' gets switched off'
              CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                   SQUEEZE_RIGHT , myThid)
            ENDIF

            IF ((gencost_mask(k) .NE. ' ').AND.
     &          (gencost_barfile(k)(1:9).EQ.'m_boxmean')) THEN
             il = ILNBLNK(gencost_mask(k))
             WRITE(tempfile(1:128),'(2A)') gencost_mask(k)(1:il),'C'
             inquire( file=tempfile(1:il+1), exist=exst )
             IF (.NOT.exst) THEN
               using_gencost(k)=.FALSE.
               il = ILNBLNK(gencost_name(k))
               WRITE(msgBuf,'(4A)')
     &           '** WARNING ** ECCO_CHECK_FILES: missing mask C file',
     &           ' so ',gencost_name(k)(1:il),' gets switched off'
               CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                    SQUEEZE_RIGHT , myThid)
             ENDIF
            ENDIF

            IF ((gencost_mask(k) .NE. ' ').AND.
     &          (gencost_barfile(k)(1:9).EQ.'m_horflux')) THEN
             il = ILNBLNK(gencost_mask(k))
             WRITE(tempfile(1:128),'(2A)') gencost_mask(k)(1:il),'W'
             inquire( file=tempfile(1:il+1), exist=exst )
             IF (.NOT.exst) THEN
               using_gencost(k)=.FALSE.
               il = ILNBLNK(gencost_name(k))
               WRITE(msgBuf,'(4A)')
     &           '** WARNING ** ECCO_CHECK_FILES: missing mask W file',
     &           ' so ',gencost_name(k)(1:il),' gets switched off'
               CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                    SQUEEZE_RIGHT , myThid)
             ENDIF
c
             il = ILNBLNK(gencost_mask(k))
             WRITE(tempfile(1:128),'(2A)') gencost_mask(k)(1:il),'S'
             inquire( file=tempfile(1:il+1), exist=exst )
             IF (.NOT.exst) THEN
               using_gencost(k)=.FALSE.
               il = ILNBLNK(gencost_name(k))
               WRITE(msgBuf,'(4A)')
     &           '** WARNING ** ECCO_CHECK_FILES: missing mask S file',
     &           ' so ',gencost_name(k)(1:il),' gets switched off'
               CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                    SQUEEZE_RIGHT , myThid)
             ENDIF
            ENDIF

c-- check barfile, make sure character m_[theta,salt] match exactly
c-- (upper/lower-case matters) in cost_gencost_customize
           IF (.NOT.(
     &          (gencost_barfile(k)(1:15).EQ.'m_boxmean_theta').OR.
     &          (gencost_barfile(k)(1:13).EQ.'m_boxmean_eta').OR.
     &          (gencost_barfile(k)(1:14).EQ.'m_boxmean_salt').OR.
     &          (gencost_barfile(k)(1:17).EQ.'m_boxmean_ptracer').OR.
     &          (gencost_barfile(k)(1:13).EQ.'m_boxmean_vol').OR.
     &          (gencost_barfile(k)(1:16).EQ.'m_boxmean_shifwf').OR.
     &          (gencost_barfile(k)(1:16).EQ.'m_boxmean_shihtf').OR.
     &          (gencost_barfile(k)(1:13).EQ.'m_horflux_vol')
     &        )) THEN
            using_gencost(k)=.FALSE.
            il=ILNBLNK(gencost_barfile(k))
            WRITE(msgBuf,'(3A)')
     &      '** WARNING ** S/R ECCO_CHECK: barfile ',
     &      gencost_barfile(k)(1:il),': has no matched model var.'
            CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                          SQUEEZE_RIGHT, myThid )
            WRITE(msgBuf,'(A)') 'Edit cost_gencost_customize to fix. '
            CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                          SQUEEZE_RIGHT, myThid )
            il = ILNBLNK(gencost_name(k))
          WRITE(msgBuf,'(2A)') gencost_name(k)(1:il),' is switched off'
            CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                          SQUEEZE_RIGHT, myThid )
           ENDIF !barfile

c---------------- block -4 ----------------------------
c-- transs: require [mask,bar][W,S]file, can have datafile, but
c-- not checked here. also not checked for variwei at the moment
         ELSEIF ( (gencost_flag(k).EQ. -4) .OR.
     &            (gencost_flag(k).EQ. -5) ) THEN
          WRITE(msgBuf,'(A,i3,L5)')
     &     'ecco_check for gencost transp & moc; k,using_gencost(k): ,',
     &     k,using_gencost(k)
          CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                        SQUEEZE_RIGHT , myThid)

C ---
C Warn the user that this is a less tested objective function
C TBD: Write a more consistent transport objective function
C ---

          IF ((gencost_barfile(k)(1:7).EQ.'m_trVol').AND.
     &        (gencost_flag(k).EQ.-4)) THEN
           WRITE(msgBuf,'(A)')
     &  '** WARNING ** ECCO_CHECK: cost_gencost_transp.F not tested'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
           WRITE(msgBuf,'(A)')
     &   ' See m_horflux_vol via cost_gencost_boxmean.F.'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
          ELSEIF( (gencost_barfile(k)(1:8).EQ.'m_trHeat').OR.
     &            (gencost_barfile(k)(1:8).EQ.'m_trSalt') ) THEN
           WRITE(msgBuf,'(2A)')
     &   '** WARNING ** ECCO_CHECK: m_tr[Heat,Salt] to be used with',
     &   ' caution because:'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
           WRITE(msgBuf,'(A)')
     &  '  (1) advection inconsistent unless ENUM_CENTERED_2ND is used'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
           WRITE(msgBuf,'(A)')
     &  '  (2) bolus velocities not included'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
           WRITE(msgBuf,'(A)')
     &  '  (3) diffusion components not included'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
         ENDIF

C ---
C Note to user: use gencost_mask not errfile
C ---
          IF (gencost_errfile(k) .NE. ' ') THEN
            WRITE(msgBuf,'(3A)') 'S/R ECCO_CHECK: transp & moc now ',
     &        ' use gencost_mask instead of gencost_errfile --',
     &        ' please update data.ecco accordingly'
            CALL PRINT_ERROR( msgBuf, myThid )
            STOP 'ABNORMAL END: S/R ECCO_CHECK'
          ENDIF

          IF (gencost_mask(k) .EQ. ' ') THEN
            using_gencost(k)=.FALSE.
            il = ILNBLNK(gencost_name(k))
            WRITE(msgBuf,'(4A)')
     &        '** WARNING ** ECCO_CHECK_FILES: gencost_mask is',
     &        ' undefined so ',gencost_name(k)(1:il),
     &        ' gets switched off'
            CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                 SQUEEZE_RIGHT , myThid)

          ELSE
c-- West ----------------------
           il = ILNBLNK(gencost_mask(k))
           WRITE(tempfile(1:128),'(2A)') gencost_mask(k)(1:il),'W'
           inquire( file=tempfile(1:il+1), exist=exst )
           WRITE(msgBuf,'(2A,L5)') 'ecco_check file, exst: ',
     &       tempfile(1:il+1),exst
           CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                  SQUEEZE_RIGHT , myThid)
           IF (.NOT.exst) THEN
             using_gencost(k)=.FALSE.
             WRITE(msgBuf,'(2A)')
     &         '** WARNING ** ECCO_CHECK_FILES: missing mask file: ',
     &         tempfile(1:il+1)
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                  SQUEEZE_RIGHT , myThid)
             il = ILNBLNK(gencost_name(k))
             WRITE(msgBuf,'(3A)')
     &         ' so ',gencost_name(k)(1:il),' gets switched off'
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                  SQUEEZE_RIGHT , myThid)
           ENDIF
c-- South --------------------
           il = ILNBLNK(gencost_mask(k))
           WRITE(tempfile(1:128),'(2A)') gencost_mask(k)(1:il),'S'
           inquire( file=tempfile(1:il+1), exist=exst )
           WRITE(msgBuf,'(2A,L5)') 'ecco_check file, exst: ',
     &       tempfile(1:il+1),exst
           CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                  SQUEEZE_RIGHT , myThid)
           IF (.NOT.exst) THEN
             using_gencost(k)=.FALSE.
             WRITE(msgBuf,'(2A)')
     &         '** WARNING ** ECCO_CHECK_FILES: missing mask file: ',
     &         tempfile(1:il+1)
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                  SQUEEZE_RIGHT , myThid)
             il = ILNBLNK(gencost_name(k))
             WRITE(msgBuf,'(3A)')
     &         ' so ',gencost_name(k)(1:il),' gets switched off'
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                  SQUEEZE_RIGHT , myThid)
           ENDIF
         ENDIF ! gencost_mask.EQ.' '

c-- check barfile, make sure character m_tr[Vol,Heat,Salt] match exactly
c-- (upper/lower-case matters) in cost_gencost_customize
          IF(.NOT.( (gencost_barfile(k)(1:7).EQ.'m_trVol') .OR.
     &              (gencost_barfile(k)(1:8).EQ.'m_trHeat').OR.
     &              (gencost_barfile(k)(1:8).EQ.'m_trSalt') )) THEN
           using_gencost(k)=.FALSE.
           il=ILNBLNK(gencost_barfile(k))
           WRITE(msgBuf,'(3A)')
     &     '** WARNING ** S/R ECCO_CHECK: barfile ',
     &     gencost_barfile(k)(1:il),': has no matched model var.'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
           WRITE(msgBuf,'(A)') 'Edit cost_gencost_customize to fix. '
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
           il = ILNBLNK(gencost_name(k))
           WRITE(msgBuf,'(2A)') gencost_name(k)(1:il),' is switched off'
           CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                         SQUEEZE_RIGHT, myThid )
          ENDIF !barfile
c-- set using_cost_transp
          IF ((using_gencost(k)).AND.(gencost_flag(k).EQ.-4))
     &      icount_transp=icount_transp+1
          IF (icount_transp.GT.0) using_cost_transp = .TRUE.
c-- final report to make sure using_cost_transp is set correctly
          WRITE(msgBuf,'(2A,i3,L5)')
     &     'ecco_check: gencost transp; icount_transp,',
     &     'using_cost_transp: ',icount_transp,using_cost_transp
          CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                        SQUEEZE_RIGHT , myThid)

         ENDIF  !gencost_flag

         ENDIF !if ( gencost_datafile(k) .NE. ' ' ) THEN
      ENDDO

c check that one of the used gencost term defines etagcm (needed in sshv4)
      IF ( (using_tpj ).OR.(using_ers).OR.(using_gfo)
     &     .OR.(using_mdt) ) using_cost_altim = .TRUE.

      igen_etagcm=0
      DO k=1,NGENCOST
        IF ( (gencost_barfile(k)(1:5).EQ.'m_eta').AND.
     &       (using_gencost(k)) )  igen_etagcm=k
      ENDDO

      IF ((igen_etagcm.EQ.0).AND.(using_cost_altim)) THEN
c warn user as we override using_cost_altim
        using_cost_altim = .FALSE.
        WRITE(msgBuf,'(2A)')
     &    '** WARNING ** S/R ECCO_CHECK: missing file: ',
     &    'for altimeter data so cost gets switched off'
        CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                      SQUEEZE_RIGHT, myThid )
      ELSE
c print result to screen
        WRITE(msgBuf,'(A,I3)')
     &  'etagcm defined by gencost =',igen_etagcm
        CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                      SQUEEZE_RIGHT, myThid )
      ENDIF

C If more than one within the data set [tp,ers,gfo] are present, they must have
C the same avgperiod, e.g., day or month. Here we check for inconsistency:
      IF (using_cost_altim) THEN
       use_mon_int = 0
       use_day_int = 0
       IF ( using_tpj ) THEN
        IF (gencost_avgperiod(igen_tp) .EQ.'month' .OR.
     &      gencost_avgperiod(igen_tp) .EQ.'MONTH') THEN
          use_mon_int = use_mon_int + 1
        ELSE
          use_day_int = use_day_int + 1
        ENDIF
       ENDIF
       IF ( using_ers ) THEN
        IF (gencost_avgperiod(igen_ers) .EQ.'month' .OR.
     &      gencost_avgperiod(igen_ers) .EQ.'MONTH') THEN
          use_mon_int = use_mon_int + 1
        ELSE
          use_day_int = use_day_int + 1
        ENDIF
       ENDIF
       IF ( using_gfo ) THEN
        IF (gencost_avgperiod(igen_gfo).EQ.'month' .OR.
     &      gencost_avgperiod(igen_gfo).EQ.'MONTH' ) THEN
          use_mon_int = use_mon_int + 1
        ELSE
          use_day_int = use_day_int + 1
        ENDIF
       ENDIF
       IF ( use_mon_int .GT. 0 .AND. use_day_int .GT. 0 ) THEN
         WRITE(msgBuf,'(2A)')
     &    'ECCO_CHECK: cost sshv4: data set TP/ERS/GFO must be all ',
     &    'daily or monthly, but cannot be mixed.'
         CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                       SQUEEZE_RIGHT, myThid )
         CALL PRINT_ERROR( msgBuf, myThid )
         STOP 'ABNORMAL END: S/R ECCO_CHECK'
       ENDIF
      ENDIF

#endif /* ALLOW_GENCOST_CONTRIBUTION */

C ============ other pkg/ecco related checks
      _BEGIN_MASTER(myThid)

#ifndef ALLOW_PSBAR_STERIC
      IF (ecco_output_sterGloH) THEN
         WRITE(msgBuf,'(3A)') 'ECCO_CHECK:',
     &         ' Cannot set ecco_output_sterGloH to TRUE',
     &         ' with #undef ALLOW_PSBAR_STERIC'
         CALL PRINT_ERROR( msgBuf, myThid )
         STOP 'ABNORMAL END: S/R ECCO_CHECK'
      ENDIF
#endif

C--   Summarize the ECCO cost function setup.
      CALL ECCO_SUMMARY( myThid )

      WRITE(msgBuf,'(2A)') 'ECCO_CHECK: ',
     &                     ' <-- Ends Normally'
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT, myThid )
      WRITE(msgBuf,'(A)') ' '
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT, myThid )

      _END_MASTER(myThid)

      RETURN
      END

C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|

      SUBROUTINE ECCO_CHECK_FILES(
     O using_cost_local,
     I localname, localobsfile, localstartdate1,
     I myThid )

C     *==========================================================*
C     | SUBROUTINE ECCO_CHECK_FILES                              |
C     | o Check that obs files are present for specified years.  |
C     |   If not then set using_cost_local to false.             |
C     *==========================================================*
      IMPLICIT NONE

C     === Global variables ===
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "ECCO_SIZE.h"
#include "ECCO.h"
#ifdef ALLOW_CAL
# include "cal.h"
#endif

C     === Routine arguments ===
C     myThid -  Number of this instances
      INTEGER myThid
      LOGICAL using_cost_local
      CHARACTER*(*) localname
      CHARACTER*(MAX_LEN_FNAM) localobsfile
      INTEGER localstartdate1

c     == external functions ==
      INTEGER  ILNBLNK
      EXTERNAL ILNBLNK

C     === Local variables ===
C     msgBuf      - Informational/error message buffer
      CHARACTER*(MAX_LEN_MBUF) msgBuf
      INTEGER irec, mody, modm, yday, locy, il
      LOGICAL exst, singleFileTest, yearlyFileTest
      CHARACTER*(128) fname

c     == end of interface ==

c left for later : refine test accounting for localstartdate1

#ifdef ALLOW_CAL

      _BEGIN_MASTER(myThid)

      IF ( (using_cost_local).AND.(localobsfile.EQ.' ') ) THEN
c warn user as we override using_cost_local
             WRITE(msgBuf,'(4A)')
     &       '** WARNING ** ECCO_CHECK_FILES: missing file',
     &       ' definition so ',localname,' gets switched off'
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                    SQUEEZE_RIGHT , myThid)
c switch off cost function term
             using_cost_local = .FALSE.
      ENDIF

      singleFileTest = .FALSE.
      IF (using_cost_local) THEN
           inquire( file=localobsfile, exist=exst )
           IF ( exst ) singleFileTest=.TRUE.
      ENDIF

      yearlyFileTest = .FALSE.
      IF ( (using_cost_local).AND.(.NOT.singleFileTest) ) THEN
        DO irec = 1, nmonsrec
           mody   = modelstartdate(1)/10000
           modm   = modelstartdate(1)/100 - mody*100
           yday   = mody + INT((modm-1+irec-1)/12)

           locy   = localstartdate1/10000

           il=ilnblnk(localobsfile)
           WRITE(fname(1:128),'(2a,i4)')
     &       localobsfile(1:il), '_', yday
           inquire( file=fname, exist=exst )

           IF ( (.NOT.exst).AND.(yday.GE.locy) ) THEN
c warn user as we override using_cost_local
             WRITE(msgBuf,'(5A)')
     &       '** WARNING ** ECCO_CHECK_FILES: missing ',fname,
     &       ' so ',localname,' gets switched off'
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                    SQUEEZE_RIGHT , myThid)
c switch off cost function term
             using_cost_local = .FALSE.
           ELSEIF ( (exst).AND.(yday.GE.locy) ) THEN
             yearlyFileTest = .TRUE.
           ENDIF
        ENDDO
      ENDIF

      IF (using_cost_local) THEN
      IF ( (.NOT.yearlyFileTest).AND.(.NOT.singleFileTest) ) THEN
c warn user as we override using_cost_local
             WRITE(msgBuf,'(4A)')
     &       '** WARNING ** ECCO_CHECK_FILES: no data ',
     &       ' so ',localname,' gets switched off'
             CALL PRINT_MESSAGE( msgBuf, errorMessageUnit,
     &                    SQUEEZE_RIGHT , myThid)
c switch off cost function term
             using_cost_local = .FALSE.
      ENDIF
      ENDIF

      _END_MASTER(myThid)

#endif /* ALLOW_CAL */

      RETURN
      END
