#include "PROFILES_OPTIONS.h"
#include "AD_CONFIG.h"

C--  File profiles_nc_utils.F:
C--   Contents
C--   o PROFILES_NF_ERROR
C--   o PROFILES_NC_CLOSE

C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|
CBOP
C !ROUTINE: PROFILES_NF_ERROR

C !INTERFACE:
      SUBROUTINE PROFILES_NF_ERROR( message, STATUS, bi, bj, myThid )

C     !DESCRIPTION:
C     Print NetCDF error message

C     !USES:
      IMPLICIT NONE
C     == Global variables ===
#ifdef ALLOW_PROFILES
# include "SIZE.h"
# include "EEPARAMS.h"
# include "PARAMS.h"
# include "netcdf.inc"
#endif

C     !INPUT PARAMETERS:
C     message   :: optional message
C     STATUS    :: NetCDF error status
C     bi,bj     :: Tile indices
C     myThid: my thread ID number
      CHARACTER*(*) message
      INTEGER STATUS, bi, bj, myThid

C     !OUTPUT PARAMETERS:
CEOP

C     !FUNCTIONS:
      INTEGER ILNBLNK
      EXTERNAL ILNBLNK

C     !LOCAL VARIABLES:
#ifdef ALLOW_PROFILES
      INTEGER IL
      CHARACTER*(MAX_LEN_MBUF) msgBuf

      IF (debugLevel .GE. debLevA .AND. STATUS .NE. NF_NOERR) THEN
        IL = ILNBLNK(message)
        IF ( IL .GT. 0 ) THEN
          WRITE(msgBuf,'(A,A,2I3,1X,A)')
     &     'NF_MESSAGE: PROFILES_', message(1:IL),
     &     bi, bj, NF_STRERROR(STATUS)
        ELSE
          WRITE(msgBuf,'(A,2I3,1X,A)') 'NF_MESSAGE: PROFILES ',
     &     bi, bj, NF_STRERROR(STATUS)
        ENDIF
        CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &       SQUEEZE_RIGHT,myThid )
      ENDIF
#endif /* ALLOW_PROFILES */

      RETURN
      END

C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|
CBOP
C !ROUTINE: PROFILES_NC_CLOSE

C !INTERFACE:
      SUBROUTINE PROFILES_NC_CLOSE( myThid )

C     !DESCRIPTION:
C     Close NetCDF files

C     !USES:
      IMPLICIT NONE
C     == Global variables ===
#ifdef ALLOW_PROFILES
# include "SIZE.h"
# include "EEPARAMS.h"
# include "PROFILES_SIZE.h"
# include "profiles.h"
# include "netcdf.inc"
#endif

C     !INPUT PARAMETERS:
C     myThid :: my Thread Id number
      INTEGER myThid

C     !OUTPUT PARAMETERS:
CEOP

C     !FUNCTIONS:
      INTEGER ILNBLNK
      EXTERNAL ILNBLNK

C     !LOCAL VARIABLES:
#ifdef ALLOW_PROFILES
C     bi,bj :: Tile indices
      INTEGER bi, bj
      INTEGER IL, numFile
      INTEGER STATUS
      CHARACTER*(MAX_LEN_MBUF) msgBuf

      _BEGIN_MASTER( myThid )

      IF (profilesDoNcOutput) THEN
c       DO bj = myByLo(myThid), myByHi(myThid)
c         DO bi = myBxLo(myThid), myBxHi(myThid)
C     Since this is only done by the master thread, we loop over the
C     enire range of tiles
        DO bj = 1, nSy
          DO bi = 1, nSx
            DO numFile = 1, NFILESPROFMAX
              IL = ILNBLNK( profilesfiles(numFile) )

              IF (IL.NE.0) THEN
                WRITE(msgBuf,'(A,A,5(1X,I8))')
     &           'S/R PROFILES_NC_CLOSE:',
     &           ' Closing '//profilesfiles(numFile)(1:IL), numFile,
     &           fiddata(numFile,bi,bj),fidforward(numFile,bi,bj),
     &           fidadjoint(numFile,bi,bj),fidtangent(numFile,bi,bj)
                CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &               SQUEEZE_RIGHT,myThid )
C Data file
                IF ( fiddata(numFile,bi,bj) .GT. 0 ) THEN
                 STATUS = NF_CLOSE( fiddata(numFile,bi,bj) )
                 WRITE(msgBuf,'(A,I3,I8)')
     &                'NC_CLOSE: NF_CLOSE data unit',
     &                numFile, fiddata(numFile,bi,bj)
                 CALL PROFILES_NF_ERROR( msgBuf, STATUS,
     &                bi, bj, myThid )
                ENDIF

C Forward equivalent (.equi) file
                IF ( fidforward(numFile,bi,bj) .GT. 0 ) THEN
                 STATUS = NF_CLOSE( fidforward(numFile,bi,bj) )
                 WRITE(msgBuf,'(A,I3,I8)')
     &                'NC_CLOSE: NF_CLOSE fwd unit',
     &                numFile, fidforward(numFile,bi,bj)
                 CALL PROFILES_NF_ERROR( msgBuf, STATUS,
     &                bi, bj, myThid )
                ENDIF
#ifdef ALLOW_ADJOINT_RUN
C Adjoint equivalent (.equi) file
                IF ( fidadjoint(numFile,bi,bj) .GT. 0 ) THEN
                 STATUS = NF_CLOSE( fidadjoint(numFile,bi,bj) )
                 WRITE(msgBuf,'(A,I3,I8)')
     &                'NC_CLOSE: NF_CLOSE adj unit',
     &                numFile, fidadjoint(numFile,bi,bj)
                 CALL PROFILES_NF_ERROR( msgBuf, STATUS,
     &                bi, bj, myThid )
                ENDIF
#endif
#ifdef ALLOW_TANGENTLINEAR_RUN
C Tangent linear equivalent (.equi) file
                IF ( fidtangent(numFile,bi,bj) .GT. 0 ) THEN
                 STATUS = NF_CLOSE( fidtangent(numFile,bi,bj) )
                 WRITE(msgBuf,'(A,I3,I8)')
     &                'NC_CLOSE: NF_CLOSE tlm unit',
     &                numFile, fidtangent(numFile,bi,bj)
                 CALL PROFILES_NF_ERROR( msgBuf, STATUS,
     &                bi, bj, myThid )
                ENDIF
#endif
              ENDIF !(IL.NE.0)

            ENDDO
          ENDDO
        ENDDO
      ENDIF

      _END_MASTER( myThid )
#endif /* ALLOW_PROFILES */

      RETURN
      END
