#include "OBSFIT_OPTIONS.h"
#ifdef ALLOW_CTRL
# include "CTRL_OPTIONS.h"
#endif

CBOP
C     !ROUTINE: OBSFIT_INLOOP

C     !INTERFACE:
      SUBROUTINE OBSFIT_INLOOP( myTime, myIter, myThid )

C     !DESCRIPTION:
C     ==================================================================
C     | Computes and writes model counterparts for ObsFit data
C     ==================================================================

C     !USES:
      IMPLICIT NONE
C     == Global variables ===
#include "SIZE.h"
#include "EEPARAMS.h"
#include "GRID.h"
#include "DYNVARS.h"
#include "PARAMS.h"
#ifdef ALLOW_CAL
# include "cal.h"
#endif
#ifdef ALLOW_CTRL
# include "OPTIMCYCLE.h"
#endif
#ifdef ALLOW_OBSFIT
# include "OBSFIT_SIZE.h"
# include "OBSFIT.h"
# include "netcdf.inc"
#endif

C     !INPUT PARAMETERS:
C     myTime :: Current time in simulation
C     myIter :: Current iteration number in simulation
C     myThid :: my thread ID number
      _RL     myTime
      INTEGER myIter
      INTEGER myThid
CEOP

#ifdef ALLOW_OBSFIT
C     !LOCAL VARIABLES:
      INTEGER sample_num, num_file, iq
      INTEGER bi, bj
      INTEGER sample_i(NUM_INTERP_PTS_OBS)
      INTEGER sample_j(NUM_INTERP_PTS_OBS)
      INTEGER sample_k(NUM_INTERP_PTS_OBS)
      _RL     sample_frac(NUM_INTERP_PTS_OBS)
      _RL     sample_modval, saved_modval
# ifndef ALLOW_CTRL
      INTEGER optimcycle
# endif
# ifndef ALLOW_ECCO
      INTEGER i,j,k
# endif

C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|

# ifndef ALLOW_CTRL
      optimcycle = 0
# endif

# ifndef ALLOW_ECCO
      DO bj = myByLo(myThid), myByHi(myThid)
        DO bi = myBxLo(myThid), myBxHi(myThid)
          DO k = 1, Nr
            DO j = 1, sNy
              DO i =  1, sNx
                m_UE(i,j,k,bi,bj) = 0. _d 0
                m_VN(i,j,k,bi,bj) = 0. _d 0
              ENDDO
            ENDDO
          ENDDO
        ENDDO
      ENDDO

      CALL ROTATE_UV2EN_RL(
     U     uVel, vVel, m_UE, m_VN,
     I     .TRUE., .TRUE., .FALSE., Nr, myThid )
# endif /* not ALLOW_ECCO */

      _BEGIN_MASTER( myThid )

      DO bj = 1, nSy
        DO bi = 1, nSx
          DO num_file = 1, NFILESMAX_OBS
            DO sample_num = 1, NSAMP_PER_TILE_MAX
              IF ( sample_num.LE.sampleNo(num_file,bi,bj) ) THEN
                IF ( (sample_timeE(num_file,sample_num,bi,bj).GE.
     &           myTime).AND.
     &           (sample_timeS(num_file,sample_num,bi,bj).LT.
     &           (myTime+deltaTClock)) ) THEN
                  DO iq = 1, NUM_INTERP_PTS_OBS
                    sample_i(iq) =
     &               sample_interp_i(num_file,sample_num,iq,bi,bj)
                    sample_j(iq) =
     &               sample_interp_j(num_file,sample_num,iq,bi,bj)
                    sample_k(iq) =
     &               sample_interp_k(num_file,sample_num,iq,bi,bj)
                    sample_frac(iq) = sample_interp_frac
     &               (num_file,sample_num,iq,bi,bj)
                  ENDDO

                  sample_modval = 0
                  saved_modval = 0

C If averaging or integrating in time, read previously
C recorded value and add to it
                  IF ( obsfitOperation(num_file).GT.0 ) THEN
                    CALL ACTIVE_READ_OBS_TILE(
     I                   num_file,
     O                   saved_modval,
     I                   sample_num,.FALSE.,optimcycle,bi,bj,myThid,
     I                   obsfit_dummy(num_file,bi,bj) )
                  ENDIF

                  CALL OBSFIT_SAMPLING(
     O                 sample_modval,
     I                 sample_i, sample_j, sample_k, sample_frac,
     I                 sample_type(num_file,sample_num,bi,bj),
     I                 num_file, bi, bj, myTime, myIter, myThid )

                  sample_modval = sample_modval*
     &             obsfit_facmod(num_file)

                  IF ( obsfitOperation(num_file).GT.0 ) THEN
                    sample_modval = saved_modval
     &               +sample_modval*deltaTClock
                  ENDIF

                  sample_modmask(bi,bj) = sample_modmask(bi,bj)*
     &             sample_weight(num_file,sample_num,bi,bj)

                  CALL ACTIVE_WRITE_OBS_TILE(
     I                 num_file,sample_modval,
     I                 sample_num,optimcycle,bi,bj,myThid,
     I                 obsfit_dummy(num_file,bi,bj) )

                ENDIF !IF ((sample_time
              ENDIF !IF (sampleNo(num_file,bi,bj).NE.0)
            ENDDO !DO sample_num
          ENDDO !DO num_file

        ENDDO
      ENDDO

      _END_MASTER( myThid )

#endif /* ALLOW_OBSFIT */

      RETURN
      END
