C
C     ==========================================
C     MNC : an MITgcm wrapper package for NetCDF
C     ==========================================
C
C     The following common block is the "state" for the MNC interface to
C     NetCDF.  The intent is to keep track of the associations between
C     files, attributes, variables, grids, and dimensions.  These
C     objects are roughly defined as:
C
C     a dimension:
C     - contains: [ name, size ]
C     - exists per-NetCDF-file
C
C     a grid:
C     - contains *ORDERED* sets of dimensions: [ name, 1+ dim-refs ]
C     - exists per-NetCDF-file
C     - NOTE: when created, the name and dim-refs are embedded in
C         the NetCDF file attributes for later retrieval
C     - NOTE: grid coordinates are implemented using variables with
C         special names (eg. lat, lon) and special units
C         (eg. degree_east)
C
C     a variable:
C     - contains: [ name, units, 1 grid-ref, data ]
C     - exists per-NetCDF-file
C     - NOTE: is associated with *exactly* one grid
C
C     an attribute:
C     - contains: [ name, units, data ]
C     - basically, a scalar (non-grid) variable
C     - exists per-NetCDF-file
C
C     a NetCDF file:
C     - contains: [ name, 0+ attr, 0+ grid-ref, 0+ var-ref ]
C
C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|

CBOP 1
C     !ROUTINE: MNC_COMMON.h

C     !INTERFACE:
C     #include "MNC_COMMON.h"

C     !DESCRIPTION:
C     Contains the "look-up" tables for the MNC package.  These tables
C     contain the mappings between the various names and the NetCDF
C     entities.

C     !LOCAL VARIABLES:
C     The following MNC "Internals" are implemented on a
C     PER-NetDCF-FILE basis:
C     .
C     mnc_blank_name    :: (convenience) just MNC_MAX_CHAR spaces
C     .
C     mnc_f_names (fi)  :: file names
C     mnc_g_names (gi)  :: grid names    <----+
C     .                                       |
C     mnc_f_info (fi,-) :: isDEF, fID, Ngrid, g1,ds1,de1,
C     .                                       g2,ds2,de2, ...
C     .                                          |   |
C     mnc_fd_ind (fi,-) :: dim indicies  <-------+---+
C     .                              |
C     mnc_d_names (di)  :: names  <--+  <--+  |
C     mnc_d_ids   (di)  :: IDs    <--+  <--+  +----+
C     mnc_d_size  (di)  :: sizes  <--+  <--+       | starting
C     .                                    |       | indicies of
C     mnc_f_alld (fi,di):: ndim, id1,id2,id3, ...  | grids in
C     .                                            | mnc_f_info
C     .                                 +----------++
C     .                                 |           |
C     mnc_fv_ids (fi,-) :: nVar, n1,ID1,ig1, n2,ID2,ig2, ...
C     .                          |           |
C     mnc_v_names (vi)  ::   <---+-----------+
C
C     fi                ::  file index
C     vi                ::  variable index
C     di                ::  dimension index
C     .
C     .
C     The following MNC "Convenience Wrapper" variables are
C     implemented independently of any NetCDF files
C     .
C     mnc_cw_fgnm  (f)  :: file group name (or "base name")
C     mnc_cw_fgud  (f)  :: file group unlimited dim value
C     mnc_cw_fgis  (f)  :: file group sequence number
C     mnc_cw_fgig  (f)  :: file group unlim dim is growing
C     mnc_cw_fgci  (f)  :: file CITER group number (cig) ------+
C     .                                                        |
C     mnc_cw_cit (3,cig):: CITER (1) flag, (2) current, and    |
C     .                          (3) next model Iter values <--+
C     .
C     mnc_cw_gname (g)  :: Gtype names              <--------+
C     mnc_cw_ndim  (g)  :: number of dimensions              |
C     mnc_cw_dn   (i,g) :: dname1, dname2, ...               |
C     mnc_cw_dims (i,g) :: d1, d2, d3, ...                   |
C     mnc_cw_is   (i,g) :: starting indicies: is1, is2, ...  |
C     mnc_cw_ie   (i,g) :: ending indicies:   ie1, ie2, ...  |
C     .                                                      |
C     mnc_cw_vname (v)  :: Vtype names                       |
C     mnc_cw_vgind (v)  :: index into                --------+
C     mnc_cw_vfmv  (v)  :: flag for missing values
C     .                      0 = ignore it (default)
C     .                      1 = use global value
C     .                      2 = use specific per-var value
C     mnc_cw_vmvi (2,v) :: integer missing values: 1=IN, 2=OUT
C     mnc_cw_vmvr (2,v) :: REAL*4  missing values: 1=IN, 2=OUT
C     mnc_cw_vmvd (2,v) :: REAL*8  missing values: 1=IN, 2=OUT
C     mnc_cw_vnat (3,v) :: number of attributes [T,I,D]
C     mnc_cw_vbij (2,v) :: bi,bi indicies (0 if not applicable)
C     mnc_cw_vtnm (i,v) :: text (character) attribute names
C     mnc_cw_vtat (i,v) :: text (character) attributes
C     mnc_cw_vinm (i,v) :: INT attribute names
C     mnc_cw_viat (i,v) :: INT attributes
C     mnc_cw_vdnm (i,v) :: REAL*8 attribute names
C     mnc_cw_vdat (i,v) :: REAL*8 attributes
C     .
C     mnc_cw_cvnm  (c)  :: CV (coordinate variable) name
C     mnc_cw_cvse (2,c) :: CV start,end indicies  ----+
C     mnc_cw_cvdt (cdt) :: CV data pool       <-------+
C     .
C     f                 :: file group index
C     g                 :: Gtype index
C     v                 :: Vtype index
C     c                 :: CV index
CEOP

#include "MNC_SIZE.h"

C=====================================================================
      COMMON /MNC_VARS_C/
     &     mnc_blank_name,
     &     mnc_g_names, mnc_v_names, mnc_d_names,
     &     mnc_out_path, mnc_f_names

      character*(MNC_MAX_CHAR) mnc_blank_name
      character*(MNC_MAX_CHAR) mnc_g_names(MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_v_names(MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_d_names(MNC_MAX_ID)

      character*(MNC_MAX_PATH) mnc_out_path
      character*(MNC_MAX_PATH) mnc_f_names(MNC_MAX_FID)

C=====================================================================
      COMMON /MNC_VARS_I/
     &     mnc_f_info,  mnc_fd_ind,  mnc_fv_ids,  mnc_f_alld,
     &     mnc_d_size,  mnc_d_ids

      integer mnc_f_info(MNC_MAX_FID,MNC_MAX_INFO)
      integer mnc_fd_ind(MNC_MAX_FID,MNC_MAX_INFO)
      integer mnc_fv_ids(MNC_MAX_FID,MNC_MAX_INFO)
      integer mnc_f_alld(MNC_MAX_FID,MNC_MAX_INFO)

      integer mnc_d_size(MNC_MAX_ID)
      integer mnc_d_ids(MNC_MAX_ID)

C=====================================================================
      COMMON /MNC_CW_VARS_C/
     &     mnc_cw_gname, mnc_cw_dn,
     &     mnc_cw_vname,
     &     mnc_cw_vtnm,  mnc_cw_vinm,  mnc_cw_vdnm,
     &     mnc_cw_fgnm,
     &     mnc_cw_vtat

      character*(MNC_MAX_CHAR) mnc_cw_gname(MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_cw_dn(MNC_CW_MAX_I,MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_cw_vname(MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_cw_vtnm(MNC_CW_MAX_I,MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_cw_vinm(MNC_CW_MAX_I,MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_cw_vdnm(MNC_CW_MAX_I,MNC_MAX_ID)
      character*(MNC_MAX_CHAR) mnc_cw_fgnm(MNC_MAX_ID)

C     Note the longer string length here
      character*(MNC_MAX_CATT) mnc_cw_vtat(MNC_CW_MAX_I,MNC_MAX_ID)

C=====================================================================
      COMMON /MNC_CW_VARS_I/
     &     mnc_cw_ndim,  mnc_cw_dims,
     &     mnc_cw_is,    mnc_cw_ie,
     &     mnc_cw_vgind, mnc_cw_vfmv,  mnc_cw_vmvi, mnc_cw_vnat,
     &     mnc_cw_vbij,  mnc_cw_viat,
     &     mnc_cw_fgud,  mnc_cw_fgis,  mnc_cw_fgig, mnc_cw_fgci,
     &     mnc_cw_cit

      integer mnc_cw_ndim(MNC_MAX_ID)
      integer mnc_cw_dims(MNC_CW_MAX_I,MNC_MAX_ID)
      integer mnc_cw_is(MNC_CW_MAX_I,MNC_MAX_ID)
      integer mnc_cw_ie(MNC_CW_MAX_I,MNC_MAX_ID)

      integer mnc_cw_vgind(MNC_MAX_ID)
      integer mnc_cw_vfmv(MNC_MAX_ID)
      integer mnc_cw_vmvi(2,MNC_MAX_ID)
      integer mnc_cw_vnat(3,MNC_MAX_ID)
      integer mnc_cw_vbij(2,MNC_MAX_ID)
      integer mnc_cw_viat(MNC_CW_MAX_I,MNC_MAX_ID)

      integer mnc_cw_fgud(MNC_MAX_ID)
      integer mnc_cw_fgis(MNC_MAX_ID)
      integer mnc_cw_fgig(MNC_MAX_ID)
      integer mnc_cw_fgci(MNC_MAX_ID)

      integer mnc_cw_cit(3,MNC_MAX_INFO)

C=====================================================================
      COMMON /MNC_CW_VARS_D/
     &     mnc_cw_vdat,  mnc_cw_vmvd
C     &     mnc_cw_cvdt

      REAL*8  mnc_cw_vmvd(2,MNC_MAX_ID)
      REAL*8  mnc_cw_vdat(MNC_CW_MAX_I,MNC_MAX_ID)

C=====================================================================
      COMMON /MNC_CW_VARS_R4/
     &     mnc_cw_vmvr

      REAL*4  mnc_cw_vmvr(2,MNC_MAX_ID)


C---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|

CEH3 ;;; Local Variables: ***
CEH3 ;;; mode:fortran ***
CEH3 ;;; End: ***
