C     ==================================================================
C     HEADER calendar
C     ==================================================================
C
C     o This header file contains variables that are used by the
C       calendar tool. The calendar tool can be used in the ECCO
C       SEALION release of the MITgcmUV.
C
C     started: Christian Eckert eckert@mit.edu  30-Jun-1999
C     changed: Christian Eckert eckert@mit.edu  17-Dec-1999
C              - restructured the original version in order to have a
C                better interface to the MITgcmUV.
C
C     ==================================================================
C     HEADER calendar
C     ==================================================================

C   - Parameters of the numerical model:
C
C     modelStart       :: start time of the numerical model.
C     modelStartDate   :: start date of the numerical model.
C     modelEnd         :: end   time of the numerical model.
C     modelEndDate     :: end   date of the numerical model.
C     modelStep        :: timestep of the numerical model.
C     modelIntSteps    :: number of timestep that are to be performed.
C     modelIter0       :: the numerical models initial timestep number.
C     modelIterEnd     :: the models last timestep number.
C     modelStepsperday :: number of model time steps per day (<- removed).

C   - Parameters used by the calendar:
C
C     refDate          :: first day of the Gregorian Calendar.
C     nMonthYear       :: number months in a year.
C     nDayMonth        :: days per month depending on the year being a leap
C                         year or not. If the Model calendar is used a 360
C                         days year with 30 days months is used instead.
C     nDaysNoLeap      :: number of days in a usual year.
C     nDaysLeap        :: number of days in a leap year.
C     nMaxDayMonth     :: maximum number of days in a years month.
C     hoursPerDay      :: number of hours   in a calendars day.
C     minutesPerDay    :: number of minutes in a calendars day.
C     minutesPerHour   :: number of minutes in a calendars hour.
C     secondsPerDay    :: number of seconds in a calendars day.
C     secondsPerHour   :: number of seconds in a calendars hour.
C     secondsPerMinute :: number of seconds in a calendars minute.
C     cal_setStatus    :: status of calendar parms setting (0=none, 3=fully set)

      INTEGER nMonthYear
      PARAMETER ( nMonthYear = 12 )

      COMMON /CALENDAR_RL/
     &                modelStart,
     &                modelEnd,
     &                modelStep
      _RL modelStart
      _RL modelEnd
      _RL modelStep

      COMMON /CALENDAR_I/
     &               refDate,
     &               nDayMonth,
     &               nDaysNoLeap,
     &               nDaysLeap,
     &               nMaxDayMonth,
     &               hoursPerDay,
     &               minutesPerDay,
     &               minutesPerHour,
     &               secondsPerDay,
     &               secondsPerHour,
     &               secondsPerMinute,
     &               modelStartDate,
     &               modelEndDate,
     &               modelIter0,
     &               modelIterEnd,
     &               modelIntSteps,
     &               cal_setStatus,
     &               startdate_1,
     &               startdate_2

      INTEGER refDate(4)
      INTEGER nDayMonth(nMonthYear,2)
      INTEGER nDaysNoLeap
      INTEGER nDaysLeap
      INTEGER nMaxDayMonth
      INTEGER hoursPerDay
      INTEGER minutesPerDay
      INTEGER minutesPerHour
      INTEGER secondsPerDay
      INTEGER secondsPerHour
      INTEGER secondsPerMinute

      INTEGER modelStartDate(4)
      INTEGER modelEndDate(4)
      INTEGER modelIter0
      INTEGER modelIterEnd
      INTEGER modelIntSteps

      INTEGER cal_setStatus
      INTEGER startdate_1
      INTEGER startdate_2

C   calendarDumps :: When set, approximate months (30-31 days) and years (360-372 days)
C                    for parameters chkPtFreq, pChkPtFreq, taveFreq, SEAICE_taveFreq,
C                    KPP_taveFreq, and freq in pkg/diagnostics are converted to exact
C                    calendar months and years.  Requires pkg/cal.
      COMMON /CALENDAR_L/
     &               calendarDumps,
     &               usingModelCalendar,
     &               usingNoLeapYearCal,
     &               usingJulianCalendar,
     &               usingGregorianCalendar
      LOGICAL calendarDumps
      LOGICAL usingModelCalendar
      LOGICAL usingNoLeapYearCal
      LOGICAL usingJulianCalendar
      LOGICAL usingGregorianCalendar

C     theCalendar :: type of calendar to use; available:
C                    'model', 'gregorian' or 'noLeapYear'.
C     dayOfWeek   :: Week day number one is the week day of refDate.
C                    For the Gregorian calendar this is Friday, 15-Oct-1582.
C     monthOfYear :: Both available calendars are assumed to have twelve
C                    months.
      COMMON /CALENDAR_C/
     &                     theCalendar,
     &                     dayOfWeek,
     &                     monthOfYear
      CHARACTER*(20) theCalendar
      CHARACTER*(3) dayOfWeek(7)
      CHARACTER*(3) monthOfYear(nMonthYear)

