#!/bin/csh -f
#
# Script to build stand-alone (outside ESMF) and component forms
# of the MITgcm atm 5L.
#
cd src/tutorial_examples/aim_5l.LatLon/run
if ( -f Makefile ) then
 make Clean
endif

# Standalone build. Creates executable that is coupled directly through MPI
# and that uses MITgcm WRAPPER for internal communication.
### cp ../code_mods_without_esmf/.genmakerc .
### ../../../tools/genmake -mods=../code_mods_without_esmf -platform=Linux+pgi+mpi
### make depend
### make
### make Clean

# ESMF component build. Creates an ESMF component that is coupled through
# the ESMF superstructure layer and that uses ESMF for internal communications.
cp ../code_mods_with_esmf/.genmakerc .
../../../tools/genmake -mods=../code_mods_with_esmf -platform=Linux+lahey+mpi
make depend
make small_f
ln -s ../../../../../tools/* .
./mkmod.sh atm
