C $Header: $
C $Name:   $  

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE ATM_STORE_HEATFLUX( myCurrentTime, 
     I                               myCurrentIter, 
     I                               myThid )
C     /==========================================================\
C     | SUBROUTINE ATM_STORE_HEATFLUX                            |
C     | o Routine for saving atmos. lower boundary heat flux for |
C     |   export to coupling layer.                              |
C     |==========================================================|
C     | This version interfaces to the MITgcm AIMPHYS package.   |
C     \==========================================================/

C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
C     == Global variables for coupling interface ==
#include "ATMCPL.h"
C     == AIMPHYS specific global data ==
#include "atparam0.h"
#include "atparam1.h"
      INTEGER NGP
      INTEGER NLON
      INTEGER NLAT
      INTEGER NLEV
      PARAMETER ( NLON=IX, NLAT=IL, NLEV=KX, NGP=NLON*NLAT )
#include "com_physvar.h"


C     == Routine arguments ==
C     myThid        - Thread number for this instance of the routine
C     myCurrentIter - Current timestep number
C     myCurrentTime - Current model time
      _RL myCurrentTime
      INTEGER myCurrentIter
      INTEGER myThid
CEndOfInterface

C     == Local variables ==
C     I,J,K,II - Loop counters
C     bi, bj
      INTEGER I,J,K,II
      INTEGER bi, bj

C     o Accumulate heat flux that will be exported to the coupling layer.
C        Heat flux at lower boundary is sum of the upward long-wave radiation 
C       (variable SLR in COMMON/FLUXES/, com_physvar.h), downward short-wave 
C       radiation (variable SSR in COMMON/FLUXES/, com_physvar.h), downward 
C       sensible heat flux (variable SHF in COMMON/FLUXES/, com_physvar.h) 
C       and latent heat flux due to evaporation (variable EVAP in 
C       COMMON/FLUXES/, com_physvar.h). Index 2 of SHF and EVAP give fluxes 
C       over sea. SLR is the flux that is radiated by the ocean/land. SSR
C       is the incoming short-wave radiation that is absorbed by the ocean/land. 
C       Variable ALHC is the latent heat of evaporation/condensation (see 
C       COMMON/PHYCON/, com_phycon.h).
C        HeatFlux is defined with positive into the atmosphere, units are W/m^2 
C       (* deltaTtracer).
      HeatFluxTime = HeatFluxTime + deltaTtracer
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO J=1,sNy
         DO I=1,sNx
          II = (sNx)*(J-1)+I
          HeatFlux(I,J,bi,bj) = 
     &    HeatFlux(I,J,bi,bj) + 
     &             ( EVAP(II,2,myThid)*ALHC
     &           +    SHF(II,2,myThid)
     &           +    SLR(II,myThid)
     &           -    SSR(II,myThid) )*deltaTtracer
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      RETURN
      END
