
#include "GMREDI_OPTIONS.h"

      subroutine GMREDI_XTRANSPORT(
     I     iMin,iMax,jMin,jMax,bi,bj,K,
     I     xA,Tracer,
     U     df,
     I     myThid)
C     /==========================================================\
C     | o SUBROUTINE GMREDI_XTRANSPORT                           |
C     |   Add horizontal x transport terms from GM/Redi          |
C     |   parameterization.                                      |
C     |==========================================================|
C     \==========================================================/
      IMPLICIT NONE

C     == GLobal variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "GRID.h"
#include "GMREDI.h"

#ifdef ALLOW_AUTODIFF_TAMC
#include "tamc.h"
#include "tamc_keys.h"
#endif /* ALLOW_AUTODIFF_TAMC */

C     == Routine arguments ==
C     iMin,iMax,jMin,  - Range of points for which calculation
C     jMax,bi,bj,k       results will be set.
C     xA               - Area of X face
C     Tracer           - 3D Tracer field
C     df               - Diffusive flux component work array.
      INTEGER iMin,iMax,jMin,jMax,bi,bj,k
      _RS xA(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      _RL Tracer(1-OLx:sNx+OLx,1-OLy:sNy+OLy,Nr,nSx,nSy)
      _RL df    (1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      INTEGER myThid

#ifdef ALLOW_GMREDI

C     == Local variables ==
C     I, J - Loop counters
      INTEGER I, J
      INTEGER km1,kp1
      _RL uTrans, maskp1, dTdz

#ifdef ALLOW_AUTODIFF_TAMC
          act1 = bi - myBxLo(myThid)
          max1 = myBxHi(myThid) - myBxLo(myThid) + 1
          act2 = bj - myByLo(myThid)
          max2 = myByHi(myThid) - myByLo(myThid) + 1
          act3 = myThid - 1
          max3 = nTx*nTy
          act4 = ikey_dynamics - 1
          ikey = (act1 + 1) + act2*max1
     &                      + act3*max1*max2
     &                      + act4*max1*max2*max3
          kkey = (ikey-1)*Nr + k
#endif /* ALLOW_AUTODIFF_TAMC */

      IF (useGMRedi) THEN
 
#ifdef GM_NON_UNITY_DIAGONAL
#ifdef ALLOW_AUTODIFF_TAMC
CADJ STORE Kux(:,:,k,bi,bj)     = comlev1_bibj_k, key=kkey, byte=isbyte
#endif
#endif

C--   Area integrated zonal flux
      DO j=jMin,jMax
       DO i=iMin,iMax
        df(i,j) = df(i,j)
     &   -xA(i,j)
#ifdef GM_NON_UNITY_DIAGONAL
     &    *Kux(i,j,k,bi,bj)
#else
     &    *(GM_isopycK 
#ifdef GM_VISBECK_VARIABLE_K
     &    +0.5*(VisbeckK(i,j,bi,bj)+VisbeckK(i-1,j,bi,bj))
#endif
     &    )
#endif /* GM_NON_UNITY_DIAGONAL */
     &    *_recip_dxC(i,j,bi,bj)
     &    *(Tracer(i,j,k,bi,bj)-Tracer(i-1,j,k,bi,bj))
       ENDDO
      ENDDO

#ifdef GM_EXTRA_DIAGONAL
      IF (GM_ExtraDiag) THEN
       km1 = MAX(k-1,1)
       kp1 = MIN(k+1,Nr)

       DO j=jMin,jMax
        DO i=iMin,iMax

C-      Vertical gradients interpolated to U points
        dTdz =  0.5*(
     &   +0.5*recip_drC(k)*
     &       ( maskC(i-1,j,k,bi,bj)*
     &           (Tracer(i-1,j,km1,bi,bj)-Tracer(i-1,j,k,bi,bj))
     &        +maskC( i ,j,k,bi,bj)*
     &           (Tracer( i ,j,km1,bi,bj)-Tracer( i ,j,k,bi,bj))
     &       )
     &   +0.5*recip_drC(kp1)*
     &       ( maskC(i-1,j,kp1,bi,bj)*
     &           (Tracer(i-1,j,k,bi,bj)-Tracer(i-1,j,kp1,bi,bj))
     &        +maskC( i ,j,kp1,bi,bj)*
     &           (Tracer( i ,j,k,bi,bj)-Tracer( i ,j,kp1,bi,bj))
     &       )      )      

C-      Off-diagonal components of horizontal flux
          df(i,j) = df(i,j) - xA(i,j)*Kuz(i,j,k,bi,bj)*dTdz

        ENDDO
       ENDDO
      ENDIF
#endif /* GM_EXTRA_DIAGONAL */

#ifdef GM_BOLUS_ADVEC
      IF (GM_AdvForm .AND. GM_AdvSeparate) THEN
       kp1 = MIN(k+1,Nr)
       maskp1 = 1.
       IF (k.GE.Nr) maskp1 = 0.
       DO j=jMin,jMax
        DO i=iMin,iMax
         uTrans = dyG(i,j,bi,bj)*( GM_PsiX(i,j,kp1,bi,bj)*maskp1
     &                            -GM_PsiX(i,j,k,bi,bj) )
     &                          *maskW(i,j,k,bi,bj)
         df(i,j) = df(i,j)
     &    +uTrans*0.5*(Tracer(i,j,k,bi,bj)+Tracer(i-1,j,k,bi,bj))
        ENDDO
       ENDDO
      ENDIF
#endif /* GM_BOLUS_ADVEC */

      ENDIF
#endif /* ALLOW_GMREDI */

      RETURN
      END
