C $Header: $
C $Name:   $

#include "CPP_OPTIONS.h"

CBOP
C     !ROUTINE: DRIVER_INIT
C     !INTERFACE:
      SUBROUTINE DRIVER_INIT(
     O              atm_HeatFlux, atm_TauX, atm_TauY,
     O              atm_Qlatent, atm_Qsensible, atm_Qlongwave,
     O              atm_Qshortwave,
     O              atm_uVelGround, atm_vVelGround,
     O              atm_FWFlux, atm_Hatm,
     I              ocn_Hocn, ocn_SSTocn
     &                      )

C     !DESCRIPTION: \bv
C     *==================================================================
C     | SUBROUTINE driver_init
C     | o External driver control routine for MITgcm init phase.
C     *==================================================================
C     |
C     | DRIVER routines are used to control the MITgcm code from an external
C     | driver. This routine invokes the init phase of code execution
C     |
C     *==================================================================
C     \ev

C     !USES:
      IMPLICIT NONE
C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "GRID.h"
#include "ATMCPL.h"

C     == Routine arguments ==
      _RL atm_HeatFlux(   1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauX(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauY(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlatent(    1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qsensible(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlongwave(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qshortwave( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_uVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_vVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_FWFlux(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Hatm(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL ocn_Hocn(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL ocn_SSTocn(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)


C     == Local variables ==
C     myThid :: Thread number for this instance of the routine
      INTEGER myThid
      INTEGER I,J,bi,bj

#define SPLIT_DRIVER
#ifdef  SPLIT_DRIVER
      INTEGER myCurrentIter
      _RL     myCurrentTime
      INTEGER iLoop
#endif

CEOP

      CALL COMP_ATM_PUSH_CONTEXT(1)
      myThid = 1

C     Read the import fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1-OLy,sNy+OLy
         DO i=1-OLx,sNx+OLx
          Hocn(  i,j,bi,bj) = ocn_Hocn(  i,j,bi,bj)
          SSTocn(i,j,bi,bj) = ocn_SSTocn(i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      CALL EEBOOT()
      myThid = 1
      CALL INITIALISE_FIXED(    myThid )
      CALL INITIALISE_VARIA(    myThid )

#ifdef  SPLIT_DRIVER
      myCurrentTime = startTime
      myCurrentIter = nIter0
      myThid = 1
      iLoop  = 1
      CALL FORWARD_STEP_SETUP( iLoop, myCurrentTime, myCurrentIter, myThid    )
#endif

C     Fill the export fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1-OLy,sNy+OLy
         DO i=1-OLx,sNx+OLx
          atm_HeatFlux(   i,j,bi,bj)=HeatFlux(  i,j,bi,bj)
          atm_TauX(       i,j,bi,bj)=tauX(      i,j,bi,bj)
          atm_TauY(       i,j,bi,bj)=tauY(      i,j,bi,bj)
          atm_Qlatent(    i,j,bi,bj)=qLatent(   i,j,bi,bj)
          atm_Qsensible(  i,j,bi,bj)=qSensible( i,j,bi,bj)
          atm_Qlongwave(  i,j,bi,bj)=qLongwave( i,j,bi,bj)
          atm_Qshortwave( i,j,bi,bj)=qShortwave(i,j,bi,bj)
          atm_uVelGround( i,j,bi,bj)=uVelGround(i,j,bi,bj)
          atm_vVelGround( i,j,bi,bj)=vVelGround(i,j,bi,bj)
          atm_FWFlux(     i,j,bi,bj)=FWFlux(    i,j,bi,bj)
          atm_Hatm(       i,j,bi,bj)=Ro_surf(   i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      CLOSE(errorMessageUnit)
      CLOSE(standardMessageUnit)
      CALL COMP_ATM_POP_CONTEXT(1)

      RETURN
      END
