C $Header: $
C $Name:   $

#include "CPP_OPTIONS.h"

CBOP
C     !ROUTINE: DRIVER_RUN
C     !INTERFACE:
      SUBROUTINE DRIVER_RUN(
     O              atm_HeatFlux, atm_TauX, atm_TauY,
     O              atm_Qlatent, atm_Qsensible, atm_Qlongwave,
     O              atm_Qshortwave,
     O              atm_uVelGround, atm_vVelGround,
     O              atm_FWFlux,
     I              ocn_Hocn, ocn_SSTocn,
     I              startStep, stopStep
     &                     )

C     !DESCRIPTION: \bv
C     *==================================================================
C     | SUBROUTINE driver_mitgcm_forward
C     | o External driver control routine for MITgcm forward phase.
C     *==================================================================
C     |
C     | DRIVER routines are used to control the MITgcm code from an external
C     | driver. This routine invokes the forward phase of code execution
C     |
C     *==================================================================
C     \ev

C     !USES:
      IMPLICIT NONE
C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "EESUPPORT.h"
#include "PARAMS.h"
#include "ATMCPL.h"

C     == Routine arguments ==
      _RL atm_HeatFlux(   1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauX(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauY(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlatent(    1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qsensible(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlongwave(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qshortwave( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_uVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_vVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_FWFlux(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL ocn_Hocn(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL ocn_SSTocn(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      INTEGER startStep, stopStep

C     == Local variables ==
C     myThid :: Thread number for this instance of the routine
      INTEGER myThid
      INTEGER myCurrentIter
      _RL     myCurrentTime
      INTEGER iLoop
      INTEGER i,j,bi,bj
      CHARACTER*13 fNam
CEOP
#define SPLIT_DRIVER

      CALL COMP_ATM_PUSH_CONTEXT(1)
      myThid = 1
      CLOSE(errorMessageUnit)
      CLOSE(standardMessageUnit)
!     myProcessStr  = '0000'
      WRITE(fNam,'(A,A)') 'STDERR.', myProcessStr(1:4)
      OPEN(errorMessageUnit,FILE=fNam,STATUS='old',POSITION='append')
      WRITE(fNam,'(A,A)') 'STDOUT.', myProcessStr(1:4)
      OPEN(standardMessageUnit,FILE=fNam,STATUS='old',POSITION='append')


C     Extract the import fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1-OLy,sNy+OLy
         DO i=1-OLx,sNx+OLx
          Hocn(  i,j,bi,bj) = ocn_Hocn(  i,j,bi,bj)
          SSTocn(i,j,bi,bj) = ocn_SSTocn(i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      nTimeSteps    = stopStep-startStep
      myCurrentTime = startTime+startStep*deltaTClock
      myCurrentIter = nIter0+startStep
      myThid        = 1

      CALL MONITOR( myCurrentIter, myCurrentTime, myThid )
#ifdef  SPLIT_DRIVER
      DO iLoop = 1, nTimeSteps-1
       CALL FORWARD_STEP_EXECUTE( iLoop, myCurrentTime, myCurrentIter, myThid )
       CALL FORWARD_STEP_SETUP( iLoop+1, myCurrentTime, myCurrentIter, myThid )
      ENDDO
#else
      DO iLoop = 1, nTimeSteps
       CALL FORWARD_STEP( iLoop, myCurrentTime, myCurrentIter, myThid )
      ENDDO
#endif

#ifdef  SPLIT_DRIVER
      iLoop = nTimeSteps
      CALL FORWARD_STEP_EXECUTE( iLoop, myCurrentTime, myCurrentIter, myThid  )
#endif

C     Fill the export fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1-OLy,sNy+OLy
         DO i=1-OLx,sNx+OLx
          atm_HeatFlux(   i,j,bi,bj)=HeatFlux(  i,j,bi,bj)
          atm_TauX(       i,j,bi,bj)=tauX(      i,j,bi,bj)
          atm_TauY(       i,j,bi,bj)=tauY(      i,j,bi,bj)
          atm_Qlatent(    i,j,bi,bj)=qLatent(   i,j,bi,bj)
          atm_Qsensible(  i,j,bi,bj)=qSensible( i,j,bi,bj)
          atm_Qlongwave(  i,j,bi,bj)=qLongwave( i,j,bi,bj)
          atm_Qshortwave( i,j,bi,bj)=qShortwave(i,j,bi,bj)
          atm_uVelGround( i,j,bi,bj)=uVelGround(i,j,bi,bj)
          atm_vVelGround( i,j,bi,bj)=vVelGround(i,j,bi,bj)
          atm_FWFlux(     i,j,bi,bj)=FWFlux(    i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      CLOSE(errorMessageUnit)
      CLOSE(standardMessageUnit)
      CALL COMP_ATM_POP_CONTEXT(1)

      RETURN
      END
