C $Header: /u/u0/gcmpack/MITgcm/model/src/forward_step.F,v 1.34 2002/07/13 04:59:42 heimbach Exp $
C $Name: checkpoint46 $

#include "CPP_OPTIONS.h"

CBOP
C     !ROUTINE: FORWARD_STEP_SETUP
C     !INTERFACE:
      SUBROUTINE FORWARD_STEP_SETUP( iloop, myTime, myIter, myThid )

C     !DESCRIPTION: \bv
C     *==================================================================
C     | SUBROUTINE forward_step
C     | o Run the ocean model and, optionally, evaluate a cost function.
C     *==================================================================
C     |
C     | THE_MAIN_LOOP is the toplevel routine for the Tangent Linear and
C     | Adjoint Model Compiler (TAMC). For this purpose the initialization
C     | of the model was split into two parts. Those parameters that do
C     | not depend on a specific model run are set in INITIALISE_FIXED,   
C     | whereas those that do depend on the specific realization are
C     | initialized in INITIALISE_VARIA.   
C     |
C     *==================================================================
C     \ev

C     !USES:
      IMPLICIT NONE
C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "DYNVARS.h"
#include "FFIELDS.h"

#ifdef ALLOW_NONHYDROSTATIC
#include "CG3D.h"
#endif

#ifdef ALLOW_SHAP_FILT
#include "SHAP_FILT.h"
#endif
#ifdef ALLOW_ZONAL_FILT
#include "ZONAL_FILT.h"
#endif

#ifdef ALLOW_AUTODIFF_TAMC
# include "tamc.h"
# include "ctrl.h"
# include "ctrl_dummy.h"
# include "cost.h"
# ifdef INCLUDE_EXTERNAL_FORCING_PACKAGE
#  include "exf_fields.h"
#  ifdef ALLOW_BULKFORMULAE
#   include "exf_constants.h"
#  endif
# endif
# ifdef ALLOW_OBCS
#  include "OBCS.h"
# endif
#endif

C     !LOCAL VARIABLES:
C     == Routine arguments ==
C     note: under the multi-threaded model myiter and 
C           mytime are local variables passed around as routine 
C           arguments. Although this is fiddly it saves the need to 
C           impose additional synchronisation points when they are 
C           updated.
C     myiter - iteration counter for this thread
C     mytime - time counter for this thread
C     mythid - thread number for this instance of the routine.
      integer iloop
      integer mythid 
      integer myiter
      _RL     mytime
      INTEGER bi,bj

CEOP


#ifdef ALLOW_AUTODIFF_TAMC
C--     Reset the model iteration counter and the model time.
        myiter = nIter0 + (iloop-1)
        mytime = startTime + float(iloop-1)*deltaTclock
#endif

#if (defined (ALLOW_AUTODIFF_TAMC) && defined (ALLOW_AUTODIFF_MONITOR))
C       Include call to a dummy routine. Its adjoint will be 
C       called at the proper place in the adjoint code.
C       The adjoint routine will print out adjoint values 
C       if requested. The location of the call is important, 
C       it has to be after the adjoint of the exchanges 
C       (DO_GTERM_BLOCKING_EXCHANGES).
        CALL DUMMY_IN_STEPPING( myTime, myIter, myThid )
        CALL DO_FIELDS_BLOCKING_EXCHANGES( myThid )
#endif

#ifdef EXACT_CONSERV
      IF (exactConserv) THEN
C--   Update etaH(n+1) :
        DO bj=myByLo(myThid),myByHi(myThid)
         DO bi=myBxLo(myThid),myBxHi(myThid)
           CALL CALC_EXACT_ETA( .FALSE., bi,bj, uVel,vVel,
     I                          myTime, myIter, myThid )
         ENDDO
        ENDDO
        IF (implicDiv2Dflow .NE. 1. _d 0 .OR. useOBCS )
     &     _EXCH_XY_R8(etaH, myThid )
      ENDIF
#endif /* EXACT_CONSERV */ 

#ifdef NONLIN_FRSURF
C--   compute the future surface level thickness
C      according to etaH(n+1) 
        IF ( nonlinFreeSurf.GT.0) THEN
          CALL CALC_SURF_DR(etaH, myTime, myIter, myThid )
        ENDIF
#endif /* NONLIN_FRSURF */

C--     Load forcing/external data fields.
#ifdef INCLUDE_EXTERNAL_FORCING_PACKAGE
C       NOTE, that although the exf package is part of the
C       distribution, it is not currently maintained, i.e.
C       exf is disabled by default in genmake.
#ifdef ALLOW_AUTODIFF_TAMC
c**************************************
#include "checkpoint_lev1_directives.h"
c**************************************
#endif
        CALL EXF_GETFORCING( mytime, myiter, mythid )
#else
        CALL TIMER_START('EXTERNAL_FIELDS_LOAD[THE_MAIN_LOOP]',mythid)
        CALL EXTERNAL_FIELDS_LOAD( mytime, myiter, mythid )
        CALL TIMER_STOP ('EXTERNAL_FIELDS_LOAD[THE_MAIN_LOOP]',mythid)
#endif

#ifdef AIM_COMPONENT_INTERFACE
C      Post coupling data that I export.
C      Read in coupling data that I import.
       CALL CPL_EXPORT_MY_DATA(
     I      myIter, myTime, myThid )
       CALL CPL_IMPORT_EXTERNAL_DATA(
     I      myIter, myTime, myThid )
#endif
      RETURN
      END
