C $Header: $
C $Name:   $

#include "CPP_OPTIONS.h"

CBOP
C     !ROUTINE: DRIVER_RUN
C     !INTERFACE:
      SUBROUTINE DRIVER_RUN

C     !DESCRIPTION: \bv
C     *==================================================================
C     | SUBROUTINE driver_mitgcm_forward
C     | o External driver control routine for MITgcm forward phase.
C     *==================================================================
C     |
C     | DRIVER routines are used to control the MITgcm code from an external
C     | driver. This routine invokes the forward phase of code execution
C     |
C     *==================================================================
C     \ev

C     !USES:
      IMPLICIT NONE
C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"

C     == Local variables ==
C     myThid :: Thread number for this instance of the routine
      INTEGER myThid
      INTEGER myCurrentIter
      _RL     myCurrentTime
      INTEGER iLoop
CEOP
#define SPLIT_DRIVER

C     CALL COMP_ATM_PUSH_CONTEXT(1)
      myCurrentTime = startTime
      myCurrentIter = nIter0
      myThid = 1

      CALL MONITOR( myCurrentIter, myCurrentTime, myThid )
#ifdef  SPLIT_DRIVER
      DO iLoop = 1, nTimeSteps-1
       CALL CPL_IMPORT_EXTERNAL_DATA(
     I      myCurrentIter, myCurrentTime, myThid )
       CALL FORWARD_STEP_EXECUTE( iLoop, myCurrentTime, myCurrentIter, myThid )
       CALL FORWARD_STEP_SETUP( iLoop+1, myCurrentTime, myCurrentIter, myThid )
      ENDDO
#else
      DO iLoop = 1, nTimeSteps
       CALL FORWARD_STEP( iLoop, myCurrentTime, myCurrentIter, myThid )
      ENDDO
#endif

#ifdef  SPLIT_DRIVER
      iLoop = nTimeSteps
       CALL CPL_IMPORT_EXTERNAL_DATA(
     I      myCurrentIter, myCurrentTime, myThid )
      CALL FORWARD_STEP_EXECUTE( iLoop, myCurrentTime, myCurrentIter, myThid  )
#endif

C     CALL COMP_ATM_POP_CONTEXT(1)


      RETURN
      END
