C $Header: $
C $Name:   $  

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE ATM_STORE_UVELGROUND( myCurrentTime, 
     I                           myCurrentIter, 
     I                           myThid )
C     /==========================================================\
C     | SUBROUTINE ATM_STORE_UVELGROUND                          |
C     | o Routine for saving atmos. lower boundary wind speed    |
C     |   for export to coupling layer.                          |
C     |==========================================================|
C     | This version interfaces to the MITgcm AIMPHYS package.   |
C     \==========================================================/

C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "DYNVARS.h"
C     == Global variables for coupling interface ==
#include "ATMCPL.h"

C     == Routine arguments ==
C     myThid        - Thread number for this instance of the routine
C     myCurrentIter - Current timestep number
C     myCurrentTime - Current model time
      _RL myCurrentTime
      INTEGER myCurrentIter
      INTEGER myThid
CEndOfInterface

C     == Local variables ==
C     I,J,K - Loop counters
C     bi, bj
      INTEGER I,J,K
      INTEGER bi, bj

C     o Accumulate zonal wind speed that will be exported to the 
C       coupling layer. Speed is in m/s with positive 
C       to the east. Wind speed is in COMMON /DYNVARS_R/,
C       DYNVARS.h variable uVel using a south-west-c-grid staggering.
      uVelGroundTime = uVelGroundTime + deltaTClock
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO J=1,sNy
         DO I=1,sNx
          uVelGround(I,J,bi,bj) = 
     &    uVelGround(I,J,bi,bj) + uVel(I,J,1,bi,bj)*deltaTClock
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      RETURN
      END
