C $Header: /u/u0/gcmpack/MITgcm/pkg/generic_advdiff/gad_c4_adv_r.F,v 1.4 2001/09/21 13:11:43 adcroft Exp $
C $Name: checkpoint46 $

C $Header: /u/u0/gcmpack/MITgcm/pkg/generic_advdiff/GAD_OPTIONS.h,v 1.4 2001/09/28 03:36:16 adcroft Exp $
C $Name: checkpoint46 $

CBOP
C !ROUTINE: GAD_OPTIONS.h

C !INTERFACE:
C #include "GAD_OPTIONS.h" 

C !DESCRIPTION:
C Contains CPP macros/flags for controlling optional features of package.
CEOP

C CPP options file for GAD (Generic Advection Diffusion) package
C
C Use this file for selecting options within the GAD package
C
C GAD is enabled with ALLOW_GAD in CPP_OPTIONS.h

C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/CPP_OPTIONS.h,v 1.2 2001/05/29 14:01:48 adcroft Exp $
C $Name: checkpoint46 $
C

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/CPP_EEOPTIONS.h,v 1.2 2001/05/29 14:01:48 adcroft Exp $
C $Name: checkpoint46 $
C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C--   Control MPI based parallel processing





 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 
C--   Control use of "double" precision constants.
C     Use D0 where it means REAL*8 but not where it means REAL*16


C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.







C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name: checkpoint46 $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.




















C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.

 
C--   Control use of "double" precision constants.
C     Use d0 where it means REAL*8 but not where it means REAL*16


C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








C o Include/exclude code specific to the ECCO/SEALION version.



C o Enable/disable state import and export.








C The selects the form of COSINE(lat) scaling of bi-harmonic term.
C *only for use on a lat-lon grid*


C The selects isotropic scaling of bi-harmonic term when
C using the COSINE(lat) scaling.


C As of checkpoint41, the inclusion of multi-dimensional advection
C introduces excessive recomputation/storage for the adjoint.
C We can disable it here using CPP because run-time flags are insufficient.






CBOP
C !ROUTINE: GAD_C4_ADV_R

C !INTERFACE: ==========================================================
      SUBROUTINE GAD_C4_ADV_R( 
     I           bi,bj,k,
     I           rTrans,
     I           tracer,
     O           wT,
     I           myThid )

C !DESCRIPTION:
C Calculates the area integrated vertical flux due to advection of a tracer
C using centered fourth-order interpolation:
C \begin{equation*}
C F^r_{adv} = W \overline{ \theta - \frac{1}{6} \delta_{kk} \theta }^k
C \end{equation*}
C Near boundaries, the scheme reduces to a second if the flow is away
C from the boundary and to third order if the flow is towards
C the boundary.

C !USES: ===============================================================
      IMPLICIT NONE
C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/SIZE.h,v 1.3 2001/09/27 15:36:29 jmc Exp $
C $Name: checkpoint46 $
C
C     /==========================================================C     | SIZE.h Declare size of underlying computational grid.    |
C     |==========================================================|
C     | The design here support a three-dimensional model grid   |
C     | with indices I,J and K. The three-dimensional domain     |
C     | is comprised of nPx*nSx blocks of size sNx along one axis|
C     | nPy*nSy blocks of size sNy along another axis and one    |
C     | block of size Nz along the final axis.                   |
C     | Blocks have overlap regions of size OLx and OLy along the|
C     | dimensions that are subdivided.                          |
C     \==========================================================/
C     Voodoo numbers controlling data layout.
C     sNx - No. X points in sub-grid.
C     sNy - No. Y points in sub-grid.
C     OLx - Overlap extent in X.
C     OLy - Overlat extent in Y.
C     nSx - No. sub-grids in X.
C     nSy - No. sub-grids in Y.
C     nPx - No. of processes to use in X.
C     nPy - No. of processes to use in Y.
C     Nx  - No. points in X for the total domain.
C     Ny  - No. points in Y for the total domain.
C     Nr  - No. points in Z for full process domain.
      INTEGER sNx
      INTEGER sNy
      INTEGER OLx
      INTEGER OLy
      INTEGER nSx
      INTEGER nSy
      INTEGER nPx
      INTEGER nPy
      INTEGER Nx
      INTEGER Ny
      INTEGER Nr
      PARAMETER (
     &           sNx = 128,
     &           sNy =   4,
C    &           sNy =   8,
C    &           sNy =  16,
C    &           sNy =  32,
C    &           sNy =  64,
     &           OLx =   3,
     &           OLy =   3,
     &           nSx =   1,
     &           nSy =   1,
     &           nPx =   1,
     &           nPy =  16,
C    &           nPy =   8,
C    &           nPy =   4,
C    &           nPy =   2,
C    &           nPy =   1,
     &           Nx  = sNx*nSx*nPx,
     &           Ny  = sNy*nSy*nPy,
     &           Nr  =   5)

C     MAX_OLX  - Set to the maximum overlap region size of any array
C     MAX_OLY    that will be exchanged. Controls the sizing of exch
C                routine buufers.
      INTEGER MAX_OLX
      INTEGER MAX_OLY
      PARAMETER ( MAX_OLX = OLx,
     &            MAX_OLY = OLy )

C $Header: /u/u0/gcmpack/MITgcm/model/inc/GRID.h,v 1.18 2001/11/08 16:34:57 jmc Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: GRID.h
C    !INTERFACE:
C    include GRID.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | GRID.h                                                    
C     | o Header file defining model grid.                        
C     *==========================================================*
C     | Model grid is defined for each process by reference to    
C     | the arrays set here.                                      
C     | Notes                                                     
C     | =====                                                     
C     | The standard MITgcm convention of westmost, southern most 
C     | and upper most having the (1,1,1) index is used here.     
C     | i.e.                                                      
C     |---------------------------------------------------------- 
C     | (1)  Plan view schematic of model grid (top layer i.e. )  
C     |      ================================= ( ocean surface )  
C     |                                        ( or top of     )  
C     |                                        ( atmosphere    )  
C     |      This diagram shows the location of the model         
C     |      prognostic variables on the model grid. The "T"      
C     |      location is used for all tracers. The figure also    
C     |      shows the southern most, western most indexing       
C     |      convention that is used for all model variables.     
C     |                                                           
C     |                                                           
C     |             V(i=1,                     V(i=Nx,            
C     |               j=Ny+1,                    j=Ny+1,          
C     |               k=1)                       k=1)             
C     |                /|\                       /|\  "PWX"       
C     |       |---------|------------------etc..  |---- *---      
C     |       |                     |                   *  |      
C     |"PWY"*******************************etc..  **********"PWY" 
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x           |             x     *==>U     
C     |  j=Ny,|      T(i=1,         |          T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=Ny,        |            j=Ny,  *  |j=Ny, 
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |                                                           
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       e                     e                   *  e      
C     |       t                     t                   *  t      
C     |       c                     c                   *  c      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x           |             x     *  |      
C     |  j=2, |      T(i=1,         |          T(i=Nx,  *  |      
C     |  k=1) |        j=2,         |            j=2,   *  |      
C     |       |        k=1)         |            k=1)   *  |      
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |      -----------|------------------etc..  |-----*---      
C     |       |       V(i=1,        |           V(i=Nx, *  |      
C     |       |         j=2,        |             j=2,  *  |      
C     |       |         k=1)        |             k=1)  *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=1,         |  k=1)      j=1,   *  |j=1,  
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |"SB"++>|---------|------------------etc..  |-----*---      
C     |      /+\      V(i=1,                    V(i=Nx, *         
C     |       +         j=1,                      j=1,  *         
C     |       +         k=1)                      k=1)  *         
C     |     "WB"                                      "PWX"       
C     |                                                           
C     |   N, y increasing northwards                              
C     |  /|\ j increasing northwards                              
C     |   |                                                       
C     |   |                                                       
C     |   ======>E, x increasing eastwards                        
C     |             i increasing eastwards                        
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    U: x-velocity (m/s)                                    
C     |    V: y-velocity (m/s)                                    
C     |    T: potential temperature (oC)                          
C     | "SB": Southern boundary                                   
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |"PWY": Periodic wrap around in Y.                          
C     |---------------------------------------------------------- 
C     | (2) South elevation schematic of model grid               
C     |     =======================================               
C     |     This diagram shows the location of the model          
C     |     prognostic variables on the model grid. The "T"       
C     |     location is used for all tracers. The figure also     
C     |     shows the upper most, western most indexing           
C     |     convention that is used for all model variables.      
C     |                                                           
C     |      "WB"                                                 
C     |       +                                                   
C     |       +                                                   
C     |      \+/       /|\                       /|\       .
C     |"UB"++>|-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=1)        |             k=1)  *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=1,         |  k=1)      j=1,   *  |j=1,  
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |       |-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=2)        |             k=2)  *  |      
C     |                                                           
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       e                     e                   *  e      
C     |       t                     t                   *  t      
C     |       c                     c                   *  c      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |       |-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=Nr)       |             k=Nr) *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=Nr)|        j=1,         |  k=Nr)     j=1,   *  |j=1,  
C     |       |        k=Nr)        |            k=Nr)  *  |k=Nr) 
C     |       |                     |                   *  |      
C     |"LB"++>==============================================      
C     |                                               "PWX"       
C     |                                                           
C     | Up   increasing upwards.                                  
C     |/|\                                                       .
C     | |                                                         
C     | |                                                         
C     | =====> E  i increasing eastwards                          
C     | |         x increasing eastwards                          
C     | |                                                         
C     |\|/                                                        
C     | Down,k increasing downwards.                              
C     |                                                           
C     | Note: r => height (m) => r increases upwards              
C     |       r => pressure (Pa) => r increases downwards         
C     |                                                           
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    U: x-velocity (m/s)                                    
C     | rVel: z-velocity ( units of r )                           
C     |       The vertical velocity variable rVel is in units of  
C     |       "r" the vertical coordinate. r in m will give       
C     |       rVel m/s. r in Pa will give rVel Pa/s.              
C     |    T: potential temperature (oC)                          
C     | "UB": Upper boundary.                                     
C     | "LB": Lower boundary (always solid - therefore om|w == 0) 
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |---------------------------------------------------------- 
C     | (3) Views showing nomenclature and indexing               
C     |     for grid descriptor variables.                        
C     |                                                           
C     |      Fig 3a. shows the orientation, indexing and          
C     |      notation for the grid spacing terms used internally  
C     |      for the evaluation of gradient and averaging terms.  
C     |      These varaibles are set based on the model input     
C     |      parameters which define the model grid in terms of   
C     |      spacing in X, Y and Z.                               
C     |                                                           
C     |      Fig 3b. shows the orientation, indexing and          
C     |      notation for the variables that are used to define   
C     |      the model grid. These varaibles are set directly     
C     |      from the model input.                                
C     |                                                           
C     | Figure 3a                                                 
C     | =========                                                 
C     |       |------------------------------------               
C     |       |                       |                           
C     |"PWY"********************************* etc...              
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |                                                           
C     |       .                       .                           
C     |       .                       .                           
C     |       .                       .                           
C     |       e                       e                           
C     |       t                       t                           
C     |       c                       c                           
C     |       |-----------v-----------|-----------v----------|-   
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       u<--dxF(i=1,j=2,k=1)--->u           t          |    
C     |       |/|\       /|\          |                      |    
C     |       | |         |           |                      |    
C     |       | |         |           |                      |    
C     |       | |         |           |                      |    
C     |       |dyU(i=1,  dyC(i=1,     |                      |    
C     | ---  ---|--j=2,---|--j=2,-----------------v----------|-   
C     | /|\   | |  k=1)   |  k=1)     |          /|\         |    
C     |  |    | |         |           |          dyF(i=2,    |    
C     |  |    | |         |           |           |  j=1,    |    
C     |dyG(   |\|/       \|/          |           |  k=1)    |    
C     |   i=1,u---        t<---dxC(i=2,j=1,k=1)-->t          |    
C     |   j=1,|                       |           |          |    
C     |   k=1)|                       |           |          |    
C     |  |    |                       |           |          |    
C     |  |    |                       |           |          |    
C     | \|/   |           |<---dxV(i=2,j=1,k=1)--\|/         |    
C     |"SB"++>|___________v___________|___________v__________|_   
C     |       <--dxG(i=1,j=1,k=1)----->                           
C     |      /+\                                              .
C     |       +                                                   
C     |       +                                                   
C     |     "WB"                                                  
C     |                                                           
C     |   N, y increasing northwards                              
C     |  /|\ j increasing northwards                              
C     |   |                                                       
C     |   |                                                       
C     |   ======>E, x increasing eastwards                        
C     |             i increasing eastwards                        
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    u: x-velocity point                                    
C     |    V: y-velocity point                                    
C     |    t: tracer point                                        
C     | "SB": Southern boundary                                   
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |"PWY": Periodic wrap around in Y.                          
C     |                                                           
C     | Figure 3b                                                 
C     | =========                                                 
C     |                                                           
C     |       .                       .                           
C     |       .                       .                           
C     |       .                       .                           
C     |       e                       e                           
C     |       t                       t                           
C     |       c                       c                           
C     |       |-----------v-----------|-----------v--etc...       
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       u<--delX(i=1)---------->u           t               
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |-----------v-----------------------v--etc...       
C     |       |          /|\          |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       u        delY(j=1)      |           t               
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |          \|/          |                           
C     |"SB"++>|___________v___________|___________v__etc...       
C     |      /+\                                                 .
C     |       +                                                   
C     |       +                                                   
C     |     "WB"                                                  
C     |                                                           
C     *==========================================================*
C     \ev
CEOP

C     Macros that override/modify standard definitions
C $Header: /u/u0/gcmpack/MITgcm/model/inc/GRID_MACROS.h,v 1.12 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: GRID_MACROS.h
C    !INTERFACE:
C    include GRID_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | GRID_MACROS.h                                             
C     *==========================================================*
C     | These macros are used to substitute definitions for       
C     | GRID.h variables for particular configurations.           
C     | In setting these variables the following convention       
C     | applies.                                                  
C     | undef  phi_CONST   - Indicates the variable phi is fixed  
C     |                      in X, Y and Z.                       
C     | undef  phi_FX      - Indicates the variable phi only      
C     |                      varies in X (i.e.not in X or Z).     
C     | undef  phi_FY      - Indicates the variable phi only      
C     |                      varies in Y (i.e.not in X or Z).     
C     | undef  phi_FXY     - Indicates the variable phi only      
C     |                      varies in X and Y ( i.e. not Z).     
C     *==========================================================*
C     \ev
CEOP




C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXC_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DXC_MACROS.h
C    !INTERFACE:
C    include DXC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXC_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXF_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DXF_MACROS.h
C    !INTERFACE:
C    include DXF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXF_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXG_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DXG_MACROS.h
C    !INTERFACE:
C    include DXG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXG_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXV_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DXV_MACROS.h
C    !INTERFACE:
C    include DXV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXV_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DYC_MACROS.h
C    !INTERFACE:
C    include DYC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYC_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DYF_MACROS.h
C    !INTERFACE:
C    include DYF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYF_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYG_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DYG_MACROS.h
C    !INTERFACE:
C    include DYG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYG_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: DYU_MACROS.h
C    !INTERFACE:
C    include DYU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYU_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: HFACC_MACROS.h
C    !INTERFACE:
C    include HFACC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACC_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: HFACS_MACROS.h
C    !INTERFACE:
C    include HFACS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACS_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: HFACW_MACROS.h
C    !INTERFACE:
C    include HFACW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACW_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DXC_MACROS.h
C    !INTERFACE:
C    include RECIP_DXC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXC_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DXF_MACROS.h
C    !INTERFACE:
C    include RECIP_DXF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXF_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXG_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DXG_MACROS.h
C    !INTERFACE:
C    include RECIP_DXG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXG_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXV_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DXV_MACROS.h
C    !INTERFACE:
C    include RECIP_DXV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXV_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DYC_MACROS.h
C    !INTERFACE:
C    include RECIP_DYC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYC_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DYF_MACROS.h
C    !INTERFACE:
C    include RECIP_DYF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYF_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYG_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DYG_MACROS.h
C    !INTERFACE:
C    include RECIP_DYG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYG_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_DYU_MACROS.h
C    !INTERFACE:
C    include RECIP_DYU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYU_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_HFACC_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACC_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_HFACS_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACS_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RECIP_HFACW_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACW_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/XC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: XC_MACROS.h
C    !INTERFACE:
C    include XC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | XC_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/YC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: YC_MACROS.h
C    !INTERFACE:
C    include YC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | YC_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RA_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RA_MACROS.h
C    !INTERFACE:
C    include RA_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RA_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP










C $Header: /u/u0/gcmpack/MITgcm/model/inc/RAW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RAW_MACROS.h
C    !INTERFACE:
C    include RAW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RAW_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP










C $Header: /u/u0/gcmpack/MITgcm/model/inc/RAS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: RAS_MACROS.h
C    !INTERFACE:
C    include RAS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RAS_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/MASKW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: MASKW_MACROS.h
C    !INTERFACE:
C    include MASKW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | MASKW_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/MASKS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: MASKS_MACROS.h
C    !INTERFACE:
C    include MASKS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | MASKS_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/TANPHIATU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: TANPHIATU_MACROS.h
C    !INTERFACE:
C    include TANPHIATU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | TANPHIATU_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/TANPHIATV_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name: checkpoint46 $
C
CBOP
C    !ROUTINE: TANPHIATV_MACROS.h
C    !INTERFACE:
C    include TANPHIATV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | TANPHIATV_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP











C
C--   COMMON /GRID_R/ REAL valued grid defining variables.
C     dxC    - Cell center separation in X across western cell wall (m)
C     dxG    - Cell face separation in X along southern cell wall (m)
C     dxF    - Cell face separation in X thru cell center (m)
C     dxV    - V-point separation in X across south-west corner of cell (m)
C     dyC    - Cell center separation in Y across southern cell wall (m)
C     dyG    - Cell face separation in Y along western cell wall (m)
C     dyF    - Cell face separation in Y thru cell center (m)
C     dyU    - U-point separation in Y across south-west corner of cell (m)
C     drC    - Cell center separation along Z axis ( units of r ).
C     drF    - Cell face separation along Z axis ( units of r ).
C     Rcolumn  -Total thickness (in r_unit) of the fluid column
C     R_low  - base of fluid in r_unit (Depth(m) / Pressure(Pa) at top Atmos.)
C     Ro_surf- surface reference (at rest) position, r_unit.
C     hFac   - Fraction of cell in vertical which is open i.e how 
C              "lopped" a cell is (dimensionless scale factor).
C              Note: The code needs terms like MIN(hFac,hFac(I+1))
C                    On some platforms it may be better to precompute
C                    hFacW, hFacE, ... here than do MIN on the fly.
C     rkFac     - Vertical coordinate to vertical index orientation.
C                 ( -1 same orientation, 1 opposite orientation )
C                 ( vertical coord == m  -> rkFac =  1 )
C                 ( vertical coord == Pa -> rkFac = -1 )
C     maskH  - cell Center full-column mask (= 2D mask)
C     maskC  - cell Center land mask
C     maskW  - West face land mask
C     maskS  - South face land mask
C     recip_dxC   - Recipricol of dxC
C     recip_dxG   - Recipricol of dxG
C     recip_dxF   - Recipricol of dxF
C     recip_dxV   - Recipricol of dxV
C     recip_dyC   - Recipricol of dxC
C     recip_dyG   - Recipricol of dyG
C     recip_dyF   - Recipricol of dyF
C     recip_dyU   - Recipricol of dyU
C     recip_drC   - Recipricol of drC
C     recip_drF   - Recipricol of drF
C     recip_Rcol  - Inverse of cell center column thickness (1/r_unit)
C     recip_hFacC - Inverse of cell open-depth f[X,Y,Z] ( dimensionless ).
C     recip_hFacW   rhFacC center, rhFacW west, rhFacS south.
C     recip_hFacS   Note: This is precomputed here because it involves division.
C     saFac  - Shallow atmosphere factor (dimensionless scale factor).
C     xC     - X-coordinate of center of cell f[X,Y]. The units of xc, yc
C              depend on the grid. They are not used in differencing or
C              averaging but are just a convient quantity for I/O,
C              diagnostics etc.. As such xc is in m for cartesian 
C              coordinates but degrees for spherical polar.
C     yC     - Y-coordinate of center of cell f[X,Y].
C     yG     - Y-coordinate of corner of cell ( c-grid vorticity point) f[X,Y]. 
C     xC0, yC0 - West edge x coord  ( metres or degrees )
C                South edge y coord ( metres or degrees )
C     rA     - R-face are f[X,Y] ( m^2 ).
C              Note: In a cartesian framework zA is simply dx*dy,
C                    however we use zA to allow for non-globally
C                    orthogonal coordinate frames (with appropriate
C                    metric terms).
C     rC     - R-coordinate of center of cell f[Z] (units of r).
C     rF     - R-coordinate of face of cell f[Z] (units of r).
C     tanPhiAtU - tan of the latitude at U point. Used for spherical polar 
C                 metric term in U equation.
C     tanPhiAtV - tan of the latitude at V point. Used for spherical polar 
C                 metric term in V equation.
      COMMON /GRID_R/
     &  dxC,dxF,dxG,dxV,dyC,dyF,dyG,dyU,
     &  R_low,Ro_surf,HFacC,HFacW,HFacS,
     &  recip_dxC,recip_dxF,recip_dxG,recip_dxV,
     &  recip_dyC,recip_dyF,recip_dyG,recip_dyU,
     &  recip_Rcol, 
     &  recip_hFacC,recip_hFacW,recip_hFacS, 
     &  saFac,
     &  xC,yC,rA,rAw,rAs,rAz,xG,yG,
     &  maskH, maskC,maskW,maskS,
     &  recip_rA,recip_rAw,recip_rAs,recip_rAz,
     &  tanPhiAtU, tanPhiAtV,
     &  cosfacU,cosfacV,sqcosfacU,sqcosfacV,
     &  drC,drF,recip_drC,recip_drF,rC,rF,
     &  rkFac, recip_rkFac, xC0, yC0
      Real*8 dxC            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxF            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxG            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxV            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyC            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyF            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyG            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyU            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 R_low          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 Ro_surf        (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 HFacC          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 HFacW          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 HFacS          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_dxC      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxF      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxG      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxV      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyC      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyF      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyG      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyU      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_Rcol     (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_hFacC    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_hFacW    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_hFacS    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 xC             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 xG             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 yC             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 yG             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rA             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAw            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAs            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAz            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rA       (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAw      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAs      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAz      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 maskH          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 maskC          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 maskW          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 maskS          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 tanPhiAtU      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 tanPhiAtV      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 cosfacU(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 cosfacV(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 sqcosfacU(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 sqcosfacV(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 drC            (1:Nr)
      Real*8 drF            (1:Nr)
      Real*8 recip_drC      (1:Nr)
      Real*8 recip_drF      (1:Nr)
      Real*8 saFac          (1:Nr)
      Real*8 rC             (1:Nr)
      Real*8 rF             (1:Nr+1)
      Real*8 rkFac
      Real*8 recip_rkFac
      Real*8 xC0
      Real*8 yC0


C $Header: /u/u0/gcmpack/MITgcm/pkg/generic_advdiff/GAD.h,v 1.9 2002/06/15 03:31:17 jmc Exp $
C $Name: checkpoint46 $

CBOP
C !ROUTINE: GAD.h

C !INTERFACE:
C #include "GAD.h"

C !DESCRIPTION:
C Contains enumerated constants for distinguishing between different
C advection schemes and tracers.
C
C Unfortunately, there is no easy way to make use of the
C tokens in namelist input so for now we have to enter the
C tokens value into "data" (ie. 2 for 2nd order etc.)

C !USES:
C $Header: /u/u0/gcmpack/MITgcm/pkg/generic_advdiff/GAD_OPTIONS.h,v 1.4 2001/09/28 03:36:16 adcroft Exp $
C $Name: checkpoint46 $

CBOP
C !ROUTINE: GAD_OPTIONS.h

C !INTERFACE:
C #include "GAD_OPTIONS.h" 

C !DESCRIPTION:
C Contains CPP macros/flags for controlling optional features of package.
CEOP

C CPP options file for GAD (Generic Advection Diffusion) package
C
C Use this file for selecting options within the GAD package
C
C GAD is enabled with ALLOW_GAD in CPP_OPTIONS.h

C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/CPP_OPTIONS.h,v 1.2 2001/05/29 14:01:48 adcroft Exp $
C $Name: checkpoint46 $
C

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/CPP_EEOPTIONS.h,v 1.2 2001/05/29 14:01:48 adcroft Exp $
C $Name: checkpoint46 $
C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/



C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name: checkpoint46 $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP



C o Include/exclude code specific to the ECCO/SEALION version.



C o Enable/disable state import and export.







C !DEFINED PARAMETERS:

C ENUM_CENTERED_2ND :: Centered 2nd order
      INTEGER ENUM_CENTERED_2ND
      PARAMETER(ENUM_CENTERED_2ND=2)

C ENUM_UPWIND_3RD :: 3rd order upwind 
      INTEGER ENUM_UPWIND_3RD
      PARAMETER(ENUM_UPWIND_3RD=3)

C ENUM_CENTERED_4TH :: Centered 4th order
      INTEGER ENUM_CENTERED_4TH
      PARAMETER(ENUM_CENTERED_4TH=4)

C ENUM_FLUX_LIMIT :: Non-linear flux limiter
      INTEGER ENUM_FLUX_LIMIT
      PARAMETER(ENUM_FLUX_LIMIT=77)

C ENUM_DST3 :: 3-DST 
      INTEGER ENUM_DST3
      PARAMETER(ENUM_DST3=30)

C ENUM_DST3_FLUX_LIMIT :: 3-DST flux limited
      INTEGER ENUM_DST3_FLUX_LIMIT
      PARAMETER(ENUM_DST3_FLUX_LIMIT=33)

C oneSixth :: Third/fourth order interpolation factor
      Real*8 oneSixth
      PARAMETER(oneSixth=1.D0/6.D0)

C Differentiate between tracers (only needed for KPP -  arrgh!!!)
C GAD_TEMPERATURE :: temperature
      INTEGER GAD_TEMPERATURE
      PARAMETER(GAD_TEMPERATURE=101)
C GAD_SALINITY :: salinity
      INTEGER GAD_SALINITY
      PARAMETER(GAD_SALINITY=102)
C GAD_TR1 :: pssive tracer 1
      INTEGER GAD_TR1
      PARAMETER(GAD_TR1=103)
CEOP

C--   COMMON /GAD_PARM_L/ Logical parameters for GAD pkg routines
C     tempMultiDimAdvec :: set to T if using multi-dimension advection for Temp
C     saltMultiDimAdvec :: set to T if using multi-dimension advection for Salt
C     tempAdamsBashforth :: set to T if using Adams-Bashforth stepping for Temp
C     saltAdamsBashforth :: set to T if using Adams-Bashforth stepping for Salt
      LOGICAL tempMultiDimAdvec
      LOGICAL saltMultiDimAdvec
      LOGICAL tr1_MultiDimAdvec
      LOGICAL tempAdamsBashforth
      LOGICAL saltAdamsBashforth
      LOGICAL tr1_AdamsBashforth
      COMMON /GAD_PARM_L/
     & tempMultiDimAdvec , saltMultiDimAdvec , tr1_MultiDimAdvec,
     & tempAdamsBashforth, saltAdamsBashforth, tr1_AdamsBashforth

C !INPUT PARAMETERS: ===================================================
C  bi,bj                :: tile indices
C  k                    :: vertical level
C  rTrans               :: vertical volume transport
C  tracer               :: tracer field
C  myThid               :: thread number
      INTEGER bi,bj,k
      Real*8 rTrans(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      Real*8 tracer(1-OLx:sNx+OLx,1-OLy:sNy+OLy,Nr,nSx,nSy)
      INTEGER myThid

C !OUTPUT PARAMETERS: ==================================================
C  wT                   :: vertical advective flux
      Real*8 wT    (1-OLx:sNx+OLx,1-OLy:sNy+OLy)

C !LOCAL VARIABLES: ====================================================
C  i,j                  :: loop indices
C  kp1                  :: =min( k+1 , Nr )
C  km1                  :: =max( k-1 , 1 )
C  km2                  :: =max( k-2 , 1 )
C  Rjm,Rj,Rjp           :: differences at i-1,i,i+1
C  Rjjm,Rjjp            :: second differences at i-1,i
C  maskP1               :: =1 for k<Nr, =0 for k>=Nr
      INTEGER i,j,kp1,km1,km2
      Real*8 Rjm,Rj,Rjp,Rjjm,Rjjp
      Real*8 maskP1
CEOP

      km2=MAX(1,k-2)
      km1=MAX(1,k-1)
      kp1=MIN(Nr,k+1)
      maskP1 = 1.
      IF (k.GE.Nr) maskP1 = 0.

      IF ( k.EQ.1 .OR. k.GT.Nr) THEN
       DO j=1-Oly,sNy+Oly
        DO i=1-Olx,sNx+Olx
         wT(i,j) = 0.
        ENDDO
       ENDDO
      ELSEIF ( k.EQ.2 ) THEN
         Rjjm= 0.
       DO j=1-Oly,sNy+Oly
        DO i=1-Olx,sNx+Olx
         Rjp=(tracer(i,j,kp1,bi,bj)-tracer(i,j,k,bi,bj))
         Rj =(tracer(i,j,k,bi,bj)-tracer(i,j,km1,bi,bj))
         Rjjp=(Rjp-Rj)*maskC(i,j,kp1,bi,bj)*maskP1
         wT(i,j) = maskC(i,j,km1,bi,bj)*(
     &     rTrans(i,j)*(
     &        (Tracer(i,j,k,bi,bj)+Tracer(i,j,km1,bi,bj))*0.5D0
     &        -oneSixth*(Rjjm+Rjjp)*0.5D0 )
     &    +ABS(rTrans(i,j))*
     &         oneSixth*(Rjjm-Rjjp)*0.5D0
     &                                  )                      
        ENDDO
       ENDDO
      ELSEIF ( k.EQ.Nr ) THEN
         Rjjp= 0.
       DO j=1-Oly,sNy+Oly
        DO i=1-Olx,sNx+Olx
         Rj =(tracer(i,j,k,bi,bj)-tracer(i,j,km1,bi,bj))
         Rjm=(tracer(i,j,km1,bi,bj)-tracer(i,j,km2,bi,bj))
         Rjjm=(Rj-Rjm)*maskC(i,j,km2,bi,bj)
         wT(i,j) = maskC(i,j,km1,bi,bj)*(
     &     rTrans(i,j)*(
     &        (Tracer(i,j,k,bi,bj)+Tracer(i,j,km1,bi,bj))*0.5D0
     &        -oneSixth*(Rjjm+Rjjp)*0.5D0 )
     &    +ABS(rTrans(i,j))*
     &         oneSixth*(Rjjm-Rjjp)*0.5D0
     &                                  )                      
        ENDDO
       ENDDO
      ELSE
       DO j=1-Oly,sNy+Oly
        DO i=1-Olx,sNx+Olx
         Rjp=(tracer(i,j,kp1,bi,bj)-tracer(i,j,k,bi,bj))
         Rj =(tracer(i,j,k,bi,bj)-tracer(i,j,km1,bi,bj))
         Rjm=(tracer(i,j,km1,bi,bj)-tracer(i,j,km2,bi,bj))
         Rjjp=(Rjp-Rj)*maskC(i,j,kp1,bi,bj)
         Rjjm=(Rj-Rjm)*maskC(i,j,km2,bi,bj)
         wT(i,j) = maskC(i,j,km1,bi,bj)*(
     &     rTrans(i,j)*(
     &        (Tracer(i,j,k,bi,bj)+Tracer(i,j,km1,bi,bj))*0.5D0
     &        -oneSixth*(Rjjm+Rjjp)*0.5D0 )
     &    +ABS(rTrans(i,j))*
     &         oneSixth*(Rjjm-Rjjp)*0.5D0
     &      *( 1.D0 - maskC(i,j,km2,bi,bj)*maskC(i,j,kp1,bi,bj) )
     &                                  )                      
        ENDDO
       ENDDO
      ENDIF

      RETURN
      END
