C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/phy_driver.F,v 1.3 2001/05/29 19:28:53 cnh Exp $
C $Name: checkpoint46 $

      SUBROUTINE PDRIVER (TYEAR, myThid)
C--
C--   SUBROUTINE PDRIVER (TYEAR)
C--
C--   Purpose: stand-alone driver for physical parametrization routines
C--   Input  :  TYEAR  : fraction of year (0 = 1jan.00, 1 = 31dec.24)
C--             grid-point model fields in common block: PHYGR1
C--             forcing fields in common blocks : LSMASK, FORFIX, FORCIN
C--   Output :  Diagnosed upper-air variables in common block: PHYGR2
C--             Diagnosed surface variables in common block: PHYGR3
C--             Physical param. tendencies in common block: PHYTEN
C--             Surface and upper boundary fluxes in common block: FLUXES
C--


      IMPLICIT rEAL*8 ( A-H,O-Z)

C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/EEPARAMS.h,v 1.10 2001/09/21 03:54:35 cnh Exp $
C $Name: checkpoint46 $
CBOP
C     !ROUTINE: EEPARAMS.h
C     !INTERFACE:
C     include "EEPARAMS.h"
C
C     !DESCRIPTION:
C     *==========================================================*
C     | EEPARAMS.h                                               |
C     *==========================================================*
C     | Parameters for "execution environemnt". These are used   |
C     | by both the particular numerical model and the "execution|
C     | environment" support routines.                           |
C     *==========================================================*
CEOP

C     MAX_LEN_MBUF         - Default message buffer max. size
C     MAX_LEN_FNAM         - Default file name max. size
C     MAX_LEN_PREC         - Default record length for reading "parameter" files
      INTEGER MAX_LEN_MBUF
      PARAMETER ( MAX_LEN_MBUF = 512 )
      INTEGER MAX_LEN_FNAM
      PARAMETER ( MAX_LEN_FNAM = 512 )
      INTEGER MAX_LEN_PREC
      PARAMETER ( MAX_LEN_PREC = 200 )

C     SQUEEZE_RIGHT       - Flag indicating right blank space removal
C                           from text field.
C     SQUEEZE_LEFT        - Flag indicating left blank space removal
C                           from text field.
C     SQUEEZE_BOTH        - Flag indicating left and right blank
C                           space removal from text field.
C     PRINT_MAP_XY        - Flag indicating to plot map as XY slices
C     PRINT_MAP_XZ        - Flag indicating to plot map as XZ slices
C     PRINT_MAP_YZ        - Flag indicating to plot map as YZ slices
C     commentCharacter    - Variable used in column 1 of parameter files to
C                           indicate comments.
C     INDEX_I             - Variable used to select an index label
C     INDEX_J               for formatted input parameters.
C     INDEX_K
C     INDEX_NONE
      CHARACTER*(*) SQUEEZE_RIGHT
      PARAMETER ( SQUEEZE_RIGHT = 'R' )
      CHARACTER*(*) SQUEEZE_LEFT
      PARAMETER ( SQUEEZE_LEFT = 'L' )
      CHARACTER*(*) SQUEEZE_BOTH
      PARAMETER ( SQUEEZE_BOTH = 'B' )
      CHARACTER*(*) PRINT_MAP_XY
      PARAMETER ( PRINT_MAP_XY = 'XY' )
      CHARACTER*(*) PRINT_MAP_XZ
      PARAMETER ( PRINT_MAP_XZ = 'XZ' )
      CHARACTER*(*) PRINT_MAP_YZ
      PARAMETER ( PRINT_MAP_YZ = 'YZ' )
      CHARACTER*(*) commentCharacter
      PARAMETER ( commentCharacter = '#' )
      INTEGER INDEX_I
      INTEGER INDEX_J
      INTEGER INDEX_K   
      INTEGER INDEX_NONE
      PARAMETER ( INDEX_I    = 1,
     &            INDEX_J    = 2,
     &            INDEX_K    = 3,
     &            INDEX_NONE = 4 )


C     EXCH_IGNORE_CORNERS - Flag to select ignoring or
C     EXCH_UPDATE_CORNERS   updating of corners during
C                           an edge exchange.
      INTEGER EXCH_IGNORE_CORNERS
      INTEGER EXCH_UPDATE_CORNERS
      PARAMETER ( EXCH_IGNORE_CORNERS = 0,
     &            EXCH_UPDATE_CORNERS = 1 )

C     FORWARD_SIMULATION
C     REVERSE_SIMULATION
      INTEGER FORWARD_SIMULATION
      INTEGER REVERSE_SIMULATION
      PARAMETER ( FORWARD_SIMULATION = 0,
     &            REVERSE_SIMULATION = 1 )


C     Particularly weird and obscure voodoo numbers
C     lShare  - This wants to be the length in
C               [148]-byte words of the size of
C               the address "window" that is snooped
C               on an SMP bus. By separating elements in
C               the global sum buffer we can avoid generating
C               extraneous invalidate traffic between
C               processors. The length of this window is usually
C               a cache line i.e. small O(64 bytes).
C               The buffer arrays are usually short arrays
C               and are declared REAL ARRA(lShare[148],LBUFF).
C               Setting lShare[148] to 1 is like making these arrays
C               one dimensional.
      INTEGER cacheLineSize
      INTEGER lShare1
      INTEGER lShare4
      INTEGER lShare8
      PARAMETER ( cacheLineSize = 256 )
      PARAMETER ( lShare1 =  cacheLineSize )
      PARAMETER ( lShare4 =  cacheLineSize/4 )
      PARAMETER ( lShare8 =  cacheLineSize/8 )

C     MAX_NO_THREADS  - Maximum number of threads allowed.
C     MAX_NO_PROCS    - Maximum number of processes allowed.
C     MAX_NO_BARRIERS - Maximum number of distinct thread "barriers"
      INTEGER MAX_NO_THREADS
      PARAMETER ( MAX_NO_THREADS =   32 )
      INTEGER MAX_NO_PROCS
      PARAMETER ( MAX_NO_PROCS   =  128 )
      INTEGER MAX_NO_BARRIERS
      PARAMETER ( MAX_NO_BARRIERS = 1 )

C--   COMMON /EEPARAMS_L/ Execution environment public logical variables.
C     eeBootError - Flag indicating error during multi-processing
C     eeEndError    initialisation/termination.
C     fatalError  - Flag used to indicate that the model is ended with
C                   an error
      COMMON /EEPARAMS_L/ eeBootError, fatalError, eeEndError,
     &  useCubedSphereExchange
      LOGICAL eeBootError
      LOGICAL eeEndError
      LOGICAL fatalError
      LOGICAL useCubedSphereExchange

C--   COMMON /EPARAMS_I/ Execution environment public integer variables.
C     errorMessageUnit    - Fortran IO unit for error messages
C     standardMessageUnit - Fortran IO unit for informational messages
C     scrUnit1      - Scratch file 1 unit number
C     scrUnit2      - Scratch file 2 unit number
C     eeDataUnit    - Unit number used for reading "execution environment" parameter file.
C     modelDataUnit - Unit number for reading "model" parameter file.
C     numberOfProcs - Number of processes computing in parallel
C     pidIO         - Id of process to use for I/O.
C     myBxLo, myBxHi - Extents of domain in blocks in X and Y
C     myByLo, myByHi   that each threads is responsble for.
C     myProcId      - My own "process" id.
C     myPx     - My X coord on the proc. grid.
C     myPy     - My Y coord on the proc. grid.
C     myXGlobalLo - My bottom-left (south-west) x-index
C                   global domain. The x-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     myYGlobalLo - My bottom-left (south-west) y-index in
C                   global domain. The y-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     nThreads    - No. of threads
C     nTx         - No. of threads in X
C     nTy         - No. of threads in Y
C                   This assumes a simple cartesian
C                   gridding of the threads which is not required elsewhere
C                   but that makes it easier.
C     ioErrorCount - IO Error Counter. Set to zero initially and increased
C                    by one every time an IO error occurs.
      COMMON /EEPARAMS_I/ errorMessageUnit, standardMessageUnit,
     & scrUnit1, scrUnit2, eeDataUnit, modelDataUnit,
     & numberOfProcs, pidIO, myProcId,
     & myPx, myPy, myXGlobalLo, myYGlobalLo, nThreads,
     & myBxLo, myBxHi, myByLo, myByHi,
     & nTx, nTy, ioErrorCount
      INTEGER eeDataUnit
      INTEGER errorMessageUnit
      INTEGER ioErrorCount(MAX_NO_THREADS)
      INTEGER modelDataUnit
      INTEGER myBxLo(MAX_NO_THREADS)
      INTEGER myBxHi(MAX_NO_THREADS)
      INTEGER myByLo(MAX_NO_THREADS)
      INTEGER myByHi(MAX_NO_THREADS)
      INTEGER myProcId
      INTEGER myPx
      INTEGER myPy
      INTEGER myXGlobalLo
      INTEGER myYGlobalLo
      INTEGER nThreads
      INTEGER nTx
      INTEGER nTy
      INTEGER numberOfProcs
      INTEGER pidIO
      INTEGER scrUnit1
      INTEGER scrUnit2
      INTEGER standardMessageUnit

C     Resolution parameters
C
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/atparam.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

C     MITgcm declaration of grid size. 
C     Latitudinal extent is one less than MITgcm ( i.e. NY-1)
C     because MITgcm has dummy layer of land at northern most
C     edge.
C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/SIZE.h,v 1.3 2001/09/27 15:36:29 jmc Exp $
C $Name: checkpoint46 $
C
C     /==========================================================C     | SIZE.h Declare size of underlying computational grid.    |
C     |==========================================================|
C     | The design here support a three-dimensional model grid   |
C     | with indices I,J and K. The three-dimensional domain     |
C     | is comprised of nPx*nSx blocks of size sNx along one axis|
C     | nPy*nSy blocks of size sNy along another axis and one    |
C     | block of size Nz along the final axis.                   |
C     | Blocks have overlap regions of size OLx and OLy along the|
C     | dimensions that are subdivided.                          |
C     \==========================================================/
C     Voodoo numbers controlling data layout.
C     sNx - No. X points in sub-grid.
C     sNy - No. Y points in sub-grid.
C     OLx - Overlap extent in X.
C     OLy - Overlat extent in Y.
C     nSx - No. sub-grids in X.
C     nSy - No. sub-grids in Y.
C     nPx - No. of processes to use in X.
C     nPy - No. of processes to use in Y.
C     Nx  - No. points in X for the total domain.
C     Ny  - No. points in Y for the total domain.
C     Nr  - No. points in Z for full process domain.
      INTEGER sNx
      INTEGER sNy
      INTEGER OLx
      INTEGER OLy
      INTEGER nSx
      INTEGER nSy
      INTEGER nPx
      INTEGER nPy
      INTEGER Nx
      INTEGER Ny
      INTEGER Nr
      PARAMETER (
     &           sNx = 128,
     &           sNy =   4,
C    &           sNy =   8,
C    &           sNy =  16,
C    &           sNy =  32,
C    &           sNy =  64,
     &           OLx =   3,
     &           OLy =   3,
     &           nSx =   1,
     &           nSy =   1,
     &           nPx =   1,
     &           nPy =  16,
C    &           nPy =   8,
C    &           nPy =   4,
C    &           nPy =   2,
C    &           nPy =   1,
     &           Nx  = sNx*nSx*nPx,
     &           Ny  = sNy*nSy*nPy,
     &           Nr  =   5)

C     MAX_OLX  - Set to the maximum overlap region size of any array
C     MAX_OLY    that will be exchanged. Controls the sizing of exch
C                routine buufers.
      INTEGER MAX_OLX
      INTEGER MAX_OLY
      PARAMETER ( MAX_OLX = OLx,
     &            MAX_OLY = OLy )

C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/atparam0.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

      INTEGER ISC
      PARAMETER (ISC=1)

      INTEGER NTRUN, MTRUN, IX
      PARAMETER ( NTRUN=21, MTRUN=21, IX=sNx )   

      INTEGER MX, MX2, IL, NTRUN1, MXP
      PARAMETER (MX=MTRUN+1 , MX2=2*MX)
      PARAMETER (IL=sNy, NTRUN1=NTRUN+1 )
      PARAMETER ( MXP=ISC*MTRUN+1 )
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/atparam1.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

      INTEGER KX
      PARAMETER (KX=NR)

      INTEGER KX2, KXM, KXP, NTR
      PARAMETER (KX2=2*KX, KXM=KX-1, KXP=KX+1)
      PARAMETER (NTR=1)
C     $Id: atparam1.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C
      INTEGER NLON, NLAT, NLEV, NGP
      PARAMETER ( NLON=IX, NLAT=IL, NLEV=KX, NGP=NLON*NLAT )
C
C     Constants + functions of sigma and latitude
C
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/Lev_def.h,v 1.3 2001/05/29 19:28:53 cnh Exp $
C $Name: checkpoint46 $

      COMMON/NB_LEVELS/NLEVxy, NLEVxyU, NLEVxyV
      INTEGER NLEVxy(IX*IL,MAX_NO_THREADS)
      INTEGER NLEVxyU(IX*IL,MAX_NO_THREADS)
      INTEGER NLEVxyV(IX*IL,MAX_NO_THREADS)
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/com_physcon.h,v 1.4 2001/06/18 17:39:58 cnh Exp $
C $Name: checkpoint46 $

C--
C--   /PHYCON/: Physical constants (initial. in INPHYS)
C--    P0   = reference pressure
C--    GG   = gravity accel.
C--    RD   = gas constant for dry air
C--    CP   = specific heat at constant pressure
C--    ALHC = latent heat of condensation
C--    SBC  = Stefan-Boltzmann constant

      COMMON /PHYCON/ P0, GG, RD, CP, ALHC, SBC
C--
C--   /FSIGMU/: Functions of sigma and latitude (initial. in INPHYS)
C--    SIG    = full-level sigma 
C--    SIGL   = logarithm of full-level sigma
C--    SIGH   = half-level sigma
C--    DSIG   = layer depth in sigma
C--    POUT   = norm. pressure level [p/p0] for post-processing
C--    GRDSIG = g/(d_sigma p0) : to convert fluxes of u,v,q into d(u,v,q)/dt
C--    GRDSCP = g/(d_sigma p0 c_p): to convert energy fluxes into dT/dt
C--    WVI    = weights for vertical interpolation
C--    FMU    = legendre polinomials in sin(lat)

      COMMON /FSIGMU/ SIG(NLEV), SIGL(NLEV), SIGH(0:NLEV), DSIG(NLEV),
     *                POUT(NLEV), GRDSIG(NLEV), GRDSCP(NLEV), 
     *                WVI(NLEV,2), FMU(NGP,2,MAX_NO_THREADS)
C
C     Model variables, tendencies and fluxes on gaussian grid
C
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/com_physvar.h,v 1.3 2001/05/29 19:28:53 cnh Exp $
C $Name: checkpoint46 $

C--
C--   /PHYGR1/ : Model variables on gaussian grid
C--    UG1     = u-wind
C--    VG1     = v-wind
C--    TG1     = abs. temperature
C--    QG1     = specific humidity (g/kg)
C--    PHIG1   = geopotential
C--    PSLG1   = log. of surface pressure
C--    Vsurfsq = Square of surface wind speed (grid position = as T,Q)

      COMMON /PHYGR1/ UG1(NGP,NLEV,MAX_NO_THREADS), 
     &                VG1(NGP,NLEV,MAX_NO_THREADS), 
     &                TG1(NGP,NLEV,MAX_NO_THREADS),
     &                QG1(NGP,NLEV,MAX_NO_THREADS), 
     &                PHIG1(NGP,NLEV,MAX_NO_THREADS), 
     &                PSLG1(NGP,MAX_NO_THREADS),
     &                Vsurfsq(NGP,MAX_NO_THREADS) 

C--   
C--   /PHYGR2/ : Diagnosed upper-air variables
C--    SE     = dry static energy
C--    RH     = relative humidity
C--    QSAT   = saturation specific humidity (g/kg)

      COMMON /PHYGR2/ 
     &                SE(NGP,NLEV,MAX_NO_THREADS), 
     &                RH(NGP,NLEV,MAX_NO_THREADS), 
     &                QSAT(NGP,NLEV,MAX_NO_THREADS)

C--
C--   /PHYGR3/ : Diagnosed surface variables 
C--    PSG    = surface pressure
C--    TS     = surface temperature
C--    TSKIN  = skin temperature (not yet implemented)
C--    CLOUDC = total cloud cover (fraction)
C --   PNLEVW = Surface pressure for the computation of the surface fluxes
C
      COMMON /PHYGR3/ PSG(NGP,MAX_NO_THREADS), 
     &                TS(NGP,MAX_NO_THREADS), 
     &                TSKIN(NGP,MAX_NO_THREADS), 
     &                CLOUDC(NGP,MAX_NO_THREADS), 
     &                PNLEVW(NGP,MAX_NO_THREADS)

C--
C--   /PHYTEN/ : Physical param. tendencies
C--    TT_CNV  =  temperature tendency due to convection
C--    QT_CNV  = sp. humidity tendency due to convection
C--    TT_LSC  =  temperature tendency due to large-scale condensation
C--    QT_LSC  = sp. humidity tendency due to large-scale condensation
C--    TT_RSW  =  temperature tendency due to short-wave radiation
C--    TT_RLW  =  temperature tendency due to long-wave radiation
C--    UT_PBL  =       u-wind tendency due to PBL and diffusive processes
C--    VT_PBL  =       v-wind tendency due to PBL and diffusive processes
C--    TT_PBL  =  temperature tendency due to PBL and diffusive processes
C--    QT_PBL  = sp. humidity tendency due to PBL and diffusive processes

      COMMON /PHYTEN/ TT_CNV(NGP,NLEV,MAX_NO_THREADS), 
     &                QT_CNV(NGP,NLEV,MAX_NO_THREADS),
     &                TT_LSC(NGP,NLEV,MAX_NO_THREADS), 
     &                QT_LSC(NGP,NLEV,MAX_NO_THREADS),
     &                TT_RSW(NGP,NLEV,MAX_NO_THREADS), 
     &                TT_RLW(NGP,NLEV,MAX_NO_THREADS),
     &                UT_PBL(NGP,NLEV,MAX_NO_THREADS), 
     &                VT_PBL(NGP,NLEV,MAX_NO_THREADS),
     &                TT_PBL(NGP,NLEV,MAX_NO_THREADS), 
     &                QT_PBL(NGP,NLEV,MAX_NO_THREADS)

C--
C--   /FLUXES/ : Surface and upper boundary fluxes
C--    PRECNV = convective precipitation  [g/(m^2 s)]
C--    PRECLS = large-scale precipitation [g/(m^2 s)]
C--    CBMF   = cloud-base mass flux 
C--    TSR    = top-of-atm. shortwave radiation (downward)
C--    SSR    = surface shortwave radiation (downward)
C--    SLR    = surface longwave radiation (upward) 
C--    OLR    = outgoing longwave radiation (upward)
C--    USTR   = u-stress (1: land, 2: sea, 3: weighted average)
C--    VSTR   = v-stress (1: land, 2: sea, 3: weighted average)
C--    SHF    = sensible heat flux (1: land, 2: sea, 3: w. average)
C--    EVAP   = evaporation [g/(m^2 s)] (1: land, 2: sea, 3: w. average)
C--    DRAG   = surface Drag term (= Cd*|V|)

      COMMON /FLUXES/ PRECNV(NGP,MAX_NO_THREADS), 
     &                PRECLS(NGP,MAX_NO_THREADS), 
     &                CBMF(NGP,MAX_NO_THREADS),
     &                TSR(NGP,MAX_NO_THREADS), 
     &                SSR(NGP,MAX_NO_THREADS), 
     &                SLR(NGP,MAX_NO_THREADS), 
     &                OLR(NGP,MAX_NO_THREADS),
     &                USTR(NGP,3,MAX_NO_THREADS), 
     &                VSTR(NGP,3,MAX_NO_THREADS), 
     &                SHF(NGP,3,MAX_NO_THREADS), 
     &                EVAP(NGP,3,MAX_NO_THREADS),
     &                T0(NGP,2,MAX_NO_THREADS), 
     &                Q0(NGP,MAX_NO_THREADS), 
     &                QSAT0(NGP,2,MAX_NO_THREADS), 
     &                SLR_DOWN(NGP,MAX_NO_THREADS),
     &                ST4S(NGP,MAX_NO_THREADS),
     &                SPEED0(NGP,MAX_NO_THREADS),
     &                DRAG(NGP,MAX_NO_THREADS)
C
C     Surface forcing fields (time-inv. or functions of seasonal cycle)
C
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/com_forcing1.h,v 1.4 2001/05/29 19:28:53 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

C--   /LSMASK/ land-sea masks 
      common /LSMASK/ fmask1(ngp,MAX_NO_THREADS) ! fractional land-sea mask

C--   /FORFIX/ Time invariant forcing fields 
      common /FORFIX/ phi0(ngp,MAX_NO_THREADS),	 ! surface geopotential
     .                alb0(ngp,MAX_NO_THREADS)	 ! land-surface albedo

C--   /FORCIN/ Forcing fields 
      common /FORCIN/ sst1(ngp,MAX_NO_THREADS),	 ! SST
     .                oice1(ngp,MAX_NO_THREADS), ! sea ice fraction
     .                stl1(ngp,MAX_NO_THREADS),	 ! land-surface temperature
     .                snow1(ngp,MAX_NO_THREADS), ! snow depth (mm water)
     .                soilq1(ngp,MAX_NO_THREADS) ! soil wetness (mm water)
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/com_forcon.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

C--
C--   /FORCON/: Constants for forcing fields (initial. in INPHYS)
C--    SOLC   = Solar constant (area averaged) in W/m^2
C--    ALBSEA = Albedo over sea 
C--    ALBICE = Albedo over sea ice (for ice fraction = 1)
C--    ALBSN  = Albedo over snow (for snow depth > SDALB)
C--    SDALB  = Snow depth corresponding to maximum albedo
C--    SWCAP  = Soil wetness capacity
C--    SWWIL  = Soil wetness at wilting point

      COMMON /FORCON/ SOLC, ALBSEA, ALBICE, ALBSN, SDALB,
     &                SWCAP, SWWIl
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/com_sflcon.h,v 1.2 2001/02/02 21:36:29 adcroft Exp $
C $Name: checkpoint46 $

C--
C--   /SFLCON/: Constants for surface fluxes (initial. in INPHYS)
C--    FWIND0 = ratio of near-sfc wind to lowest-level wind
C--    FTEMP0 = weight for near-sfc temperature extrapolation (0-1) :
C--             1 : linear extrapolation from two lowest levels
C--             0 : constant potential temperature ( = lowest level)
C--    FHUM0  = weight for near-sfc specific humidity extrapolation (0-1) :
C--             1 : extrap. with constant relative hum. ( = lowest level)
C--             0 : constant specific hum. ( = lowest level)
C--    CDL    = drag coefficient for momentum over land
C--    CDS    = drag coefficient for momentum over sea
C--    CHL    = heat exchange coefficient over land
C--    CHS    = heat exchange coefficient over sea
C--    VGUST  = wind speed for sub-grid-scale gusts
C--    SWMAX  = Soil wetness (in mm) corresp. to potential evapotranspiration

      COMMON /SFLCON/ FWIND0, FTEMP0, FHUM0,
     *                CDL, CDS, CHL, CHS, VGUST, SWMAX

      REAL TYEAR
      INTEGER myThid

      INTEGER IDEPTH(NGP)
      REAL RPS(NGP), ALB1(NGP), FSOL1(NGP), OZONE1(NGP)

      REAL TAURAD(NGP,NLEV), ST4ARAD(NGP,NLEV,2)
CcnhDebugStarts
      REAL    AUX(NGP)
      REAL    Phymask(NGP,NLEV)
      real xminim
      REAL UT_VDI(NGP,NLEV), VT_VDI(NGP,NLEV), TT_VDI(NGP,NLEV)
      REAL QT_VDI(NGP,NLEV)
CcnhDebugEnds
      INTEGER J, K


C--   1. Compute surface variables

C     1.1 Surface pressure (ps), 1/ps and surface temperature 
C
      DO J=1,NGP
       PSG(J,myThid)=EXP(PSLG1(J,myThid))
       RPS(J)=1./PSG(J,myThid)
       TS(J,myThid) =SST1(J,myThid)+
     &  FMASK1(J,myThid)*(STL1(J,myThid)-SST1(J,myThid))
      ENDDO

C     1.2 Surface albedo:
C         defined as a weighed average of land and ocean albedos, where
C         land albedo depends linearly on snow depth (up to the SDALB
C         threshold) and sea albedo depends linearly on sea-ice fraction. 
C
      DALB=ALBICE-ALBSEA
      RSD=1./SDALB
C
CmoltBegin
      DO J=1,NGP
        ALB1(J)=ALB0(J,myThid)
      ENDDO
CmoltEnd

C--   2. Compute thermodynamic variables

C     2.1 Dry static energy

      DO K=1,NLEV
       DO J=1,NGP
        SE(J,K,myThid)=CP*TG1(J,K,myThid)+PHIG1(J,K,myThid)
       ENDDO
      ENDDO
C
C     2.2 Relative humidity and saturation spec. humidity
C
      DO K=1,NLEV
       CALL SHTORH (1,NGP,TG1(1,K,myThid),PSG(1,myThid),
     &              SIG(K),QG1(1,K,myThid),
     *              RH(1,K,myThid),QSAT(1,K,myThid),
     I              myThid)
      ENDDO
C
      DO K=1,NLEV
       DO J=1,NGP
        phymask(J,K)=0.
        IF (Tg1(J,K,myThid).ne.0.) THEN
         phymask(J,K)=1.
        ENDIF
        QSAT(J,K,myThid)=QSAT(J,K,myThid)*Phymask(J,K)
        QG1(J,K,myThid)=QG1(J,K,myThid)*Phymask(J,K)
        RH(J,K,myThid)=RH(J,K,myThid)*Phymask(J,K)
       ENDDO
      ENDDO
cdbgch
C
C--   3. Precipitation

C     3.1 Deep convection
C
cch      CALL CONVMF (PSG,SE,QG1,QSAT,
      CALL CONVMF (PSG(1,myThid),TG1(1,1,myThid),
     &             QG1(1,1,myThid),QSAT(1,1,myThid),
     *             IDEPTH,CBMF(1,myThid),PRECNV(1,myThid),
     &             TT_CNV(1,1,myThid),QT_CNV(1,1,myThid),
     I             myThid)

C
      DO K=2,NLEV
       DO J=1,NGP
        TT_CNV(J,K,myThid)=TT_CNV(J,K,myThid)*RPS(J)*GRDSCP(K)
        QT_CNV(J,K,myThid)=QT_CNV(J,K,myThid)*RPS(J)*GRDSIG(K)
       ENDDO
      ENDDO

C     3.2 Large-scale condensation

      CALL LSCOND (PSG(1,myThid),QG1(1,1,myThid),QSAT(1,1,myThid),
     *             PRECLS(1,myThid),TT_LSC(1,1,myThid),
     &             QT_LSC(1,1,myThid),
     I             myThid)

C
C--   4. Radiation (shortwave and longwave) 

C     4.1 Compute climatological forcing

      CALL SOL_OZ (SOLC,TYEAR,FSOL1,OZONE1,
     I             myThid)

C     4.2 Compute shortwave tendencies and initialize lw transmissivity
C     (The sw radiation may be called at selected time steps)

      CALL RADSW (PSG(1,myThid),QG1(1,1,myThid),RH(1,1,myThid),
     *            FSOL1,OZONE1,ALB1,TAURAD,
     *            CLOUDC(1,myThid),TSR(1,myThid),SSR(1,myThid),
     &            TT_RSW(1,1,myThid),
     I            myThid)

C     4.3 Compute longwave fluxes 

      CALL RADLW (1,TG1(1,1,myThid),TS(1,myThid),ST4S(1,myThid),
     &            TAURAD, ST4ARAD,
     *            OLR(1,myThid),SLR(1,myThid),TT_RLW(1,1,myThid),
     &            SLR_DOWN(1,myThid),
     I            myThid)

      DO K=1,NLEV
       DO J=1,NGP
        TT_RSW(J,K,myThid)=TT_RSW(J,K,myThid)*RPS(J)*GRDSCP(K)
        TT_RLW(J,K,myThid)=TT_RLW(J,K,myThid)*RPS(J)*GRDSCP(K)
       ENDDO
      ENDDO

C
C--   5. PBL interactions with lower troposphere and surface

C     5.1. Surface fluxes (from climatological surface temperature)

cch Attention the pressure used is a the last T level and
Cch  not at the last W level
C --------------------------------
      CALL SUFLUX (PNLEVW(1,myThid),
     &             UG1(1,1,myThid),VG1(1,1,myThid),
     &             TG1(1,1,myThid),QG1(1,1,myThid),
     &             RH(1,1,myThid),QSAT(1,1,myThid),
     &             VsurfSq(1,myThid),PHIG1(1,1,myThid),
     &             PHI0(1,myThid),FMASK1(1,myThid),
     &             STL1(1,myThid),SST1(1,myThid),SOILQ1(1,myThid),
     &             SSR(1,myThid),SLR(1,myThid),
     &             DRAG(1,myThid),
     &             USTR(1,1,myThid),VSTR(1,1,myThid),SHF(1,1,myThid),
     &             EVAP(1,1,myThid),T0(1,1,myThid),Q0(1,myThid),
     &             QSAT0(1,1,myThid),SPEED0(1,myThid),
     I             myThid)

C
C     remove when vdifsc is implemented
      DO K=1,NLEV
       DO J=1,NGP
        UT_PBL(J,K,myThid)=0.
        VT_PBL(J,K,myThid)=0.
        TT_PBL(J,K,myThid)=0.
        QT_PBL(J,K,myThid)=0.
       ENDDO
      ENDDO
c
C
c
C     5.3 Add surface fluxes and convert fluxes to tendencies

      DO J=1,NGP
       IF ( NLEVxy(J,myThid) .GT. 0 ) THEN
        UT_PBL(J,NLEVxy(J,myThid),myThid)=UT_PBL(J,NLEVxy(J,myThid),myThid)+ USTR(J,3,myThid)
        VT_PBL(J,NLEVxy(J,myThid),myThid)=VT_PBL(J,NLEVxy(J,myThid),myThid)+ VSTR(J,3,myThid)
        TT_PBL(J,NLEVxy(J,myThid),myThid)=TT_PBL(J,NLEVxy(J,myThid),myThid)+ SHF(J,3,myThid)
        QT_PBL(J,NLEVxy(J,myThid),myThid)=QT_PBL(J,NLEVxy(J,myThid),myThid)+ EVAP(J,3,myThid)
       ENDIF
      ENDDO
C
Cdbgch
      DO J=1,NGP
       IF ( NLEVxy(J,myThid) .GT. 0 ) THEN
        DO K=NLEVxy(J,myThid)-1,NLEVxy(J,myThid)
         UT_PBL(J,K,myThid)=UT_PBL(J,K,myThid)*GRDSIG(K)
         VT_PBL(J,K,myThid)=VT_PBL(J,K,myThid)*GRDSIG(K)
         TT_PBL(J,K,myThid)=TT_PBL(J,K,myThid)*GRDSCP(K)
         QT_PBL(J,K,myThid)=QT_PBL(J,K,myThid)*GRDSIG(K)
        ENDDO
       ENDIF
      ENDDO
C
C     5.2 Vertical diffusion and shallow convection (not yet implemented)
C
      CALL VDIFSC (UG1(1,1,myThid),VG1(1,1,myThid),
     &             TG1(1,1,myThid),RH(1,1,myThid), 
     &             QG1(1,1,myThid), QSAT(1,1,myThid),
     *             UT_VDI,VT_VDI,TT_VDI,QT_VDI,
     I             myThid)
C
      DO K=1,NLEV
       DO J=1,NGP
        UT_PBL(J,K,myThid)=UT_PBL(J,K,myThid)+ UT_VDI(J,K)
        VT_PBL(J,K,myThid)=VT_PBL(J,K,myThid)+ VT_VDI(J,K)
        TT_PBL(J,K,myThid)=TT_PBL(J,K,myThid)+ TT_VDI(J,K)
        QT_PBL(J,K,myThid)=QT_PBL(J,K,myThid)+ QT_VDI(J,K)
       ENDDO
      ENDDO
C

CdbgC--
      RETURN
      END
