C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/phy_suflux.F,v 1.5 2001/09/25 19:53:57 jmc Exp $
C $Name: checkpoint46 $

      SUBROUTINE SUFLUX (PSA,UA,VA,TA,QA,RH,QSAT,Vsurfsq,PHI,
     *                   PHI0,FMASK,TLAND,TSEA,SWAV,SSR,SLR,
     *                   DRAG,USTR,VSTR,SHF,EVAP,T0,Q0,QSAT0,SPEED0,
     &                   myThid)
C--
C--   SUBROUTINE SUFLUX (PSA,UA,VA,TA,QA,RH,PHI,
C--  *                   PHI0,FMASK,TLAND,TSEA,SWAV,
C--  *                   USTR,VSTR,SHF,EVAP)
C--
C--   Purpose: Compute surface fluxes of momentum, energy and moisture
C--   Input:   PSA    = norm. surface pressure [p/p0] (2-dim)
C--            UA     = u-wind                        (3-dim)
C--            VA     = v-wind                        (3-dim)
C--            TA     = temperature                   (3-dim)
C--            QA     = specific humidity [g/kg]      (3-dim)
C--            RH     = relative humidity             (3-dim)
C--            PHI    = geopotential                  (3-dim)
C--            PHI0   = surface geopotential          (2-dim)
C--            FMASK  = fractional land-sea mask         (2-dim)
C--            TLAND  = land-surface temperature         (2-dim)
C--            TSEA   =  sea-surface temperature         (2-dim)
C--            SWET   = soil wetness availability [0-1]  (2-dim)
C--   Output:  USTR   = u stress                         (2-dim)
C--            VSTR   = v stress                         (2-dim)
C--            SHF    = sensible heat flux               (2-dim)
C--            EVAP   = evaporation [g/(m^2 s)]          (2-dim)
C - added (jmc) :
C--           Vsurfsq = square of surface wind speed (2-dim,input)
C--                       ==> UA,VA are no longer used
C--            DRAG   = surface Drag term (= Cd*|V|) (2-dim,output)
C--                       ==> USTR,VSTR are no longer used
C--         myThid    = Instance number of this instance of the
C--                     the routine.
C--


      IMPLICIT rEAL*8 (A-H,O-Z)


C     Resolution parameters
C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/EEPARAMS.h,v 1.10 2001/09/21 03:54:35 cnh Exp $
C $Name: checkpoint46 $
CBOP
C     !ROUTINE: EEPARAMS.h
C     !INTERFACE:
C     include "EEPARAMS.h"
C
C     !DESCRIPTION:
C     *==========================================================*
C     | EEPARAMS.h                                               |
C     *==========================================================*
C     | Parameters for "execution environemnt". These are used   |
C     | by both the particular numerical model and the "execution|
C     | environment" support routines.                           |
C     *==========================================================*
CEOP

C     MAX_LEN_MBUF         - Default message buffer max. size
C     MAX_LEN_FNAM         - Default file name max. size
C     MAX_LEN_PREC         - Default record length for reading "parameter" files
      INTEGER MAX_LEN_MBUF
      PARAMETER ( MAX_LEN_MBUF = 512 )
      INTEGER MAX_LEN_FNAM
      PARAMETER ( MAX_LEN_FNAM = 512 )
      INTEGER MAX_LEN_PREC
      PARAMETER ( MAX_LEN_PREC = 200 )

C     SQUEEZE_RIGHT       - Flag indicating right blank space removal
C                           from text field.
C     SQUEEZE_LEFT        - Flag indicating left blank space removal
C                           from text field.
C     SQUEEZE_BOTH        - Flag indicating left and right blank
C                           space removal from text field.
C     PRINT_MAP_XY        - Flag indicating to plot map as XY slices
C     PRINT_MAP_XZ        - Flag indicating to plot map as XZ slices
C     PRINT_MAP_YZ        - Flag indicating to plot map as YZ slices
C     commentCharacter    - Variable used in column 1 of parameter files to
C                           indicate comments.
C     INDEX_I             - Variable used to select an index label
C     INDEX_J               for formatted input parameters.
C     INDEX_K
C     INDEX_NONE
      CHARACTER*(*) SQUEEZE_RIGHT
      PARAMETER ( SQUEEZE_RIGHT = 'R' )
      CHARACTER*(*) SQUEEZE_LEFT
      PARAMETER ( SQUEEZE_LEFT = 'L' )
      CHARACTER*(*) SQUEEZE_BOTH
      PARAMETER ( SQUEEZE_BOTH = 'B' )
      CHARACTER*(*) PRINT_MAP_XY
      PARAMETER ( PRINT_MAP_XY = 'XY' )
      CHARACTER*(*) PRINT_MAP_XZ
      PARAMETER ( PRINT_MAP_XZ = 'XZ' )
      CHARACTER*(*) PRINT_MAP_YZ
      PARAMETER ( PRINT_MAP_YZ = 'YZ' )
      CHARACTER*(*) commentCharacter
      PARAMETER ( commentCharacter = '#' )
      INTEGER INDEX_I
      INTEGER INDEX_J
      INTEGER INDEX_K   
      INTEGER INDEX_NONE
      PARAMETER ( INDEX_I    = 1,
     &            INDEX_J    = 2,
     &            INDEX_K    = 3,
     &            INDEX_NONE = 4 )


C     EXCH_IGNORE_CORNERS - Flag to select ignoring or
C     EXCH_UPDATE_CORNERS   updating of corners during
C                           an edge exchange.
      INTEGER EXCH_IGNORE_CORNERS
      INTEGER EXCH_UPDATE_CORNERS
      PARAMETER ( EXCH_IGNORE_CORNERS = 0,
     &            EXCH_UPDATE_CORNERS = 1 )

C     FORWARD_SIMULATION
C     REVERSE_SIMULATION
      INTEGER FORWARD_SIMULATION
      INTEGER REVERSE_SIMULATION
      PARAMETER ( FORWARD_SIMULATION = 0,
     &            REVERSE_SIMULATION = 1 )


C     Particularly weird and obscure voodoo numbers
C     lShare  - This wants to be the length in
C               [148]-byte words of the size of
C               the address "window" that is snooped
C               on an SMP bus. By separating elements in
C               the global sum buffer we can avoid generating
C               extraneous invalidate traffic between
C               processors. The length of this window is usually
C               a cache line i.e. small O(64 bytes).
C               The buffer arrays are usually short arrays
C               and are declared REAL ARRA(lShare[148],LBUFF).
C               Setting lShare[148] to 1 is like making these arrays
C               one dimensional.
      INTEGER cacheLineSize
      INTEGER lShare1
      INTEGER lShare4
      INTEGER lShare8
      PARAMETER ( cacheLineSize = 256 )
      PARAMETER ( lShare1 =  cacheLineSize )
      PARAMETER ( lShare4 =  cacheLineSize/4 )
      PARAMETER ( lShare8 =  cacheLineSize/8 )

C     MAX_NO_THREADS  - Maximum number of threads allowed.
C     MAX_NO_PROCS    - Maximum number of processes allowed.
C     MAX_NO_BARRIERS - Maximum number of distinct thread "barriers"
      INTEGER MAX_NO_THREADS
      PARAMETER ( MAX_NO_THREADS =   32 )
      INTEGER MAX_NO_PROCS
      PARAMETER ( MAX_NO_PROCS   =  128 )
      INTEGER MAX_NO_BARRIERS
      PARAMETER ( MAX_NO_BARRIERS = 1 )

C--   COMMON /EEPARAMS_L/ Execution environment public logical variables.
C     eeBootError - Flag indicating error during multi-processing
C     eeEndError    initialisation/termination.
C     fatalError  - Flag used to indicate that the model is ended with
C                   an error
      COMMON /EEPARAMS_L/ eeBootError, fatalError, eeEndError,
     &  useCubedSphereExchange
      LOGICAL eeBootError
      LOGICAL eeEndError
      LOGICAL fatalError
      LOGICAL useCubedSphereExchange

C--   COMMON /EPARAMS_I/ Execution environment public integer variables.
C     errorMessageUnit    - Fortran IO unit for error messages
C     standardMessageUnit - Fortran IO unit for informational messages
C     scrUnit1      - Scratch file 1 unit number
C     scrUnit2      - Scratch file 2 unit number
C     eeDataUnit    - Unit number used for reading "execution environment" parameter file.
C     modelDataUnit - Unit number for reading "model" parameter file.
C     numberOfProcs - Number of processes computing in parallel
C     pidIO         - Id of process to use for I/O.
C     myBxLo, myBxHi - Extents of domain in blocks in X and Y
C     myByLo, myByHi   that each threads is responsble for.
C     myProcId      - My own "process" id.
C     myPx     - My X coord on the proc. grid.
C     myPy     - My Y coord on the proc. grid.
C     myXGlobalLo - My bottom-left (south-west) x-index
C                   global domain. The x-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     myYGlobalLo - My bottom-left (south-west) y-index in
C                   global domain. The y-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     nThreads    - No. of threads
C     nTx         - No. of threads in X
C     nTy         - No. of threads in Y
C                   This assumes a simple cartesian
C                   gridding of the threads which is not required elsewhere
C                   but that makes it easier.
C     ioErrorCount - IO Error Counter. Set to zero initially and increased
C                    by one every time an IO error occurs.
      COMMON /EEPARAMS_I/ errorMessageUnit, standardMessageUnit,
     & scrUnit1, scrUnit2, eeDataUnit, modelDataUnit,
     & numberOfProcs, pidIO, myProcId,
     & myPx, myPy, myXGlobalLo, myYGlobalLo, nThreads,
     & myBxLo, myBxHi, myByLo, myByHi,
     & nTx, nTy, ioErrorCount
      INTEGER eeDataUnit
      INTEGER errorMessageUnit
      INTEGER ioErrorCount(MAX_NO_THREADS)
      INTEGER modelDataUnit
      INTEGER myBxLo(MAX_NO_THREADS)
      INTEGER myBxHi(MAX_NO_THREADS)
      INTEGER myByLo(MAX_NO_THREADS)
      INTEGER myByHi(MAX_NO_THREADS)
      INTEGER myProcId
      INTEGER myPx
      INTEGER myPy
      INTEGER myXGlobalLo
      INTEGER myYGlobalLo
      INTEGER nThreads
      INTEGER nTx
      INTEGER nTy
      INTEGER numberOfProcs
      INTEGER pidIO
      INTEGER scrUnit1
      INTEGER scrUnit2
      INTEGER standardMessageUnit
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/atparam.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

C     MITgcm declaration of grid size. 
C     Latitudinal extent is one less than MITgcm ( i.e. NY-1)
C     because MITgcm has dummy layer of land at northern most
C     edge.
C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/SIZE.h,v 1.3 2001/09/27 15:36:29 jmc Exp $
C $Name: checkpoint46 $
C
C     /==========================================================C     | SIZE.h Declare size of underlying computational grid.    |
C     |==========================================================|
C     | The design here support a three-dimensional model grid   |
C     | with indices I,J and K. The three-dimensional domain     |
C     | is comprised of nPx*nSx blocks of size sNx along one axis|
C     | nPy*nSy blocks of size sNy along another axis and one    |
C     | block of size Nz along the final axis.                   |
C     | Blocks have overlap regions of size OLx and OLy along the|
C     | dimensions that are subdivided.                          |
C     \==========================================================/
C     Voodoo numbers controlling data layout.
C     sNx - No. X points in sub-grid.
C     sNy - No. Y points in sub-grid.
C     OLx - Overlap extent in X.
C     OLy - Overlat extent in Y.
C     nSx - No. sub-grids in X.
C     nSy - No. sub-grids in Y.
C     nPx - No. of processes to use in X.
C     nPy - No. of processes to use in Y.
C     Nx  - No. points in X for the total domain.
C     Ny  - No. points in Y for the total domain.
C     Nr  - No. points in Z for full process domain.
      INTEGER sNx
      INTEGER sNy
      INTEGER OLx
      INTEGER OLy
      INTEGER nSx
      INTEGER nSy
      INTEGER nPx
      INTEGER nPy
      INTEGER Nx
      INTEGER Ny
      INTEGER Nr
      PARAMETER (
     &           sNx = 128,
     &           sNy =   4,
C    &           sNy =   8,
C    &           sNy =  16,
C    &           sNy =  32,
C    &           sNy =  64,
     &           OLx =   3,
     &           OLy =   3,
     &           nSx =   1,
     &           nSy =   1,
     &           nPx =   1,
     &           nPy =  16,
C    &           nPy =   8,
C    &           nPy =   4,
C    &           nPy =   2,
C    &           nPy =   1,
     &           Nx  = sNx*nSx*nPx,
     &           Ny  = sNy*nSy*nPy,
     &           Nr  =   5)

C     MAX_OLX  - Set to the maximum overlap region size of any array
C     MAX_OLY    that will be exchanged. Controls the sizing of exch
C                routine buufers.
      INTEGER MAX_OLX
      INTEGER MAX_OLY
      PARAMETER ( MAX_OLX = OLx,
     &            MAX_OLY = OLy )

C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/atparam0.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

      INTEGER ISC
      PARAMETER (ISC=1)

      INTEGER NTRUN, MTRUN, IX
      PARAMETER ( NTRUN=21, MTRUN=21, IX=sNx )   

      INTEGER MX, MX2, IL, NTRUN1, MXP
      PARAMETER (MX=MTRUN+1 , MX2=2*MX)
      PARAMETER (IL=sNy, NTRUN1=NTRUN+1 )
      PARAMETER ( MXP=ISC*MTRUN+1 )
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/atparam1.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Name: checkpoint46 $
C $Namer: $

      INTEGER KX
      PARAMETER (KX=NR)

      INTEGER KX2, KXM, KXP, NTR
      PARAMETER (KX2=2*KX, KXM=KX-1, KXP=KX+1)
      PARAMETER (NTR=1)
C     $Id: atparam1.h,v 1.3 2001/02/04 14:38:49 cnh Exp $
C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/Lev_def.h,v 1.3 2001/05/29 19:28:53 cnh Exp $
C $Name: checkpoint46 $

      COMMON/NB_LEVELS/NLEVxy, NLEVxyU, NLEVxyV
      INTEGER NLEVxy(IX*IL,MAX_NO_THREADS)
      INTEGER NLEVxyU(IX*IL,MAX_NO_THREADS)
      INTEGER NLEVxyV(IX*IL,MAX_NO_THREADS)
C
      INTEGER NLON,NLAT,NLEV,NGP
      PARAMETER ( NLON=IX, NLAT=IL, NLEV=KX, NGP=NLON*NLAT )

C     Physical constants + functions of sigma and latitude

C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/com_physcon.h,v 1.4 2001/06/18 17:39:58 cnh Exp $
C $Name: checkpoint46 $

C--
C--   /PHYCON/: Physical constants (initial. in INPHYS)
C--    P0   = reference pressure
C--    GG   = gravity accel.
C--    RD   = gas constant for dry air
C--    CP   = specific heat at constant pressure
C--    ALHC = latent heat of condensation
C--    SBC  = Stefan-Boltzmann constant

      COMMON /PHYCON/ P0, GG, RD, CP, ALHC, SBC
C--
C--   /FSIGMU/: Functions of sigma and latitude (initial. in INPHYS)
C--    SIG    = full-level sigma 
C--    SIGL   = logarithm of full-level sigma
C--    SIGH   = half-level sigma
C--    DSIG   = layer depth in sigma
C--    POUT   = norm. pressure level [p/p0] for post-processing
C--    GRDSIG = g/(d_sigma p0) : to convert fluxes of u,v,q into d(u,v,q)/dt
C--    GRDSCP = g/(d_sigma p0 c_p): to convert energy fluxes into dT/dt
C--    WVI    = weights for vertical interpolation
C--    FMU    = legendre polinomials in sin(lat)

      COMMON /FSIGMU/ SIG(NLEV), SIGL(NLEV), SIGH(0:NLEV), DSIG(NLEV),
     *                POUT(NLEV), GRDSIG(NLEV), GRDSCP(NLEV), 
     *                WVI(NLEV,2), FMU(NGP,2,MAX_NO_THREADS)

C     Surface flux constants

C $Header: /u/u0/gcmpack/MITgcm/pkg/aim/com_sflcon.h,v 1.2 2001/02/02 21:36:29 adcroft Exp $
C $Name: checkpoint46 $

C--
C--   /SFLCON/: Constants for surface fluxes (initial. in INPHYS)
C--    FWIND0 = ratio of near-sfc wind to lowest-level wind
C--    FTEMP0 = weight for near-sfc temperature extrapolation (0-1) :
C--             1 : linear extrapolation from two lowest levels
C--             0 : constant potential temperature ( = lowest level)
C--    FHUM0  = weight for near-sfc specific humidity extrapolation (0-1) :
C--             1 : extrap. with constant relative hum. ( = lowest level)
C--             0 : constant specific hum. ( = lowest level)
C--    CDL    = drag coefficient for momentum over land
C--    CDS    = drag coefficient for momentum over sea
C--    CHL    = heat exchange coefficient over land
C--    CHS    = heat exchange coefficient over sea
C--    VGUST  = wind speed for sub-grid-scale gusts
C--    SWMAX  = Soil wetness (in mm) corresp. to potential evapotranspiration

      COMMON /SFLCON/ FWIND0, FTEMP0, FHUM0,
     *                CDL, CDS, CHL, CHS, VGUST, SWMAX

C
      REAL PSA(NGP), UA(NGP,NLEV), VA(NGP,NLEV), TA(NGP,NLEV),
     *     QA(NGP,NLEV), RH(NGP,NLEV), QSAT(NGP,NLEV), PHI(NGP,NLEV),
     *     PHI0(NGP), FMASK(NGP), TLAND(NGP), TSEA(NGP), SWAV(NGP),
     *     SSR(NGP), SLR(NGP)
      REAL Vsurfsq(NGP), DRAG(NGP)
      INTEGER myThid
C
      REAL USTR(NGP,3), VSTR(NGP,3), SHF(NGP,3), EVAP(NGP,3)
C									
      REAL U0(NGP),V0(NGP),T0(NGP,2),Q0(NGP),QSAT0(NGP,2),DENVV(NGP,3)
      REAL SPEED0(NGP)
      REAL WORK(NGP)
      INTEGER NL1(NGP)
      REAL AUX(NGP)
C
      REAL    pSurfs(NLEV)
      DATA    pSurfs /75D2,250D2,500D2,775D2,950D2 /
C
      REAL    pSurfw(NLEV)
      DATA    pSurfw /150D2,350D2,650D2,900D2,1000D2/
Cchdbg
      INTEGER NPAS
      SAVE NPAS
      LOGICAL Ifirst
      SAVE Ifirst
      DATA Ifirst /.TRUE./
      REAL T0moy1(NGP)
      REAL T0moy2(NGP)
      SAVE T0moy2, T0moy1
      REAL denmoy1(NGP)
      REAL denmoy2(NGP)
      SAVE denmoy1, denmoy2
      REAL Q0moy(NGP)
      SAVE Q0moy
      REAL factwind2
      INTEGER J
      REAL QDUMMY(1), RDUMMY(1)
C
C--   1. Extrapolation of wind, temp, hum. and density to the surface
C
C     1.1 Wind components
C   
      DO J=1,NGP
         U0(J) = 0.0
         V0(J) = 0.0
        IF ( NLEVxyU(J,myThid) .GT. 0 ) THEN
         U0(J) = FWIND0*UA(J,NLEVxyU(J,myThid))
        ENDIF
        IF ( NLEVxyV(J,myThid) .GT. 0 ) THEN
         V0(J) = FWIND0*VA(J,NLEVxyV(J,myThid))
        ENDIF
      ENDDO
C
C     1.2 Temperature
C
      GTEMP0 = 1.D0-FTEMP0
      RCP = 1.D0/CP
      DO J=1,NGP
        NL1(J)=NLEVxy(J,myThid)-1
      ENDDO
C
      DO J=1,NGP
       IF ( NLEVxy(J,myThid) .GT. 0 ) THEN
        T0(J,1) = TA(J,NLEVxy(J,myThid))+WVI(NLEVxy(J,myThid),2)*
     &                          (TA(J,NLEVxy(J,myThid))-TA(J,NL1(J)))
ccccc        T0(J,2) = TA(J,NLEVxy(J))+RCP*(PHI(J,NLEVxy(J))-PHI0(J))
        T0(J,2) = TA(J,NLEVxy(J,myThid))*
     &         ((Psurfw(NLEVxy(J,myThid))/
     &           Psurfs(Nlevxy(J,myThid)))**(RD/CP))
       ELSE
        T0(J,1) = 273.16D0
        T0(J,2) = 273.16D0
       ENDIF
      ENDDO
C
      DO J=1,NGP
        T0(J,1) = FTEMP0*T0(J,1)+GTEMP0*T0(J,2)
      ENDDO
C
C     1.3 Spec. humidity
C
      GHUM0 = 1.D0-FHUM0
C
      DO J=1,NGP
       IF ( NLEVxy(J,myThid) .GT. 0 ) THEN
        WORK(J)=RH(J,Nlevxy(J,myThid))
cchdbg
c        WORK(J) = RH(J,NLEVxy(J))+WVI(NLEVxy(J),2)*
c     &                          (RH(J,NLEVxy(J))-RH(J,NL1(J)))
cchdbg
       ENDIF
      ENDDO
C
      CALL SHTORH (-1,NGP,T0,PSA,1.D0,Q0,WORK,QSAT0,myThid)
C
      DO J=1,NGP
       IF ( NLEVxy(J,myThid) .GT. 0 ) THEN
        Q0(J)=FHUM0*Q0(J)+GHUM0*QA(J,NLEVxy(J,myThid))
       ENDIF
      ENDDO

C     1.4 Density * wind speed (including gustiness factor)

      PRD = P0/RD
      VG2 = VGUST*VGUST
      factwind2 = FWIND0*FWIND0
C
      DO J=1,NGP
c_jmc   SPEED0(J)=SQRT(U0(J)*U0(J)+V0(J)*V0(J)+VG2)
        SPEED0(J)=SQRT(factwind2*Vsurfsq(J)+VG2)
        DENVV(J,3)=(PRD*PSA(J)/T0(J,1))*SPEED0(J)
c_jmc   DENVV(J,3)=(PRD*PSA(J)/T0(J,1))*
c_jmc*           SQRT(U0(J)*U0(J)+V0(J)*V0(J)+VG2)
cchdbg        DENVV(J,3)=0.7*(PRD*PSA(J)/T0(J,1))*
cchdbg     *           SQRT(U0(J)*U0(J)+V0(J)*V0(J)+VG2)
      ENDDO
C
C     1.5 Stability correction for heat/moisture fluxes
C
      DTHETAF = 3.D0
      FSTAB = 0.67D0
      RDTH = FSTAB/DTHETAF
C
      DO J=1,NGP
        FSLAND=1.+MIN(DTHETAF,MAX(-DTHETAF,TLAND(J)-T0(J,2)))*RDTH
        FSSEA =1.+MIN(DTHETAF,MAX(-DTHETAF, TSEA(J)-T0(J,2)))*RDTH
        aux(J)=FSLAND
        DENVV(J,1)=DENVV(J,3)*FSLAND
        DENVV(J,2)=DENVV(J,3)*FSSEA
cchdbg        DENVV(J,1)=DENVV(J,3)
cchdbg        DENVV(J,2)=DENVV(J,3)
      ENDDO
C
C--   2. Computation of fluxes over land and sea
C
C     2.1 Wind stress
C
c_jmc DO J=1,NGP
c_jmc  IF ( NLEVxyu(J) .GT. 0  ) THEN
c_jmc   USTR(J,1) = -CDL*DENVV(J,3)*UA(J,NLEVxyu(J))
c_jmc   USTR(J,2) = -CDS*DENVV(J,3)*UA(J,NLEVxyu(J))
c_jmc  ENDIF
c_jmc  IF ( NLEVxyv(J) .GT. 0  ) THEN
c_jmc   VSTR(J,1) = -CDL*DENVV(J,3)*VA(J,NLEVxyv(J))
c_jmc   VSTR(J,2) = -CDS*DENVV(J,3)*VA(J,NLEVxyv(j))
c_jmc  ENDIF
c---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|
C   Compute surface drag term (= C_drag*|V| ) to allow direct computation 
C     of surface stress on C-grid.
C     add Land + Sea contributions ; Convert to surface pressure level 
      DO J=1,NGP
       IF ( NLEVxy(J,myThid) .GT. 0  ) THEN
        DRAG(J) = ( CDS+FMASK(J)*(CDL-CDS) ) * DENVV(J,3)
       ELSE
        DRAG(J) = 0.
       ENDIF
      ENDDO
C - Notes: 
C   because of a different mapping between the Drag and the Wind (A/C-grid)
C   the surface stress is computed later, in "External Forcing", 
C  => USTR,VSTR is no longer used. only here for diagnostic of old version.
      DO J=1,NGP
        USTR(J,3) = 0.
        VSTR(J,3) = 0.
       IF ( NLEVxyU(J,myThid) .GT. 0  ) 
     &  USTR(J,3) = -DRAG(J)*UA(J,NLEVxyU(J,myThid))
       IF ( NLEVxyV(J,myThid) .GT. 0  ) 
     &  VSTR(J,3) = -DRAG(J)*VA(J,NLEVxyV(J,myThid))
      ENDDO
c---+----1----+----2----+----3----+----4----+----5----+----6----+----7-|--+----|
C
C     2.2 Sensible heat flux (from clim. TS over land)
C
      CHLCP = CHL*CP
      CHSCP = CHS*CP
C
      DO J=1,NGP
        SHF(J,1) = CHLCP*DENVV(J,1)*(TLAND(J)-T0(J,1))
        SHF(J,2) = CHSCP*DENVV(J,2)*(TSEA(J) -T0(J,1))
      ENDDO
C
C ****************************************************
cchdbg
      IF (Ifirst) then 
        npas=0.
        do J=1,NGP
          T0moy1(J)=0. 
          T0moy2(J)=0. 
          denmoy1(J)=0. 
          denmoy2(J)=0. 
          Q0moy(J)=0.
        enddo
        ifirst=.false.
      ENDIF
C
      npas=npas+1
      DO J=1,NGP
        T0moy1(J)=T0moy1(J) + T0(J,1)
        T0moy2(J)=T0moy2(J) + T0(J,2)
        denmoy1(J)=denmoy1(J) + DENVV(J,1)
        denmoy2(J)=denmoy2(J) + DENVV(J,2)
        Q0moy(J)=Q0moy(J) + Q0(J)
      ENDDO
C
      if(npas.eq.5760) then
        DO J=1,NGP
          T0moy1(J)=T0moy1(J)/float(npas)
          T0moy2(J)=T0moy2(J)/float(npas)
          denmoy1(J)=denmoy1(J)/float(npas)
          denmoy2(J)=denmoy2(J)/float(npas)
          Q0moy(J)=Q0moy(J)/float(npas)
        ENDDO
C
        open(73,file='Tmoy1',form='unformatted')
        write(73) T0moy1
        close(73)
        open(74,file='Tmoy2',form='unformatted')
        write(74) T0moy2
        close(74)
        open(73,file='denmoy1',form='unformatted')
        write(73) denmoy1
        close(73)
        open(74,file='denmoy2',form='unformatted')
        write(74) denmoy2
        close(74)
        open(74,file='Q0moy',form='unformatted')
        write(74) Q0moy
        close(74)
      ENDIF
C
cchdbg
C ****************************************************
C
c        CALL DUMP_WRITE2D ( NGP,1,'T0.', nIter,T0 , iErr)
c        CALL DUMP_WRITE2D ( NGP,3,'DENVV.', nIter,DENVV , iErr)
c        CALL DUMP_WRITE2D ( NGP,1,'TSEA.', nIter,TSEA , iErr)
c        CALL DUMP_WRITE2D ( NGP,1,'TLAND.', nIter,TLAND , iErr)
c        CALL DUMP_WRITE2D ( NGP,1,'AUX.', nIter,aux , iErr)
C
C     2.3 Evaporation
C
      CALL SHTORH (0,NGP,TLAND,PSA,1.D0,QDUMMY,RDUMMY,QSAT0(1,1),myThid)
      CALL SHTORH (0,NGP,TSEA ,PSA,1.D0,QDUMMY,RDUMMY,QSAT0(1,2),myThid)

      DO J=1,NGP
Cdj    EVAP(J,1) = CHL*DENVV(J,1)*MAX(0.D0,SWAV(J)*QSAT0(J,1)-Q0(J))
       EVAP(J,1)=CHL*DENVV(J,1)*MIN(1.D0,SWAV(J))*(QSAT0(J,1)-Q0(J))
cdj try new scheme : assume that the net heat flux on land is zero
cdj                  at all time and at all points (this is equivalent
cdj                  to say that the land has a zero heat capacity)
cdj        EVAP(J,1) = SSR(J)-SLR(J)-SHF(J,1)
       EVAP(J,2) = CHS*DENVV(J,2)*(QSAT0(J,2)-Q0(J))
C - test(jmc): only positive evaporation :
c      EVAP(J,1)=CHL*DENVV(J,1)*MAX(0.D0,SWAV(J)*(QSAT0(J,1)-Q0(J)))
c      EVAP(J,2)=CHS*DENVV(J,2)*MAX(0.D0,QSAT0(J,2)-Q0(J))
      ENDDO


C--   3. Weighted average of fluxes according to land-sea mask

      DO J=1,NGP
c_jmc   USTR(J,3) = USTR(J,2)+FMASK(J)*(USTR(J,1)-USTR(J,2))
c_jmc   VSTR(J,3) = VSTR(J,2)+FMASK(J)*(VSTR(J,1)-VSTR(J,2))
         SHF(J,3) =  SHF(J,2)+FMASK(J)*( SHF(J,1)- SHF(J,2))
        EVAP(J,3) = EVAP(J,2)+FMASK(J)*(EVAP(J,1)-EVAP(J,2))
cdj
        QSAT0(J,1) = QSAT0(J,2)+FMASK(J)*(QSAT0(J,1)-QSAT0(J,2))
cdj
      ENDDO

C--
      RETURN
      END
