C $Header: /u/u0/gcmpack/MITgcm/pkg/ptracers/ptracers_read_checkpoint.F,v 1.1 2002/03/04 19:01:29 adcroft Exp $
C $Name: checkpoint46 $

#include "PTRACERS_OPTIONS.h"

CBOP
C !ROUTINE: PTRACERS_READ_CHECKPOINT

C !INTERFACE: ==========================================================
      SUBROUTINE PTRACERS_READ_CHECKPOINT( myIter,myThid )

C !DESCRIPTION:
C     Reads current state of passive tracers from a pickup file

C !USES: ===============================================================
      IMPLICIT NONE
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "PTRACERS.h"

C !INPUT PARAMETERS: ===================================================
C  myIter               :: time-step number
C  myThid               :: thread number
      INTEGER myIter
      INTEGER myThid

C !OUTPUT PARAMETERS: ==================================================
C  none

#ifdef ALLOW_PTRACERS

C !LOCAL VARIABLES: ====================================================
C  iTracer		:: loop indices
C  iRec    		:: record number
C  fn   		:: character buffer for creating filename
C  prec 		:: precision of pickup files
C  fn                   :: suffix for pickup file (eg. 0000000010)
      INTEGER iTracer,prec,iRec
      CHARACTER*(MAX_LEN_MBUF) fn
CEOP

      WRITE(fn,'(A,I10.10)') 'pickup_ptracers.',myIter
      prec = precFloat64

C Write fields as consecutive records
      DO iTracer=1,PTRACERS_num
       iRec = iTracer
       CALL MDSREADFIELD(fn,prec,'RL',Nr,
     &      pTracer(1-Olx,1-Oly,1,1,1,iTracer),iRec,myThid)
      _EXCH_XYZ_R8(pTracer,myThid)
      ENDDO

C Write historical tendancies as consecutive records
      DO iTracer=1,PTRACERS_num
       iRec = iTracer + PTRACERS_num
       CALL MDSREADFIELD(fn,prec,'RL',Nr,
     &      gPtr(1-Olx,1-Oly,1,1,1,iTracer),iRec,myThid)
      _EXCH_XYZ_R8(gPtr,myThid)
      ENDDO
      DO iTracer=1,PTRACERS_num
       iRec = iTracer + PTRACERS_num*2
       CALL MDSREADFIELD(fn,prec,'RL',Nr,
     &      gPtrNm1(1-Olx,1-Oly,1,1,1,iTracer),iRec,myThid)
      _EXCH_XYZ_R8(gPtrNm1,myThid)
      ENDDO

#endif /* ALLOW_PTRACERS */

      RETURN
      END
