C $Header: /u/u0/gcmpack/MITgcm/model/src/swfrac.F,v 1.9 2001/09/26 18:09:16 cnh Exp $
C $Name: checkpoint46 $

C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/CPP_OPTIONS.h,v 1.2 2001/05/29 14:01:48 adcroft Exp $
C $Name: checkpoint46 $
C

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/aim.5l_LatLon/code/CPP_EEOPTIONS.h,v 1.2 2001/05/29 14:01:48 adcroft Exp $
C $Name: checkpoint46 $
C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C--   Control MPI based parallel processing





 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 
C--   Control use of "double" precision constants.
C     Use D0 where it means REAL*8 but not where it means REAL*16


C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.







C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name: checkpoint46 $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.




















C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.

 
C--   Control use of "double" precision constants.
C     Use d0 where it means REAL*8 but not where it means REAL*16


C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








C o Include/exclude code specific to the ECCO/SEALION version.



C o Enable/disable state import and export.





CBOP
C     !ROUTINE: SWFRAC
C     !INTERFACE:
      SUBROUTINE SWFRAC(
     I     imax, fact,
     I     mytime, mythid,
     U     swdk )
C     !DESCRIPTION: \bv
C     *==========================================================*
C     | SUBROUTINE SWFRAC                                         
C     | o Compute solar short-wave flux penetration.
C     *==========================================================*
C     | Compute fraction of solar short-wave flux penetrating to  
C     | specified depth, swdk, due to exponential decay in        
C     | Jerlov water type jwtype.                                 
C     | Reference : Two band solar absorption model of Paulson    
C     |             and Simpson (1977, JPO, 7, 952-956)           
C     | Notes                                                     
C     | =====                                                     
C     | Parameter jwtype is hardcoded to 3 for time being.        
C     | Below 200m the solar penetration gets set to zero,        
C     | otherwise the limit for the exponent (+/- 5678) needs to   
C     | be taken care of.                                         
C     | Written by   : Jan Morzel                                 
C     | Date         : July 12, 1995                              
C     *==========================================================*
C     \ev

C     !USES:
      IMPLICIT NONE

C     !INPUT/OUTPUT PARAMETERS:
C     === Routine arguments ===
C     input arguments
C     imax    :: number of vertical grid points
C     fact    :: scale  factor to apply to depth array
C     myTime  :: current time in simulation
C     myThid  :: thread number for this instance of the routine.
      INTEGER imax
      Real*8     fact
      Real*8     mytime
      integer mythid
C     input/output arguments
C     swdk    :: on input: vertical depth for desired sw fraction
C               (fact*swdk) is negative distance (m) from surface
C     swdk    :: on output: short wave (radiation) fractional decay
      Real*8     swdk(imax)

C     !LOCAL VARIABLES:
C     === Local variables ===
C     max number of different water types 
      integer   nwtype  , jwtype
      PARAMETER(nwtype=5)
      Real*8 facz
      Real*8 rfac(nwtype),a1(nwtype),a2(nwtype)
      INTEGER i

C
C     Jerlov water type :  I       IA      IB      II      III
C                jwtype    1       2       3       4       5
C
      DATA rfac         /  0.58 ,  0.62 ,  0.67 ,  0.77 ,  0.78 /
      DATA a1           /  0.35 ,  0.6  ,  1.0  ,  1.5  ,  1.4  /
      DATA a2           / 23.0  , 20.0  , 17.0  , 14.0  ,  7.9  /
CEOP


      jwtype=2


      DO i = 1,imax
         facz = fact*swdk(i)
         IF (facz .LT. (-200.)) THEN
            swdk(i) = 0.
         ELSE
            swdk(i) =       rfac(jwtype)  * exp(facz/a1(jwtype))
     $                + (1.-rfac(jwtype)) * exp(facz/a2(jwtype))
         ENDIF
      ENDDO

      RETURN
      END
