#!/bin/csh -f
#
# Driver to build ESMF superstructure
# and infrastructure based component 
# form of JMCl.
#
# The build has four major steps
#  1. compiling and creating modules for the
#     ocn component internals
#  2. compiling and creating modules for the
#     atm component internals
#  3. compiling and creating modules for the
#     a2o, o2a coupler components and for the
#     driver and ESMF based communication.
#  4. Linking to form an executable image
#     "esmf_top/a.out"
#
setenv BUILDROOT `pwd`

cd esmf_top
./comp1.sh   |& tee esmfapp-build.log >/dev/null
cd ..

cd ocn
./build.sh  |& tee ocn-build.log >/dev/null
cd ..

cd atm
./build.sh  |& tee atm-build.log >/dev/null
cd ..

cd esmf_top
./comp2.sh   |& tee esmfapp-build.log >/dev/null
cd ..
