C $Header: $
C $Name:   $  

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE ATM_STORE_QLONGWAVE( myCurrentTime, 
     I                               myCurrentIter, 
     I                               myThid )
C     /==========================================================\
C     | SUBROUTINE ATM_STORE_QLONGWAVE                           |
C     | o Routine for saving atmos. lower bdy longwave heat flux |
C     |   export to coupling layer.                              |
C     |==========================================================|
C     | This version interfaces to the MITgcm AIMPHYS package.   |
C     \==========================================================/

C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
C     == Global variables for coupling interface ==
#include "ATMCPL.h"
C     == AIMPHYS specific global data ==
#include "atparam0.h"
#include "atparam1.h"
      INTEGER NGP
      INTEGER NLON
      INTEGER NLAT
      INTEGER NLEV
      PARAMETER ( NLON=IX, NLAT=IL, NLEV=KX, NGP=NLON*NLAT )
#include "com_physvar.h"


C     == Routine arguments ==
C     myThid        - Thread number for this instance of the routine
C     myCurrentIter - Current timestep number
C     myCurrentTime - Current model time
      INTEGER myThid
CEndOfInterface

C     == Local variables ==
C     I,J,K,II - Loop counters
C     bi, bj
      INTEGER I,J,K,II
      INTEGER bi, bj

C     o Accumulate heat flux that will be exported to the coupling layer.
C     +ve into atmos., W/m^2.
      QlongwaveTime = QlongwaveTime + deltaTtracer
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO J=1,sNy
         DO I=1,sNx
          II = (sNx)*(J-1)+I
          Qlongwave(I,J,bi,bj) = 
     &    Qlongwave(I,J,bi,bj) + SLR(II,myThid)*deltaTtracer
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      RETURN
      END
