C $Header: $
C $Name:   $  

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE ATM_STORE_TAUY( myCurrentTime, 
     I                           myCurrentIter, 
     I                           myThid )
C     /==========================================================\
C     | SUBROUTINE ATM_STORE_TAUY                                |
C     | o Routine for saving atmos. lower boundary momentum flux |
C     |   for export to coupling layer.                          |
C     |==========================================================|
C     | This version interfaces to the MITgcm AIMPHYS package.   |
C     \==========================================================/

C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
C     == Global variables for coupling interface ==
#include "ATMCPL.h"
C     == AIMPHYS specific global data ==
#include "atparam0.h"
#include "atparam1.h"
      INTEGER NGP
      INTEGER NLON
      INTEGER NLAT
      INTEGER NLEV
      PARAMETER ( NLON=IX, NLAT=IL, NLEV=KX, NGP=NLON*NLAT )
#include "com_physvar.h"


C     == Routine arguments ==
C     myThid        - Thread number for this instance of the routine
C     myCurrentIter - Current timestep number
C     myCurrentTime - Current model time
      INTEGER myThid
CEndOfInterface

C     == Local variables ==
C     I,J,K,II - Loop counters
C     bi, bj
      INTEGER I,J,K,II
      INTEGER bi, bj

C     o Accumulate meridional momentum flux that will be exported to the 
C       coupling layer. Momentum flux is in N/m^2 with positive 
C       flux into the atmosphere. Momentum flux is in COMMON /FLUXES/,
C       com_physvar.h.
      tauYTime = tauYTime + deltaTtracer
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO J=1,sNy
         DO I=1,sNx
          II = (sNx)*(J-1)+I
          tauY(I,J,bi,bj) = 
     &    tauY(I,J,bi,bj) + VSTR(II,2,myThid)*deltaTtracer
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      RETURN
      END
