C $Header: /u/u0/gcmpack/models/MITgcmUV/pkg/gmredi/gmredi_diags.F,v 1.5 2001/03/06 18:01:07 jmc Exp $
C $Name:  $
cswdice modified for ice -- 25 Oct 01

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE ICE_DIAGS( myTime, myIter, myThid )
C     /==========================================================\
C     | SUBROUTINE ICE_DIAGS                                  |
C     | o Do ICE diagnostic output                           |
C     |==========================================================|
C     \==========================================================/
      IMPLICIT NONE

C     === Global variables ===
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
cswdice --- add --
#ifdef ALLOW_SEAICE
#include "ICE.h"
#include "ICE_DIAGS.h"
#endif
cswdice -- end add ---

C     == Routine arguments ==
C     myTime - Current time of simulation ( s )
C     myIter - Iteration number
C     myThid -  Number of this instance of INI_FORCING
      _RL     myTime
      INTEGER myIter
      INTEGER myThid
CEndOfInterface


C     == Local variables ==
      LOGICAL  DIFFERENT_MULTIPLE
      EXTERNAL DIFFERENT_MULTIPLE
      INTEGER bi, bj
      CHARACTER*(MAX_LEN_MBUF) suff

#ifdef ALLOW_SEAICE


#ifdef ALLOW_TIMEAVE

c set arrays to zero if first timestep
      IF ( myIter .EQ. nIter0 ) THEN
        CALL TIMEAVE_RESET(ICE_icemask_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_iceheight_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_snowheight_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_Tsrf_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_Tice1_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_Tice2_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_snow_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_qleft_AVE,   1,  bi, bj, myThid)
        CALL TIMEAVE_RESET(ICE_fresh_AVE,   1,  bi, bj, myThid)
        DO bj = myByLo(myThid), myByHi(myThid)
         DO bi = myBxLo(myThid), myBxHi(myThid)
           ICE_TimeAve(bi,bj)=0.
         ENDDO
        ENDDO
      ENDIF

C     Dump files and restart average computation if needed
      IF ( DIFFERENT_MULTIPLE(taveFreq,myTime,myTime-deltaTClock)
     &     ) THEN
         
C      Normalize by integrated time
       DO bj = myByLo(myThid), myByHi(myThid)
        DO bi = myBxLo(myThid), myBxHi(myThid)
         CALL TIMEAVE_NORMALIZ(ICE_icemask_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_iceheight_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_snowHeight_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_Tsrf_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_Tice1_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_Tice2_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_snow_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_qleft_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
         CALL TIMEAVE_NORMALIZ(ICE_fresh_AVE,ICE_timeave, 1 ,
     &                 bi,bj,myThid)
        ENDDO
       ENDDO
         
       WRITE(suff,'(I10.10)') myIter

       CALL WRITE_FLD_XY_RL('ICE_icemask-T.',suff,ICE_icemask_AVE,
     &     myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_iceheight-T.',suff,
     &     ICE_iceheight_AVE,myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_snowheight-T.',suff,
     &     ICE_snowheight_AVE,myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_Tsrf-T.',suff,
     &     ICE_Tsrf_AVE,myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_Tice1-T.',suff,
     &     ICE_Tice1_AVE,myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_Tice2-T.',suff,
     &     ICE_Tice2_AVE,myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_snow-T.',suff,
     &     ICE_snow_AVE,myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_Qleft-T.',suff,
     &     ICE_qleft_AVE,myIter,myThid)
       CALL WRITE_FLD_XY_RL('ICE_fresh-T.',suff,
     &     ICE_fresh_AVE,myIter,myThid)


         
C      Reset averages to zero
       DO bj = myByLo(myThid), myByHi(myThid)
        DO bi = myBxLo(myThid), myBxHi(myThid)
         CALL TIMEAVE_RESET(ICE_icemask_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_iceheight_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_snowheight_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_Tsrf_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_Tice1_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_Tice2_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_snow_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_qleft_AVE,1,bi,bj,myThid)
         CALL TIMEAVE_RESET(ICE_fresh_AVE,1,bi,bj,myThid)
         ICE_TimeAve(bi,bj)=0.
        ENDDO
       ENDDO
         
      ENDIF

#endif /* ALLOW_TIMEAVE */
      
#endif /* ALLOW_SEAICE */
      
      RETURN
      END
