C $Header: $
C $Name:   $

C $Header: /u/gcmpack/models/MITgcmUV/model/inc/CPP_OPTIONS.h,v 1.11 1999/07/28 16:21:38 adcroft Exp $
C

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for KPP mixing scheme


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude latitude circle FFT filter


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude prognostic variable shapiro filter code
C   Note - Shapiro filter of prognostics variables requires the
C          three steps "step forward including edges", filter, 
C          "communicate edges".
C           If the filtering code is included then we do not use the 
C          pipelined "step forward including edges" in S/R DYNAMICS. 
C          Instead the three steps are performed before DYNAMICS one 
C          after another in an un-pipelined fashion.






C o Include/exclude call to S/R FIND_RHO


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_ISOSLOPES


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/gcmpack/models/MITgcmUV/eesupp/inc/CPP_EEOPTIONS.h,v 1.12 1999/05/21 21:57:44 adcroft Exp $
C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control MPI based parallel processing



C--   Hack for switching in JAM based communication
C     JAM_WITH_TWO_PROCS_PER_NODE option is defined if we want two processes
C     per node. It goes with a different link-time library so be careful!



 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 



























C--   Control use of "double" precision constants.
C     Use D0 where it means Real*8*8 but not where it means Real*8*16



C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.





C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








CStartOfInterface
      SUBROUTINE CPL_SEND_OCN_ATMCONFIG
C     /==========================================================C     | SUBROUTINE CPL_SEND_OCN_ATMCONFIG                        |
C     | o Routine for sending atmos. config to ocean component.  |
C     |==========================================================|
C     | This version talks to the MITgcm general circulation     |
C     | model. For now just send atmosphere depths.              |
C     \==========================================================/
      IMPLICIT NONE

C     == Global variables ==
C $Header: $
C $Name: $

C     /==========================================================C     | ATMSIZE.h  Declare size of underlying computational grid |
C     |            for atmosphere component.                     |
C     \==========================================================/
C     Nx_atm  - No. points in X for the total domain.
C     Ny_atm  - No. points in Y for the total domain.
      INTEGER Nx_atm
      INTEGER Ny_atm
      PARAMETER (
     &           Nx_atm  = 128,
     &           Ny_atm  =  64)
C $Header: $
C $Name:   $

C     /==========================================================C     | ATMVARS.h Declare arrays for holding data on the atmos.  |
C     |           grid. Arrays may need adding or removing       |
C     |           different couplings.                           |
C     \==========================================================/
C     AtmDepths_atm  - Atmos. depths on atmos. grid
C     OcnDepths_ocn  - Ocean depth on atmos. grid.
C     SST_atm        - Sea surface temperature on atmos. grid ( oC ).
C     HeatFlux_atm   - Heat flux on atmos. grid ( Wm^-2, positive into
C                      atmosphere).
      COMMON /ATMVARS_R/
     &       AtmDepths_atm, OcnDepths_atm,
     &       SST_atm, HeatFlux_atm, FWFlux_atm,
     &       TauX_atm, TauY_atm,
     &       uVelGround_atm, vVelGround_atm,
     &       qLatent_atm, qSensible_atm,
     &       qLongwave_atm, qShortwave_atm
      Real*8 AtmDepths_atm  (Nx_atm,Ny_atm)
      Real*8 OcnDepths_atm  (Nx_atm,Ny_atm)
      Real*8 SST_atm        (Nx_atm,Ny_atm)
      Real*8 HeatFlux_atm   (Nx_atm,Ny_atm)
      Real*8 FWFlux_atm     (Nx_atm,Ny_atm)
      Real*8 TauX_atm       (Nx_atm,Ny_atm)
      Real*8 TauY_atm       (Nx_atm,Ny_atm)
      Real*8 uVelGround_atm (Nx_atm,Ny_atm)
      Real*8 vVelGround_atm (Nx_atm,Ny_atm)
      Real*8 qLatent_atm    (Nx_atm,Ny_atm)
      Real*8 qSensible_atm  (Nx_atm,Ny_atm)
      Real*8 qShortwave_atm (Nx_atm,Ny_atm)
      Real*8 qLongwave_atm  (Nx_atm,Ny_atm)
C $Header: $
C $Name: $

C     /==========================================================C     | ATMIDS.h Declare symbolic constants holding strings that |
C     |          are used to identify this component and the     |
C     |          fields it exchanges with other components.      |
C     \==========================================================/
      CHARACTER*(8)  atmCompName 
      PARAMETER( atmCompName          = 'UV-Atmos'        )
      CHARACTER*(10) atmDepthName
      PARAMETER( atmDepthName         = 'ATM Depths'      )
      CHARACTER*(7)  atmSSTName
      PARAMETER( atmSSTName           = 'ATM SST'         )
      CHARACTER*(8)  atmTauXName
      PARAMETER( atmTauXName          = 'ATM tauX'        )
      CHARACTER*(8)  atmTauYName
      PARAMETER( atmTauYName          = 'ATM tauY'        )
      CHARACTER*(12) atmHeatFluxName
      PARAMETER( atmHeatFluxName      = 'ATM HeatFlux'    )
      CHARACTER*(10) atmFWFluxName
      PARAMETER( atmFWFluxName        = 'ATM FWFlux'      )
      CHARACTER*(13) atmQlongwaveName
      PARAMETER( atmQlongwaveName     = 'ATM Qlongwave'   )
      CHARACTER*(14) atmQshortwaveName
      PARAMETER( atmQshortwaveName    = 'ATM Qshortwave'  )
      CHARACTER*(11) atmQlatentName
      PARAMETER( atmQlatentName       = 'ATM Qlatent'     )
      CHARACTER*(13) atmQsensibleName
      PARAMETER( atmQsensibleName     = 'ATM Qsensible'   )
      CHARACTER*(14) atmUvelgroundName
      PARAMETER( atmUvelgroundName    = 'ATM Uvelground'  )
      CHARACTER*(14) atmVvelgroundName
      PARAMETER( atmVvelgroundName    = 'ATM Vvelground'  )
C $Header: $
C $Name: $

C     /==========================================================C     | OCN_SIZE.h Declare size of underlying computational grid |
C     |            for ocean component.                          |
C     \==========================================================/
C     Nx_ocn  - No. points in X for the total domain.
C     Ny_ocn  - No. points in Y for the total domain.
      INTEGER Nx_ocn
      INTEGER Ny_ocn
      PARAMETER (
     &           Nx_ocn  = 128,
     &           Ny_ocn  =  64)
C $Header: $
C $Name:   $

C     /==========================================================C     | OCNVARS.h Declare arrays for holding data on the ocean   |
C     |           grid. Arrays may need adding or removing       |
C     |           different couplings.                           |
C     \==========================================================/
C     OcnDepths_ocn  - Ocean bathymetry on ocean grid ( m  )
C     AtmDepths_ocn  - Atmos. depth on ocean grid     ( Pa )
C     SST_ocn        - Sea surface temperature on ocean grid ( oC ).
C     HeatFlux_ocn   - Heat flux on ocean grid ( Wm^-2, positive out
C                      of ocean).
C     FWFlux_ocn     - Fresh water flux on ocean grid ( m/s, positive out
C                      of ocean).
C     TauX_ocn       - Zonal momentum flux on ocean grid ( N/m^2, positive
C                      out of the ocean. Positive momentum == westward
C                      flow.)
C     TauY_ocn       - Meridional momentum flux on ocean grid ( N/m^2, positive
C                      out of the ocean. Positive momentum == northward
C                      flow.)
      COMMON /OCNVARS_R/
     &       OcnDepths_ocn, AtmDepths_ocn,
     &       SST_ocn, HeatFlux_ocn, FWFlux_ocn,
     &       TauX_ocn, TauY_ocn,
     &       uVelGround_ocn, vVelGround_ocn,
     &       qLatent_ocn, qSensible_ocn,
     &       qLongwave_ocn, qShortwave_ocn
      Real*8 OcnDepths_ocn  (Nx_ocn,Ny_ocn)
      Real*8 AtmDepths_ocn  (Nx_ocn,Ny_ocn)
      Real*8 SST_ocn        (Nx_ocn,Ny_ocn)
      Real*8 HeatFlux_ocn   (Nx_ocn,Ny_ocn)
      Real*8 FWFlux_ocn     (Nx_ocn,Ny_ocn)
      Real*8 TauX_ocn       (Nx_ocn,Ny_ocn)
      Real*8 TauY_ocn       (Nx_ocn,Ny_ocn)
      Real*8 uVelGround_ocn (Nx_ocn,Ny_ocn)
      Real*8 vVelGround_ocn (Nx_ocn,Ny_ocn)
      Real*8 qLatent_ocn    (Nx_ocn,Ny_ocn)
      Real*8 qSensible_ocn  (Nx_ocn,Ny_ocn)
      Real*8 qLongwave_ocn  (Nx_ocn,Ny_ocn)
      Real*8 qShortwave_ocn (Nx_ocn,Ny_ocn)
C $Header: $
C $Name: $

C     /==========================================================C     | OCNIDS.h Declare symbolic constants holding strings that |
C     |          are used to identify this component and the     |
C     |          fields it exchanges with other components.      |
C     \==========================================================/
      CHARACTER*(*) ocnCompName 
      PARAMETER( ocnCompName         = 'UV-Ocean'       )
      CHARACTER*(*) ocnBathyName
      PARAMETER( ocnBathyName        = 'OCN Bathymetry' )
      CHARACTER*(*) ocnSSTName
      PARAMETER( ocnSSTName          = 'OCN SST'        )
      CHARACTER*(*) ocnTauXName
      PARAMETER( ocnTauXName         = 'OCN tauX'       )
      CHARACTER*(*) ocnTauYName
      PARAMETER( ocnTauYName         = 'OCN tauY'       )
      CHARACTER*(*) ocnHeatFluxName
      PARAMETER( ocnHeatFluxName     = 'OCN HeatFlux'   )
      CHARACTER*(*) ocnFWFluxName
      PARAMETER( ocnFWFluxName       = 'OCN FWFlux'     )

      CHARACTER*(*) ocnuVelGroundName
      PARAMETER( ocnuVelGroundName   = 'OCN uVelGround'     )
      CHARACTER*(*) ocnvVelGroundName
      PARAMETER( ocnvVelGroundName   = 'OCN vVelGround'     )
      CHARACTER*(*) ocnqLatentName
      PARAMETER( ocnqLatentName      = 'OCN qLatent'     )
      CHARACTER*(*) ocnqShortwaveName
      PARAMETER( ocnqShortwaveName   = 'OCN qShortwave'     )
      CHARACTER*(*) ocnqLongwaveName
      PARAMETER( ocnqLongwaveName    = 'OCN qLongwave'     )
      CHARACTER*(*) ocnqSensibleName
      PARAMETER( ocnqSensibleName    = 'OCN qSensible'     )

C     == Routine arguments ==

C     == Local variables ==

CEndOfInterface

C     Map atmos. depth map onto ocean grid
      CALL ATM_TO_OCN_MAPXYR8(
     I     Nx_atm, Ny_atm, 
     I     AtmDepths_atm, 
     I     Nx_ocn, Ny_ocn,
     O     AtmDepths_ocn)

C     Send atmos. config to ocean component
      CALL COUPSEND_R8TILES( ocnCompName, atmDepthName, Nx_ocn, Ny_ocn, 
     &                       AtmDepths_ocn )

      RETURN
      END
