C $Header: $
C $Name:   $

C $Header: /u/gcmpack/models/MITgcmUV/model/inc/CPP_OPTIONS.h,v 1.11 1999/07/28 16:21:38 adcroft Exp $
C

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for KPP mixing scheme


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude latitude circle FFT filter


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude prognostic variable shapiro filter code
C   Note - Shapiro filter of prognostics variables requires the
C          three steps "step forward including edges", filter, 
C          "communicate edges".
C           If the filtering code is included then we do not use the 
C          pipelined "step forward including edges" in S/R DYNAMICS. 
C          Instead the three steps are performed before DYNAMICS one 
C          after another in an un-pipelined fashion.






C o Include/exclude call to S/R FIND_RHO


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_ISOSLOPES


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/gcmpack/models/MITgcmUV/eesupp/inc/CPP_EEOPTIONS.h,v 1.12 1999/05/21 21:57:44 adcroft Exp $
C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control MPI based parallel processing



C--   Hack for switching in JAM based communication
C     JAM_WITH_TWO_PROCS_PER_NODE option is defined if we want two processes
C     per node. It goes with a different link-time library so be careful!



 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 



























C--   Control use of "double" precision constants.
C     Use D0 where it means Real*8*8 but not where it means Real*8*16



C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.





C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








CStartOfInterface
      SUBROUTINE OCN_TO_ATM_MAPXYR8( 
     I           oNx, oNy,
     I           fld_ocn, 
     I           aNx, aNy,
     O           fld_atm )
C     /==========================================================C     | SUBROUTINE OCN_TO_ATM_MAPXYR8                            |
C     | o Maps ocean field to atmos. field for XY 64-bit float   |
C     |   field.                                                 |
C     \==========================================================/
      IMPLICIT NONE

C     == Routine arguments ==
C     fld_atm - Atmos. grid field (ocean field will be mapped to this
C               grid).
C     aNx     - Atmos. grid global extent in X
C     aNy     - Atmos. grid global extent in Y
C     fld_ocn - Ocean grid field
C     oNx     - Ocean grid global extent in X
C     oNy     - Ocean grid global extent in Y
      INTEGER aNx
      INTEGER aNy
      Real*8 fld_atm(aNx, aNy)
      INTEGER oNx
      INTEGER oNy
      Real*8 fld_ocn(oNx, oNy)
CEndOfInterface

C     == Local variables ==
      INTEGER I,J

C     Set to zero's everywhere
      DO J=1,aNy
       DO I=1,aNx
        fld_atm(I,J)=0.
       ENDDO
      ENDDO
C     Now copy intersection of _atm and _ocn into
C     _atm.
      DO J=1,MIN(aNy,oNy)
       DO I=1,MIN(aNx,oNx)
        fld_atm(I,J)=fld_ocn(I,J)
       ENDDO
      ENDDO

      RETURN
      END
