! $Header: $
! $Name:   $
      MODULE MITGCM_ORG_A2O_ESMF_DRIVER

!     =============================================================================
!     | MOD MITGCM_ORG_A2O_ESMF_DRIVER: A2O coupler for MITgcm ATM to MITgcm OCN
!     =============================================================================
!     | A2O coupler for MITgcm ATM to MITgcm OCN
!     | Maps field in MITgcm ATM export state to fields in MITgcm OCN import state.
!     | Interfaces are:
!     | 1. ESMF_SET_SERVICES: Simply registers INIT and RUN methods.
!     | 2.       DRIVER_INIT: Expects an import state that is an MITgcm ATM export
!     |                       state and an export state that is an MITgcm OCN import
!     |                       state.
!     | 3.        DRIVER_RUN: Expects an import state that is an MITgcm ATM export
!     |                       state and an export state that is an MITgcm OCN import
!     |                       state.
!     =============================================================================

!     == Global module data ==
!     ESMF_MOD              -- ESMF library types, procedures and signatures.
!     MITGCM_ORG_ESMF_UTILS -- Utilities and types used for easing development of MITgcm
!                           -- to ESMF bindings.
!     MITGCM_ORG_ATM_ESMF_EXPORTS -- Defines export field names for an MITgcm ATM component.
!     MITGCM_ORG_OCN_ESMF_IMPORTS -- Defines import field names for an MITgcm OCN component.
      USE ESMF_MOD
      USE MITGCM_ORG_ESMF_UTILS
      USE MITGCM_ORG_OCN_ESMF_IMPORTS
      USE MITGCM_ORG_ATM_ESMF_EXPORTS

      IMPLICIT NONE

      PRIVATE
      PUBLIC ESMF_SET_SERVICES

      CONTAINS

      SUBROUTINE ESMF_SET_SERVICES( gC, esmfRC )
!     ====================================================================================
!     | S/R ESMF_SET_SERVICES: Register service handlers for A2O coupler.
!     ====================================================================================

!     == Routine arguments ==
      TYPE(ESMF_CplComp)  :: gC
      INTEGER             :: esmfRC

!     Register init handler
      CALL ESMF_CplCompSetEntryPoint( gC, ESMF_SETINIT,
     &            driver_init, ESMF_SINGLEPHASE, esmfRC )

!     Register run handler
      CALL ESMF_CplCompSetEntryPoint( gC, ESMF_SETRUN,
     &            driver_run, ESMF_SINGLEPHASE, esmfRC )

      RETURN
      END SUBROUTINE

      SUBROUTINE DRIVER_INIT( gC, iState, eState, clock, esmfRC )

!     =============================================================
!     = S/R DRIVER_INIT: A2O coupler initialization routine.
!     =============================================================

!     == Global variables  ==
!     Uses module static data EXPORT_NAMES

!     == Routine arguments ==
      TYPE(ESMF_CplComp)  :: gC
      TYPE(ESMF_State)    :: iState
      TYPE(ESMF_State)    :: eState
      TYPE(ESMF_Clock)    :: clock
      INTEGER             :: esmfRC
  
      RETURN
      END SUBROUTINE

      SUBROUTINE DRIVER_RUN(  gC, iState, eState, clock, esmfRC )

!     =============================================================
!     | S/R DRIVER_RUN: Map ATM export state to OCN import state.
!     =============================================================
!     | During run A2O coupler executes mappig of fields in its import
!     | state to fields in its export state. The mapping operator for
!     | this configuration is the indentity matrix.
!     =============================================================

!     == Routine arguments ==
      TYPE(ESMF_CplComp)  :: gC
      TYPE(ESMF_State)    :: iState
      TYPE(ESMF_State)    :: eState
      TYPE(ESMF_Clock)    :: clock
      INTEGER             :: esmfRC

!     == Local variables ==
!     fSp  :: Composite field, array, data pointer object
!     I, J :: Composite field, array, data pointer object
      TYPE(FIARDA) :: fSp
      INTEGER      :: Ix, Jy
      INTEGER I
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: srcPtr
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: trgPtr

      WRITE(0,*) 'Executing A2O: Mapping import (ATM exports) to export (OCN imports)'

      DO I=1,MAX_IMPORTS
       WRITE (0,*) 'Transfering import field  "',TRIM(export_names(I)),
     &                     '" to export field "',TRIM(import_names(I)),'"'
       CALL STATE_GET_FADP( iState, export_names(I), srcPtr, fSpec=fSp )
       CALL STATE_GET_FADP( eState, import_names(I), trgPtr, fSpec=fSp )
       DO Jy=fSp%LoC(2),fSp%HiC(2)
        DO Ix=fSp%LoC(1),fSp%HiC(1)
         trgPtr(Ix,Jy) = srcPtr(Ix,Jy)
        ENDDO
       ENDDO
       CALL ESMF_FieldHalo(fSp%fRef , rc=esmfRC)
      ENDDO

      RETURN
      END SUBROUTINE

      END MODULE
