#!/bin/csh -f
#
set OPATH = ( ../ocn/src/tutorial_examples/global_ocean.128x64x15/run/mmout )
set APATH = ( ../atm/src/tutorial_examples/aim_5l.LatLon/run/mmout          )
set AINC  = ( ../atm/src/tutorial_examples/aim_5l.LatLon/run                )
set OINC  = ( ../ocn/src/tutorial_examples/global_ocean.128x64x15/run       )

# Portland Group compiler options (for when ESMF library builds OK against this)
set comp     = /usr/local/pkg/mpi/mpi-1.2.4..8a-gm-1.5/pgi/bin/mpif90
set compopts = ( -r8 -Mfixed -Mextend -byteswapio )
set complibs = ( )

# Lahey compiler options (ESMF_1_0_4 builds OK against this on Redhat)
set comp     = /usr/local/pkg/mpi/mpich-1.2.5..10/lahey/bin/mpif77
set compopts = ( --dbl -O0 --fix --lst --xref --wide -sav                   )
set complibs = ( -L/usr/local/pkg/ESMF/ESMF_1_0_4/mpich-1.2.5..10/lahey/lib/libO/Linux.lahey.32.default -lesmf )
set compinc  = ( -I/usr/local/pkg/ESMF/ESMF_1_0_4/mpich-1.2.5..10/lahey/mod/modO/Linux.lahey.32.default        )

set includes = ( -I${APATH} -I${OPATH} -I${AINC}  -I${OINC} ${compinc}      )
set libs     = ( -L${APATH} -L${OPATH} -lmitgcm_org_ocn -lmitgcm_org_atm -lmitgcmrtl ${complibs} -lesmf )
set src      = ( `find . -name '*.F'` )

$comp $compopts -c ./utils/mitgcm_org_esmf_utils.F     $includes $libs
$comp $compopts -c ./ocn/mitgcm_org_ocn_esmf_exports.F $includes $libs
$comp $compopts -c ./ocn/mitgcm_org_ocn_esmf_imports.F $includes $libs
$comp $compopts -c ./atm/mitgcm_org_atm_esmf_exports.F $includes $libs
$comp $compopts -c ./atm/mitgcm_org_atm_esmf_imports.F $includes $libs
$comp $compopts -c ./ocn/mitgcm_org_ocn_esmf_gs.F      $includes $libs
$comp $compopts -c ./ocn/mitgcm_org_ocn_esmf_exch.F    $includes $libs
$comp $compopts -c ./ocn/mitgcm_org_ocn_esmf_driver.F  $includes $libs
$comp $compopts -c ./atm/mitgcm_org_atm_esmf_driver.F  $includes $libs
$comp $compopts -c ./o2a/mitgcm_org_o2a_esmf_driver.F  $includes $libs
$comp $compopts -c ./a2o/mitgcm_org_a2o_esmf_driver.F  $includes $libs
