C $Header: $
C $Name:   $

#define _TRACE(a) a

      PROGRAM MAIN

C     ESMF base library
      USE ESMF_MOD

C     Used for direct execution without ESMF superstructure abstraction
      USE MITGCM_ORG_OCN, ONLY: OCN_INIT => DRIVER_INIT
      USE MITGCM_ORG_OCN, ONLY: OCN_RUN  => DRIVER_RUN
      USE MITGCM_ORG_ATM, ONLY: ATM_INIT => DRIVER_INIT
      USE MITGCM_ORG_ATM, ONLY: ATM_RUN  => DRIVER_RUN

C     Used for execution through standard ESMF component interfaces
      USE MITGCM_ORG_OCN_ESMF_DRIVER, ONLY: OCN4ESMF_SETSERVICES => ESMF_SET_SERVICES
      USE MITGCM_ORG_ATM_ESMF_DRIVER, ONLY: ATM4ESMF_SETSERVICES => ESMF_SET_SERVICES
      USE MITGCM_ORG_A2O_ESMF_DRIVER, ONLY: A2O4ESMF_SETSERVICES => ESMF_SET_SERVICES
      USE MITGCM_ORG_O2A_ESMF_DRIVER, ONLY: O2A4ESMF_SETSERVICES => ESMF_SET_SERVICES

      IMPLICIT NONE

C !DESCRIPTION:
C     *==========================================================*
C     | PROGRAM MAIN                                            
C     | o MAIN wrapper for MITgcm UV implementation.            
C     *==========================================================*
C     | MAIN controls the "execution environment".               
C     | Its main functions are                                   
C     | 1. call procedure EEBOOT to perform execution environment
C     |    initialisation.                                       
C     | 2. call procedure THE_MODEL_MAIN once for each concurrent
C     |    thread. THE_MODEL_MAIN is the user supplied top-level 
C     |    routine.                                              
C     | 3. call procedure EEDIE to perform execution environment 
C     |    shutdown.                                             
C     *==========================================================*

C     Temporary code for passing export and import states
#include "SIZE.h"
      real*8 atm_HeatFlux(   1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_TauX(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_TauY(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_Qlatent(    1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_Qsensible(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_Qlongwave(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_Qshortwave( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_uVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_vVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_FWFlux(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 atm_Hatm(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 ocn_Hocn(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      real*8 ocn_SSTocn(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
C     End temporary code for passing export and import states

C     atmStartStep, atmStopStep :: These provide start and stop steps for each 
C     ocnStartStep, ocnStopStep :: run cycle of the gridded components.
C     iCpl                      :: Loop counter for coupled driving loop.
C     esmfRC                    :: Return code for ESMF functions.
C     I,J,K                     :: Loop counters
      INTEGER atmStartStep, atmStopStep
      INTEGER ocnStartStep, ocnStopStep
      INTEGER iCpl
      INTEGER esmfRC
      INTEGER I, J, K

C     ESMF variables
C     o top (app driver)
      TYPE(ESMF_DELayout)     :: topLayout
      INTEGER                 :: totalDECount
      TYPE(ESMF_Clock)        :: topClock
      TYPE(ESMF_Time)         :: topStart, topStop
      TYPE(ESMF_TimeInterval) :: timeStep
      TYPE(ESMF_Calendar)     :: ESMF_360DayCalendar
C     o ocn (gridded)
      INTEGER, DIMENSION(:), ALLOCATABLE :: ocnDEList
      INTEGER                        :: ocnDECount, ocnDEBase
      TYPE(ESMF_DELayout)            :: ocnLayout
      TYPE(ESMF_GridComp)            :: ocnComp
      TYPE(ESMF_State)               :: ocnImport
      TYPE(ESMF_State)               :: ocnExport
C     o atm (gridded)
      INTEGER, DIMENSION(:), ALLOCATABLE :: atmDEList
      INTEGER                        :: atmDECount, atmDEBase
      TYPE(ESMF_DELayout)            :: atmLayout
      TYPE(ESMF_GridComp)            :: atmComp
      TYPE(ESMF_State)               :: atmImport
      TYPE(ESMF_State)               :: atmExport
C     o o2a (coupler)
      INTEGER, DIMENSION(:), ALLOCATABLE :: o2aDEList
      INTEGER                        :: o2aDECount, o2aDEBase
      TYPE(ESMF_DELayout)            :: o2aLayout
      TYPE(ESMF_CplComp)             :: o2aComp
C     o a2o (coupler)
      INTEGER, DIMENSION(:), ALLOCATABLE :: a2oDEList
      INTEGER                        :: a2oDECount, a2oDEBase
      TYPE(ESMF_DELayout)            :: a2oLayout
      TYPE(ESMF_CplComp)             :: a2oComp

C     MPI diagnostics for debugging and checking only
      INTEGER top_pgroup
      INTEGER mpiRC
      INTEGER mpiGSize

#include "mpif.h"

      CALL ESMF_Initialize(esmfRC)
      _TRACE(WRITE(0,*) 'ESMF Init called')

C     Create the top layout and get total number of DEs
      topLayout = ESMF_DELayoutCreate(rc=esmfRC)
      CALL ESMF_DELayoutGetNumDEs( topLayout, totalDECount, rc=esmfRC )

C     Set component DE counts to use full set.
      ocnDECount = totalDECount
      ocnDEBase  = 0
      atmDECount = totalDECount
      atmDEBase  = 0
      o2aDECount = totalDECount
      o2aDEBase  = 0
      a2oDECount = totalDECount
      a2oDEBase  = 0

C     Now create gridded components
C     1. Create DE lists
      ALLOCATE( ocnDEList(ocnDECount) )
      DO I=1,ocnDECount
       ocnDEList(I) = I+ocnDEBase-1
      ENDDO
      ALLOCATE( atmDEList(atmDECount) )
      DO I=1,atmDECount
       atmDEList(I) = I+atmDEBase-1
      ENDDO
      ALLOCATE( o2aDEList(o2aDECount) )
      DO I=1,o2aDECount
       o2aDEList(I) = I+o2aDEBase-1
      ENDDO
      ALLOCATE( a2oDEList(a2oDECount) )
      DO I=1,a2oDECount
       a2oDEList(I) = I+a2oDEBase-1
      ENDDO
C     2. Create layouts using the DE lists
      ocnLayout = ESMF_DELayoutCreate( ocnDEList, 2,
     &            (/ 1, ocnDECount/), (/0, 0/),
     &            rc=esmfRC)
      atmLayout = ESMF_DELayoutCreate( atmDEList, 2,
     &            (/ 1, atmDECount/), (/0, 0/),
     &            rc=esmfRC)
      o2aLayout = ESMF_DELayoutCreate( o2aDEList, 2,
     &            (/ 1, o2aDECount/), (/0, 0/),
     &            rc=esmfRC)
      a2oLayout = ESMF_DELayoutCreate( a2oDEList, 2,
     &            (/ 1, a2oDECount/), (/0, 0/),
     &            rc=esmfRC)
C     3. Create components for ocn, atm, o2a, a2o
      ocnComp   = ESMF_GridCompCreate('ocn Component',layout=ocnLayout,rc=esmfRC)
      atmComp   = ESMF_GridCompCreate('atm Component',layout=atmLayout,rc=esmfRC)
      o2aComp   = ESMF_CplCompCreate( 'o2a Component',layout=o2aLayout,rc=esmfRC)
      a2oComp   = ESMF_CplCompCreate( 'a2o Component',layout=a2oLayout,rc=esmfRC)

C     Register service handlers for each component
      CALL ESMF_GridCompSetServices( ocnComp, ocn4esmf_setservices, esmfRC)
      CALL ESMF_GridCompSetServices( atmComp, atm4esmf_setservices, esmfRC)
      CALL ESMF_CplCompSetServices(  a2oComp, a2o4esmf_setservices, esmfRC)
      CALL ESMF_CplCompSetServices(  o2aComp, o2a4esmf_setservices, esmfRC)

C     Do the constructor methods for the import and exports
      ocnImport = ESMF_StateCreate("ocn import", ESMF_STATEIMPORT, "ocn Component", rc=esmfRC )
      ocnExport = ESMF_StateCreate("ocn export", ESMF_STATEEXPORT, "ocn Component", rc=esmfRC )
      atmImport = ESMF_StateCreate("atm import", ESMF_STATEIMPORT, "atm Component", rc=esmfRC )
      atmExport = ESMF_StateCreate("atm export", ESMF_STATEEXPORT, "atm Component", rc=esmfRC )

C     Do the constructor methods for the clock object
      CALL ESMF_CalendarSet(ESMF_360DayCalendar, ESMF_CAL_360DAY, esmfRC)
      CALL ESMF_TimeIntervalSet(timeStep, d=1, rc=esmfRC)
      CALL ESMF_TimeSet(topStart, yr=0, mm=0, dd=0,
     &                          calendar=esmf_360dayCalendar, rc=esmfRC)
      CALL ESMF_TimeSet(topStop , yr=0, mm=0, dd=9,
     &                          calendar=esmf_360dayCalendar, rc=esmfRC)
      topClock = ESMF_ClockCreate("360 Day Clock", timeStep, topStart,
     &                                   topStop, rc=ESMFrc)

C     Call the init method for each component
      CALL ESMF_GridCompInitialize( ocnComp, 
     &                              ocnImport,
     &                              ocnExport,
     &                              topClock,
     &                              esmfRC )
      CALL ESMF_GridCompInitialize( atmComp, 
     &                              atmImport,
     &                              atmExport,
     &                              topClock,
     &                              esmfRC )
      CALL ESMF_CplCompInitialize(  a2oComp, 
     &                              atmExport,
     &                              ocnImport,
     &                              topClock,
     &                              esmfRC )
      CALL ESMF_CplCompInitialize(  o2aComp, 
     &                              ocnExport,
     &                              atmImport,
     &                              topClock,
     &                              esmfRC )

C     Iterate over the run methods for each component
      DO iCpl=1,10
       CALL ESMF_GridCompRun( ocnComp, 
     &                        ocnImport, ocnExport, topClock,
     &                        esmfRC )
       CALL ESMF_GridCompRun( atmComp, 
     &                        atmImport, atmExport, topClock,
     &                        esmfRC )
       CALL ESMF_CplCompRun(  a2oComp, 
     &                        atmExport, ocnImport, topClock,
     &                        esmfRC )
       CALL ESMF_CplCompRun(  o2aComp, 
     &                        ocnExport, atmImport, topClock,
     &                        esmfRC )
       CALL ESMF_ClockAdvance(topClock, rc=esmfRC)
       IF ( ESMF_ClockIsStopTime(topClock, esmfRC )  ) THEN
        WRITE(0,*) ' I am DONE'
       ENDIF
      ENDDO
     
      CALL ESMF_Finalize(esmfRC)

      END
