! $Header: /u/u0/gcmpack/MITgcm/eesupp/src/global_sum.F,v 1.10 2001/09/21 03:54:35 cnh Exp $
! $Name:  $
      MODULE MITGCM_ORG_ESMF_EXCH

      USE ESMF_MOD
      USE MITGCM_ORG_ESMF_UTILS

      IMPLICIT NONE

!     Static halo buffer(s) that interface to ESMF workspace
      TYPE(FIARDA)   :: hB
      SAVE hB
!     Temp for debugging
      INTEGER        :: cMyDEx, cMyDEy
      SAVE cMyDEx, cMyDEy

      CONTAINS
      SUBROUTINE EXCH_E_INIT( gC, nx, ny, nr, OL )

!     Create variables that will be used to do MITgcm EXCH through ESMF as follows
!     o a two dimensional field with same halo, extents and layout as the
!       component primary layout.
!     o pointer to the data in the array within the field
!     o lower and upper bound indices

!     Routine arguments
      TYPE(ESMF_GridComp) :: gC
      INTEGER             :: nx, ny, nr, OL

!     Local variables
      TYPE(ESMF_DELayout)  :: cLayout
      INTEGER              :: esmfRC
      INTEGER              :: gridCount(2)
      REAL(ESMF_KIND_R8)   :: gridLo(2), gridHi(2)
      TYPE(ESMF_Logical)   :: periodic(2)
      INTEGER              :: haloW
      TYPE(ESMF_Grid)      :: gridRef
      TYPE(ESMF_ArraySpec) :: arraySpec
      TYPE(ESMF_Field)     :: fieldRef
      TYPE(ESMF_Array)     :: arrayRef, outArray
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: thePtr
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: thePtr4
      REAL(KIND=ESMF_KIND_R8) :: sum
      TYPE(ESMF_AxisIndex), dimension(ESMF_MAXGRIDDIM) :: indexc
      TYPE(ESMF_AxisIndex), dimension(ESMF_MAXGRIDDIM) :: indext
      INTEGER                 :: I


!     Create work field used in global sum
      CALL ESMF_GridCompGet( gC, layout=cLayout, rc=esmfRC             )
      CALL ESMF_DELayoutGetDEPosition( cLayout, cMyDEx, cMyDEy, esmfRC )
      gridCount(1) = nx
      gridCount(2) = ny
      gridLo(1)    = 0.
      gridLo(2)    = 0.
      gridHi(1)    = 1.
      gridHi(2)    = 1.
      haloW        = OL
      periodic(1)  = ESMF_TRUE
      periodic(2)  = ESMF_TRUE
      gridRef      = ESMF_GridCreate(2,
     &               counts=gridCount,
     &               min=gridLo,
     &               max=gridHi,
     &               layout=cLayout,
     &               horz_gridtype=ESMF_GridType_XY,
     &               horz_stagger=ESMF_GridStagger_A,
     &               horz_coord_system=ESMF_CoordSystem_Cartesian,
     &               periodic=periodic,
     &               name="ocn exch grid",
     &               rc=esmfRC)
      CALL ESMF_ArraySpecInit( arraySpec, rank=2, type=ESMF_DATA_REAL,
     &                         kind=ESMF_R8)
      hB%fRef = ESMF_FieldCreate( gridRef, arraySpec,
     &            relloc=ESMF_CELL_CENTER,
     &            haloWidth=haloW,
     &            name="ocn exch field",
     &            rc=esmfRC)

!     Bits needed for the sum
      CALL ESMF_FieldGetData( hB%fRef, hB%aRef, esmfRC )
      CALL ESMF_ArrayGetData( hB%aRef, thePtr, ESMF_DATA_REF, esmfRC )
      hB%dPR8 => thePtr
      CALL ESMF_ArrayGetAxisIndex( hB%aRef,
     O                             compindex=indexc,
     O                             totalindex=indext,
     O                                     rc=esmfRC)
       hB%nDims  = 2
!      Interior domain extents
       hB%LoC(1) = indexc(1)%min
       hB%LoC(2) = indexc(2)%min
       hB%HiC(1) = indexc(1)%max
       hB%HiC(2) = indexc(2)%max
!      Total domain extents
       hB%LoT(1) = indext(1)%min
       hB%LoT(2) = indext(2)%min
       hB%HiT(1) = indext(1)%max
       hB%HiT(2) = indext(2)%max
!      Inferred halo width and tile interior size
       hB%hW     = hB%HiT(1) - hB%HiC(1)
       hB%nI(1)  = hB%HiC(1) - hB%LoC(1)+1
       hB%nI(2)  = hB%HiC(2) - hB%LoC(2)+1


      RETURN
      END SUBROUTINE
      SUBROUTINE EXCH_E_R8( arr, iLo, iHi, jLo, jHi, OL, nr  )
      
!     == Routine arguments ==
      INTEGER  :: iLo, iHi, jLo, jHi, OL, nr
      REAL*8   :: arr(iLo-OL:iHi+OL,jLo-OL:jHi+OL,nr )
      

!     == Local variables ==
      INTEGER  :: I,J,K
      INTEGER              :: esmfRC
      REAL*8, ALLOCATABLE, DIMENSION(:,:)  :: wEdge, eEdge, tEdge

!     if ( cMyDEy .EQ. 3 ) then
!      write(0,*) ' hB%LoC(1), hB%LoC(2) = ', hB%LoC(1), hB%LoC(2)
!     endif
      DO K=1,nr
!      Put interior in buffer and halo
       hB%dPR8(:,:) = 0.
       DO J=jLo,jHi
        DO I=iLo,iHi
         hB%dPR8(hB%LoC(1)+I-1,hB%LoC(2)+J-1)=arr(I,J,K)
        ENDDO
       ENDDO
!      if ( cMyDEy .EQ. 3 ) then
!       WRITE(0,*) ' dP SIZE   = ', LBOUND(hB%dPR8), UBOUND(hB%dPR8)
!       WRITE(0,*) ' dP(131:134,4) - before = ', hB%dPR8(131:134,4)
!      endif
!      if ( cMyDEy .EQ. 3 ) then
!       WRITE(0,*) ' dP SIZE   = ', LBOUND(hB%dPR8), UBOUND(hB%dPR8)
!       WRITE(0,*) ' dP(1:4,4) - before = ', hB%dPR8(1:4,4)
!      endif
       CALL ESMF_FieldHalo( hB%fRef )
!      Correct for east-west inversion
       ALLOCATE(wEdge(hB%hW,hB%HiT(2)))
       ALLOCATE(eEdge(hB%hW,hB%HiT(2)))
       wEdge=hB%dPR8(1:hB%hW,1:hB%HiT(2))
       eEdge=hB%dPR8(hB%HiC(1)+1:hB%HiC(1)+hB%hW,1:hB%HiT(2))
       hB%dPR8(1:hB%hW,1:hB%HiT(2))=eEdge
       hB%dPR8(hB%HiC(1)+1:hB%HiC(1)+hB%hW,1:hB%HiT(2))=wEdge
       DEALLOCATE(wEdge)
       DEALLOCATE(eEdge)
!      if ( cMyDEy .EQ. 3 ) then
!       WRITE(0,*) ' dP SIZE   = ', LBOUND(hB%dPR8), UBOUND(hB%dPR8)
!       WRITE(0,*) ' dP(131:134,4) - after  = ', hB%dPR8(131:134,4)
!      endif
!      if ( cMyDEy .EQ. 3 ) then
!       WRITE(0,*) ' dP SIZE   = ', LBOUND(hB%dPR8), UBOUND(hB%dPR8)
!       WRITE(0,*) ' dP(1:4,4) - after  = ', hB%dPR8(1:4,4)
!      endif
!      Extract from buffer (including halo)
       DO J=jLo-OL,jHi+OL
        DO I=iLo-OL,iHi+OL
         arr(I,J,K) = hB%dPR8(hB%LoC(1)+I-1,hB%LoC(2)+J-1)
        ENDDO
       ENDDO
      ENDDO

      END SUBROUTINE
      END MODULE MITGCM_ORG_ESMF_EXCH
