! $Header: /u/u0/gcmpack/MITgcm/eesupp/src/global_sum.F,v 1.10 2001/09/21 03:54:35 cnh Exp $
! $Name:  $
      MODULE MITGCM_ORG_ESMF_GS

      USE ESMF_MOD
      USE MITGCM_ORG_ESMF_UTILS

      IMPLICIT NONE

      TYPE(ESMF_Field)   :: phiGSRL
      SAVE    phiGSRL
      PRIVATE phiGSRL
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: phiGSPtr
      SAVE    phiGSPtr
      PRIVATE phiGSPtr
      INTEGER :: cDEny
      SAVE       cDEny
      PRIVATE    cDEny


      CONTAINS
      SUBROUTINE GLOBAL_SUM_E_INIT( gC )

!     Create a work array that we will use to do a gather
!     form global sum - (the only style that works in ESMF_1_0_4).

!     Routine arguments
      TYPE(ESMF_GridComp) :: gC

!     Local variables
      TYPE(ESMF_DELayout)  :: cLayout
      INTEGER              :: cDEnx, nDE, cMyDEx, cMyDEy
      INTEGER              :: esmfRC
      INTEGER              :: gridCount(2)
      REAL(ESMF_KIND_R8)   :: gridLo(2), gridHi(2)
      TYPE(ESMF_Logical)   :: periodic(2)
      INTEGER              :: haloW
      TYPE(ESMF_Grid)      :: gridRef
      TYPE(ESMF_ArraySpec) :: arraySpec
      TYPE(ESMF_Field)     :: fieldRef
      TYPE(ESMF_Array)     :: arrayRef, outArray
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: thePtr
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: thePtr4
      REAL(KIND=ESMF_KIND_R8) :: sum
      INTEGER                 :: I


!     Create work field used in global sum
      CALL ESMF_GridCompGet( gC, layout=cLayout, rc=esmfRC             )
      CALL ESMF_DELayoutGetSize( cLayout, cDEnx, cDEny, esmfRC         )
      CALL ESMF_DELayoutGetDEPosition( cLayout, cMyDEx, cMyDEy, esmfRC )
      nDE = cDEnx*cDEny

      gridCount(1) = cDEnx
      gridCount(2) = cDEny*2
      gridLo(1)    = 0.
      gridLo(2)    = 0.
      gridHi(1)    = 1.
      gridHi(2)    = 1.
      haloW        = 0
      periodic(1)  = ESMF_FALSE
      periodic(2)  = ESMF_FALSE
      gridRef      = ESMF_GridCreate(2,
     &               counts=gridCount,
     &               min=gridLo,
     &               max=gridHi,
     &               layout=cLayout,
     &               horz_gridtype=ESMF_GridType_XY,
     &               horz_stagger=ESMF_GridStagger_A,
     &               horz_coord_system=ESMF_CoordSystem_Cartesian,
     &               periodic=periodic,
     &               name="ocn gsum grid",
     &               rc=esmfRC)
      CALL ESMF_ArraySpecInit( arraySpec, rank=2, type=ESMF_DATA_REAL,
     &                         kind=ESMF_R8)
      phiGSRL = ESMF_FieldCreate( gridRef, arraySpec,
     &           relloc=ESMF_CELL_CENTER,
     &           haloWidth=haloW,
     &           name="ocn gsum field",
     &           rc=esmfRC)

!     Bits needed for the sum
      CALL ESMF_FieldGetData( phiGSRL, arrayRef, esmfRC )
      CALL ESMF_ArrayGetData( arrayRef, thePtr, ESMF_DATA_REF, esmfRC )
!     phiGSRL  =  fieldRef
      phiGSPtr => thePtr

      sum = cMyDEy  
!     WRITE(0,*) 'Local sum = ', sum
!     WRITE(0,*) 'dex, dey = ', cDEnx, cDEny
      CALL GLOBAL_SUM_E_R8(sum, 1 )

      RETURN
      END SUBROUTINE

      SUBROUTINE GLOBAL_SUM_E_R4( 
     U                       sumPhi,
     I                       myThid )

!     Routine arguments
      Real*4 sumPhi
      INTEGER myThid

!     Local variables
      TYPE(ESMF_Array) :: outarray, arrayRef
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: thePtr
      INTEGER          :: esmfRC, I
      REAL(KIND=ESMF_KIND_R8) :: theSum

      phiGSPtr = sumPhi
      CALL ESMF_FieldAllGather( phiGSRL, outArray, rc=esmfRC )
      CALL ESMF_ArrayGetData( outArray, thePtr, ESMF_DATA_REF, esmfRC )
      theSum = 0.
      DO I=1,cDEny
       theSum = theSum + thePtr(1,I)
      ENDDO
!     WRITE(0,*) theSum
      CALL ESMF_ArrayDestroy(outarray, esmfRC)
      sumPhi = theSum


      RETURN
      END SUBROUTINE
      SUBROUTINE GLOBAL_SUM_E_R8( 
     U                       sumPhi,
     I                       myThid )

!     Routine arguments
      Real*8 sumPhi
      INTEGER myThid

!     Local variables
      TYPE(ESMF_Array) :: outarray, arrayRef
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: thePtr
      INTEGER          :: esmfRC, I
      REAL(KIND=ESMF_KIND_R8) :: theSum

      phiGSPtr = 0.
      phiGSPtr(1,1) = sumPhi
!     WRITE(0,*) 'phiGSPtr - A ', phiGSPtr
      CALL ESMF_FieldAllGather( phiGSRL, outArray, rc=esmfRC )
      CALL ESMF_ArrayGetData( outArray, thePtr, ESMF_DATA_REF, esmfRC )
      theSum = 0.
      DO I=1,cDEny
       theSum = theSum + thePtr(1,I)
      ENDDO
!     WRITE(0,*) 'theSum', theSum
!     WRITE(0,*) 'thePtr ', thePtr
!     WRITE(0,*) 'phiGSPtr ', phiGSPtr
!     WRITE(0,*) LBOUND(phiGSPtr), UBOUND(phiGSPtr)
!     WRITE(0,*) LBOUND(thePtr), UBOUND(thePtr)
      CALL ESMF_ArrayDestroy(outarray, esmfRC)
      sumPhi = theSum

      RETURN
      END SUBROUTINE
      END MODULE MITGCM_ORG_ESMF_GS
