! $Header: $
! $Name:   $
! Useful utilities for interfacing to ESMF
      MODULE MITGCM_ORG_ESMF_UTILS

      USE ESMF_MOD
      IMPLICIT NONE
      PUBLIC

!     Create a useful type for communicating collected information about a field, array, data 
!     composite.
!     fRef      -- Reference to the field
!     aRef      -- Reference to the array contained in the field
!     dPR8      -- Pointer to the data in the array (for now we assume R8 here but
!               -- we could extend to carry pointers to other types)
!     nDims     -- No. of dimensions for the index space
!     LoC,HiC   -- Lower and upper bounds of the interior domain (compute domain).
!     LoT,HiT   -- Lower and upper bounds of the full domain (data domain).
!     hW        -- Halo width
      TYPE FIARDA
       TYPE(ESMF_Field)           :: fRef
       CHARACTER(LEN=ESMF_MAXSTR) :: fNam
       TYPE(ESMF_Array)           :: aRef
       CHARACTER(LEN=ESMF_MAXSTR) :: aNam
       INTEGER                    :: nDims
       INTEGER                    :: LoC(ESMF_MAXGRIDDIM)
       INTEGER                    :: HiC(ESMF_MAXGRIDDIM)
       INTEGER                    :: LoT(ESMF_MAXGRIDDIM)
       INTEGER                    :: HiT(ESMF_MAXGRIDDIM)
       INTEGER                    :: nI( ESMF_MAXGRIDDIM)
       INTEGER                    :: hW
       REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: dPR8
      END TYPE FIARDA
     
      CONTAINS
      SUBROUTINE STATE_GET_FADP( theState, 
     &                           theFieldName, 
     &                           thePtr, 
     &                           theFieldRef,
     &                           fSpec )
!     =========================================================
!     = S/R STATE_GET_FADP: Get the data pointer for an array within
!     = a field within a state                                       
!     =========================================================

!     == Routine arguments ==
      TYPE(ESMF_State)                                 :: theState
      CHARACTER*(*)                                    :: theFieldName
      REAL(KIND=ESMF_KIND_R8), DIMENSION(:,:), POINTER :: thePtr
      TYPE(ESMF_FIELD), OPTIONAL                       :: theFieldRef
      TYPE(FIARDA), OPTIONAL                           :: fSpec

!     == Local variables ==
      INTEGER                                          :: esmfRC
      TYPE(ESMF_Grid)                                  :: gridRef
      TYPE(ESMF_Field)                                 :: fieldRef
      TYPE(ESMF_Array)                                 :: arrayRef
      TYPE(ESMF_AxisIndex), dimension(ESMF_MAXGRIDDIM) :: indexc
      TYPE(ESMF_AxisIndex), dimension(ESMF_MAXGRIDDIM) :: indext

!     Default behavoir is to get the data pointer for the field
      CALL ESMF_StateGetData( theState, theFieldName, 
     &                        fieldRef, esmfRC )
      CALL ESMF_FieldGetData( fieldRef, arrayRef, esmfRC )
      CALL ESMF_ArrayGetData( arrayRef, thePtr, ESMF_DATA_REF, esmfRC )

!     Optionally return field reference
      IF ( PRESENT(theFieldRef) ) THEN
       theFieldRef = fieldRef
      ENDIF

!     Optionally return the spec field
      IF ( PRESENT(fSpec) ) THEN
       fSpec%fRef = fieldRef
       CALL ESMF_FieldGetData( fSpec%fRef,
     O                     array=fspec%aRef,
     O                        rc=esmfRC )
       CALL ESMF_FieldGetName( fSpec%fRef,
     O                      name=fspec%fNam,
     O                        rc=esmfRC )
       CALL ESMF_ArrayGetAxisIndex( fspec%aRef,
     O                               compindex=indexc,
     O                              totalindex=indext,
     O                                      rc=esmfRC)
       CALL ESMF_ArrayGetData( fspec%aRef,
     O                         fspec%dPR8,
     I                         ESMF_DATA_REF,
     O                         esmfRC )
       fSpec%nDims  = 2
!      Interior domain extents
       fSpec%LoC(1) = indexc(1)%min
       fSpec%LoC(2) = indexc(2)%min
       fSpec%HiC(1) = indexc(1)%max
       fSpec%HiC(2) = indexc(2)%max
!      Total domain extents
       fSpec%LoT(1) = indext(1)%min
       fSpec%LoT(2) = indext(2)%min
       fSpec%HiT(1) = indext(1)%max
       fSpec%HiT(2) = indext(2)%max
!      Inferred halo width and tile interior size
       fSpec%hW     = fSpec%HiT(1) - fSpec%HiC(1)
       fSpec%nI(1)  = fSpec%HiC(1) - fSpec%LoC(1)+1
       fSpec%nI(2)  = fSpec%HiC(2) - fSpec%LoC(2)+1
      ENDIF

      RETURN
      END SUBROUTINE
      END MODULE
