C $Header: /u/u0/gcmpack/MITgcm/eesupp/src/exch_rx_cube.template,v 1.3 2001/09/21 03:55:50 cnh Exp $
C $Name:  $

#include "CPP_EEOPTIONS.h"

CBOP
C     !ROUTINE: EXCH_RS_CUBE

C     !INTERFACE:
      SUBROUTINE EXCH_RS_CUBE( 
     U            array,
     I            myOLw, myOLe, myOLn, myOLs, myNz,
     I            exchWidthX, exchWidthY,
     I            simulationMode, cornerMode, myThid )
      IMPLICIT NONE

C     !DESCRIPTION:
C     *==========================================================*
C     | SUBROUTINE EXCH_RS_CUBE                                   
C     | o Control edge exchanges for RS array.                    
C     *==========================================================*
C     |                                                           
C     | Controlling routine for exchange of XY edges of an array  
C     | distributed in X and Y. The routine interfaces to         
C     | communication routines that can use messages passing      
C     | exchanges, put type exchanges or get type exchanges.      
C     |  This allows anything from MPI to raw memory channel to   
C     | memmap segments to be used as a inter-process and/or      
C     | inter-thread communiation and synchronisation             
C     | mechanism.                                                
C     | Notes --                                                  
C     | 1. Some low-level mechanisms such as raw memory-channel   
C     | or SGI/CRAY shmem put do not have direct Fortran bindings 
C     | and are invoked through C stub routines.                  
C     | 2. Although this routine is fairly general but it does    
C     | require nSx and nSy are the same for all innvocations.    
C     | There are many common data structures ( myByLo,           
C     | westCommunicationMode, mpiIdW etc... ) tied in with       
C     | (nSx,nSy). To support arbitray nSx and nSy would require  
C     | general forms of these.                                   
C     |                                                           
C     *==========================================================*

C     !USES:
C     == Global data ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "EESUPPORT.h"
#include "EXCH.h"

C     !INPUT/OUTPUT PARAMETERS:
C     == Routine arguments ==
C     array :: Array with edges to exchange.
C     myOLw :: West, East, North and South overlap region sizes.
C     myOLe
C     myOLn
C     myOLs
C     exchWidthX :: Width of data region exchanged in X.
C     exchWidthY :: Width of data region exchanged in Y.
C                   Note -- 
C                   1. In theory one could have a send width and
C                   a receive width for each face of each tile. The only
C                   restriction woul be that the send width of one
C                   face should equal the receive width of the sent to
C                   tile face. Dont know if this would be useful. I 
C                   have left it out for now as it requires additional 
C                   bookeeping.
C     simulationMode :: Forward or reverse mode exchange ( provides 
C                       support for adjoint integration of code. )
C     cornerMode     :: Flag indicating whether corner updates are 
C                       needed.
C     myThid         :: Thread number of this instance of S/R EXCH...
      INTEGER myOLw
      INTEGER myOLe
      INTEGER myOLs
      INTEGER myOLn
      INTEGER myNz
      INTEGER exchWidthX
      INTEGER exchWidthY
      INTEGER simulationMode
      INTEGER cornerMode
      INTEGER myThid
      _RS array(1-myOLw:sNx+myOLe,
     &          1-myOLs:sNy+myOLn, 
     &          myNZ, nSx, nSy)

C     !LOCAL VARIABLES:
C     == Local variables ==
C     theSimulationMode :: Holds working copy of simulation mode
C     theCornerMode     :: Holds working copy of corner mode
C     I,J,K,bl,bt,bn,bs :: Loop and index counters
C     be,bw
      INTEGER theSimulationMode
      INTEGER theCornerMode
      INTEGER I,J,K
      INTEGER bl,bt,bn,bs,be,bw
C     == Statement function ==
C     tilemod - Permutes indices to return neighboring tile index on
C               six face cube.
      INTEGER tilemod
      tilemod(I)=1+mod(I-1+6,6)
CEOP

      theSimulationMode = simulationMode
      theCornerMode     = cornerMode

C     For now tile<->tile exchanges are sequentialised through
C     thread 1. This is a temporary feature for preliminary testing until
C     general tile decomposistion is in place (CNH April 11, 2001)
      CALL BAR2( myThid )
      IF ( myThid .EQ. 1 ) THEN

       DO bl = 1, 5, 2

        bt = bl
        bn=tilemod(bt+2)
        bs=tilemod(bt-1)
        be=tilemod(bt+1)
        bw=tilemod(bt-2)

        DO K = 1, myNz
         DO J = 1, sNy
          DO I = 1, exchWidthX

C          Tile Odd:Odd+2 [get] [North<-West]
           array(J,sNy+I,K,bt,1) = array(I,sNy+1-J,K,bn,1)
C          Tile Odd:Odd-1 [get] [South<-North]
           array(J,1-I,K,bt,1) = array(J,sNy+1-I,K,bs,1)
C          Tile Odd:Odd+1 [get] [East<-West]
           array(sNx+I,J,K,bt,1) = array(I,J,K,be,1)
C          Tile Odd:Odd-2 [get] [West<-North]
           array(1-I,J,K,bt,1) = array(sNx+1-J,sNy+1-I,K,bw,1)

          ENDDO
         ENDDO
        ENDDO

        bt = bl+1
        bn=tilemod(bt+1)
        bs=tilemod(bt-2)
        be=tilemod(bt+2)
        bw=tilemod(bt-1)

        DO K = 1, myNz
         DO J = 1, sNy
          DO I = 1, exchWidthX

C          Tile Even:Even+1 [get] [North<-South]
           array(J,sNy+I,K,bt,1) = array(J,I,K,bn,1)
C          Tile Even:Even-2 [get] [South<-East]
           array(J,1-I,K,bt,1) = array(sNx+1-I,sNy+1-J,K,bs,1)
C          Tile Even:Even+2 [get] [East<-South]
           array(sNx+I,J,K,bt,1) = array(sNx+1-J,I,K,be,1)
C          Tile Even:Even-1 [get] [West<-East]
           array(1-I,J,K,bt,1) = array(sNx+1-I,J,K,bw,1)

          ENDDO
         ENDDO
        ENDDO

       ENDDO

      ENDIF
      CALL BAR2(myThid)
  
      RETURN
      END
