C $Header: $
C $Name:   $
C
C
C     /==========================================================\
C     | ATMCPL.h                                                 |
C     | o Variables shared between atmos. component to coupler   |
C     |   layer.                                                 |
C     |==========================================================|
C     | These variables are used in the atmos component. Grid    |
C     | variables have already been mapped/interpolated to the   |
C     | atmos grid.                                              |
C     | Which variables are exported will depend on the specific |
C     | ocean coupling being utilised. The variables             |
C     | carried here will need to be customised accordingly.     |
C     \==========================================================/
C
C     COMMON /ATM_ATM2CPL_R/ 
C     HeatFlux   - Atmospheric heat flux at lower boundary (W/m^2). Positive flux 
C                  is into atmosphere.
C     tauX       - Atmospheric zonal momentum flux at lower boundary (N/m^2).
C                  Positive flux is into the atmosphere. Positive zonal momentum
C                  is westward.
C     tauY       - Atmospheric meridional momentum flux at lower boundary (N/m^2).
C                  Positive flux is into the atmosphere. Positive meridional 
C                  momentum is northward.
C     uVelGround - Zonal wind speed at the ground (m/s).
C     vVelGround - Meridional wind speed at the ground (m/s).
C     FWFlux     - Atmospheric fresh water flux at lower boundary (m/s). Positive 
C                  flux is into atmosphere.
C     Qsensible  - Sensible heatflux (W/m^2).
C     Qlatent    - Latent heatflux (W/m^2).
C     Qlongwave  - Downward longwave (W/m^2).
C     Qshortwave - Upward shortwave (W/m^2).
C     HeatFluxTime   - Time period over which flux field has been integrated.
C     tauXTime       - Time period over which flux field has been integrated.
C     tauYTime       - Time period over which flux field has been integrated.
C     uVelGroundTime - Time period over which term has been integrated.
C     vVelGroundTime - Time period over which term has been integrated.
C     FWFluxTime     - Time period over which flux field has been integrated.
C     QsensibleTime  - Time period over which term has been integrated.
C     QlatentTime    - Time period over which term has been integrated.
C     QlongwaveTime  - Time period over which term has been integrated.
C     QshortwaveTime - Time period over which term has been integrated.
      COMMON /ATM_ATM2CPL_R/ 
     &                   HeatFlux, tauX, tauY, FWFlux,
     &                   uVelGround, vVelGround,
     &                   Qsensible, Qlatent, Qlongwave, Qshortwave, 
     &                   HeatFluxTime, tauXtime, tauYtime, 
     &                   uVelGroundTime, vVelGroundTime,
     &                   FWFluxTime,
     &                   QsensibleTime, QlatentTime,
     &                   QlongwaveTime, QshortwaveTime
      _RL  HeatFlux  (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  tauX      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  tauY      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  uVelGround(1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  vVelGround(1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  FWFlux    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  Qsensible (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  Qlatent   (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  Qlongwave (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  Qshortwave(1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  HeatFluxTime
      _RL  tauXTime
      _RL  tauYTime
      _RL  uVelGroundTime
      _RL  vVelGroundTime
      _RL  FWFluxTime
      _RL  QsensibleTime
      _RL  QlatentTime
      _RL  QlongwaveTime
      _RL  QshortwaveTime

C
C     COMMON /ATM_CPL2ATM_R/
C     Hocn   - Ocean depths (m). Hocn==0. => land.
C     SSTocn - Ocean surface temperature (oC). Undefined data for land points.
      COMMON /ATM_CPL2ATM_R/ 
     &                   Hocn, SSTocn
      _RL  Hocn   (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL  SSTocn (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
