C $Header: $
C $Name:   $  

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE ATM_STORE_FWFLUX( myCurrentTime, 
     I                             myCurrentIter, 
     I                             myThid )
C     /==========================================================\
C     | SUBROUTINE ATM_STORE_FWFLUX                              |
C     | o Routine for saving atmos. lower boundary fresh water   |
C     |   flux for export to coupling layer.                     |
C     |==========================================================|
C     | This version interfaces to the MITgcm AIMPHYS package.   |
C     \==========================================================/

C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
C     == Global variables for coupling interface ==
#include "ATMCPL.h"
C     == AIMPHYS specific global data ==
#include "atparam0.h"
#include "atparam1.h"
      INTEGER NGP
      INTEGER NLON
      INTEGER NLAT
      INTEGER NLEV
      PARAMETER ( NLON=IX, NLAT=IL, NLEV=KX, NGP=NLON*NLAT )
#include "com_physvar.h"


C     == Routine arguments ==
C     myThid        - Thread number for this instance of the routine
C     myCurrentIter - Current timestep number
C     myCurrentTime - Current model time
      INTEGER myThid
CEndOfInterface

C     == Local variables ==
C     I,J,K,II - Loop counters
C     bi, bj
      INTEGER I,J,K,II
      INTEGER bi, bj

C     o Accumulate fresh water flux that will be exported to the 
C       coupling layer. Fresh-water flux is in units of g/m^2/s. 
C       To convert to meters per second divide by density in 
C       g/m^3. Positive flux is into the atmosphere.
      FWFluxTime = FWFluxTime + deltaTtracer
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO J=1,sNy
         DO I=1,sNx
          II = (sNx)*(J-1)+I
          FWFlux(I,J,bi,bj) = 
     &    FWFlux(I,J,bi,bj) + EVAP(II,2,myThid)*deltaTtracer
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      RETURN
      END
