C $Header: /u/u0/gcmpack/MITgcm/pkg/mom_vecinv/mom_calc_tension.F,v 1.2 2001/11/27 15:50:01 adcroft Exp $
C $Name:  $

#include "CPP_OPTIONS.h"

CBOP
C !ROUTINE: MOM_CALC_TENSION

C !INTERFACE: ==========================================================
      SUBROUTINE MOM_CALC_TENSION( 
     I        bi,bj,k,
     I        uFld, vFld,
     O        tension,
     I        myThid)
C !DESCRIPTION:
C Calculates the tension of the horizontal flow field (at tracer points):
C \begin{equation*}
C D_T = \frac{\Delta y_f}{\Delta x_f} \delta_i \frac{u}{\Delta y_g}
C     - \frac{\Delta x_f}{\Delta y_f} \delta_j \frac{v}{\Delta x_g}
C \end{equation*}

C !USES: ===============================================================
      IMPLICIT NONE
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "GRID.h"

C !INPUT PARAMETERS: ===================================================
C  bi,bj                :: tile indices
C  k                    :: vertical level
C  uFld                 :: zonal flow
C  vFld                 :: meridional flow
C  myThid               :: thread number
      INTEGER bi,bj,k
      _RL uFld(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      _RL vFld(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      INTEGER myThid

C !OUTPUT PARAMETERS: ==================================================
C  tension              :: tension of horizontal flow
      _RL tension(1-OLx:sNx+OLx,1-OLy:sNy+OLy)

C !LOCAL VARIABLES: ====================================================
C  i,j                  :: loop indices
      INTEGER i,j
CEOP

      DO j=1-Oly,sNy+Oly-1
       DO i=1-Olx,sNx+Olx-1

C Calculate tension of horizontal flow (ignoring lopping factors)
C *NOTE* that masking is implicit in the contents of the (u,v) fields.
        tension(i,j)= 
     &    (dyf(i,j,bi,bj)*recip_dxf(i,j,bi,bj))
     &   *( uFld(i+1, j )*recip_dyg(i+1, j ,bi,bj)
     &     -uFld( i , j )*recip_dyg( i , j ,bi,bj) )
     &   -(dxf(i,j,bi,bj)*recip_dyf(i,j,bi,bj))
     &   *( vFld( i ,j+1)*recip_dxg( i ,j+1,bi,bj)
     &     -vFld( i , j )*recip_dxg( i , j ,bi,bj) )

       ENDDO
      ENDDO
        
      RETURN
      END
