C     $Header: /u/u0/gcmpack/MITgcm/pkg/aim/aim_calc_diags.F,v 1.6 2001/09/25 19:53:57 jmc Exp $
C     $Name:  $

#include "CPP_OPTIONS.h"

CStartOfInterFace
      SUBROUTINE CPL_CALC_DIAGS( bi, bj, myTime, myThid )
C     /==========================================================\
C     | SUBROUTINE CPL_CALC_DIAGS                                |
C     | o Calculate CPL diagnostics                              |
C     \==========================================================/
      IMPLICIT rEAL*8 (A-H,O-Z)

C     === Global variables ===
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "OCNCPL.h"
#include "CPL_DIAGS.h"

      LOGICAL  DIFFERENT_MULTIPLE
      EXTERNAL DIFFERENT_MULTIPLE

C     == Routine arguments ==
C     myTime - Current time of simulation ( s )
C     myThid - Number of this instance of the routine
C     bi,bj  - Tile index
      _RL     myTime
      INTEGER myThid
      INTEGER bi, bj
CEndOfInterface

#ifdef COMPONENT_MODULE

C     == Local variables ==
      INTEGER I,J,I2,K
      _RL DDTT

#ifdef ALLOW_TIMEAVE

      DDTT = deltaTclock

      DO J=1,sNy
       DO I=1,sNx
        HFtave(i,j,bi,bj)   = HFtave(i,j,bi,bj)   + HeatFlux(i,j,bi,bj)*DDTT
        TXtave(i,j,bi,bj)   = TXtave(i,j,bi,bj)   + tauX(i,j,bi,bj)*DDTT
        TYtave(i,j,bi,bj)   = TYtave(i,j,bi,bj)   + tauY(i,j,bi,bj)*DDTT
        FWtave(i,j,bi,bj)   = FWtave(i,j,bi,bj)   + FWFlux(i,j,bi,bj)*DDTT
        UGtave(i,j,bi,bj)   = UGtave(i,j,bi,bj)   + uVelGround(i,j,bi,bj)*DDTT
        VGtave(i,j,bi,bj)   = VGtave(i,j,bi,bj)   + vVelGround(i,j,bi,bj)*DDTT
        QLTtave(i,j,bi,bj)  = QLTtave(i,j,bi,bj)  + qLatent(i,j,bi,bj)*DDTT
        QSNtave(i,j,bi,bj)  = QSNtave(i,j,bi,bj)  + qSensible(i,j,bi,bj)*DDTT
        QLNtave(i,j,bi,bj)  = QLNtave(i,j,bi,bj)  + qLongwave(i,j,bi,bj)*DDTT
        QSHtave(i,j,bi,bj)  = QSHtave(i,j,bi,bj)  + qShortwave(i,j,bi,bj)*DDTT
        SSTtave(i,j,bi,bj)  = SSTtave(i,j,bi,bj)  + SSTocn2cpl(i,j,bi,bj)*DDTT
       ENDDO
      ENDDO

C-    Keep record of how much time has been integrated over
      DO K=1,Nr
       CPL_TimeAve(k,bi,bj)=CPL_TimeAve(k,bi,bj)+DDTT
      ENDDO                                                                                    


#endif /* ALLOW_TIMEAVE */

#endif /* COMPONENT_MODULE */

      RETURN
      END



