C $Header: $
C $Name:   $

#include "CPP_OPTIONS.h"

CBOP
C     !ROUTINE: DRIVER_RUN
C     !INTERFACE:
      SUBROUTINE DRIVER_RUN(
     I                     atm_HeatFlux, atm_TauX, atm_TauY,
     I                     atm_Qlatent, atm_Qsensible, atm_Qlongwave,
     I                     atm_Qshortwave,
     I                     atm_uVelGround, atm_vVelGround,
     I                     atm_FWFlux,
     O                     ocn_SSTocn,
     I                     startStep, stopStep
     &                     )

C     !DESCRIPTION: \bv
C     *==================================================================
C     | SUBROUTINE driver_run
C     | o External driver control routine for MITgcm forward step
C     |   execution phase. 
C     *==================================================================
C     |
C     | DRIVER routines are used to control the MITgcm code from an external
C     | driver. This routine invokes the forward phase of code execution.
C     | The driver here is written for an ocean configuration and is designed
C     | for use with either an argument based call/return interface or with a
C     | messaging based "event loop" interface.
C     |
C     *==================================================================
C     \ev

C     !USES:
      IMPLICIT NONE
C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "EESUPPORT.h"
#include "PARAMS.h"
#include "OCNCPL.h"

C     == Routine arguments ==
      _RL atm_HeatFlux(   1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauX(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauY(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlatent(    1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qsensible(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlongwave(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qshortwave( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_uVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_vVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_FWFlux(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL ocn_SSTocn(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      INTEGER startStep, stopStep

C     == Local variables ==
C     myThid :: Thread number for this instance of the routine
      INTEGER myThid
      INTEGER myCurrentIter
      _RL     myCurrentTime
      INTEGER iLoop
      INTEGER i,j,bi,bj
      CHARACTER*(MAX_LEN_MBUF) msgBuf
      CHARACTER*13 fNam
CEOP

      CALL COMP_OCN_PUSH_CONTEXT(1)
      myThid = 1
      CLOSE(errorMessageUnit)
      CLOSE(standardMessageUnit)
!     myProcessStr  = '0000'
      WRITE(fNam,'(A,A)') 'STDOUT.', myProcessStr(1:4)
      OPEN(standardMessageUnit,FILE=fNam,STATUS='old',POSITION='append')
      WRITE(fNam,'(A,A)') 'STDERR.', myProcessStr(1:4)
      OPEN(errorMessageUnit,FILE=fNam,STATUS='old',POSITION='append')


      WRITE(msgBuf,*) 'Entering OCN driver_run'
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)

C     Extract the import fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1-OLy,sNy+OLy
         DO i=1-OLx,sNx+OLx
          HeatFlux(   i,j,bi,bj)=atm_HeatFlux(  i,j,bi,bj)
          TauX(       i,j,bi,bj)=atm_tauX(      i,j,bi,bj)
          TauY(       i,j,bi,bj)=atm_tauY(      i,j,bi,bj)
          Qlatent(    i,j,bi,bj)=atm_qLatent(   i,j,bi,bj)
          Qsensible(  i,j,bi,bj)=atm_qSensible( i,j,bi,bj)
          Qlongwave(  i,j,bi,bj)=atm_qLongwave( i,j,bi,bj)
          Qshortwave( i,j,bi,bj)=atm_qShortwave(i,j,bi,bj)
          uVelGround( i,j,bi,bj)=atm_uVelGround(i,j,bi,bj)
          vVelGround( i,j,bi,bj)=atm_vVelGround(i,j,bi,bj)
          FWFlux(     i,j,bi,bj)=atm_FWFlux(    i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      myCurrentTime = startTime+startStep*deltaTClock
      myCurrentIter = nIter0+startStep
      myThid        = 1
      nTimesteps    = stopStep-startStep

      WRITE(msgBuf,*) 'OCN driver_run begin: myCurrentTime = ', myCurrentTime
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)
      WRITE(msgBuf,*) 'OCN driver_run begin: myCurrentIter = ', myCurrentIter
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)
      WRITE(msgBuf,*) 'OCN driver_run begin: nTimeSteps    = ', nTimeSteps
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)

      CALL MONITOR( myCurrentIter, myCurrentTime, myThid )

      DO iLoop = 1, nTimeSteps-1
       CALL CPL_IMPORT_EXTERNAL_DATA(
     I      myCurrentIter, myCurrentTime, myThid )
       CALL FORWARD_STEP_EXECUTE( iLoop, myCurrentTime, myCurrentIter, myThid )
       CALL FORWARD_STEP_SETUP( iLoop+1, myCurrentTime, myCurrentIter, myThid )
      ENDDO

      iLoop = nTimeSteps
       CALL CPL_IMPORT_EXTERNAL_DATA(
     I      myCurrentIter, myCurrentTime, myThid )
      CALL FORWARD_STEP_EXECUTE( iLoop, myCurrentTime, myCurrentIter, myThid  )
      CALL FORWARD_STEP_SETUP( iLoop+1, myCurrentTime, myCurrentIter, myThid )

C     Fill the export fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1,sNy
         DO i=1,sNx
          ocn_SSTocn(     i,j,bi,bj)=SSTocn2cpl(    i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      WRITE(msgBuf,*) 'OCN driver_run   end: myCurrentTime = ', myCurrentTime
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)
      WRITE(msgBuf,*) 'OCN driver_run   end: myCurrentIter = ', myCurrentIter
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)
      WRITE(msgBuf,*) 'OCN driver_run   end: nTimeSteps    = ', nTimeSteps
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)

      WRITE(msgBuf,*) 'Exiting OCN driver_run'
      CALL PRINT_MESSAGE( msgBuf, standardMessageUnit,
     &                    SQUEEZE_RIGHT , 1)

      CLOSE(errorMessageUnit)
      CLOSE(standardMessageUnit)
      CALL COMP_OCN_POP_CONTEXT(1)

      RETURN
      END
