C $Header: $
C $Name:   $

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE OCN_EXPORT_SST(myThid)
C     /==========================================================\
C     | SUBROUTINE OCN_EXPORT_SST                                |
C     | o Routine for exporting ocean sea-surface temperature    |
C     |   to the coupling layer.                                 |
C     |==========================================================|
C     | This version talks to the MIT Coupler. It uses the MIT   |
C     | Coupler "checkpoint1" library calls.                     |
C     \==========================================================/
      IMPLICIT NONE

C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "GRID.h"
#include "DYNVARS.h"
#include "OCNIDS.h"
#include "OCNCPL.h"
#ifdef ALLOW_SEAICE
#include "ICE.h"
#endif

C     == Routine arguments ==
C     myThid - Thread number for this instance of the routine
      INTEGER myThid
CEndOfInterface

C     == Local variables ==
C     I,J :: Loop variables
      INTEGER I,J


C     Send my sea-surface temperatur to coupling layer
C     o Information is sent on the ocean model grid.
      DO J=1,sNy
       DO I=1,sNx
        IF ( hFacC(I,J,1,1,1) .EQ. 0. ) THEN
         SSTocn2cpl(I,J,1,1) = theta(I,J,1,1,1)
        ELSE
         SSTocn2cpl(I,J,1,1) = theta(I,J,1,1,1)
        ENDIF
       ENDDO
      ENDDO
#ifdef ALLOW_SEAICE
      DO J=1,sNy
       DO I=1,sNx
        IF ( iceMask(I,J,1,1) .NE. 0. ) THEN
         SSTocn2cpl(I,J,1,1) = 0.
        ENDIF
       ENDDO
      ENDDO
#endif

C     CALL COMPSEND_R8TILES( ocnSSTName,
C    I     sNx, OLx, sNy, OLy, 1, nSx, nSy, SSTocn2cpl )
      WRITE(0,*) 'OCN needs to export SST'
      WRITE(0,*) ' see routine ocn_export_sst()'

      RETURN
      END
