C $Header: $
C $Name:   $

#include "CPP_OPTIONS.h"

CStartOfInterface
      SUBROUTINE CPL_CHECKPOINT(
     &               prec, lgf, permCheckPoint, myIter, myThid)
C     /==========================================================\
C     | SUBROUTINE  CPL_CHECKPOINT                               |
C     | o Store coupling state for restart.                      |
C     \==========================================================/
      IMPLICIT NONE

C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "GRID.h"
#include "OCNCPL.h"

C     == Routine arguments ==
C     myThid - Thread number for this instance of the routine.
C     myIter - Timestep number.
C     myCurrentTime  - Simulation time.
C     permCheckpoint - Controls whether timestamped or rolling checkpoint.
C     lgf            - Controls whether global files are used.
      INTEGER myIter
      INTEGER myThid
      _RL     myCurrentTime
      LOGICAL permCheckPoint
      INTEGER prec
      LOGICAL lgf
CEndOfInterface

C     == Local variables ==
C     I,J,K,bi,bj - Loop counters
C     fn          - Workspace for building file name
      INTEGER I,J,K,bi,bj
      CHARACTER*(MAX_LEN_FNAM) fn

      IF ( permCheckPoint ) THEN
       WRITE(fn,'(A,I10.10)') 'pickup_cpl.',myIter
      ELSE
       WRITE(fn,'(A,A)') 'pickup_cpl.',checkPtSuff(nCheckLev)
      ENDIF
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,SSTocn2cpl, 1,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,HeatFlux  , 2,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,tauX      , 3,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,tauY      , 4,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,FWFlux    , 5,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,uVelGround, 6,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,vVelGround, 7,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,qLatent   , 8,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,qSensible , 9,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,qLongwave ,10,myIter,myThid)
      CALL MDSWRITEFIELD(fn,prec,lgf,'RL',1,qShortwave,11,myIter,myThid)

      RETURN
      END

