C $Header: $
C $Name:   $

#define _TRACE(a)
#define _TRACE(a) a

#include "CPP_OPTIONS.h"

CBOP
C     !ROUTINE: DRIVER_INIT
C     !INTERFACE:
      SUBROUTINE DRIVER_INIT(
     I              atm_HeatFlux, atm_TauX, atm_TauY,
     I              atm_Qlatent, atm_Qsensible, atm_Qlongwave,
     I              atm_Qshortwave,
     I              atm_uVelGround, atm_vVelGround,
     I              atm_FWFlux,
     I              atm_Hatm, 
     O              ocn_SSTocn, ocn_Hocn
     &                      )

C     !DESCRIPTION: \bv
C     *==================================================================
C     | SUBROUTINE driver_init
C     | o External driver control routine for MITgcm init phase.
C     *==================================================================
C     |
C     | DRIVER routines are used to control the MITgcm code from an external
C     | driver. This routine invokes the init phase of code execution
C     |
C     *==================================================================
C     \ev

C     !USES:
      IMPLICIT NONE
C     == Global variables ==
#include "SIZE.h"
#include "EEPARAMS.h"
#include "PARAMS.h"
#include "GRID.h"
#include "OCNCPL.h"

C     == Routine arguments ==
      _RL atm_HeatFlux(   1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauX(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_TauY(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlatent(    1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qsensible(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qlongwave(  1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Qshortwave( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_uVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_vVelGround( 1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_FWFlux(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL atm_Hatm(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL ocn_SSTocn(     1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      _RL ocn_Hocn(       1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)


C     == Local variables ==
C     myThid :: Thread number for this instance of the routine
      INTEGER myThid
      INTEGER i,j,bi,bj

#define SPLIT_DRIVER
#ifdef  SPLIT_DRIVER
      INTEGER myCurrentIter
      _RL     myCurrentTime
      INTEGER iLoop
#endif

CEOP

      _TRACE(WRITE(0,*) 'DRIVER INIT (MITGCM_ORG_OCN) started')

      _TRACE(WRITE(0,*) 'Set context')
      CALL COMP_OCN_PUSH_CONTEXT(1)

      _TRACE(WRITE(0,*) 'CALL EEBOOT()')
      CALL EEBOOT()
      myThid = 1

      _TRACE(WRITE(0,*) 'READING IMPORTS()')
!     WRITE(0,*) myByLo(myThid),myByHi(myThid)
!     WRITE(0,*) myBxLo(myThid),myBxHi(myThid)
!     WRITE(0,*) 1-OLy, sNy+OLy
!     WRITE(0,*) 1-OLx, sNx+OLx
C     Read the import fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1-OLy,sNy+OLy
         DO i=1-OLx,sNx+OLx
          HeatFlux(   i,j,bi,bj)=atm_HeatFlux(  i,j,bi,bj)
          TauX(       i,j,bi,bj)=atm_tauX(      i,j,bi,bj)
          TauY(       i,j,bi,bj)=atm_tauY(      i,j,bi,bj)
          Qlatent(    i,j,bi,bj)=atm_qLatent(   i,j,bi,bj)
          Qsensible(  i,j,bi,bj)=atm_qSensible( i,j,bi,bj)
          Qlongwave(  i,j,bi,bj)=atm_qLongwave( i,j,bi,bj)
          Qshortwave( i,j,bi,bj)=atm_qShortwave(i,j,bi,bj)
          uVelGround( i,j,bi,bj)=atm_uVelGround(i,j,bi,bj)
          vVelGround( i,j,bi,bj)=atm_vVelGround(i,j,bi,bj)
          FWFlux(     i,j,bi,bj)=atm_FWFlux(    i,j,bi,bj)
          Hatm(       i,j,bi,bj)=atm_Hatm(      i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      _TRACE(WRITE(0,*) 'CALL INITIALISE_FIXED()')
      CALL INITIALISE_FIXED(    myThid )

      _TRACE(WRITE(0,*) 'CALL INITIALISE_VARIA()')
      CALL INITIALISE_VARIA(    myThid )

#ifdef  SPLIT_DRIVER
      myCurrentTime = startTime
      myCurrentIter = nIter0
      myThid = 1
      iLoop  = 1
      CALL FORWARD_STEP_SETUP( iLoop, myCurrentTime, myCurrentIter, myThid    )
#endif

C     Fill the export fields
      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO j=1-OLy,sNy+OLy
         DO i=1-OLx,sNx+OLx
          ocn_SSTocn(i,j,bi,bj) = SSTocn2cpl(i,j,bi,bj)
          ocn_Hocn(  i,j,bi,bj) = R_low(     i,j,bi,bj)
         ENDDO
        ENDDO
       ENDDO
      ENDDO

      CLOSE(errorMessageUnit)
      CLOSE(standardMessageUnit)
      CALL COMP_OCN_POP_CONTEXT(1)

      _TRACE(WRITE(0,*) 'DRIVER INIT (MITGCM_ORG_OCN) finished')

      RETURN
      END
