c $Header: /u/u0/gcmpack/MITgcm/pkg/exf/exf_bulkqsat.F,v 1.1 2001/05/14 22:08:40 heimbach Exp $

C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_OPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


cswdblk --- add ---
C o Include/exclude code for bulk formula


cswdice -- add ---
C o allow seaice

cswdice -- end add ---
C o try to conserve qnet and emp


cswdblk -- end add ---

C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_EEOPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C--   Control MPI based parallel processing





 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 
C--   Control use of "double" precision constants.
C     Use D0 where it means REAL*8 but not where it means REAL*16


C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.







C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name:  $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.




















C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.

 
C--   Control use of "double" precision constants.
C     Use d0 where it means REAL*8 but not where it means REAL*16


C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








C o Include/exclude code specific to the ECCO/SEALION version.


 
C o Enable/disable state import and export.




C Need to define byteswapio if using Lahey compiler (for ESMF lib built against Lahey)


      Real*8 function exf_BulkqSat(
     I                           tkelvin
     &                         )

c     ==================================================================
c     FUNCTION exf_BulkqSat
c     ==================================================================
c
c     o Compute the saturation specific humidity.
c
c     started: Christian Eckert eckert@mit.edu  27-Aug-1999
c
c     changed: Christian Eckert eckert@mit.edu  14-Jan-2000
c
c              - Restructured the code in order to create a package
c                for the MITgcmUV.
c
c              Patrick Heimbach heimbach@mit.edu  05-May-2000
c
c              - Included appropriate CPP options
c                ALLOW_BULKFORMULAE, ALLOW_ATM_TEMP
c
c     swd, April 2002: changed to be used in bulkf package
c
c     ==================================================================
c     FUNCTION exf_BulkqSat
c     ==================================================================

      implicit none



c     == global variables ==

C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/SIZE.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | SIZE.h Declare size of underlying computational grid.    |
C     |==========================================================|
C     | The design here support a three-dimensional model grid   |
C     | with indices I,J and K. The three-dimensional domain     |
C     | is comprised of nPx*nSx blocks of size sNx along one axis|
C     | nPy*nSy blocks of size sNy along another axis and one    |
C     | block of size Nz along the final axis.                   |
C     | Blocks have overlap regions of size OLx and OLy along the|
C     | dimensions that are subdivided.                          |
C     \==========================================================/
C     Voodoo numbers controlling data layout.
C     sNx - No. X points in sub-grid.
C     sNy - No. Y points in sub-grid.
C     OLx - Overlap extent in X.
C     OLy - Overlat extent in Y.
C     nSx - No. sub-grids in X.
C     nSy - No. sub-grids in Y.
C     nPx - No. of processes to use in X.
C     nPy - No. of processes to use in Y.
C     Nx  - No. points in X for the total domain.
C     Ny  - No. points in Y for the total domain.
C     Nr  - No. points in Z for full process domain.
      INTEGER sNx
      INTEGER sNy
      INTEGER OLx
      INTEGER OLy
      INTEGER nSx
      INTEGER nSy
      INTEGER nPx
      INTEGER nPy
      INTEGER Nx
      INTEGER Ny
      INTEGER Nr
      PARAMETER (
     &           sNx = 128,
     &           sNy =   4,
C    &           sNy =   8,
C    &           sNy =  16,
C    &           sNy =  32,
C    &           sNy =  64,
     &           OLx =   3,
     &           OLy =   3,
     &           nSx =   1,
     &           nSy =   1,
     &           nPx =   1,
     &           nPy =  16,
C    &           nPy =   8,
C    &           nPy =   4,
C    &           nPy =   2,
C    &           nPy =   1,
     &           Nx  = sNx*nSx*nPx,
     &           Ny  = sNy*nSy*nPy,
     &           Nr  =  15)

C     MAX_OLX  - Set to the maximum overlap region size of any array
C     MAX_OLY    that will be exchanged. Controls the sizing of exch
C                routine buufers.
      INTEGER MAX_OLX
      INTEGER MAX_OLY
      PARAMETER ( MAX_OLX = OLx,
     &            MAX_OLY = OLy )

c----------------------------------------------------------------------------
c.. Common blocks for almost everything that the sea ice model passes around.
c----------------------------------------------------------------------------
c.. number layers of ice  
      integer nlyr        ! maximum number of ice layers
      Real*8  rnlyr          ! real value of nlyr
      parameter (nlyr = 2)
      parameter (rnlyr = 2.)

c.. densities
      Real*8  rhoa                      ! density of air (kg/m^3)
      Real*8  rhos                      ! density of snow (kg/m^3)
      Real*8  rhoi                      ! density of ice (kg/m^3)
      Real*8  rhosw                     ! density of seawater (kg/m^3)
      Real*8  rhoiw                     ! ocean-ice density difference (kg/m^3)

      parameter (rhoa =1.3)
      parameter (rhos = 330.)
      parameter (rhoi = 900.)
      parameter (rhosw = 1026.)
      parameter (rhoiw = rhosw - rhoi)

c.. specific heats
      Real*8  cpair          ! specific heat of air (J/kg/K)
      Real*8  cpice          ! specific heat of fresh ice (J/kg/K)
      Real*8  cpwater        ! specific heat of water (J/kg/K)
      Real*8  cpwv           ! specific heat of water vapour (J/kg/KC)
      Real*8  cpvir

      parameter(cpair = 1004.)
      parameter(cpice = 2106.)
      parameter (cpwater = 4218.)
      parameter (cpwv = 1.81e3)
      parameter (cpvir = cpwv/cpair -1.)

c .. thermal conductivity. QQ check units
      Real*8  kice           ! thermal conductivity of pure ice (W/m/K)
      Real*8  ksnow          ! thermal conductivity of snow (W/m/K)

      parameter (kice  = 2.03)
      parameter (ksnow = 0.30)

c .. heat transfer coefficient
      Real*8 transcoef       ! transfer coef between ice and water (unitless)
 
      parameter (transcoef=0.006)  !orginally 0.006

c .. latent heat
      Real*8  Lvap           ! latent heat of vaporizn at 0 C (J/kg)
      Real*8  Lfresh         ! latent heat of melting of pure ice (J/kg)

      parameter(Lvap = 2.5e+6)
      parameter (Lfresh = 3.34e5)

c.. Enthalpy
      Real*8  qsnow            ! snow enthalpy (J/kg)
      parameter (qsnow = Lfresh)

c .. Albedo
      Real*8  albsnodry                 ! albedo of dry snow (Tsfc < 0)
      Real*8  albsnowet                 ! albedo of melting snow (Tsfc = 0)
      Real*8  albicemax                 ! max albedo of bare ice
      Real*8  albicemin                 ! minimum ice albedo (thin melting ice)
      Real*8  halb                      ! melt rate parameter for albedo QQ units

      parameter (albsnodry = 0.85)
      parameter (albsnowet = 0.75)
      parameter (albicemax = 0.65)
      parameter (albicemin = 0.20)
      parameter (halb = .5)

c.. Solar parameters
      Real*8  i0             ! fraction of penetrating solar rad
      Real*8  ksolar         ! bulk solar abs coeff of sea ice (m-1)

      parameter (i0 = 0.3)        !QQQQQQ was 0.3    
      parameter (ksolar = 1.5)    !QQQQQQ was1.5


c .. Salinity
      Real*8  saltice                   ! salinity of ice (o/oo)
      Real*8  S_winton                  ! winton salinity of ice (o/oo)
      Real*8  mu_Tf                     ! Tf:brine salinity ratio (C/ppt)

      parameter (saltice  = 4.)
      parameter (S_winton = 1.)
      parameter (mu_Tf = 0.054)

c .. melting
      Real*8  Tf0kel         ! Freezing temp of fresh ice in Kelvin = 273.15
      Real*8  Tmlt1                     ! melting temp; depends on S (C)
 
      parameter (Tf0kel = 273.15)
      parameter (Tmlt1=-mu_Tf*S_winton)

c .. wind drag
c     cdrag_[n]    - n = 1,2,3 coefficients used to evaluate
c                    drag coefficient
      Real*8 cdrag_1,    cdrag_2,     cdrag_3 
       parameter ( cdrag_1     =       0.0027000,
     &            cdrag_2     =       0.0001420,
     &            cdrag_3     =       0.0000764)

c .. constants
      Real*8  stefan         ! Stefan-Boltzmann constant (W/m^2 K^4)
      Real*8  xkar           ! Von Karman constant  QQ units?
      Real*8  Rvap           ! gas constant for H2O vapor (J/kg/K)

      parameter (stefan = 5.67e-8)
      parameter (xkar =  0.4 ) 
      parameter(Rvap = 461.)

c.. Miscellaneous
      Real*8  p0             ! surface pressure (mb)

      parameter(p0 = 1013.)

c.. Combinations used for efficiency
      Real*8  rhoi_Lfresh    ! rhoi*Lfresh
      Real*8  Qcoef          ! another constant for latent heat flux
      Real*8  lvrrv          ! (Lvap + Lfresh) / Rvap

      parameter (rhoi_Lfresh = rhoi*Lfresh)
      parameter (Qcoef = 6.11*0.622/p0)
      parameter (lvrrv = (Lvap + Lfresh) / Rvap)

c .. Min/Max
      Real*8  himin          ! minimum thickness for ice (m)
      Real*8  Terrmax        ! temperature convergence precision (C)

      parameter (himin = 0.01)
      parameter (Terrmax = 2.0e-3)

c .. for bulk formula
      Real*8  humid_fac       ! const. for the evaluation of the virtual temp.
      Real*8  saltsat         ! reduction of sat. vapor pressure over salt water
      Real*8  gamma_blk       ! adiabatic lapse rate


      parameter (humid_fac   =  0.606)
      parameter (saltsat     =  0.980)
      parameter (gamma_blk   =  0.010)
    


c .. for Vince bulk formula QQ check units
      Real*8 Lvap_ice
      Real*8 Rgas
      Real*8 Sha

      parameter (Lvap_ice  = 2.83e6)   ! latent heat from sublimation
      parameter (Rgas      = 287.e0)   ! gas constant for dry air
      parameter (Sha       = Rgas/.286) !

c .. emissivities   QQQ find
      Real*8 atm_emissivity
      Real*8 ocean_emissivity
      Real*8 snow_emissivity
      Real*8 ice_emissivity
 
cQQQQQQ find real values
      parameter(atm_emissivity=.90d0)     !QQ
      parameter(ocean_emissivity=.985d0) !QQ
      parameter(snow_emissivity=1.d0) !QQ
      parameter(ice_emissivity=1.d0) !QQ

c     == function arguments ==
      Real*8 tkelvin
      Real*8 cvapor_fac, cvapor_exp
      cvapor_fac  =  640380.000
      cvapor_exp  =    5107.400
c
      exf_BulkqSat = cvapor_fac/exp(cvapor_exp/tkelvin)



      end



