C $Header: /u/u0/gcmpack/MITgcm/eesupp/src/main.F,v 1.9 2001/09/28 16:49:54 adcroft Exp $
C $Name: checkpoint46 $

CBOI
C
C !TITLE: WRAPPER CODE SYNOPSIS
C !AUTHORS: mitgcm developers ( support@mitgcm.org )
C !AFFILIATION: Massachussetts Institute of Technology
C !DATE:
C !INTRODUCTION: Wrapper synopsis and code
C Routines in the subdirectories under eesupp/ ( src/ and inc/ ) provide the core
C framework within which numerical and ancilliary software of MITgcm operates.
C The eesupp/ directories provide a collection of software we call {\bf WRAPPER} (
C ({\bf W}rappable {\bf A}pplication {\bf P}aralell {\bf P}rogramming {\bf E}nvironment {\bf R}esource).
C The {bf WRAPPER} provides a generic bootstrapping capability to start applications
C in a manner that allows them to exploit single and multi-processing environments on all present 
C day hardware platforms (spanning vector SMP systems to distributed memory and processing cluster
C systems). Numerical applications must be coded to fit within the {\bf WRAPPER}. This entails
C applications adopting a particular style for declaring data structures representing
C grids and values on grids. The {\bf WRAPPER} currently provides support for grid point
C models using a single global indexing system. This is sufficient for latitude-logitude,
C cylindrical, and cartesian coordinate configurations. There is also limited support for
C composing grids in which no single, sructured global index can be defined. At present, this 
C support is limited to specific configurations of projections of a cube onto the sphere.
C
C The main functions supported by the current {\bf WRAPPER} code are
C \begin{itemize}
C  \item program startup and termination including creation/management of multiple 
C        threads and/or processes
C  \item communication and synchronisatioin operations between multiple processes and/or threads 
C  \item multi-process input and output operations to disk and to other 
C  applications
C \end{itemize}
C
C Multi-process execution assumes the existence of MPI for process startup and termination. However,
C MPI does not have to be used for performance critical operations. Instead,
C {\bf WRAPPER} performance critical parallel primitives are implemented to allow them to bind to 
C different low-level system software layers. Bindings exist for using {\bf WRAPPER} with portable
C systems such as MPI and UNIX System V IPC memory mapping, as well bindings for high-performance 
C propreitary systems such as Myrinet GM software and Compaq IMC memory channel technology.
C 
CEOI


C--   Get C preprocessor options
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_OPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


cswdblk --- add ---
C o Include/exclude code for bulk formula


cswdice -- add ---
C o allow seaice

cswdice -- end add ---
C o try to conserve qnet and emp


cswdblk -- end add ---

C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_EEOPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C--   Control MPI based parallel processing





 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 
C--   Control use of "double" precision constants.
C     Use D0 where it means REAL*8 but not where it means REAL*16


C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.







C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name:  $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.




















C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.

 
C--   Control use of "double" precision constants.
C     Use d0 where it means REAL*8 but not where it means REAL*16


C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








C o Include/exclude code specific to the ECCO/SEALION version.


 
C o Enable/disable state import and export.




C Need to define byteswapio if using Lahey compiler (for ESMF lib built against Lahey)

C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_EEOPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/



C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name:  $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP



CBOP
C !ROUTINE: MAIN

C !INTERFACE:
      PROGRAM MAIN
      USE MITGCM_ORG_OCN, ONLY: OCN_INIT => DRIVER_INIT, OCN_RUN => DRIVER_RUN
      IMPLICIT NONE

C !DESCRIPTION:
C     *==========================================================*
C     | PROGRAM MAIN                                            
C     | o MAIN wrapper for MITgcm UV implementation.            
C     *==========================================================*
C     | MAIN controls the "execution environment".               
C     | Its main functions are                                   
C     | 1. call procedure EEBOOT to perform execution environment
C     |    initialisation.                                       
C     | 2. call procedure THE_MODEL_MAIN once for each concurrent
C     |    thread. THE_MODEL_MAIN is the user supplied top-level 
C     |    routine.                                              
C     | 3. call procedure EEDIE to perform execution environment 
C     |    shutdown.                                             
C     *==========================================================*

      CALL OCN_INIT
      CALL OCN_RUN

      END
