#!/bin/csh -f
#
# Script to create modules for an MITgcm production code instnace
# Run this script after the CPP stage of the standard genmake/genmake2 
# build
# 
# Script does following
# Selects a set of "module" files with the .f suffix. 
# The set of module files includes all the source files except
# main.f and a small number of runtime library files.
# The module file set is then placed within a module of a given name.
# 
#
# Needed interface routines
# eeboot_comp         - returns eeBootError and nThreads
# check_threads_comp  - needs to be given nThreads as an additonal argument
#                       and return eeBootError
# the_model_main_comp - needs to return threadIsComplete()
# eedie_comp          - needs to return fatalError
#
# 
# Set module prefix 
if ( $# == 1 ) then
set mpref_s = ( $1 )
else
set mpref_s = ( atm )
endif
set mpref_l = ( mitgcm_org_${mpref_s} )

# Set output directory
set outdir = ( mmout )

echo "Creating small f files"
make small_f

echo "Building list of .f files"
ls -1 *.f > flist
cp flist flist1
set mitgcmrtl   = ( mdsio_byteswapr4.f mdsio_byteswapr8.f fool_the_compiler.f )
set excludelist = ( main.f ${mitgcmrtl} )
foreach f ( $excludelist )
 cat flist1 | grep -v "^$f" > flist2
 cp flist2   flist1
end
cp flist1 flist
set flist = (`cat flist`)

echo "Joining .f into ${mpref_s}_mod.F"
\rm ${mpref_l}_mod.Ftmp ${mpref_l}_mod.F
foreach f ( $flist )
 cat $f >> ${mpref_l}_mod.Ftmp
 echo -n "."
end
echo " "

echo "Removing comments and blank lines"
cat ${mpref_l}_mod.Ftmp | grep -v '^ *$' | grep -v '^[a-zA-Z]' > ${mpref_l}_mod2.Ftmp

echo "Putting END SUBROUTINE at end of subroutines"
cat ${mpref_l}_mod2.Ftmp | awk -f print_sub.awk  > ${mpref_l}_mod3.Ftmp
cat <<EOF > ${mpref_l}_mod.Ftmp
      MODULE ${mpref_l}
      USE ESMF_MOD
      PRIVATE
      PUBLIC DRIVER_INIT
      PUBLIC DRIVER_RUN
      PUBLIC GET_DOMAIN_SIZE
      CONTAINS
EOF
cat ${mpref_l}_mod3.Ftmp >> ${mpref_l}_mod.Ftmp

# Remove EXTERNAL refs for functions
echo "Removing EXTERNAL refs for functions that are within the module"
set extDel = ( DIFFERENT_MULTIPLE IFNBLNK ILNBLNK TIMER_INDEX \
               IO_ERRCOUNT MDS_RECLEN PORT_RAND SBO_RHO NLATBND \
               EXF_BULKQSAT EXF_BULKCDN EXF_BULKRHN)
foreach e ( $extDel )
cat ${mpref_l}_mod.Ftmp | grep -iv "      EXTERNAL *${e}" > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
end

# Remove type declaarations for functions
echo "Removing type declarations for functions that are within the module"
cat ${mpref_l}_mod.Ftmp | grep -iv '      *LOGICAL *DIFFERENT_MULTIPLE' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *INTEGER *ILNBLNK' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *INTEGER *IFNBLNK' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *INTEGER *TIMER_INDEX' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *INTEGER *IO_ERRCOUNT' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *INTEGER *MDS_RECLEN' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *INTEGER *NLATBND' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *REAL\*8 *PORT_RAND' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *REAL\*8 *SBO_RHO' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *REAL\*8 *EXF_BULKQSAT' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *REAL\*8 *EXF_BULKCDN' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp
cat ${mpref_l}_mod.Ftmp | grep -iv '      *REAL\*8 *EXF_BULKRHN' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp

echo "Putting END FUNCTION at end of functions"
cat ${mpref_l}_mod2.Ftmp | awk -f print_func.awk > ${mpref_l}_mod4.Ftmp
cat ${mpref_l}_mod4.Ftmp >> ${mpref_l}_mod.Ftmp

cat <<EOF >> ${mpref_l}_mod.Ftmp
      END MODULE ${mpref_l}
EOF
# Change all the common block names in the module
# cat ${mpref_l}_mod.Ftmp | sed s'z\( *COMMON *[^/]*/ *\)\([^ ]*\)\( */.*\)z\1COMPOCEAN_\2\3z' >f1.Ftmp
cat ${mpref_l}_mod.Ftmp | sed s'z\( *COMMON[^/]*\)/\(.*\)/\([^/]*\)z      COMMON/C_'${mpref_s}'_\2/\3z' > f1.Ftmp
cp f1.Ftmp ${mpref_l}_mod.Ftmp

echo "Compiling code"
set comp     = /s/local/1/cnh/usr/local/pkg/lammpi/lam-7.0.3/lahey/bin/mpif77
set compopts = ( --dbl -O0 --fix --lst --xref --wide -I/s/local/1/cnh/usr/local/src/ESMF_1_0_4_withlam/esmf/mod/modO/Linux.lahey.32.default )
set complibs = ( -L/s/local/1/cnh/usr/local/src/ESMF_1_0_4_withlam/esmf/lib/libO/Linux.lahey.32.default -lesmf )

set comp     = /usr/local/pkg/mpi/mpi-1.2.4..8a-gm-1.5/pgi/bin/mpif90
set compopts = ( -r8 -Mfixed -Mextend -byteswapio )
set complibs = ( )

set comp     = /usr/local/pkg/mpi/mpich-1.2.5..10/lahey/bin/mpif90
set compopts = ( --dbl --o2 --fix --lst --xref --wide --tp4 )
#set compopts = ( --dbl --o0 --fix --lst --xref --wide --sav )
set complibs = ( -L/usr/local/pkg/ESMF/ESMF_1_0_4/mpich-1.2.5..10/lahey/lib/libO/Linux.lahey.32.default -lesmf )
set compinc  = ( -I/usr/local/pkg/ESMF/ESMF_1_0_4/mpich-1.2.5..10/lahey/mod/modO/Linux.lahey.32.default )
set compinc  = ( ${compinc} -I${BUILDROOT}/esmf_top )

#set compopts = ( -O0 --fix --lst --xref --wide  )
#set comp     = pgf90
#set compopts = ( -r8 -Mfixed -Mextend )

# Create output directory
mkdir mmout

# Create runtime library archive
set mitgcmrtlo = ( )
foreach f ( $mitgcmrtl )
 echo " " | $comp $compopts -c ${f}
 set mitgcmrtlo = ( $mitgcmrtlo ${f:r}.o )
end
gcc -c tim.c
set mitgcmrtlo = ( $mitgcmrtlo tim.o )
\rm mmout/libmitgcmrtl.a
ar -rc mmout/libmitgcmrtl.a $mitgcmrtlo
ranlib mmout/libmitgcmrtl.a

# Create component library archive
mv ${mpref_l}_mod.Ftmp ${mpref_l}_mod.F
echo " " | $comp $compopts -c ${mpref_l}_mod.F ${complibs} ${compinc}
mv ${mpref_l}_mod.F ${mpref_l}_mod.Ftmp
./template_comp.sh ${mpref_s}
gcc -c component_${mpref_s}_context.c
\rm mmout/lib${mpref_l}.a
ar -rc mmout/lib${mpref_l}.a ${mpref_l}_mod.o component_${mpref_s}_context.o
ranlib mmout/lib${mpref_l}.a
cp ${mpref_l}.mod mmout

\rm *mod
mv main.f main.F90
#echo $comp $compopts main.F90 ${mpref_l}_mod.o $mitgcmrtlo tim.o $complibs
#echo " " | $comp $compopts main.F90 ${mpref_l}_mod.o $mitgcmrtlo $complibs
#echo $comp $compopts main.F90 -Immout -Lmmout -l${mpref_l} -lmitgcmrtl $complibs
#echo " " | $comp $compopts main.F90 -Immout -Lmmout -l${mpref_l} -lmitgcmrtl $complibs
mv main.F90 main.f

# Lahey compiler command line
#  /usr/local/pkg/lammpi/lam-7.0.3/lahey/bin/mpif77  --dbl -O0 --fix --lst --xref --wide -I/s/local/1/cnh/usr/local/src/ESMF_1_0_4_withlam/esmf/mod/modO/Linux.lahey.32.default main.F90 ${mpref_l}_mod.o mdsio_byteswapr4.o mdsio_byteswapr8.o fool_the_compiler.o tim.o -L/home/cnh/src/ESMF_1_0_4_withlam/esmf/lib/libO/Linux.lahey.32.default -lesmf
# To run
#   /s/local/1/cnh/usr/local/pkg/lammpi/lam-7.0.3/lahey/bin/mpirun -np 4 -t -v  ../build/a.out
# To start lam daemon
#   /s/local/1/cnh/usr/local/pkg/lammpi/lam-7.0.3/lahey/bin/lamboot  -c /s/local/1/cnh/usr/local/pkg/lammpi/lam-7.0.3/lahey/etc/lam-conf.lamd -v -d
#  NB - for starting daemon you need "lamd" in your search path
