C $Header: /u/u0/gcmpack/MITgcm/pkg/mom_vecinv/mom_calc_tension.F,v 1.2 2001/11/27 15:50:01 adcroft Exp $
C $Name:  $

C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_OPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


cswdblk --- add ---
C o Include/exclude code for bulk formula


cswdice -- add ---
C o allow seaice

cswdice -- end add ---
C o try to conserve qnet and emp


cswdblk -- end add ---

C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_EEOPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C--   Control MPI based parallel processing





 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 
C--   Control use of "double" precision constants.
C     Use D0 where it means REAL*8 but not where it means REAL*16


C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.







C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name:  $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.




















C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.

 
C--   Control use of "double" precision constants.
C     Use d0 where it means REAL*8 but not where it means REAL*16


C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








C o Include/exclude code specific to the ECCO/SEALION version.


 
C o Enable/disable state import and export.




C Need to define byteswapio if using Lahey compiler (for ESMF lib built against Lahey)


CBOP
C !ROUTINE: MOM_CALC_TENSION

C !INTERFACE: ==========================================================
      SUBROUTINE MOM_CALC_TENSION( 
     I        bi,bj,k,
     I        uFld, vFld,
     O        tension,
     I        myThid)
C !DESCRIPTION:
C Calculates the tension of the horizontal flow field (at tracer points):
C \begin{equation*}
C D_T = \frac{\Delta y_f}{\Delta x_f} \delta_i \frac{u}{\Delta y_g}
C     - \frac{\Delta x_f}{\Delta y_f} \delta_j \frac{v}{\Delta x_g}
C \end{equation*}

C !USES: ===============================================================
      IMPLICIT NONE
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/SIZE.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | SIZE.h Declare size of underlying computational grid.    |
C     |==========================================================|
C     | The design here support a three-dimensional model grid   |
C     | with indices I,J and K. The three-dimensional domain     |
C     | is comprised of nPx*nSx blocks of size sNx along one axis|
C     | nPy*nSy blocks of size sNy along another axis and one    |
C     | block of size Nz along the final axis.                   |
C     | Blocks have overlap regions of size OLx and OLy along the|
C     | dimensions that are subdivided.                          |
C     \==========================================================/
C     Voodoo numbers controlling data layout.
C     sNx - No. X points in sub-grid.
C     sNy - No. Y points in sub-grid.
C     OLx - Overlap extent in X.
C     OLy - Overlat extent in Y.
C     nSx - No. sub-grids in X.
C     nSy - No. sub-grids in Y.
C     nPx - No. of processes to use in X.
C     nPy - No. of processes to use in Y.
C     Nx  - No. points in X for the total domain.
C     Ny  - No. points in Y for the total domain.
C     Nr  - No. points in Z for full process domain.
      INTEGER sNx
      INTEGER sNy
      INTEGER OLx
      INTEGER OLy
      INTEGER nSx
      INTEGER nSy
      INTEGER nPx
      INTEGER nPy
      INTEGER Nx
      INTEGER Ny
      INTEGER Nr
      PARAMETER (
     &           sNx = 128,
     &           sNy =   4,
C    &           sNy =   8,
C    &           sNy =  16,
C    &           sNy =  32,
C    &           sNy =  64,
     &           OLx =   3,
     &           OLy =   3,
     &           nSx =   1,
     &           nSy =   1,
     &           nPx =   1,
     &           nPy =  16,
C    &           nPy =   8,
C    &           nPy =   4,
C    &           nPy =   2,
C    &           nPy =   1,
     &           Nx  = sNx*nSx*nPx,
     &           Ny  = sNy*nSy*nPy,
     &           Nr  =  15)

C     MAX_OLX  - Set to the maximum overlap region size of any array
C     MAX_OLY    that will be exchanged. Controls the sizing of exch
C                routine buufers.
      INTEGER MAX_OLX
      INTEGER MAX_OLY
      PARAMETER ( MAX_OLX = OLx,
     &            MAX_OLY = OLy )

C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/EEPARAMS.h,v 1.10 2001/09/21 03:54:35 cnh Exp $
C $Name:  $
CBOP
C     !ROUTINE: EEPARAMS.h
C     !INTERFACE:
C     include "EEPARAMS.h"
C
C     !DESCRIPTION:
C     *==========================================================*
C     | EEPARAMS.h                                               |
C     *==========================================================*
C     | Parameters for "execution environemnt". These are used   |
C     | by both the particular numerical model and the "execution|
C     | environment" support routines.                           |
C     *==========================================================*
CEOP

C     MAX_LEN_MBUF         - Default message buffer max. size
C     MAX_LEN_FNAM         - Default file name max. size
C     MAX_LEN_PREC         - Default record length for reading "parameter" files
      INTEGER MAX_LEN_MBUF
      PARAMETER ( MAX_LEN_MBUF = 512 )
      INTEGER MAX_LEN_FNAM
      PARAMETER ( MAX_LEN_FNAM = 512 )
      INTEGER MAX_LEN_PREC
      PARAMETER ( MAX_LEN_PREC = 200 )

C     SQUEEZE_RIGHT       - Flag indicating right blank space removal
C                           from text field.
C     SQUEEZE_LEFT        - Flag indicating left blank space removal
C                           from text field.
C     SQUEEZE_BOTH        - Flag indicating left and right blank
C                           space removal from text field.
C     PRINT_MAP_XY        - Flag indicating to plot map as XY slices
C     PRINT_MAP_XZ        - Flag indicating to plot map as XZ slices
C     PRINT_MAP_YZ        - Flag indicating to plot map as YZ slices
C     commentCharacter    - Variable used in column 1 of parameter files to
C                           indicate comments.
C     INDEX_I             - Variable used to select an index label
C     INDEX_J               for formatted input parameters.
C     INDEX_K
C     INDEX_NONE
      CHARACTER*(*) SQUEEZE_RIGHT
      PARAMETER ( SQUEEZE_RIGHT = 'R' )
      CHARACTER*(*) SQUEEZE_LEFT
      PARAMETER ( SQUEEZE_LEFT = 'L' )
      CHARACTER*(*) SQUEEZE_BOTH
      PARAMETER ( SQUEEZE_BOTH = 'B' )
      CHARACTER*(*) PRINT_MAP_XY
      PARAMETER ( PRINT_MAP_XY = 'XY' )
      CHARACTER*(*) PRINT_MAP_XZ
      PARAMETER ( PRINT_MAP_XZ = 'XZ' )
      CHARACTER*(*) PRINT_MAP_YZ
      PARAMETER ( PRINT_MAP_YZ = 'YZ' )
      CHARACTER*(*) commentCharacter
      PARAMETER ( commentCharacter = '#' )
      INTEGER INDEX_I
      INTEGER INDEX_J
      INTEGER INDEX_K   
      INTEGER INDEX_NONE
      PARAMETER ( INDEX_I    = 1,
     &            INDEX_J    = 2,
     &            INDEX_K    = 3,
     &            INDEX_NONE = 4 )


C     EXCH_IGNORE_CORNERS - Flag to select ignoring or
C     EXCH_UPDATE_CORNERS   updating of corners during
C                           an edge exchange.
      INTEGER EXCH_IGNORE_CORNERS
      INTEGER EXCH_UPDATE_CORNERS
      PARAMETER ( EXCH_IGNORE_CORNERS = 0,
     &            EXCH_UPDATE_CORNERS = 1 )

C     FORWARD_SIMULATION
C     REVERSE_SIMULATION
      INTEGER FORWARD_SIMULATION
      INTEGER REVERSE_SIMULATION
      PARAMETER ( FORWARD_SIMULATION = 0,
     &            REVERSE_SIMULATION = 1 )


C     Particularly weird and obscure voodoo numbers
C     lShare  - This wants to be the length in
C               [148]-byte words of the size of
C               the address "window" that is snooped
C               on an SMP bus. By separating elements in
C               the global sum buffer we can avoid generating
C               extraneous invalidate traffic between
C               processors. The length of this window is usually
C               a cache line i.e. small O(64 bytes).
C               The buffer arrays are usually short arrays
C               and are declared REAL ARRA(lShare[148],LBUFF).
C               Setting lShare[148] to 1 is like making these arrays
C               one dimensional.
      INTEGER cacheLineSize
      INTEGER lShare1
      INTEGER lShare4
      INTEGER lShare8
      PARAMETER ( cacheLineSize = 256 )
      PARAMETER ( lShare1 =  cacheLineSize )
      PARAMETER ( lShare4 =  cacheLineSize/4 )
      PARAMETER ( lShare8 =  cacheLineSize/8 )

C     MAX_NO_THREADS  - Maximum number of threads allowed.
C     MAX_NO_PROCS    - Maximum number of processes allowed.
C     MAX_NO_BARRIERS - Maximum number of distinct thread "barriers"
      INTEGER MAX_NO_THREADS
      PARAMETER ( MAX_NO_THREADS =   32 )
      INTEGER MAX_NO_PROCS
      PARAMETER ( MAX_NO_PROCS   =  128 )
      INTEGER MAX_NO_BARRIERS
      PARAMETER ( MAX_NO_BARRIERS = 1 )

C--   COMMON /EEPARAMS_L/ Execution environment public logical variables.
C     eeBootError - Flag indicating error during multi-processing
C     eeEndError    initialisation/termination.
C     fatalError  - Flag used to indicate that the model is ended with
C                   an error
      COMMON /EEPARAMS_L/ eeBootError, fatalError, eeEndError,
     &  useCubedSphereExchange
      LOGICAL eeBootError
      LOGICAL eeEndError
      LOGICAL fatalError
      LOGICAL useCubedSphereExchange

C--   COMMON /EPARAMS_I/ Execution environment public integer variables.
C     errorMessageUnit    - Fortran IO unit for error messages
C     standardMessageUnit - Fortran IO unit for informational messages
C     scrUnit1      - Scratch file 1 unit number
C     scrUnit2      - Scratch file 2 unit number
C     eeDataUnit    - Unit number used for reading "execution environment" parameter file.
C     modelDataUnit - Unit number for reading "model" parameter file.
C     numberOfProcs - Number of processes computing in parallel
C     pidIO         - Id of process to use for I/O.
C     myBxLo, myBxHi - Extents of domain in blocks in X and Y
C     myByLo, myByHi   that each threads is responsble for.
C     myProcId      - My own "process" id.
C     myPx     - My X coord on the proc. grid.
C     myPy     - My Y coord on the proc. grid.
C     myXGlobalLo - My bottom-left (south-west) x-index
C                   global domain. The x-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     myYGlobalLo - My bottom-left (south-west) y-index in
C                   global domain. The y-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     nThreads    - No. of threads
C     nTx         - No. of threads in X
C     nTy         - No. of threads in Y
C                   This assumes a simple cartesian
C                   gridding of the threads which is not required elsewhere
C                   but that makes it easier.
C     ioErrorCount - IO Error Counter. Set to zero initially and increased
C                    by one every time an IO error occurs.
      COMMON /EEPARAMS_I/ errorMessageUnit, standardMessageUnit,
     & scrUnit1, scrUnit2, eeDataUnit, modelDataUnit,
     & numberOfProcs, pidIO, myProcId,
     & myPx, myPy, myXGlobalLo, myYGlobalLo, nThreads,
     & myBxLo, myBxHi, myByLo, myByHi,
     & nTx, nTy, ioErrorCount
      INTEGER eeDataUnit
      INTEGER errorMessageUnit
      INTEGER ioErrorCount(MAX_NO_THREADS)
      INTEGER modelDataUnit
      INTEGER myBxLo(MAX_NO_THREADS)
      INTEGER myBxHi(MAX_NO_THREADS)
      INTEGER myByLo(MAX_NO_THREADS)
      INTEGER myByHi(MAX_NO_THREADS)
      INTEGER myProcId
      INTEGER myPx
      INTEGER myPy
      INTEGER myXGlobalLo
      INTEGER myYGlobalLo
      INTEGER nThreads
      INTEGER nTx
      INTEGER nTy
      INTEGER numberOfProcs
      INTEGER pidIO
      INTEGER scrUnit1
      INTEGER scrUnit2
      INTEGER standardMessageUnit
C $Header: /u/u0/gcmpack/MITgcm/model/inc/PARAMS.h,v 1.67 2001/12/11 14:54:04 jmc Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: PARAMS.h
C    !INTERFACE:
C    include PARAMS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | PARAMS.h                                                  
C     | o Header file defining model "parameters".                
C     *==========================================================*
C     | The values from the model standard input file are         
C     | stored into the variables held here. Notes describing     
C     | the parameters can also be found here.                    
C     *==========================================================*
C     \ev
CEOP

C     Macros for special grid options
C $Header: /u/u0/gcmpack/MITgcm/model/inc/PARAMS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: PARAMS_MACROS.h
C    !INTERFACE:
C    include PARAMS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | PARAMS_MACROS.h                                           
C     *==========================================================*
C     | These macros are used to substitute definitions for       
C     | PARAMS.h variables for particular configurations.         
C     | In setting these variables the following convention       
C     | applies.                                                  
C     | define phi_CONST   - Indicates the variable phi is fixed  
C     |                      in X, Y and Z.                       
C     | define phi_FX      - Indicates the variable phi only      
C     |                      varies in X (i.e.not in X or Z).     
C     | define phi_FY      - Indicates the variable phi only      
C     |                      varies in Y (i.e.not in X or Z).     
C     | define phi_FXY     - Indicates the variable phi only      
C     |                      varies in X and Y ( i.e. not Z).     
C     *==========================================================*
C     \ev
CEOP




C $Header: /u/u0/gcmpack/MITgcm/model/inc/FCORI_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: FCORI_MACROS.h
C    !INTERFACE:
C    include FCORI_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | FCORI_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP












C--   Contants
C     Useful physical values
      Real*8 PI
      PARAMETER ( PI    = 3.14159265358979323844D0   )
      Real*8 deg2rad
      PARAMETER ( deg2rad = 2.D0*PI/360.D0           )

C     Symbolic values
C     precXXXX :: Used to indicate what precision to use for
C                dumping model state.
      INTEGER precFloat32
      PARAMETER ( precFloat32 = 32 )
      INTEGER precFloat64
      PARAMETER ( precFloat64 = 64 )
C     UNSET_xxx :: Used to indicate variables that have not been given a value
      Real*8 UNSET_FLOAT8
      PARAMETER ( UNSET_FLOAT8 = 1.234567D5 )
      Real*4 UNSET_FLOAT4
      PARAMETER ( UNSET_FLOAT4 = 1.234567E5 )
      Real*8    UNSET_RL    
      PARAMETER ( UNSET_RL     = 1.234567D5 )
      Real*8    UNSET_RS     
      PARAMETER ( UNSET_RS     = 1.234567E5 )
      INTEGER UNSET_I
      PARAMETER ( UNSET_I      = 123456789  )

C     Checkpoint data
      INTEGER maxNoChkptLev
      PARAMETER ( maxNoChkptLev = 2 )

C--   COMMON /PARM_C/ Character valued parameters used by the model.
C     checkPtSuff :: List of checkpoint file suffices
C     bathyFile   :: File containing bathymetry. If not defined bathymetry
C                   is taken from inline function.
C     topoFile    :: File containing the topography of the surface (unit=m)
C                   (mainly used for the atmosphere = ground height).
C     hydrogThetaFile :: File containing initial hydrographic data for potential
C                       temperature.
C     hydrogSaltFile  :: File containing initial hydrographic data for salinity.
C     zonalWindFile   :: File containing zonal wind data
C     meridWindFile   :: File containing meridional wind data
C     thetaClimFile   :: File containing theta climataology used
C                       in relaxation term -lambda(theta-theta*)
C     saltClimFile    :: File containing salt climataology used
C                       in relaxation term -lambda(salt-salt*)
C     surfQfile       :: File containing surface heat flux
C     surfQswfile     :: File containing surface shortwave radiation
C     dQdTfile        :: File containing thermal relaxation coefficient
C     EmPmRfile       :: File containing surface fresh water flux
C     buoyancyRelation :: Flag used to indicate which relation to use to
C                        get buoyancy.
      COMMON /PARM_C/ checkPtSuff,
     &                bathyFile, topoFile,
     &                hydrogThetaFile, hydrogSaltFile,
     &                zonalWindFile, meridWindFile, thetaClimFile,
     &                saltClimFile, buoyancyRelation,
     &                EmPmRfile, surfQfile, surfQswfile,
     &                uVelInitFile, vVelInitFile, pSurfInitFile,
     &                dQdTfile
      CHARACTER*(5) checkPtSuff(maxNoChkptLev)
      CHARACTER*(MAX_LEN_FNAM) bathyFile, topoFile
      CHARACTER*(MAX_LEN_FNAM) hydrogThetaFile
      CHARACTER*(MAX_LEN_FNAM) hydrogSaltFile
      CHARACTER*(MAX_LEN_FNAM) zonalWindFile
      CHARACTER*(MAX_LEN_FNAM) meridWindFile
      CHARACTER*(MAX_LEN_FNAM) thetaClimFile
      CHARACTER*(MAX_LEN_FNAM) saltClimFile
      CHARACTER*(MAX_LEN_FNAM) surfQfile
      CHARACTER*(MAX_LEN_FNAM) surfQswfile
      CHARACTER*(MAX_LEN_FNAM) EmPmRfile
      CHARACTER*(MAX_LEN_FNAM) buoyancyRelation
      CHARACTER*(MAX_LEN_FNAM) uVelInitFile
      CHARACTER*(MAX_LEN_FNAM) vVelInitFile
      CHARACTER*(MAX_LEN_FNAM) pSurfInitFile
      CHARACTER*(MAX_LEN_FNAM) dQdTfile

C--   COMMON /PARM_I/ Integer valued parameters used by the model.
C     cg2dMaxIters        :: Maximum number of iterations in the
C                           two-dimensional con. grad solver.
C     cg2dChkResFreq      :: Frequency with which to check residual
C                           in con. grad solver.
C     cg3dMaxIters        :: Maximum number of iterations in the
C                           three-dimensional con. grad solver.
C     cg3dChkResFreq      :: Frequency with which to check residual
C                           in con. grad solver.
C     nIter0              :: Start time-step number of for this run
C     nTimeSteps          :: Number of timesteps to execute
C     numStepsPerPickup   :: For offline setup. Frequency of pickup
C                           of flow fields.
C     writeStatePrec      :: Precision used for writing model state.
C     writeBinaryPrec     :: Precision used for writing binary files
C     readBinaryPrec      :: Precision used for reading binary files
C     nCheckLev           :: Holds current checkpoint level
C     nonlinFreeSurf      :: option related to non-linear free surface
C                           =0 Linear free surface ; >0 Non-linear

      COMMON /PARM_I/
     &        cg2dMaxIters,
     &        cg2dChkResFreq,
     &        cg3dMaxIters,
     &        cg3dChkResFreq,
     &        nIter0, nTimeSteps, nEndIter,
     &        numStepsPerPickup,
     &        writeStatePrec, nCheckLev,
     &        writeBinaryPrec, readBinaryPrec,
     &        nonlinFreeSurf,
     &        tempAdvScheme, saltAdvScheme, tracerAdvScheme
      INTEGER cg2dMaxIters
      INTEGER cg2dChkResFreq
      INTEGER cg3dMaxIters
      INTEGER cg3dChkResFreq
      INTEGER nIter0
      INTEGER nTimeSteps
      INTEGER nEndIter
      INTEGER numStepsPerPickup
      INTEGER writeStatePrec
      INTEGER writeBinaryPrec
      INTEGER readBinaryPrec
      INTEGER nCheckLev
      INTEGER nonlinFreeSurf
      INTEGER tempAdvScheme
      INTEGER saltAdvScheme
      INTEGER tracerAdvScheme

C--   COMMON /PARM_L/ Logical valued parameters used by the model.
C     usingCartesianGrid :: If TRUE grid generation will be in a cartesian
C                          coordinate frame.
C     usingSphericalPolarGrid :: If TRUE grid generation will be in a 
C                               spherical polar frame.
C     no_slip_sides :: Impose "no-slip" at lateral boundaries.
C     no_slip_bottom :: Impose "no-slip" at bottom boundary.
C     staggerTimeStep :: enable a Stagger time stepping T,S Rho then U,V
C     momViscosity  :: Flag which turns momentum friction terms on and off.
C     momAdvection  :: Flag which turns advection of momentum on and off.
C     momForcing    :: Flag which turns external forcing of momentum on
C                     and off.
C     momPressureForcing :: Flag which turns pressure term in momentum equation
C                          on and off.
C     metricTerms   :: Flag which turns metric terms on or off.
C     usingSphericalPolarMTerms :: If TRUE use spherical polar metric terms.
C     useCoriolis   :: Flag which turns the coriolis terms on and off.
C     tempDiffusion :: Flag which turns diffusion of temperature on
C                     and off.
C     tempAdvection :: Flag which turns advection of temperature on
C                     and off.
C     tempForcing   :: Flag which turns external forcing of temperature on
C                     and off.
C     saltDiffusion :: Flag which turns diffusion of salinit on
C                     and off.
C     saltAdvection :: Flag which turns advection of salinit on
C                     and off.
C     saltForcing   :: Flag which turns external forcing of salinit on
C                     and off.
C     rigidLid            :: Set to true to use rigid lid
C     implicitFreeSurface :: Set to true to use implcit free surface
C     exactConserv        :: Set to true to conserve exactly the total Volume
C     uniformLin_PhiSurf  :: Set to true to use a uniform Bo_surf in the
C                           linear relation Phi_surf = Bo_surf*eta
C     momStepping   :: Turns momentum equation time-stepping off
C     tempStepping  :: Turns temperature equation time-stepping off
C     saltStepping  :: Turns salinity equation time-stepping off
C     tr1Stepping   :: Turns passive tracer 1 time-stepping on/off
C     useConstantF  :: Coriolis parameter set to f0
C     useBetaPlaneF :: Coriolis parameter set to f0 + beta.y
C     useSphereF    :: Coriolis parameter set to 2.omega.sin(phi)
C     implicitDiffusion :: Turns implicit vertical diffusion on
C     implicitViscosity :: Turns implicit vertical viscosity on
C     doThetaClimRelax :: Set true if relaxation to temperature
C                        climatology is required.
C     doSaltClimRelax  :: Set true if relaxation to salinity
C                        climatology is required.
C     periodicExternalForcing :: Set true if forcing is time-dependant
C     usingPCoords     :: Set to indicate that we are working in pressure
C                        coords.
C     usingZCoords     :: Set to indicate that we are working in height
C                        coords.
C     nonHydrostatic :: Using non-hydrostatic terms
C     globalFiles    :: Selects between "global" and "tiled" files
C     allowFreezing  :: Allows water to freeze and form ice
C     groundAtK1  :: put the surface(k=1) at the Lower Boundary (=ground)
C     useJamartWetPoints :: Use wet-point method for Coriolis (Jamart and Ozer, 1986)
      COMMON /PARM_L/ usingCartesianGrid, usingSphericalPolarGrid,
     & usingCurvilinearGrid,
     & no_slip_sides,no_slip_bottom,
     & staggerTimeStep,
     & momViscosity, momAdvection, momForcing, useCoriolis, 
     & momPressureForcing, vectorInvariantMomentum,
     & tempDiffusion, tempAdvection, tempForcing,
     & saltDiffusion, saltAdvection, saltForcing,
     & rigidLid, implicitFreeSurface, exactConserv, uniformLin_PhiSurf,
     & momStepping, tempStepping, saltStepping, tr1Stepping,
     & metricTerms, usingSphericalPolarMTerms,
     & useConstantF, useBetaPlaneF, useSphereF,
     & implicitDiffusion, implicitViscosity,
     & doThetaClimRelax, doSaltClimRelax, doTr1ClimRelax, 
     & periodicExternalForcing, usingPCoords, usingZCoords,
     & nonHydrostatic, globalFiles,
     & allowFreezing, groundAtK1,
     & usePickupBeforeC35, debugMode,
     & readPickupWithTracer, writePickupWithTracer,
     & multiDimAdvection, useEnergyConservingCoriolis,
     & useJamartWetPoints
      LOGICAL usingCartesianGrid
      LOGICAL usingSphericalPolarGrid
      LOGICAL usingCurvilinearGrid
      LOGICAL usingSphericalPolarMTerms
      LOGICAL no_slip_sides
      LOGICAL no_slip_bottom
      LOGICAL staggerTimeStep
      LOGICAL momViscosity
      LOGICAL momAdvection
      LOGICAL momForcing
      LOGICAL momPressureForcing
      LOGICAL useCoriolis
      LOGICAL vectorInvariantMomentum
      LOGICAL tempDiffusion
      LOGICAL tempAdvection
      LOGICAL tempForcing
      LOGICAL saltDiffusion
      LOGICAL saltAdvection
      LOGICAL saltForcing
      LOGICAL rigidLid
      LOGICAL implicitFreeSurface
      LOGICAL exactConserv
      LOGICAL uniformLin_PhiSurf
      LOGICAL momStepping
      LOGICAL tempStepping
      LOGICAL saltStepping
      LOGICAL tr1Stepping
      LOGICAL metricTerms
      LOGICAL useConstantF
      LOGICAL useBetaPlaneF
      LOGICAL useSphereF
      LOGICAL implicitDiffusion
      LOGICAL implicitViscosity
      LOGICAL doThetaClimRelax
      LOGICAL doSaltClimRelax
      LOGICAL doTr1ClimRelax
      LOGICAL periodicExternalForcing
      LOGICAL usingPCoords
      LOGICAL usingZCoords
      LOGICAL nonHydrostatic
      LOGICAL globalFiles
      LOGICAL allowFreezing
      LOGICAL groundAtK1
      LOGICAL usePickupBeforeC35
      LOGICAL debugMode
      LOGICAL readPickupWithTracer
      LOGICAL writePickupWithTracer
      LOGICAL multiDimAdvection
      LOGICAL useEnergyConservingCoriolis
      LOGICAL useJamartWetPoints

C--   COMMON /PARM_R/ "Real" valued parameters used by the model.
C     gg2dTargetResidual
C          :: Target residual for cg2d solver; no unit (RHS normalisation)
C     cg2dTargetResWunit
C          :: Target residual for cg2d solver; W unit (No RHS normalisation)
C     cg3dTargetResidual
C               :: Target residual for cg3d solver.
C     cg2dpcOffDFac :: Averaging weight for preconditioner off-diagonal.
C     Note. 20th May 1998
C           I made a weird discovery! In the model paper we argue
C           for the form of the preconditioner used here ( see
C           A Finite-volume, Incompressible Navier-Stokes Model
C           ...., Marshall et. al ). The algebra gives a simple
C           0.5 factor for the averaging of ac and aCw to get a
C           symmettric pre-conditioner. By using a factor of 0.51
C           i.e. scaling the off-diagonal terms in the
C           preconditioner down slightly I managed to get the
C           number of iterations for convergence in a test case to
C           drop form 192 -> 134! Need to investigate this further!
C           For now I have introduced a parameter cg2dpcOffDFac which
C           defaults to 0.51 but can be set at runtime.
C     delP      :: Vertical grid spacing ( Pa ).
C     delZ      :: Vertical grid spacing ( m  ).
C     delR      :: Vertical grid spacing ( units of r ).
C     delX      :: Separation between cell faces (m) or (deg), depending
C     delY        on input flags.
C     gravity   :: Accel. due to gravity ( m/s^2 )
C     recip_gravity and its inverse
C     gBaro     :: Accel. due to gravity used in barotropic equation ( m/s^2 )
C     ronil     :: Reference density
C     rhoConst  :: Vertically constant reference density 
C     startTime :: Start time for model ( s )
C     phiMin    :: Latitude of southern most cell face.
C     thetaMin  :: Longitude of western most cell face (this
C                 is an "inert" parameter but it is included
C                 to make geographical references simple.)
C     rSphere   :: Radius of sphere for a spherical polar grid ( m ).
C     recip_RSphere  :: Reciprocal radius of sphere ( m ).
C     f0        :: Reference coriolis parameter ( 1/s )
C                 ( Southern edge f for beta plane )
C     beta      :: df/dy ( s^-1.m^-1 )
C     omega     :: Angular velocity ( rad/s )
C     viscAh    :: Eddy viscosity coeff. for mixing of
C                 momentum laterally ( m^2/s )
C     viscAz    :: Eddy viscosity coeff. for mixing of
C                 momentum vertically ( m^2/s )
C     viscAp    :: Eddy viscosity coeff. for mixing of
C                 momentum vertically ( Pa^2/s )
C     viscAr    :: Eddy viscosity coeff. for mixing of
C                 momentum vertically ( units of r^2/s )
C     viscA4    :: Biharmonic viscosity coeff. for mixing of
C                 momentum laterally ( m^4/s )
C     diffKhT   :: Laplacian diffusion coeff. for mixing of
C                 heat laterally ( m^2/s )
C     diffKzT   :: Laplacian diffusion coeff. for mixing of
C                 heat vertically ( m^2/s )
C     diffKpT   :: Laplacian diffusion coeff. for mixing of
C                 heat vertically ( Pa^2/s )
C     diffKrT   :: Laplacian diffusion coeff. for mixing of
C                 heat vertically ( units of r^2/s )
C     diffK4T   :: Biharmonic diffusion coeff. for mixing of
C                 heat laterally ( m^4/s )
C     diffKhS  ::  Laplacian diffusion coeff. for mixing of
C                 salt laterally ( m^2/s )
C     diffKzS   :: Laplacian diffusion coeff. for mixing of
C                 salt vertically ( m^2/s )
C     diffKpS   :: Laplacian diffusion coeff. for mixing of
C                 salt vertically ( Pa^2/s )
C     diffKrS   :: Laplacian diffusion coeff. for mixing of
C                 salt vertically ( units of r^2/s )
C     diffK4S   :: Biharmonic diffusion coeff. for mixing of
C                 salt laterally ( m^4/s )
C     deltaT    :: Default timestep ( s )
C     deltaTClock  :: Timestep used as model "clock". This determines the
C                    IO frequencies and is used in tagging output. It can
C                    be totally different to the dynamical time. Typically
C                    it will be the deep-water timestep for accelerated runs.
C                    Frequency of checkpointing and dumping of the model state
C                    are referenced to this clock. ( s )
C     deltaTMom    :: Timestep for momemtum equations ( s )
C     deltaTtracer :: Timestep for tracer equations ( s )
C     freesurfFac  :: Parameter to turn implicit free surface term on or off
C                    freesurfac = 1. uses implicit free surface
C                    freesurfac = 0. uses rigid lid
C     implicSurfPress :: parameter of the Crank-Nickelson time stepping :
C                     Implicit part of Surface Pressure Gradient ( 0-1 )
C     implicDiv2Dflow :: parameter of the Crank-Nickelson time stepping :
C                     Implicit part of barotropic flow Divergence ( 0-1 )
C     hFacMin      :: Minimum fraction size of a cell (affects hFacC etc...)
C     hFacMinDz    :: Minimum dimesional size of a cell (affects hFacC etc..., m)
C     hFacMinDp    :: Minimum dimesional size of a cell (affects hFacC etc..., Pa)
C     hFacMinDr    :: Minimum dimesional size of a cell (affects hFacC etc..., units of r)
C     hFacInf      :: Threshold (inf and sup) for fraction size of surface cell
C     hFacSup        that control vanishing and creating levels
C     tauCD        :: CD scheme coupling timescale ( 1/s )
C     rCD          :: CD scheme normalised coupling parameter ( 0-1 )
C     startTime     :: Starting time for this integration ( s ).
C     endTime       :: Ending time for this integration ( s ).
C     chkPtFreq     :: Frequency of rolling check pointing ( s ).
C     pChkPtFreq    :: Frequency of permanent check pointing ( s ).
C     dumpFreq      :: Frequency with which model state is written to
C                     post-processing files ( s ).
C     diagFreq      :: Frequency with which model writes diagnostic output
C                     of intermediate quantities.
C     afFacMom      :: Advection of momentum term tracer parameter
C     vfFacMom      :: Momentum viscosity tracer parameter
C     pfFacMom      :: Momentum pressure forcing tracer parameter
C     cfFacMom      :: Coriolis term tracer parameter
C     foFacMom      :: Momentum forcing tracer parameter
C     mtFacMom      :: Metric terms tracer parameter
C     cosPower      :: Power of cosine of latitude to multiply viscosity
C     cAdjFreq      :: Frequency of convective adjustment
C
C     taveFreq      :: Frequency with which time-averaged model state is written to
C                     post-processing files ( s ).
C     tauThetaClimRelax :: Relaxation to climatology time scale ( s ).
C     lambdaThetaClimRelax :: Inverse time scale for relaxation ( 1/s ).
C     tauSaltClimRelax :: Relaxation to climatology time scale ( s ).
C     lambdaSaltClimRelax :: Inverse time scale for relaxation ( 1/s ).
C     externForcingPeriod :: Is the period of which forcing varies (eg. 1 month)
C     externForcingCycle :: Is the repeat time of the forcing (eg. 1 year)
C                          (note: externForcingCycle must be an integer
C                           number times externForcingPeriod)
C     horiVertRatio      :: Ratio on units in vertical to units in horizontal.
C     recip_horiVertRatio  ( 1 if horiz in m and vertical in m ).
C                          ( g*rho if horiz in m and vertical in Pa ).
C     Ro_SeaLevel        :: standard position of Sea-Level in "R" coordinate, used as
C                          starting value (k=1) for vertical coordinate (rf(1)=Ro_SeaLevel)
C     bottomDragLinear   :: Drag coefficient built in to core dynamics
C      --"-"--  Quadratic  ( linear: 1/s, quadratic: 1/m )
      COMMON /PARM_R/ cg2dTargetResidual, cg2dTargetResWunit, 
     & cg2dpcOffDFac, cg3dTargetResidual,
     & delP, delZ, delR, delX, delY, 
     & deltaT,deltaTmom, deltaTtracer, deltaTClock,abeps, startTime, 
     & phiMin, thetaMin, rSphere, recip_RSphere, f0, beta,
     & fCori, fCoriG,
     & viscAh,  viscAz,  viscA4,  viscAr, viscAstrain, viscAtension,
     & diffKhT, diffKzT, diffK4T, diffKrT,
     & diffKhS, diffKzS, diffK4S, diffKrS,
     & delT, tauCD, rCD, freeSurfFac, implicSurfPress, implicDiv2Dflow,
     & hFacMin, hFacMinDz, hFacInf, hFacSup,
     & gravity, recip_Gravity, gBaro, rhonil, recip_rhonil, 
     & recip_rhoConst, rhoConst, tRef, sRef,
     & endTime, chkPtFreq, pchkPtFreq, dumpFreq,
     & diagFreq, taveFreq, monitorFreq,
     & afFacMom, vfFacMom, pfFacMom, cfFacMom, foFacMom, mtFacMom,
     & cosPower, cAdjFreq, omega, 
     & tauThetaClimRelax, lambdaThetaClimRelax,
     & tauSaltClimRelax, lambdaSaltClimRelax,
     & tauTr1ClimRelax, lambdaTr1ClimRelax,
     & externForcingCycle, externForcingPeriod,
     & viscAp, diffKpT, diffKpS, hFacMinDr, hFacMinDp,
     & theta_S, specVol_S, horiVertRatio, recip_horiVertRatio,
     & ivdc_kappa, Ro_SeaLevel,
     & bottomDragLinear,bottomDragQuadratic

      Real*8 cg2dTargetResidual
      Real*8 cg2dTargetResWunit
      Real*8 cg3dTargetResidual
      Real*8 cg2dpcOffDFac
      Real*8 delZ(Nr)
      Real*8 delP(Nr)
      Real*8 delR(Nr)
      Real*8 delX(Nx)
      Real*8 delY(Ny)
      Real*8 deltaT
      Real*8 deltaTClock
      Real*8 deltaTmom
      Real*8 deltaTtracer
      Real*8 abeps
      Real*8 phiMin
      Real*8 thetaMin
      Real*8 rSphere
      Real*8 recip_RSphere
      Real*8 f0
      Real*8 freeSurfFac
      Real*8 implicSurfPress
      Real*8 implicDiv2Dflow
      Real*8 hFacMin
      Real*8 hFacMinDz
      Real*8 hFacMinDp
      Real*8 hFacMinDr
      Real*8 hFacInf
      Real*8 hFacSup
      Real*8 beta
      Real*8 viscAh
      Real*8 viscAstrain
      Real*8 viscAtension
      Real*8 viscAz
      Real*8 viscAp
      Real*8 viscAr
      Real*8 viscA4 
      Real*8 diffKhT 
      Real*8 diffKrT
      Real*8 diffKzT
      Real*8 diffKpT
      Real*8 diffK4T 
      Real*8 diffKhS 
      Real*8 diffKrS
      Real*8 diffKzS
      Real*8 diffKpS
      Real*8 diffK4S 
      Real*8 delt
      Real*8 tauCD
      Real*8 rCD
      Real*8 gravity
      Real*8 recip_gravity
      Real*8 gBaro
      Real*8 rhonil
      Real*8 recip_rhonil
      Real*8 rhoConst
      Real*8 recip_rhoConst
      Real*8 specVol_S(Nr)
      Real*8 tRef(Nr)
      Real*8 theta_S(Nr)
      Real*8 sRef(Nr)
      Real*8 fCori(1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 fCoriG(1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 startTime
      Real*8 endTime
      Real*8 chkPtFreq
      Real*8 pChkPtFreq
      Real*8 dumpFreq
      Real*8 diagFreq
      Real*8 taveFreq
      Real*8 monitorFreq
      Real*8 afFacMom
      Real*8 vfFacMom
      Real*8 pfFacMom
      Real*8 cfFacMom
      Real*8 foFacMom
      Real*8 mTFacMom
      Real*8 cosPower
      Real*8 cAdjFreq
      Real*8 omega
      Real*8 tauThetaClimRelax
      Real*8 lambdaThetaClimRelax
      Real*8 tauSaltClimRelax
      Real*8 lambdaSaltClimRelax
      Real*8 tauTr1ClimRelax
      Real*8 lambdaTr1ClimRelax
      Real*8 externForcingCycle
      Real*8 externForcingPeriod
      Real*8 horiVertRatio
      Real*8 recip_horiVertRatio
      Real*8 ivdc_kappa
      Real*8 Ro_SeaLevel
      Real*8 bottomDragLinear
      Real*8 bottomDragQuadratic

      COMMON /PARM_A/ HeatCapacity_Cp,recip_Cp,
     &                Lamba_theta
      Real*8 HeatCapacity_Cp
      Real*8 Lamba_theta
      Real*8 recip_Cp

C Equation of State (polynomial coeffients)
      COMMON /PARM_EOS_NL/ eosC,eosSig0,eosRefT,eosRefS
      Real*8 eosC(9,Nr+1),eosSig0(Nr+1),eosRefT(Nr+1),eosRefS(Nr+1)
C Linear equation of state
C     tAlpha    :: Linear EOS thermal expansion coefficient ( 1/degree ).
C     sBeta     :: Linear EOS haline contraction coefficient.
      COMMON /PARM_EOS_LIN/ tAlpha,sBeta,eosType
      Real*8 tAlpha
      Real*8 sBeta
      character*(6) eosType

C Atmospheric physical parameters (Ideal Gas EOS, ...)
C     atm_po    :: standard reference pressure
C     atm_cp    :: specific heat (Cp) of the (dry) air at constant pressure
C     atm_kappa :: kappa = R/Cp (R: constant of Ideal Gas EOS)
C     Integr_GeoPot :: option to select the way we integrate the geopotential
C                     (still a subject of discussions ...) 
      COMMON /PARM_ATM/ atm_cp, atm_kappa, atm_po,
     &                  Integr_GeoPot
      Real*8 atm_cp, atm_kappa, atm_po
      INTEGER Integr_GeoPot

C Logical flags for selecting packages
      LOGICAL useKPP
      LOGICAL useGMRedi
      LOGICAL useOBCS
      LOGICAL useAIM
      LOGICAL useGrdchk
      LOGICAL useECCO
      LOGICAL useSHAP_FILT
      LOGICAL useZONAL_FILT
      LOGICAL useFLT
cswdblk -- add ---
      LOGICAL useBulkf
cswdblk --- end add ---
cswdice -- add ---
      LOGICAL useSeaIce
cswdice --- end add ---
cswdblk -- add useBulkf ---
cswdice -- add useSeaIce ---
      COMMON /PARM_PACKAGES/
     &        useKPP, useGMRedi, useOBCS, useAIM, useECCO, 
     &        useSHAP_FILT, useZONAL_FILT, useGrdchk, useFLT,
     &        useBulkf, useSeaIce

C $Header: /u/u0/gcmpack/MITgcm/model/inc/GRID.h,v 1.18 2001/11/08 16:34:57 jmc Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: GRID.h
C    !INTERFACE:
C    include GRID.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | GRID.h                                                    
C     | o Header file defining model grid.                        
C     *==========================================================*
C     | Model grid is defined for each process by reference to    
C     | the arrays set here.                                      
C     | Notes                                                     
C     | =====                                                     
C     | The standard MITgcm convention of westmost, southern most 
C     | and upper most having the (1,1,1) index is used here.     
C     | i.e.                                                      
C     |---------------------------------------------------------- 
C     | (1)  Plan view schematic of model grid (top layer i.e. )  
C     |      ================================= ( ocean surface )  
C     |                                        ( or top of     )  
C     |                                        ( atmosphere    )  
C     |      This diagram shows the location of the model         
C     |      prognostic variables on the model grid. The "T"      
C     |      location is used for all tracers. The figure also    
C     |      shows the southern most, western most indexing       
C     |      convention that is used for all model variables.     
C     |                                                           
C     |                                                           
C     |             V(i=1,                     V(i=Nx,            
C     |               j=Ny+1,                    j=Ny+1,          
C     |               k=1)                       k=1)             
C     |                /|\                       /|\  "PWX"       
C     |       |---------|------------------etc..  |---- *---      
C     |       |                     |                   *  |      
C     |"PWY"*******************************etc..  **********"PWY" 
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x           |             x     *==>U     
C     |  j=Ny,|      T(i=1,         |          T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=Ny,        |            j=Ny,  *  |j=Ny, 
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |                                                           
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       e                     e                   *  e      
C     |       t                     t                   *  t      
C     |       c                     c                   *  c      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x           |             x     *  |      
C     |  j=2, |      T(i=1,         |          T(i=Nx,  *  |      
C     |  k=1) |        j=2,         |            j=2,   *  |      
C     |       |        k=1)         |            k=1)   *  |      
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |      -----------|------------------etc..  |-----*---      
C     |       |       V(i=1,        |           V(i=Nx, *  |      
C     |       |         j=2,        |             j=2,  *  |      
C     |       |         k=1)        |             k=1)  *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=1,         |  k=1)      j=1,   *  |j=1,  
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |"SB"++>|---------|------------------etc..  |-----*---      
C     |      /+\      V(i=1,                    V(i=Nx, *         
C     |       +         j=1,                      j=1,  *         
C     |       +         k=1)                      k=1)  *         
C     |     "WB"                                      "PWX"       
C     |                                                           
C     |   N, y increasing northwards                              
C     |  /|\ j increasing northwards                              
C     |   |                                                       
C     |   |                                                       
C     |   ======>E, x increasing eastwards                        
C     |             i increasing eastwards                        
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    U: x-velocity (m/s)                                    
C     |    V: y-velocity (m/s)                                    
C     |    T: potential temperature (oC)                          
C     | "SB": Southern boundary                                   
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |"PWY": Periodic wrap around in Y.                          
C     |---------------------------------------------------------- 
C     | (2) South elevation schematic of model grid               
C     |     =======================================               
C     |     This diagram shows the location of the model          
C     |     prognostic variables on the model grid. The "T"       
C     |     location is used for all tracers. The figure also     
C     |     shows the upper most, western most indexing           
C     |     convention that is used for all model variables.      
C     |                                                           
C     |      "WB"                                                 
C     |       +                                                   
C     |       +                                                   
C     |      \+/       /|\                       /|\       .
C     |"UB"++>|-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=1)        |             k=1)  *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=1,         |  k=1)      j=1,   *  |j=1,  
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |       |-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=2)        |             k=2)  *  |      
C     |                                                           
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       e                     e                   *  e      
C     |       t                     t                   *  t      
C     |       c                     c                   *  c      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |       |-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=Nr)       |             k=Nr) *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=Nr)|        j=1,         |  k=Nr)     j=1,   *  |j=1,  
C     |       |        k=Nr)        |            k=Nr)  *  |k=Nr) 
C     |       |                     |                   *  |      
C     |"LB"++>==============================================      
C     |                                               "PWX"       
C     |                                                           
C     | Up   increasing upwards.                                  
C     |/|\                                                       .
C     | |                                                         
C     | |                                                         
C     | =====> E  i increasing eastwards                          
C     | |         x increasing eastwards                          
C     | |                                                         
C     |\|/                                                        
C     | Down,k increasing downwards.                              
C     |                                                           
C     | Note: r => height (m) => r increases upwards              
C     |       r => pressure (Pa) => r increases downwards         
C     |                                                           
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    U: x-velocity (m/s)                                    
C     | rVel: z-velocity ( units of r )                           
C     |       The vertical velocity variable rVel is in units of  
C     |       "r" the vertical coordinate. r in m will give       
C     |       rVel m/s. r in Pa will give rVel Pa/s.              
C     |    T: potential temperature (oC)                          
C     | "UB": Upper boundary.                                     
C     | "LB": Lower boundary (always solid - therefore om|w == 0) 
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |---------------------------------------------------------- 
C     | (3) Views showing nomenclature and indexing               
C     |     for grid descriptor variables.                        
C     |                                                           
C     |      Fig 3a. shows the orientation, indexing and          
C     |      notation for the grid spacing terms used internally  
C     |      for the evaluation of gradient and averaging terms.  
C     |      These varaibles are set based on the model input     
C     |      parameters which define the model grid in terms of   
C     |      spacing in X, Y and Z.                               
C     |                                                           
C     |      Fig 3b. shows the orientation, indexing and          
C     |      notation for the variables that are used to define   
C     |      the model grid. These varaibles are set directly     
C     |      from the model input.                                
C     |                                                           
C     | Figure 3a                                                 
C     | =========                                                 
C     |       |------------------------------------               
C     |       |                       |                           
C     |"PWY"********************************* etc...              
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |                                                           
C     |       .                       .                           
C     |       .                       .                           
C     |       .                       .                           
C     |       e                       e                           
C     |       t                       t                           
C     |       c                       c                           
C     |       |-----------v-----------|-----------v----------|-   
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       u<--dxF(i=1,j=2,k=1)--->u           t          |    
C     |       |/|\       /|\          |                      |    
C     |       | |         |           |                      |    
C     |       | |         |           |                      |    
C     |       | |         |           |                      |    
C     |       |dyU(i=1,  dyC(i=1,     |                      |    
C     | ---  ---|--j=2,---|--j=2,-----------------v----------|-   
C     | /|\   | |  k=1)   |  k=1)     |          /|\         |    
C     |  |    | |         |           |          dyF(i=2,    |    
C     |  |    | |         |           |           |  j=1,    |    
C     |dyG(   |\|/       \|/          |           |  k=1)    |    
C     |   i=1,u---        t<---dxC(i=2,j=1,k=1)-->t          |    
C     |   j=1,|                       |           |          |    
C     |   k=1)|                       |           |          |    
C     |  |    |                       |           |          |    
C     |  |    |                       |           |          |    
C     | \|/   |           |<---dxV(i=2,j=1,k=1)--\|/         |    
C     |"SB"++>|___________v___________|___________v__________|_   
C     |       <--dxG(i=1,j=1,k=1)----->                           
C     |      /+\                                              .
C     |       +                                                   
C     |       +                                                   
C     |     "WB"                                                  
C     |                                                           
C     |   N, y increasing northwards                              
C     |  /|\ j increasing northwards                              
C     |   |                                                       
C     |   |                                                       
C     |   ======>E, x increasing eastwards                        
C     |             i increasing eastwards                        
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    u: x-velocity point                                    
C     |    V: y-velocity point                                    
C     |    t: tracer point                                        
C     | "SB": Southern boundary                                   
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |"PWY": Periodic wrap around in Y.                          
C     |                                                           
C     | Figure 3b                                                 
C     | =========                                                 
C     |                                                           
C     |       .                       .                           
C     |       .                       .                           
C     |       .                       .                           
C     |       e                       e                           
C     |       t                       t                           
C     |       c                       c                           
C     |       |-----------v-----------|-----------v--etc...       
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       u<--delX(i=1)---------->u           t               
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |-----------v-----------------------v--etc...       
C     |       |          /|\          |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       u        delY(j=1)      |           t               
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |          \|/          |                           
C     |"SB"++>|___________v___________|___________v__etc...       
C     |      /+\                                                 .
C     |       +                                                   
C     |       +                                                   
C     |     "WB"                                                  
C     |                                                           
C     *==========================================================*
C     \ev
CEOP

C     Macros that override/modify standard definitions
C $Header: /u/u0/gcmpack/MITgcm/model/inc/GRID_MACROS.h,v 1.12 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: GRID_MACROS.h
C    !INTERFACE:
C    include GRID_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | GRID_MACROS.h                                             
C     *==========================================================*
C     | These macros are used to substitute definitions for       
C     | GRID.h variables for particular configurations.           
C     | In setting these variables the following convention       
C     | applies.                                                  
C     | undef  phi_CONST   - Indicates the variable phi is fixed  
C     |                      in X, Y and Z.                       
C     | undef  phi_FX      - Indicates the variable phi only      
C     |                      varies in X (i.e.not in X or Z).     
C     | undef  phi_FY      - Indicates the variable phi only      
C     |                      varies in Y (i.e.not in X or Z).     
C     | undef  phi_FXY     - Indicates the variable phi only      
C     |                      varies in X and Y ( i.e. not Z).     
C     *==========================================================*
C     \ev
CEOP




C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXC_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXC_MACROS.h
C    !INTERFACE:
C    include DXC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXC_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXF_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXF_MACROS.h
C    !INTERFACE:
C    include DXF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXF_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXG_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXG_MACROS.h
C    !INTERFACE:
C    include DXG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXG_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXV_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXV_MACROS.h
C    !INTERFACE:
C    include DXV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXV_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYC_MACROS.h
C    !INTERFACE:
C    include DYC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYC_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYF_MACROS.h
C    !INTERFACE:
C    include DYF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYF_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYG_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYG_MACROS.h
C    !INTERFACE:
C    include DYG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYG_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYU_MACROS.h
C    !INTERFACE:
C    include DYU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYU_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: HFACC_MACROS.h
C    !INTERFACE:
C    include HFACC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACC_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: HFACS_MACROS.h
C    !INTERFACE:
C    include HFACS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACS_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: HFACW_MACROS.h
C    !INTERFACE:
C    include HFACW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACW_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXC_MACROS.h
C    !INTERFACE:
C    include RECIP_DXC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXC_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXF_MACROS.h
C    !INTERFACE:
C    include RECIP_DXF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXF_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXG_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXG_MACROS.h
C    !INTERFACE:
C    include RECIP_DXG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXG_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXV_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXV_MACROS.h
C    !INTERFACE:
C    include RECIP_DXV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXV_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYC_MACROS.h
C    !INTERFACE:
C    include RECIP_DYC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYC_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYF_MACROS.h
C    !INTERFACE:
C    include RECIP_DYF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYF_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYG_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYG_MACROS.h
C    !INTERFACE:
C    include RECIP_DYG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYG_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYU_MACROS.h
C    !INTERFACE:
C    include RECIP_DYU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYU_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_HFACC_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACC_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_HFACS_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACS_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_HFACW_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACW_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/XC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: XC_MACROS.h
C    !INTERFACE:
C    include XC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | XC_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/YC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: YC_MACROS.h
C    !INTERFACE:
C    include YC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | YC_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RA_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RA_MACROS.h
C    !INTERFACE:
C    include RA_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RA_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP










C $Header: /u/u0/gcmpack/MITgcm/model/inc/RAW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RAW_MACROS.h
C    !INTERFACE:
C    include RAW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RAW_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP










C $Header: /u/u0/gcmpack/MITgcm/model/inc/RAS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RAS_MACROS.h
C    !INTERFACE:
C    include RAS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RAS_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/MASKW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: MASKW_MACROS.h
C    !INTERFACE:
C    include MASKW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | MASKW_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/MASKS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: MASKS_MACROS.h
C    !INTERFACE:
C    include MASKS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | MASKS_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/TANPHIATU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: TANPHIATU_MACROS.h
C    !INTERFACE:
C    include TANPHIATU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | TANPHIATU_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/TANPHIATV_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: TANPHIATV_MACROS.h
C    !INTERFACE:
C    include TANPHIATV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | TANPHIATV_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP











C
C--   COMMON /GRID_R/ REAL valued grid defining variables.
C     dxC    - Cell center separation in X across western cell wall (m)
C     dxG    - Cell face separation in X along southern cell wall (m)
C     dxF    - Cell face separation in X thru cell center (m)
C     dxV    - V-point separation in X across south-west corner of cell (m)
C     dyC    - Cell center separation in Y across southern cell wall (m)
C     dyG    - Cell face separation in Y along western cell wall (m)
C     dyF    - Cell face separation in Y thru cell center (m)
C     dyU    - U-point separation in Y across south-west corner of cell (m)
C     drC    - Cell center separation along Z axis ( units of r ).
C     drF    - Cell face separation along Z axis ( units of r ).
C     Rcolumn  -Total thickness (in r_unit) of the fluid column
C     R_low  - base of fluid in r_unit (Depth(m) / Pressure(Pa) at top Atmos.)
C     Ro_surf- surface reference (at rest) position, r_unit.
C     hFac   - Fraction of cell in vertical which is open i.e how 
C              "lopped" a cell is (dimensionless scale factor).
C              Note: The code needs terms like MIN(hFac,hFac(I+1))
C                    On some platforms it may be better to precompute
C                    hFacW, hFacE, ... here than do MIN on the fly.
C     rkFac     - Vertical coordinate to vertical index orientation.
C                 ( -1 same orientation, 1 opposite orientation )
C                 ( vertical coord == m  -> rkFac =  1 )
C                 ( vertical coord == Pa -> rkFac = -1 )
C     maskH  - cell Center full-column mask (= 2D mask)
C     maskC  - cell Center land mask
C     maskW  - West face land mask
C     maskS  - South face land mask
C     recip_dxC   - Recipricol of dxC
C     recip_dxG   - Recipricol of dxG
C     recip_dxF   - Recipricol of dxF
C     recip_dxV   - Recipricol of dxV
C     recip_dyC   - Recipricol of dxC
C     recip_dyG   - Recipricol of dyG
C     recip_dyF   - Recipricol of dyF
C     recip_dyU   - Recipricol of dyU
C     recip_drC   - Recipricol of drC
C     recip_drF   - Recipricol of drF
C     recip_Rcol  - Inverse of cell center column thickness (1/r_unit)
C     recip_hFacC - Inverse of cell open-depth f[X,Y,Z] ( dimensionless ).
C     recip_hFacW   rhFacC center, rhFacW west, rhFacS south.
C     recip_hFacS   Note: This is precomputed here because it involves division.
C     saFac  - Shallow atmosphere factor (dimensionless scale factor).
C     xC     - X-coordinate of center of cell f[X,Y]. The units of xc, yc
C              depend on the grid. They are not used in differencing or
C              averaging but are just a convient quantity for I/O,
C              diagnostics etc.. As such xc is in m for cartesian 
C              coordinates but degrees for spherical polar.
C     yC     - Y-coordinate of center of cell f[X,Y].
C     yG     - Y-coordinate of corner of cell ( c-grid vorticity point) f[X,Y]. 
C     xC0, yC0 - West edge x coord  ( metres or degrees )
C                South edge y coord ( metres or degrees )
C     rA     - R-face are f[X,Y] ( m^2 ).
C              Note: In a cartesian framework zA is simply dx*dy,
C                    however we use zA to allow for non-globally
C                    orthogonal coordinate frames (with appropriate
C                    metric terms).
C     rC     - R-coordinate of center of cell f[Z] (units of r).
C     rF     - R-coordinate of face of cell f[Z] (units of r).
C     tanPhiAtU - tan of the latitude at U point. Used for spherical polar 
C                 metric term in U equation.
C     tanPhiAtV - tan of the latitude at V point. Used for spherical polar 
C                 metric term in V equation.
      COMMON /GRID_R/
     &  dxC,dxF,dxG,dxV,dyC,dyF,dyG,dyU,
     &  R_low,Ro_surf,HFacC,HFacW,HFacS,
     &  recip_dxC,recip_dxF,recip_dxG,recip_dxV,
     &  recip_dyC,recip_dyF,recip_dyG,recip_dyU,
     &  recip_Rcol, 
     &  recip_hFacC,recip_hFacW,recip_hFacS, 
     &  saFac,
     &  xC,yC,rA,rAw,rAs,rAz,xG,yG,
     &  maskH, maskC,maskW,maskS,
     &  recip_rA,recip_rAw,recip_rAs,recip_rAz,
     &  tanPhiAtU, tanPhiAtV,
     &  cosfacU,cosfacV,sqcosfacU,sqcosfacV,
     &  drC,drF,recip_drC,recip_drF,rC,rF,
     &  rkFac, recip_rkFac, xC0, yC0
      Real*8 dxC            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxF            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxG            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxV            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyC            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyF            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyG            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyU            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 R_low          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 Ro_surf        (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 HFacC          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 HFacW          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 HFacS          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_dxC      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxF      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxG      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxV      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyC      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyF      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyG      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyU      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_Rcol     (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_hFacC    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_hFacW    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_hFacS    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 xC             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 xG             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 yC             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 yG             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rA             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAw            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAs            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAz            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rA       (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAw      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAs      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAz      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 maskH          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 maskC          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 maskW          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 maskS          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 tanPhiAtU      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 tanPhiAtV      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 cosfacU(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 cosfacV(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 sqcosfacU(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 sqcosfacV(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 drC            (1:Nr)
      Real*8 drF            (1:Nr)
      Real*8 recip_drC      (1:Nr)
      Real*8 recip_drF      (1:Nr)
      Real*8 saFac          (1:Nr)
      Real*8 rC             (1:Nr)
      Real*8 rF             (1:Nr+1)
      Real*8 rkFac
      Real*8 recip_rkFac
      Real*8 xC0
      Real*8 yC0



C !INPUT PARAMETERS: ===================================================
C  bi,bj                :: tile indices
C  k                    :: vertical level
C  uFld                 :: zonal flow
C  vFld                 :: meridional flow
C  myThid               :: thread number
      INTEGER bi,bj,k
      Real*8 uFld(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      Real*8 vFld(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      INTEGER myThid

C !OUTPUT PARAMETERS: ==================================================
C  tension              :: tension of horizontal flow
      Real*8 tension(1-OLx:sNx+OLx,1-OLy:sNy+OLy)

C !LOCAL VARIABLES: ====================================================
C  i,j                  :: loop indices
      INTEGER i,j
CEOP

      DO j=1-Oly,sNy+Oly-1
       DO i=1-Olx,sNx+Olx-1

C Calculate tension of horizontal flow (ignoring lopping factors)
C *NOTE* that masking is implicit in the contents of the (u,v) fields.
        tension(i,j)= 
     &    (dyf(i,j,bi,bj)*recip_dxf(i,j,bi,bj))
     &   *( uFld(i+1, j )*recip_dyg(i+1, j ,bi,bj)
     &     -uFld( i , j )*recip_dyg( i , j ,bi,bj) )
     &   -(dxf(i,j,bi,bj)*recip_dyf(i,j,bi,bj))
     &   *( vFld( i ,j+1)*recip_dxg( i ,j+1,bi,bj)
     &     -vFld( i , j )*recip_dxg( i , j ,bi,bj) )

       ENDDO
      ENDDO
        
      RETURN
      END
