C $Header: /u/u0/gcmpack/MITgcm/pkg/mom_vecinv/mom_vi_u_grad_ke.F,v 1.2 2001/05/29 14:01:39 adcroft Exp $
C $Name:  $

C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_OPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


cswdblk --- add ---
C o Include/exclude code for bulk formula


cswdice -- add ---
C o allow seaice

cswdice -- end add ---
C o try to conserve qnet and emp


cswdblk -- end add ---

C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_EEOPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C--   Control MPI based parallel processing





 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 
C--   Control use of "double" precision constants.
C     Use D0 where it means REAL*8 but not where it means REAL*16


C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.







C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name:  $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.




















C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.

 
C--   Control use of "double" precision constants.
C     Use d0 where it means REAL*8 but not where it means REAL*16


C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








C o Include/exclude code specific to the ECCO/SEALION version.


 
C o Enable/disable state import and export.




C Need to define byteswapio if using Lahey compiler (for ESMF lib built against Lahey)


      SUBROUTINE MOM_VI_U_GRAD_KE( 
     I        bi,bj,K,
     I        KE,
     O        dKEdx,
     I        myThid)
      IMPLICIT NONE
C     /==========================================================C     | S/R MOM_U_GRAD_KE                                        |
C     |==========================================================|
C     \==========================================================/

C     == Global variables ==
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/SIZE.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | SIZE.h Declare size of underlying computational grid.    |
C     |==========================================================|
C     | The design here support a three-dimensional model grid   |
C     | with indices I,J and K. The three-dimensional domain     |
C     | is comprised of nPx*nSx blocks of size sNx along one axis|
C     | nPy*nSy blocks of size sNy along another axis and one    |
C     | block of size Nz along the final axis.                   |
C     | Blocks have overlap regions of size OLx and OLy along the|
C     | dimensions that are subdivided.                          |
C     \==========================================================/
C     Voodoo numbers controlling data layout.
C     sNx - No. X points in sub-grid.
C     sNy - No. Y points in sub-grid.
C     OLx - Overlap extent in X.
C     OLy - Overlat extent in Y.
C     nSx - No. sub-grids in X.
C     nSy - No. sub-grids in Y.
C     nPx - No. of processes to use in X.
C     nPy - No. of processes to use in Y.
C     Nx  - No. points in X for the total domain.
C     Ny  - No. points in Y for the total domain.
C     Nr  - No. points in Z for full process domain.
      INTEGER sNx
      INTEGER sNy
      INTEGER OLx
      INTEGER OLy
      INTEGER nSx
      INTEGER nSy
      INTEGER nPx
      INTEGER nPy
      INTEGER Nx
      INTEGER Ny
      INTEGER Nr
      PARAMETER (
     &           sNx = 128,
     &           sNy =   4,
C    &           sNy =   8,
C    &           sNy =  16,
C    &           sNy =  32,
C    &           sNy =  64,
     &           OLx =   3,
     &           OLy =   3,
     &           nSx =   1,
     &           nSy =   1,
     &           nPx =   1,
     &           nPy =  16,
C    &           nPy =   8,
C    &           nPy =   4,
C    &           nPy =   2,
C    &           nPy =   1,
     &           Nx  = sNx*nSx*nPx,
     &           Ny  = sNy*nSy*nPy,
     &           Nr  =  15)

C     MAX_OLX  - Set to the maximum overlap region size of any array
C     MAX_OLY    that will be exchanged. Controls the sizing of exch
C                routine buufers.
      INTEGER MAX_OLX
      INTEGER MAX_OLY
      PARAMETER ( MAX_OLX = OLx,
     &            MAX_OLY = OLy )

C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/EEPARAMS.h,v 1.10 2001/09/21 03:54:35 cnh Exp $
C $Name:  $
CBOP
C     !ROUTINE: EEPARAMS.h
C     !INTERFACE:
C     include "EEPARAMS.h"
C
C     !DESCRIPTION:
C     *==========================================================*
C     | EEPARAMS.h                                               |
C     *==========================================================*
C     | Parameters for "execution environemnt". These are used   |
C     | by both the particular numerical model and the "execution|
C     | environment" support routines.                           |
C     *==========================================================*
CEOP

C     MAX_LEN_MBUF         - Default message buffer max. size
C     MAX_LEN_FNAM         - Default file name max. size
C     MAX_LEN_PREC         - Default record length for reading "parameter" files
      INTEGER MAX_LEN_MBUF
      PARAMETER ( MAX_LEN_MBUF = 512 )
      INTEGER MAX_LEN_FNAM
      PARAMETER ( MAX_LEN_FNAM = 512 )
      INTEGER MAX_LEN_PREC
      PARAMETER ( MAX_LEN_PREC = 200 )

C     SQUEEZE_RIGHT       - Flag indicating right blank space removal
C                           from text field.
C     SQUEEZE_LEFT        - Flag indicating left blank space removal
C                           from text field.
C     SQUEEZE_BOTH        - Flag indicating left and right blank
C                           space removal from text field.
C     PRINT_MAP_XY        - Flag indicating to plot map as XY slices
C     PRINT_MAP_XZ        - Flag indicating to plot map as XZ slices
C     PRINT_MAP_YZ        - Flag indicating to plot map as YZ slices
C     commentCharacter    - Variable used in column 1 of parameter files to
C                           indicate comments.
C     INDEX_I             - Variable used to select an index label
C     INDEX_J               for formatted input parameters.
C     INDEX_K
C     INDEX_NONE
      CHARACTER*(*) SQUEEZE_RIGHT
      PARAMETER ( SQUEEZE_RIGHT = 'R' )
      CHARACTER*(*) SQUEEZE_LEFT
      PARAMETER ( SQUEEZE_LEFT = 'L' )
      CHARACTER*(*) SQUEEZE_BOTH
      PARAMETER ( SQUEEZE_BOTH = 'B' )
      CHARACTER*(*) PRINT_MAP_XY
      PARAMETER ( PRINT_MAP_XY = 'XY' )
      CHARACTER*(*) PRINT_MAP_XZ
      PARAMETER ( PRINT_MAP_XZ = 'XZ' )
      CHARACTER*(*) PRINT_MAP_YZ
      PARAMETER ( PRINT_MAP_YZ = 'YZ' )
      CHARACTER*(*) commentCharacter
      PARAMETER ( commentCharacter = '#' )
      INTEGER INDEX_I
      INTEGER INDEX_J
      INTEGER INDEX_K   
      INTEGER INDEX_NONE
      PARAMETER ( INDEX_I    = 1,
     &            INDEX_J    = 2,
     &            INDEX_K    = 3,
     &            INDEX_NONE = 4 )


C     EXCH_IGNORE_CORNERS - Flag to select ignoring or
C     EXCH_UPDATE_CORNERS   updating of corners during
C                           an edge exchange.
      INTEGER EXCH_IGNORE_CORNERS
      INTEGER EXCH_UPDATE_CORNERS
      PARAMETER ( EXCH_IGNORE_CORNERS = 0,
     &            EXCH_UPDATE_CORNERS = 1 )

C     FORWARD_SIMULATION
C     REVERSE_SIMULATION
      INTEGER FORWARD_SIMULATION
      INTEGER REVERSE_SIMULATION
      PARAMETER ( FORWARD_SIMULATION = 0,
     &            REVERSE_SIMULATION = 1 )


C     Particularly weird and obscure voodoo numbers
C     lShare  - This wants to be the length in
C               [148]-byte words of the size of
C               the address "window" that is snooped
C               on an SMP bus. By separating elements in
C               the global sum buffer we can avoid generating
C               extraneous invalidate traffic between
C               processors. The length of this window is usually
C               a cache line i.e. small O(64 bytes).
C               The buffer arrays are usually short arrays
C               and are declared REAL ARRA(lShare[148],LBUFF).
C               Setting lShare[148] to 1 is like making these arrays
C               one dimensional.
      INTEGER cacheLineSize
      INTEGER lShare1
      INTEGER lShare4
      INTEGER lShare8
      PARAMETER ( cacheLineSize = 256 )
      PARAMETER ( lShare1 =  cacheLineSize )
      PARAMETER ( lShare4 =  cacheLineSize/4 )
      PARAMETER ( lShare8 =  cacheLineSize/8 )

C     MAX_NO_THREADS  - Maximum number of threads allowed.
C     MAX_NO_PROCS    - Maximum number of processes allowed.
C     MAX_NO_BARRIERS - Maximum number of distinct thread "barriers"
      INTEGER MAX_NO_THREADS
      PARAMETER ( MAX_NO_THREADS =   32 )
      INTEGER MAX_NO_PROCS
      PARAMETER ( MAX_NO_PROCS   =  128 )
      INTEGER MAX_NO_BARRIERS
      PARAMETER ( MAX_NO_BARRIERS = 1 )

C--   COMMON /EEPARAMS_L/ Execution environment public logical variables.
C     eeBootError - Flag indicating error during multi-processing
C     eeEndError    initialisation/termination.
C     fatalError  - Flag used to indicate that the model is ended with
C                   an error
      COMMON /EEPARAMS_L/ eeBootError, fatalError, eeEndError,
     &  useCubedSphereExchange
      LOGICAL eeBootError
      LOGICAL eeEndError
      LOGICAL fatalError
      LOGICAL useCubedSphereExchange

C--   COMMON /EPARAMS_I/ Execution environment public integer variables.
C     errorMessageUnit    - Fortran IO unit for error messages
C     standardMessageUnit - Fortran IO unit for informational messages
C     scrUnit1      - Scratch file 1 unit number
C     scrUnit2      - Scratch file 2 unit number
C     eeDataUnit    - Unit number used for reading "execution environment" parameter file.
C     modelDataUnit - Unit number for reading "model" parameter file.
C     numberOfProcs - Number of processes computing in parallel
C     pidIO         - Id of process to use for I/O.
C     myBxLo, myBxHi - Extents of domain in blocks in X and Y
C     myByLo, myByHi   that each threads is responsble for.
C     myProcId      - My own "process" id.
C     myPx     - My X coord on the proc. grid.
C     myPy     - My Y coord on the proc. grid.
C     myXGlobalLo - My bottom-left (south-west) x-index
C                   global domain. The x-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     myYGlobalLo - My bottom-left (south-west) y-index in
C                   global domain. The y-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     nThreads    - No. of threads
C     nTx         - No. of threads in X
C     nTy         - No. of threads in Y
C                   This assumes a simple cartesian
C                   gridding of the threads which is not required elsewhere
C                   but that makes it easier.
C     ioErrorCount - IO Error Counter. Set to zero initially and increased
C                    by one every time an IO error occurs.
      COMMON /EEPARAMS_I/ errorMessageUnit, standardMessageUnit,
     & scrUnit1, scrUnit2, eeDataUnit, modelDataUnit,
     & numberOfProcs, pidIO, myProcId,
     & myPx, myPy, myXGlobalLo, myYGlobalLo, nThreads,
     & myBxLo, myBxHi, myByLo, myByHi,
     & nTx, nTy, ioErrorCount
      INTEGER eeDataUnit
      INTEGER errorMessageUnit
      INTEGER ioErrorCount(MAX_NO_THREADS)
      INTEGER modelDataUnit
      INTEGER myBxLo(MAX_NO_THREADS)
      INTEGER myBxHi(MAX_NO_THREADS)
      INTEGER myByLo(MAX_NO_THREADS)
      INTEGER myByHi(MAX_NO_THREADS)
      INTEGER myProcId
      INTEGER myPx
      INTEGER myPy
      INTEGER myXGlobalLo
      INTEGER myYGlobalLo
      INTEGER nThreads
      INTEGER nTx
      INTEGER nTy
      INTEGER numberOfProcs
      INTEGER pidIO
      INTEGER scrUnit1
      INTEGER scrUnit2
      INTEGER standardMessageUnit
C $Header: /u/u0/gcmpack/MITgcm/model/inc/GRID.h,v 1.18 2001/11/08 16:34:57 jmc Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: GRID.h
C    !INTERFACE:
C    include GRID.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | GRID.h                                                    
C     | o Header file defining model grid.                        
C     *==========================================================*
C     | Model grid is defined for each process by reference to    
C     | the arrays set here.                                      
C     | Notes                                                     
C     | =====                                                     
C     | The standard MITgcm convention of westmost, southern most 
C     | and upper most having the (1,1,1) index is used here.     
C     | i.e.                                                      
C     |---------------------------------------------------------- 
C     | (1)  Plan view schematic of model grid (top layer i.e. )  
C     |      ================================= ( ocean surface )  
C     |                                        ( or top of     )  
C     |                                        ( atmosphere    )  
C     |      This diagram shows the location of the model         
C     |      prognostic variables on the model grid. The "T"      
C     |      location is used for all tracers. The figure also    
C     |      shows the southern most, western most indexing       
C     |      convention that is used for all model variables.     
C     |                                                           
C     |                                                           
C     |             V(i=1,                     V(i=Nx,            
C     |               j=Ny+1,                    j=Ny+1,          
C     |               k=1)                       k=1)             
C     |                /|\                       /|\  "PWX"       
C     |       |---------|------------------etc..  |---- *---      
C     |       |                     |                   *  |      
C     |"PWY"*******************************etc..  **********"PWY" 
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x           |             x     *==>U     
C     |  j=Ny,|      T(i=1,         |          T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=Ny,        |            j=Ny,  *  |j=Ny, 
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |                                                           
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       e                     e                   *  e      
C     |       t                     t                   *  t      
C     |       c                     c                   *  c      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x           |             x     *  |      
C     |  j=2, |      T(i=1,         |          T(i=Nx,  *  |      
C     |  k=1) |        j=2,         |            j=2,   *  |      
C     |       |        k=1)         |            k=1)   *  |      
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |      -----------|------------------etc..  |-----*---      
C     |       |       V(i=1,        |           V(i=Nx, *  |      
C     |       |         j=2,        |             j=2,  *  |      
C     |       |         k=1)        |             k=1)  *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=1,         |  k=1)      j=1,   *  |j=1,  
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |"SB"++>|---------|------------------etc..  |-----*---      
C     |      /+\      V(i=1,                    V(i=Nx, *         
C     |       +         j=1,                      j=1,  *         
C     |       +         k=1)                      k=1)  *         
C     |     "WB"                                      "PWX"       
C     |                                                           
C     |   N, y increasing northwards                              
C     |  /|\ j increasing northwards                              
C     |   |                                                       
C     |   |                                                       
C     |   ======>E, x increasing eastwards                        
C     |             i increasing eastwards                        
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    U: x-velocity (m/s)                                    
C     |    V: y-velocity (m/s)                                    
C     |    T: potential temperature (oC)                          
C     | "SB": Southern boundary                                   
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |"PWY": Periodic wrap around in Y.                          
C     |---------------------------------------------------------- 
C     | (2) South elevation schematic of model grid               
C     |     =======================================               
C     |     This diagram shows the location of the model          
C     |     prognostic variables on the model grid. The "T"       
C     |     location is used for all tracers. The figure also     
C     |     shows the upper most, western most indexing           
C     |     convention that is used for all model variables.      
C     |                                                           
C     |      "WB"                                                 
C     |       +                                                   
C     |       +                                                   
C     |      \+/       /|\                       /|\       .
C     |"UB"++>|-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=1)        |             k=1)  *  |      
C     |       |                     |                   *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=1) |        j=1,         |  k=1)      j=1,   *  |j=1,  
C     |       |        k=1)         |            k=1)   *  |k=1)  
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |       |-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=2)        |             k=2)  *  |      
C     |                                                           
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       .                     .                      .      
C     |       e                     e                   *  e      
C     |       t                     t                   *  t      
C     |       c                     c                   *  c      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |                     |                   *  |      
C     |       |        /|\          |            /|\    *  |      
C     |       |-------- | -----------------etc..  | ----*---      
C     |       |    rVel(i=1,        |        rVel(i=Nx, *  |      
C     |       |         j=1,        |             j=1,  *  |      
C     |       |         k=Nr)       |             k=Nr) *  |      
C     |U(i=1, ==>       x         ==>U(i=2,       x     *==>U     
C     |  j=1, |      T(i=1,         |  j=1,    T(i=Nx,  *(i=Nx+1, 
C     |  k=Nr)|        j=1,         |  k=Nr)     j=1,   *  |j=1,  
C     |       |        k=Nr)        |            k=Nr)  *  |k=Nr) 
C     |       |                     |                   *  |      
C     |"LB"++>==============================================      
C     |                                               "PWX"       
C     |                                                           
C     | Up   increasing upwards.                                  
C     |/|\                                                       .
C     | |                                                         
C     | |                                                         
C     | =====> E  i increasing eastwards                          
C     | |         x increasing eastwards                          
C     | |                                                         
C     |\|/                                                        
C     | Down,k increasing downwards.                              
C     |                                                           
C     | Note: r => height (m) => r increases upwards              
C     |       r => pressure (Pa) => r increases downwards         
C     |                                                           
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    U: x-velocity (m/s)                                    
C     | rVel: z-velocity ( units of r )                           
C     |       The vertical velocity variable rVel is in units of  
C     |       "r" the vertical coordinate. r in m will give       
C     |       rVel m/s. r in Pa will give rVel Pa/s.              
C     |    T: potential temperature (oC)                          
C     | "UB": Upper boundary.                                     
C     | "LB": Lower boundary (always solid - therefore om|w == 0) 
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |---------------------------------------------------------- 
C     | (3) Views showing nomenclature and indexing               
C     |     for grid descriptor variables.                        
C     |                                                           
C     |      Fig 3a. shows the orientation, indexing and          
C     |      notation for the grid spacing terms used internally  
C     |      for the evaluation of gradient and averaging terms.  
C     |      These varaibles are set based on the model input     
C     |      parameters which define the model grid in terms of   
C     |      spacing in X, Y and Z.                               
C     |                                                           
C     |      Fig 3b. shows the orientation, indexing and          
C     |      notation for the variables that are used to define   
C     |      the model grid. These varaibles are set directly     
C     |      from the model input.                                
C     |                                                           
C     | Figure 3a                                                 
C     | =========                                                 
C     |       |------------------------------------               
C     |       |                       |                           
C     |"PWY"********************************* etc...              
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |                                                           
C     |       .                       .                           
C     |       .                       .                           
C     |       .                       .                           
C     |       e                       e                           
C     |       t                       t                           
C     |       c                       c                           
C     |       |-----------v-----------|-----------v----------|-   
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       |                       |                      |    
C     |       u<--dxF(i=1,j=2,k=1)--->u           t          |    
C     |       |/|\       /|\          |                      |    
C     |       | |         |           |                      |    
C     |       | |         |           |                      |    
C     |       | |         |           |                      |    
C     |       |dyU(i=1,  dyC(i=1,     |                      |    
C     | ---  ---|--j=2,---|--j=2,-----------------v----------|-   
C     | /|\   | |  k=1)   |  k=1)     |          /|\         |    
C     |  |    | |         |           |          dyF(i=2,    |    
C     |  |    | |         |           |           |  j=1,    |    
C     |dyG(   |\|/       \|/          |           |  k=1)    |    
C     |   i=1,u---        t<---dxC(i=2,j=1,k=1)-->t          |    
C     |   j=1,|                       |           |          |    
C     |   k=1)|                       |           |          |    
C     |  |    |                       |           |          |    
C     |  |    |                       |           |          |    
C     | \|/   |           |<---dxV(i=2,j=1,k=1)--\|/         |    
C     |"SB"++>|___________v___________|___________v__________|_   
C     |       <--dxG(i=1,j=1,k=1)----->                           
C     |      /+\                                              .
C     |       +                                                   
C     |       +                                                   
C     |     "WB"                                                  
C     |                                                           
C     |   N, y increasing northwards                              
C     |  /|\ j increasing northwards                              
C     |   |                                                       
C     |   |                                                       
C     |   ======>E, x increasing eastwards                        
C     |             i increasing eastwards                        
C     |                                                           
C     |    i: East-west index                                     
C     |    j: North-south index                                   
C     |    k: up-down index                                       
C     |    u: x-velocity point                                    
C     |    V: y-velocity point                                    
C     |    t: tracer point                                        
C     | "SB": Southern boundary                                   
C     | "WB": Western boundary                                    
C     |"PWX": Periodic wrap around in X.                          
C     |"PWY": Periodic wrap around in Y.                          
C     |                                                           
C     | Figure 3b                                                 
C     | =========                                                 
C     |                                                           
C     |       .                       .                           
C     |       .                       .                           
C     |       .                       .                           
C     |       e                       e                           
C     |       t                       t                           
C     |       c                       c                           
C     |       |-----------v-----------|-----------v--etc...       
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       u<--delX(i=1)---------->u           t               
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |                       |                           
C     |       |-----------v-----------------------v--etc...       
C     |       |          /|\          |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       u        delY(j=1)      |           t               
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |           |           |                           
C     |       |          \|/          |                           
C     |"SB"++>|___________v___________|___________v__etc...       
C     |      /+\                                                 .
C     |       +                                                   
C     |       +                                                   
C     |     "WB"                                                  
C     |                                                           
C     *==========================================================*
C     \ev
CEOP

C     Macros that override/modify standard definitions
C $Header: /u/u0/gcmpack/MITgcm/model/inc/GRID_MACROS.h,v 1.12 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: GRID_MACROS.h
C    !INTERFACE:
C    include GRID_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | GRID_MACROS.h                                             
C     *==========================================================*
C     | These macros are used to substitute definitions for       
C     | GRID.h variables for particular configurations.           
C     | In setting these variables the following convention       
C     | applies.                                                  
C     | undef  phi_CONST   - Indicates the variable phi is fixed  
C     |                      in X, Y and Z.                       
C     | undef  phi_FX      - Indicates the variable phi only      
C     |                      varies in X (i.e.not in X or Z).     
C     | undef  phi_FY      - Indicates the variable phi only      
C     |                      varies in Y (i.e.not in X or Z).     
C     | undef  phi_FXY     - Indicates the variable phi only      
C     |                      varies in X and Y ( i.e. not Z).     
C     *==========================================================*
C     \ev
CEOP




C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXC_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXC_MACROS.h
C    !INTERFACE:
C    include DXC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXC_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXF_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXF_MACROS.h
C    !INTERFACE:
C    include DXF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXF_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXG_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXG_MACROS.h
C    !INTERFACE:
C    include DXG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXG_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DXV_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DXV_MACROS.h
C    !INTERFACE:
C    include DXV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DXV_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYC_MACROS.h
C    !INTERFACE:
C    include DYC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYC_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYF_MACROS.h
C    !INTERFACE:
C    include DYF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYF_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYG_MACROS.h,v 1.4 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYG_MACROS.h
C    !INTERFACE:
C    include DYG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYG_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/DYU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: DYU_MACROS.h
C    !INTERFACE:
C    include DYU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | DYU_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: HFACC_MACROS.h
C    !INTERFACE:
C    include HFACC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACC_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: HFACS_MACROS.h
C    !INTERFACE:
C    include HFACS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACS_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/HFACW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: HFACW_MACROS.h
C    !INTERFACE:
C    include HFACW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | HFACW_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXC_MACROS.h
C    !INTERFACE:
C    include RECIP_DXC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXC_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXF_MACROS.h
C    !INTERFACE:
C    include RECIP_DXF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXF_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXG_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXG_MACROS.h
C    !INTERFACE:
C    include RECIP_DXG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXG_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DXV_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DXV_MACROS.h
C    !INTERFACE:
C    include RECIP_DXV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DXV_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYC_MACROS.h
C    !INTERFACE:
C    include RECIP_DYC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYC_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYF_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYF_MACROS.h
C    !INTERFACE:
C    include RECIP_DYF_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYF_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYG_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYG_MACROS.h
C    !INTERFACE:
C    include RECIP_DYG_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYG_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_DYU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_DYU_MACROS.h
C    !INTERFACE:
C    include RECIP_DYU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_DYU_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_HFACC_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACC_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_HFACS_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACS_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/RECIP_HFACW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RECIP_HFACW_MACROS.h
C    !INTERFACE:
C    include RECIP_HFACW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RECIP_HFACW_MACROS.h                                      
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/XC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: XC_MACROS.h
C    !INTERFACE:
C    include XC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | XC_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/YC_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: YC_MACROS.h
C    !INTERFACE:
C    include YC_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | YC_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/RA_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RA_MACROS.h
C    !INTERFACE:
C    include RA_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RA_MACROS.h                                               
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP










C $Header: /u/u0/gcmpack/MITgcm/model/inc/RAW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RAW_MACROS.h
C    !INTERFACE:
C    include RAW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RAW_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP










C $Header: /u/u0/gcmpack/MITgcm/model/inc/RAS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: RAS_MACROS.h
C    !INTERFACE:
C    include RAS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | RAS_MACROS.h                                              
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP















C $Header: /u/u0/gcmpack/MITgcm/model/inc/MASKW_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: MASKW_MACROS.h
C    !INTERFACE:
C    include MASKW_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | MASKW_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP

















C $Header: /u/u0/gcmpack/MITgcm/model/inc/MASKS_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: MASKS_MACROS.h
C    !INTERFACE:
C    include MASKS_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | MASKS_MACROS.h                                            
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP
















C $Header: /u/u0/gcmpack/MITgcm/model/inc/TANPHIATU_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: TANPHIATU_MACROS.h
C    !INTERFACE:
C    include TANPHIATU_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | TANPHIATU_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP














C $Header: /u/u0/gcmpack/MITgcm/model/inc/TANPHIATV_MACROS.h,v 1.3 2001/09/21 15:13:31 cnh Exp $
C $Name:  $
C
CBOP
C    !ROUTINE: TANPHIATV_MACROS.h
C    !INTERFACE:
C    include TANPHIATV_MACROS.h
C    !DESCRIPTION: \bv
C     *==========================================================*
C     | TANPHIATV_MACROS.h                                        
C     *==========================================================*
C     | These macros are used to reduce memory requirement and/or 
C     | memory references when variables are fixed along a given  
C     | axis or axes.                                             
C     *==========================================================*
C     \ev
CEOP











C
C--   COMMON /GRID_R/ REAL valued grid defining variables.
C     dxC    - Cell center separation in X across western cell wall (m)
C     dxG    - Cell face separation in X along southern cell wall (m)
C     dxF    - Cell face separation in X thru cell center (m)
C     dxV    - V-point separation in X across south-west corner of cell (m)
C     dyC    - Cell center separation in Y across southern cell wall (m)
C     dyG    - Cell face separation in Y along western cell wall (m)
C     dyF    - Cell face separation in Y thru cell center (m)
C     dyU    - U-point separation in Y across south-west corner of cell (m)
C     drC    - Cell center separation along Z axis ( units of r ).
C     drF    - Cell face separation along Z axis ( units of r ).
C     Rcolumn  -Total thickness (in r_unit) of the fluid column
C     R_low  - base of fluid in r_unit (Depth(m) / Pressure(Pa) at top Atmos.)
C     Ro_surf- surface reference (at rest) position, r_unit.
C     hFac   - Fraction of cell in vertical which is open i.e how 
C              "lopped" a cell is (dimensionless scale factor).
C              Note: The code needs terms like MIN(hFac,hFac(I+1))
C                    On some platforms it may be better to precompute
C                    hFacW, hFacE, ... here than do MIN on the fly.
C     rkFac     - Vertical coordinate to vertical index orientation.
C                 ( -1 same orientation, 1 opposite orientation )
C                 ( vertical coord == m  -> rkFac =  1 )
C                 ( vertical coord == Pa -> rkFac = -1 )
C     maskH  - cell Center full-column mask (= 2D mask)
C     maskC  - cell Center land mask
C     maskW  - West face land mask
C     maskS  - South face land mask
C     recip_dxC   - Recipricol of dxC
C     recip_dxG   - Recipricol of dxG
C     recip_dxF   - Recipricol of dxF
C     recip_dxV   - Recipricol of dxV
C     recip_dyC   - Recipricol of dxC
C     recip_dyG   - Recipricol of dyG
C     recip_dyF   - Recipricol of dyF
C     recip_dyU   - Recipricol of dyU
C     recip_drC   - Recipricol of drC
C     recip_drF   - Recipricol of drF
C     recip_Rcol  - Inverse of cell center column thickness (1/r_unit)
C     recip_hFacC - Inverse of cell open-depth f[X,Y,Z] ( dimensionless ).
C     recip_hFacW   rhFacC center, rhFacW west, rhFacS south.
C     recip_hFacS   Note: This is precomputed here because it involves division.
C     saFac  - Shallow atmosphere factor (dimensionless scale factor).
C     xC     - X-coordinate of center of cell f[X,Y]. The units of xc, yc
C              depend on the grid. They are not used in differencing or
C              averaging but are just a convient quantity for I/O,
C              diagnostics etc.. As such xc is in m for cartesian 
C              coordinates but degrees for spherical polar.
C     yC     - Y-coordinate of center of cell f[X,Y].
C     yG     - Y-coordinate of corner of cell ( c-grid vorticity point) f[X,Y]. 
C     xC0, yC0 - West edge x coord  ( metres or degrees )
C                South edge y coord ( metres or degrees )
C     rA     - R-face are f[X,Y] ( m^2 ).
C              Note: In a cartesian framework zA is simply dx*dy,
C                    however we use zA to allow for non-globally
C                    orthogonal coordinate frames (with appropriate
C                    metric terms).
C     rC     - R-coordinate of center of cell f[Z] (units of r).
C     rF     - R-coordinate of face of cell f[Z] (units of r).
C     tanPhiAtU - tan of the latitude at U point. Used for spherical polar 
C                 metric term in U equation.
C     tanPhiAtV - tan of the latitude at V point. Used for spherical polar 
C                 metric term in V equation.
      COMMON /GRID_R/
     &  dxC,dxF,dxG,dxV,dyC,dyF,dyG,dyU,
     &  R_low,Ro_surf,HFacC,HFacW,HFacS,
     &  recip_dxC,recip_dxF,recip_dxG,recip_dxV,
     &  recip_dyC,recip_dyF,recip_dyG,recip_dyU,
     &  recip_Rcol, 
     &  recip_hFacC,recip_hFacW,recip_hFacS, 
     &  saFac,
     &  xC,yC,rA,rAw,rAs,rAz,xG,yG,
     &  maskH, maskC,maskW,maskS,
     &  recip_rA,recip_rAw,recip_rAs,recip_rAz,
     &  tanPhiAtU, tanPhiAtV,
     &  cosfacU,cosfacV,sqcosfacU,sqcosfacV,
     &  drC,drF,recip_drC,recip_drF,rC,rF,
     &  rkFac, recip_rkFac, xC0, yC0
      Real*8 dxC            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxF            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxG            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dxV            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyC            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyF            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyG            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 dyU            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 R_low          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 Ro_surf        (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 HFacC          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 HFacW          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 HFacS          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_dxC      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxF      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxG      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dxV      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyC      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyF      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyG      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_dyU      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_Rcol     (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_hFacC    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_hFacW    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 recip_hFacS    (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 xC             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 xG             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 yC             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 yG             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rA             (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAw            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAs            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 rAz            (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rA       (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAw      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAs      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 recip_rAz      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 maskH          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 maskC          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 maskW          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 maskS          (1-OLx:sNx+OLx,1-OLy:sNy+OLy,1:Nr,nSx,nSy)
      Real*8 tanPhiAtU      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 tanPhiAtV      (1-OLx:sNx+OLx,1-OLy:sNy+OLy,nSx,nSy)
      Real*8 cosfacU(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 cosfacV(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 sqcosfacU(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 sqcosfacV(1-Oly:sNy+Oly,nSx,nSy)
      Real*8 drC            (1:Nr)
      Real*8 drF            (1:Nr)
      Real*8 recip_drC      (1:Nr)
      Real*8 recip_drF      (1:Nr)
      Real*8 saFac          (1:Nr)
      Real*8 rC             (1:Nr)
      Real*8 rF             (1:Nr+1)
      Real*8 rkFac
      Real*8 recip_rkFac
      Real*8 xC0
      Real*8 yC0



C     == Routine arguments ==
      INTEGER bi,bj,K
      Real*8 KE(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      Real*8 dKEdx(1-OLx:sNx+OLx,1-OLy:sNy+OLy)
      INTEGER myThid

C     == Local variables ==
      INTEGER I,J

       DO J=1-Oly,sNy+Oly
        DO I=2-Olx,sNx+Olx
         dKEdx(I,J)=-recip_dxC(i,j,bi,bj)*(KE(i,j)-KE(i-1,j))
     &       *maskW(i,j,k,BI,BJ)
        ENDDO
       ENDDO

      RETURN
      END
