C $Header: /u/u0/gcmpack/MITgcm/pkg/monitor/mon_advcflw.F,v 1.4 2001/06/25 20:35:23 adcroft Exp $
C $Name:  $

C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_OPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C 
C CPP flags controlling which code in included in the files that
C will be compiled.
C

C o Include/exclude code for AIM package


C o Include/exclude code for GM/Redi parameterization


C o Include/exclude code for KPP mixing scheme


cswdblk --- add ---
C o Include/exclude code for bulk formula


cswdice -- add ---
C o allow seaice

cswdice -- end add ---
C o try to conserve qnet and emp


cswdblk -- end add ---

C o Shortwave heating as extra term in external_forcing.F


C o Include/exclude code for Shapiro filters


C o Include/exclude code for C-D grid method of integrating the 
C   coriolis terms


C o Include/exclude code for open-boundary conditions


C o Include/exclude diagnostics package interface code


C o Include/exclude zonal FFT filter code


C o Include/exclude temperature advection code






C o Include/exclude temperature diffusion code







C o Include/exclude temperature forcing code


C o Include/exclude momentum advection code






C o Include/exclude laplacian viscosity code






C o Include/exclude biharmonic viscosity code






C o Include/exclude gradient of phy_hyd code






C o Include/exclude momentum forcing code


C o Include/exclude momentum eqn metric terms code


C o Include/exclude phi_hyd calculation code


C o Include/exclude call to S/R CONVECT


C o Include/exclude call to S/R CALC_DIFFUSIVITY


C o Allow nonHydrostatic code


C o Use "natural" boundary conditions for salinity
C   instead of the "virtual salt flux"


C o Use "Exact Convervation" of fluid in Free-Surface formulation
C   so that d/dt(eta) is exactly equal to - Div.Transport


C o Allow the use of Non-Linear Free-Surface formulation
C   this implies that surface thickness (hFactors) vary with time


C o Use "OLD" UV discretisation near boundaries (*not* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Use "OLD" UV geometry on sphere (definately *NOT* recommended)
C   Note - only works with  #undef NO_SLIP_LATERAL  in calc_mom_rhs.F
C          because the old code did not have no-slip BCs


C o Execution environment support options
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/CPP_EEOPTIONS.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | CPP_EEOPTIONS.h                                          |
C     |==========================================================|
C     | C preprocessor "execution environment" supporting        |
C     | flags. Use this file to set flags controlling the        |
C     | execution environment in which a model runs - as opposed |
C     | to the dynamical problem the model solves.               |
C     | Note: Many options are implemented with both compile time|
C     |       and run-time switches. This allows options to be   |
C     |       removed altogether, made optional at run-time or   |
C     |       to be permanently enabled. This convention helps   |
C     |       with the data-dependence analysis performed by the |
C     |       adjoint model compiler. This data dependency       |
C     |       analysis can be upset by runtime switches that it  |
C     |       is unable to recoginise as being fixed for the     |
C     |       duration of an integration.                        |
C     |       A reasonable way to use these flags is to          |
C     |       set all options as selectable at runtime but then  |
C     |       once an experimental configuration has been        |
C     |       identified, rebuild the code with the appropriate  |
C     |       options set at compile time.                       |
C     \==========================================================/




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate whether Fortran formatted write
C     and read are threadsafe. On SGI the routines can be thread
C     safe, on Sun it is not possible - if you are unsure then
C     undef this option.


C--   Control MPI based parallel processing





 
C--   Control use of communication that might overlap computation.
C     Under MPI selects/deselects "non-blocking" sends and receives.



C--   Control use of communication that is atomic to computation.
C     Under MPI selects/deselects "blocking" sends and receives.



C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.

 
C--   Control use of "double" precision constants.
C     Use D0 where it means REAL*8 but not where it means REAL*16


C--   Control XY periodicity in processor to grid mappings
C     Note: Model code does not need to know whether a domain is 
C           periodic because it has overlap regions for every box.
C           Model assume that these values have been
C           filled in some way.







C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/CPP_EEMACROS.h,v 1.5 2001/09/21 03:54:35 cnh Exp $
C $Name:  $

CBOP
C     !ROUTINE: CPP_EEMACROS.h 
C     !INTERFACE:
C     include "CPP_EEMACROS.h "
C     !DESCRIPTION:
C     *==========================================================*
C     | CPP_EEMACROS.h                                            
C     *==========================================================*
C     | C preprocessor "execution environment" supporting         
C     | macros. Use this file to define macros for  simplifying   
C     | execution environment in which a model runs - as opposed  
C     | to the dynamical problem the model solves.                
C     *==========================================================*
CEOP




C     In general the following convention applies:
C     ALLOW  - indicates an feature will be included but it may
C     CAN      have a run-time flag to allow it to be switched
C              on and off.
C              If ALLOW or CAN directives are "undef'd" this generally
C              means that the feature will not be available i.e. it
C              will not be included in the compiled code and so no
C              run-time option to use the feature will be available.
C
C     ALWAYS - indicates the choice will be fixed at compile time
C              so no run-time option will be present

C     Flag used to indicate which flavour of multi-threading
C     compiler directives to use. Only set one of these.
C     USE_SOLARIS_THREADING  - Takes directives for SUN Workshop
C                              compiler.
C     USE_KAP_THREADING      - Takes directives for Kuck and 
C                              Associates multi-threading compiler
C                              ( used on Digital platforms ).
C     USE_IRIX_THREADING     - Takes directives for SGI MIPS
C                              Pro Fortran compiler.
C     USE_EXEMPLAR_THREADING - Takes directives for HP SPP series
C                              compiler.
C     USE_C90_THREADING      - Takes directives for CRAY/SGI C90
C                              system F90 compiler.










C--   Define the mapping for the _BARRIER macro
C     On some systems low-level hardware support can be accessed through
C     compiler directives here.


C--   Define the mapping for the BEGIN_CRIT() and  END_CRIT() macros. 
C     On some systems we simply execute this section only using the
C     master thread i.e. its not really a critical section. We can
C     do this because we do not use critical sections in any critical
C     sections of our code!



C--   Define the mapping for the BEGIN_MASTER_SECTION() and
C     END_MASTER_SECTION() macros. These are generally implemented by
C     simply choosing a particular thread to be "the master" and have
C     it alone execute the BEGIN_MASTER..., END_MASTER.. sections.



C--   Control storage of floating point operands
C     On many systems it improves performance only to use
C     8-byte precision for time stepped variables.
C     Constant in time terms ( geometric factors etc.. )
C     can use 4-byte precision, reducing memory utilisation and
C     boosting performance because of a smaller working
C     set size. However, on vector CRAY systems this degrades
C     performance.




















C--   Control use of JAM routines for Artic network
C     These invoke optimized versions of "exchange" and "sum" that
C     utilize the programmable aspect of Artic cards.

 
C--   Control use of "double" precision constants.
C     Use d0 where it means REAL*8 but not where it means REAL*16


C--   Substitue for 1.D variables
C     Sun compilers do not use 8-byte precision for literals
C     unless .Dnn is specified. CRAY vector machines use 16-byte
C     precision when they see .Dnn which runs very slowly!








C o Include/exclude code specific to the ECCO/SEALION version.


 
C o Enable/disable state import and export.




C Need to define byteswapio if using Lahey compiler (for ESMF lib built against Lahey)


      SUBROUTINE MON_ADVCFLW(
     I                label, W, rDz, dT,
     I                myThid )
C     /==========================================================C     | SUBROUTINE MON_ADVCFLW                                   |
C     | o Calculates maximum CFL number in vertical              |
C     |==========================================================|
C     \==========================================================/
      IMPLICIT NONE

C     === Global data ===
C $Header: /u/u0/gcmpack/MITgcm/verification/global_ocean.90x40x15/code/SIZE.h,v 1.1 2001/09/28 14:53:34 adcroft Exp $
C $Name:  $

C
C     /==========================================================C     | SIZE.h Declare size of underlying computational grid.    |
C     |==========================================================|
C     | The design here support a three-dimensional model grid   |
C     | with indices I,J and K. The three-dimensional domain     |
C     | is comprised of nPx*nSx blocks of size sNx along one axis|
C     | nPy*nSy blocks of size sNy along another axis and one    |
C     | block of size Nz along the final axis.                   |
C     | Blocks have overlap regions of size OLx and OLy along the|
C     | dimensions that are subdivided.                          |
C     \==========================================================/
C     Voodoo numbers controlling data layout.
C     sNx - No. X points in sub-grid.
C     sNy - No. Y points in sub-grid.
C     OLx - Overlap extent in X.
C     OLy - Overlat extent in Y.
C     nSx - No. sub-grids in X.
C     nSy - No. sub-grids in Y.
C     nPx - No. of processes to use in X.
C     nPy - No. of processes to use in Y.
C     Nx  - No. points in X for the total domain.
C     Ny  - No. points in Y for the total domain.
C     Nr  - No. points in Z for full process domain.
      INTEGER sNx
      INTEGER sNy
      INTEGER OLx
      INTEGER OLy
      INTEGER nSx
      INTEGER nSy
      INTEGER nPx
      INTEGER nPy
      INTEGER Nx
      INTEGER Ny
      INTEGER Nr
      PARAMETER (
     &           sNx = 128,
     &           sNy =   4,
C    &           sNy =   8,
C    &           sNy =  16,
C    &           sNy =  32,
C    &           sNy =  64,
     &           OLx =   3,
     &           OLy =   3,
     &           nSx =   1,
     &           nSy =   1,
     &           nPx =   1,
     &           nPy =  16,
C    &           nPy =   8,
C    &           nPy =   4,
C    &           nPy =   2,
C    &           nPy =   1,
     &           Nx  = sNx*nSx*nPx,
     &           Ny  = sNy*nSy*nPy,
     &           Nr  =  15)

C     MAX_OLX  - Set to the maximum overlap region size of any array
C     MAX_OLY    that will be exchanged. Controls the sizing of exch
C                routine buufers.
      INTEGER MAX_OLX
      INTEGER MAX_OLY
      PARAMETER ( MAX_OLX = OLx,
     &            MAX_OLY = OLy )

C $Header: /u/u0/gcmpack/MITgcm/eesupp/inc/EEPARAMS.h,v 1.10 2001/09/21 03:54:35 cnh Exp $
C $Name:  $
CBOP
C     !ROUTINE: EEPARAMS.h
C     !INTERFACE:
C     include "EEPARAMS.h"
C
C     !DESCRIPTION:
C     *==========================================================*
C     | EEPARAMS.h                                               |
C     *==========================================================*
C     | Parameters for "execution environemnt". These are used   |
C     | by both the particular numerical model and the "execution|
C     | environment" support routines.                           |
C     *==========================================================*
CEOP

C     MAX_LEN_MBUF         - Default message buffer max. size
C     MAX_LEN_FNAM         - Default file name max. size
C     MAX_LEN_PREC         - Default record length for reading "parameter" files
      INTEGER MAX_LEN_MBUF
      PARAMETER ( MAX_LEN_MBUF = 512 )
      INTEGER MAX_LEN_FNAM
      PARAMETER ( MAX_LEN_FNAM = 512 )
      INTEGER MAX_LEN_PREC
      PARAMETER ( MAX_LEN_PREC = 200 )

C     SQUEEZE_RIGHT       - Flag indicating right blank space removal
C                           from text field.
C     SQUEEZE_LEFT        - Flag indicating left blank space removal
C                           from text field.
C     SQUEEZE_BOTH        - Flag indicating left and right blank
C                           space removal from text field.
C     PRINT_MAP_XY        - Flag indicating to plot map as XY slices
C     PRINT_MAP_XZ        - Flag indicating to plot map as XZ slices
C     PRINT_MAP_YZ        - Flag indicating to plot map as YZ slices
C     commentCharacter    - Variable used in column 1 of parameter files to
C                           indicate comments.
C     INDEX_I             - Variable used to select an index label
C     INDEX_J               for formatted input parameters.
C     INDEX_K
C     INDEX_NONE
      CHARACTER*(*) SQUEEZE_RIGHT
      PARAMETER ( SQUEEZE_RIGHT = 'R' )
      CHARACTER*(*) SQUEEZE_LEFT
      PARAMETER ( SQUEEZE_LEFT = 'L' )
      CHARACTER*(*) SQUEEZE_BOTH
      PARAMETER ( SQUEEZE_BOTH = 'B' )
      CHARACTER*(*) PRINT_MAP_XY
      PARAMETER ( PRINT_MAP_XY = 'XY' )
      CHARACTER*(*) PRINT_MAP_XZ
      PARAMETER ( PRINT_MAP_XZ = 'XZ' )
      CHARACTER*(*) PRINT_MAP_YZ
      PARAMETER ( PRINT_MAP_YZ = 'YZ' )
      CHARACTER*(*) commentCharacter
      PARAMETER ( commentCharacter = '#' )
      INTEGER INDEX_I
      INTEGER INDEX_J
      INTEGER INDEX_K   
      INTEGER INDEX_NONE
      PARAMETER ( INDEX_I    = 1,
     &            INDEX_J    = 2,
     &            INDEX_K    = 3,
     &            INDEX_NONE = 4 )


C     EXCH_IGNORE_CORNERS - Flag to select ignoring or
C     EXCH_UPDATE_CORNERS   updating of corners during
C                           an edge exchange.
      INTEGER EXCH_IGNORE_CORNERS
      INTEGER EXCH_UPDATE_CORNERS
      PARAMETER ( EXCH_IGNORE_CORNERS = 0,
     &            EXCH_UPDATE_CORNERS = 1 )

C     FORWARD_SIMULATION
C     REVERSE_SIMULATION
      INTEGER FORWARD_SIMULATION
      INTEGER REVERSE_SIMULATION
      PARAMETER ( FORWARD_SIMULATION = 0,
     &            REVERSE_SIMULATION = 1 )


C     Particularly weird and obscure voodoo numbers
C     lShare  - This wants to be the length in
C               [148]-byte words of the size of
C               the address "window" that is snooped
C               on an SMP bus. By separating elements in
C               the global sum buffer we can avoid generating
C               extraneous invalidate traffic between
C               processors. The length of this window is usually
C               a cache line i.e. small O(64 bytes).
C               The buffer arrays are usually short arrays
C               and are declared REAL ARRA(lShare[148],LBUFF).
C               Setting lShare[148] to 1 is like making these arrays
C               one dimensional.
      INTEGER cacheLineSize
      INTEGER lShare1
      INTEGER lShare4
      INTEGER lShare8
      PARAMETER ( cacheLineSize = 256 )
      PARAMETER ( lShare1 =  cacheLineSize )
      PARAMETER ( lShare4 =  cacheLineSize/4 )
      PARAMETER ( lShare8 =  cacheLineSize/8 )

C     MAX_NO_THREADS  - Maximum number of threads allowed.
C     MAX_NO_PROCS    - Maximum number of processes allowed.
C     MAX_NO_BARRIERS - Maximum number of distinct thread "barriers"
      INTEGER MAX_NO_THREADS
      PARAMETER ( MAX_NO_THREADS =   32 )
      INTEGER MAX_NO_PROCS
      PARAMETER ( MAX_NO_PROCS   =  128 )
      INTEGER MAX_NO_BARRIERS
      PARAMETER ( MAX_NO_BARRIERS = 1 )

C--   COMMON /EEPARAMS_L/ Execution environment public logical variables.
C     eeBootError - Flag indicating error during multi-processing
C     eeEndError    initialisation/termination.
C     fatalError  - Flag used to indicate that the model is ended with
C                   an error
      COMMON /EEPARAMS_L/ eeBootError, fatalError, eeEndError,
     &  useCubedSphereExchange
      LOGICAL eeBootError
      LOGICAL eeEndError
      LOGICAL fatalError
      LOGICAL useCubedSphereExchange

C--   COMMON /EPARAMS_I/ Execution environment public integer variables.
C     errorMessageUnit    - Fortran IO unit for error messages
C     standardMessageUnit - Fortran IO unit for informational messages
C     scrUnit1      - Scratch file 1 unit number
C     scrUnit2      - Scratch file 2 unit number
C     eeDataUnit    - Unit number used for reading "execution environment" parameter file.
C     modelDataUnit - Unit number for reading "model" parameter file.
C     numberOfProcs - Number of processes computing in parallel
C     pidIO         - Id of process to use for I/O.
C     myBxLo, myBxHi - Extents of domain in blocks in X and Y
C     myByLo, myByHi   that each threads is responsble for.
C     myProcId      - My own "process" id.
C     myPx     - My X coord on the proc. grid.
C     myPy     - My Y coord on the proc. grid.
C     myXGlobalLo - My bottom-left (south-west) x-index
C                   global domain. The x-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     myYGlobalLo - My bottom-left (south-west) y-index in
C                   global domain. The y-coordinate of this
C                   point in for example m or degrees is *not*
C                   specified here. A model needs to provide a
C                   mechanism for deducing that information if it
C                   is needed.
C     nThreads    - No. of threads
C     nTx         - No. of threads in X
C     nTy         - No. of threads in Y
C                   This assumes a simple cartesian
C                   gridding of the threads which is not required elsewhere
C                   but that makes it easier.
C     ioErrorCount - IO Error Counter. Set to zero initially and increased
C                    by one every time an IO error occurs.
      COMMON /EEPARAMS_I/ errorMessageUnit, standardMessageUnit,
     & scrUnit1, scrUnit2, eeDataUnit, modelDataUnit,
     & numberOfProcs, pidIO, myProcId,
     & myPx, myPy, myXGlobalLo, myYGlobalLo, nThreads,
     & myBxLo, myBxHi, myByLo, myByHi,
     & nTx, nTy, ioErrorCount
      INTEGER eeDataUnit
      INTEGER errorMessageUnit
      INTEGER ioErrorCount(MAX_NO_THREADS)
      INTEGER modelDataUnit
      INTEGER myBxLo(MAX_NO_THREADS)
      INTEGER myBxHi(MAX_NO_THREADS)
      INTEGER myByLo(MAX_NO_THREADS)
      INTEGER myByHi(MAX_NO_THREADS)
      INTEGER myProcId
      INTEGER myPx
      INTEGER myPy
      INTEGER myXGlobalLo
      INTEGER myYGlobalLo
      INTEGER nThreads
      INTEGER nTx
      INTEGER nTy
      INTEGER numberOfProcs
      INTEGER pidIO
      INTEGER scrUnit1
      INTEGER scrUnit2
      INTEGER standardMessageUnit
C $Header: /u/u0/gcmpack/MITgcm/pkg/monitor/MONITOR.h,v 1.2 2001/11/08 16:47:34 jmc Exp $
C $Name:  $
C
C     /==========================================================C     | MONITOR.h                                                |
C     |==========================================================|
C     | Parameters for "monitor" setup.                          |
C     | Monitor routines ( prefixed MON_ ) provide a simple      |
C     | set of utilities for outputting useful runtime diagnostic|
C     | information. They use a standard format so that the      |
C     | monitor output can be parsed offline to help in trouble  |
C     | shooting.                                                |
C     | Monitor setup params should be set through appropriate   |
C     | MON_ routines to ensure that changes are made in a       |
C     | thread-safe fashion.                                     |
C     \==========================================================/

C--   Monitor head and tail strings
      CHARACTER*(*) mon_head
      PARAMETER ( mon_head = '%MON'       )
      CHARACTER*(*) mon_foot_min
      PARAMETER ( mon_foot_min = '_min'   )
      CHARACTER*(*) mon_foot_max
      PARAMETER ( mon_foot_max = '_max'   )
      CHARACTER*(*) mon_foot_sd 
      PARAMETER ( mon_foot_sd = '_sd'     )
      CHARACTER*(*) mon_foot_mean
      PARAMETER ( mon_foot_mean = '_mean' )
      CHARACTER*(*) mon_foot_volint
      PARAMETER ( mon_foot_volint = '_volint' )
      CHARACTER*(*) mon_foot_volmean
      PARAMETER ( mon_foot_volmean = '_volmean' )
      CHARACTER*(*) mon_foot_del2
      PARAMETER ( mon_foot_del2 = '_del2' )
      CHARACTER*(*) mon_string_none
      PARAMETER ( mon_string_none = 'NONE')

C--   COMMON /MON_I/ Monitor integer variables
C     mon_ioUnit - Used to specify the output unit for monitor IO.
C     mon_prefL  - Prefix length of current mon_ prefix
      COMMON /MON_I/ mon_ioUnit, mon_prefL
      INTEGER mon_ioUnit 
      INTEGER mon_prefL

C--   COMMON /MON_C/ Monitor character variables
C     mon_pref   - Prefix used for monitor output
      COMMON /MON_C/ mon_pref
      CHARACTER*(MAX_LEN_MBUF) mon_pref

C     === Routine arguments ===
      CHARACTER*(*) label
      Real*8 W(1-OLx:sNx+OLx,1-OLy:sNy+OLy,Nr,nSx,nSy)
      Real*8 rDz(Nr)
      Real*8 dT
      INTEGER myThid

C     === Local variables ====
      INTEGER bi,bj,I,J,K
      Real*8 tmpVal,theMax

      theMax=0.

      DO bj=myByLo(myThid),myByHi(myThid)
       DO bi=myBxLo(myThid),myBxHi(myThid)
        DO K=1,Nr
         DO J=1,sNy
          DO I=1,sNx
           tmpVal=abs(W(I,J,K,bi,bj))*rDz(K)*dT
           theMax=max(theMax,tmpVal)
          ENDDO
         ENDDO
        ENDDO
       ENDDO
      ENDDO
      CALL GLOBAL_MAX_R8 ( theMax, myThid )

      CALL MON_OUT_RL( label, theMax, mon_foot_max ,myThid)

      RETURN
      END
